/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing.expressions;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.php.PhpBundle;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.ListParsingHelper;
import fleet.com.jetbrains.php.lang.parser.ParserPart;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.StaticScalar;

public final class StaticArrayPairList {
    private static final ParserPart PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            PsiBuilder.Marker arrayElement = builder.mark();
            PsiBuilder.Marker staticArrayPair = builder.mark();
            IElementType result = StaticScalar.parse(builder);
            if (result != PhpElementTypes.EMPTY_INPUT) {
                boolean hash_array_element = false;
                if (builder.compare(PhpTokenTypes.opHASH_ARRAY)) {
                    staticArrayPair.done(PhpElementTypes.ARRAY_KEY);
                    hash_array_element = true;
                    builder.advanceLexer();
                    staticArrayPair = builder.mark();
                    if (StaticScalar.parse(builder) == PhpElementTypes.EMPTY_INPUT) {
                        builder.error(PhpParserErrors.expected(PhpBundle.message("static.value", new Object[0])));
                    }
                }
                staticArrayPair.done(PhpElementTypes.ARRAY_VALUE);
                if (hash_array_element) {
                    arrayElement.done(PhpElementTypes.HASH_ARRAY_ELEMENT);
                } else {
                    arrayElement.drop();
                }
            } else {
                staticArrayPair.rollbackTo();
                arrayElement.drop();
            }
            return result;
        }
    };

    public static IElementType parse(PhpPsiBuilder builder) {
        IElementType result = PART.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, result, PART, true);
        }
        return result;
    }
}

