/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing.classes;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.php.PhpBundle;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.ListParsingHelper;
import fleet.com.jetbrains.php.lang.parser.ParserPart;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.PhpStubElementTypes;
import fleet.com.jetbrains.php.lang.parser.parsing.Attributes;
import fleet.com.jetbrains.php.lang.parser.parsing.TypeDeclaration;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassMemberModifiers;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public final class ClassConstant {
    private static final ParserPart CONSTANT_PARSER_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            PsiBuilder.Marker classConstant = builder.mark();
            if (!ClassConstant.parseConstantName(builder, false)) {
                classConstant.error(PhpParserErrors.expected(PhpTokenTypes.IDENTIFIER));
                return PhpElementTypes.EMPTY_INPUT;
            }
            builder.match(PhpTokenTypes.opASGN);
            IElementType result = Expression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpBundle.message("initializer", new Object[0])));
            }
            classConstant.done(PhpStubElementTypes.CLASS_CONST);
            return PhpStubElementTypes.CLASS_CONST;
        }
    };

    public static boolean parseConstantName(PhpPsiBuilder builder, boolean remapKeywordToIdentifier) {
        if (builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
            return true;
        }
        if (builder.compare(PhpTokenTypes.tsKEYWORDS)) {
            if (remapKeywordToIdentifier) {
                builder.remapToIdentifier();
            }
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker classConstants = builder.mark();
        Attributes.parseAttributesList(builder);
        ClassMemberModifiers.parseConstantModifiers(builder);
        Attributes.parseAttributesList(builder);
        if (!builder.compareAndEat(PhpTokenTypes.kwCONST)) {
            classConstants.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        Attributes.parseAttributesList(builder);
        PsiBuilder.Marker beforePossibleType = builder.mark();
        IElementType type = TypeDeclaration.parseType(builder, PhpElementTypes.CLASS_CONSTANT_TYPE);
        if (type != PhpElementTypes.EMPTY_INPUT && builder.compare(PhpTokenTypes.opASGN)) {
            beforePossibleType.rollbackTo();
        } else {
            beforePossibleType.drop();
        }
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, CONSTANT_PARSER_PART.parse(builder), CONSTANT_PARSER_PART, false);
        builder.match(PhpTokenTypes.opSEMICOLON);
        classConstants.done(PhpElementTypes.CLASS_CONSTANTS);
        return PhpStubElementTypes.CLASS_CONST;
    }
}

