/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.openapi.project.Project;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.php.lang.parser.PhpElementCodeFragmentParser;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import org.jetbrains.annotations.NotNull;

public class PhpExpressionCodeFragmentParser
extends PhpElementCodeFragmentParser {
    public PhpExpressionCodeFragmentParser(@NotNull Project project) {
        super(project);
    }

    @Override
    public boolean parseFragment(@NotNull PsiBuilder psiBuilder, @NotNull PhpPsiBuilder phpPsiBuilder, boolean expressionParsed) {
        if (expressionParsed) {
            psiBuilder.error(PhpParserErrors.getExpressionExpectedMessage());
        } else {
            PsiBuilder.Marker expressionMarker = phpPsiBuilder.mark();
            IElementType result = Expression.parse(phpPsiBuilder);
            if (result != PhpElementTypes.EMPTY_INPUT) {
                expressionMarker.done(result);
                expressionParsed = true;
            } else {
                expressionMarker.drop();
                psiBuilder.error(PhpParserErrors.unexpected(psiBuilder.getTokenType()));
            }
        }
        psiBuilder.advanceLexer();
        return expressionParsed;
    }
}

