/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.Adaptation;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.ColorSpaces;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import androidx.compose.ui.graphics.colorspace.RenderIntent;
import androidx.compose.ui.graphics.colorspace.Rgb;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000  2\u00020\u0001:\u0002\u001f B;\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fB!\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\u000eJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0016J/\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0010\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00020\b\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector;", "", "source", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "destination", "transformSource", "transformDestination", "renderIntent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "transform", "", "<init>", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;I[FLkotlin/jvm/internal/DefaultConstructorMarker;)V", "intent", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getSource", "()Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "getDestination", "getRenderIntent-uksYyKA", "()I", "I", "r", "", "g", "b", "v", "transformToColor", "Landroidx/compose/ui/graphics/Color;", "a", "transformToColor-wmQWz5c$fleet_noria_ui", "(FFFF)J", "RgbConnector", "Companion", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Connector.kt\nandroidx/compose/ui/graphics/colorspace/Connector\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,339:1\n34#2:340\n41#2:341\n*S KotlinDebug\n*F\n+ 1 Connector.kt\nandroidx/compose/ui/graphics/colorspace/Connector\n*L\n162#1:340\n163#1:341\n*E\n"})
public class Connector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorSpace source;
    @NotNull
    private final ColorSpace destination;
    @NotNull
    private final ColorSpace transformSource;
    @NotNull
    private final ColorSpace transformDestination;
    private final int renderIntent;
    @Nullable
    private final float[] transform;
    @NotNull
    private static final Connector SrgbIdentity = Companion.identity$fleet_noria_ui(ColorSpaces.INSTANCE.getSrgb());
    @NotNull
    private static final Connector SrgbToOklabPerceptual = new Connector(ColorSpaces.INSTANCE.getSrgb(), ColorSpaces.INSTANCE.getOklab(), RenderIntent.Companion.getPerceptual-uksYyKA(), null);
    @NotNull
    private static final Connector OklabToSrgbPerceptual = new Connector(ColorSpaces.INSTANCE.getOklab(), ColorSpaces.INSTANCE.getSrgb(), RenderIntent.Companion.getPerceptual-uksYyKA(), null);

    private Connector(ColorSpace source, ColorSpace destination, ColorSpace transformSource, ColorSpace transformDestination, int renderIntent, float[] transform2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)transformSource, (String)"transformSource");
        Intrinsics.checkNotNullParameter((Object)transformDestination, (String)"transformDestination");
        this.source = source;
        this.destination = destination;
        this.transformSource = transformSource;
        this.transformDestination = transformDestination;
        this.renderIntent = renderIntent;
        this.transform = transform2;
    }

    @NotNull
    public final ColorSpace getSource() {
        return this.source;
    }

    @NotNull
    public final ColorSpace getDestination() {
        return this.destination;
    }

    public final int getRenderIntent-uksYyKA() {
        return this.renderIntent;
    }

    private Connector(ColorSpace source, ColorSpace destination, int intent) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        this(source, destination, ColorModel.equals-impl0(source.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) ? ColorSpaceKt.adapt$default(source, Illuminant.INSTANCE.getD50(), null, 2, null) : source, ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) ? ColorSpaceKt.adapt$default(destination, Illuminant.INSTANCE.getD50(), null, 2, null) : destination, intent, Connector.Companion.computeTransform-YBCOT_4(source, destination, intent), null);
    }

    @NotNull
    public final float[] transform(float r, float g, float b) {
        float[] fArray = new float[]{r, g, b};
        return this.transform(fArray);
    }

    @NotNull
    public float[] transform(@NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float[] xyz = this.transformSource.toXyz(v);
        if (this.transform != null) {
            xyz[0] = xyz[0] * this.transform[0];
            xyz[1] = xyz[1] * this.transform[1];
            xyz[2] = xyz[2] * this.transform[2];
        }
        return this.transformDestination.fromXyz(xyz);
    }

    public long transformToColor-wmQWz5c$fleet_noria_ui(float r, float g, float b, float a) {
        long packed = this.transformSource.toXy$fleet_noria_ui(r, g, b);
        boolean $i$f$unpackFloat1 = false;
        float x = Float.intBitsToFloat((int)(packed >> 32));
        boolean $i$f$unpackFloat2 = false;
        float y = Float.intBitsToFloat((int)(packed & 0xFFFFFFFFL));
        float z = this.transformSource.toZ$fleet_noria_ui(r, g, b);
        if (this.transform != null) {
            x *= this.transform[0];
            y *= this.transform[1];
            z *= this.transform[2];
        }
        return this.transformDestination.xyzaToColor-JlNiLsg$fleet_noria_ui(x, y, z, a, this.destination);
    }

    public /* synthetic */ Connector(ColorSpace source, ColorSpace destination, ColorSpace transformSource, ColorSpace transformDestination, int renderIntent, float[] transform2, DefaultConstructorMarker $constructor_marker) {
        this(source, destination, transformSource, transformDestination, renderIntent, transform2);
    }

    public /* synthetic */ Connector(ColorSpace source, ColorSpace destination, int intent, DefaultConstructorMarker $constructor_marker) {
        this(source, destination, intent);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000fR\u0014\u0010\u0010\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u0017"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector$Companion;", "", "<init>", "()V", "computeTransform", "", "source", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "destination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "computeTransform-YBCOT_4", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;I)[F", "identity", "Landroidx/compose/ui/graphics/colorspace/Connector;", "identity$fleet_noria_ui", "SrgbIdentity", "getSrgbIdentity$fleet_noria_ui", "()Landroidx/compose/ui/graphics/colorspace/Connector;", "SrgbToOklabPerceptual", "getSrgbToOklabPerceptual$fleet_noria_ui", "OklabToSrgbPerceptual", "getOklabToSrgbPerceptual$fleet_noria_ui", "fleet.noria.ui"})
    public static final class Companion {
        private Companion() {
        }

        private final float[] computeTransform-YBCOT_4(ColorSpace source, ColorSpace destination, int intent) {
            if (!RenderIntent.equals-impl0(intent, RenderIntent.Companion.getAbsolute-uksYyKA())) {
                return null;
            }
            boolean srcRGB = ColorModel.equals-impl0(source.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw());
            boolean dstRGB = ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw());
            if (srcRGB && dstRGB) {
                return null;
            }
            if (srcRGB || dstRGB) {
                ColorSpace colorSpace = srcRGB ? source : destination;
                Intrinsics.checkNotNull((Object)colorSpace, (String)"null cannot be cast to non-null type androidx.compose.ui.graphics.colorspace.Rgb");
                Rgb rgb = (Rgb)colorSpace;
                float[] srcXYZ = srcRGB ? rgb.getWhitePoint().toXyz$fleet_noria_ui() : Illuminant.INSTANCE.getD50Xyz$fleet_noria_ui();
                float[] dstXYZ = dstRGB ? rgb.getWhitePoint().toXyz$fleet_noria_ui() : Illuminant.INSTANCE.getD50Xyz$fleet_noria_ui();
                float[] fArray = new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
                return fArray;
            }
            return null;
        }

        @NotNull
        public final Connector identity$fleet_noria_ui(@NotNull ColorSpace source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            int n = RenderIntent.Companion.getRelative-uksYyKA();
            return new Connector(source, n){

                public float[] transform(float[] v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return v;
                }

                public long transformToColor-wmQWz5c$fleet_noria_ui(float r, float g, float b, float a) {
                    return ColorKt.Color(r, g, b, a, this.getDestination());
                }
            };
        }

        @NotNull
        public final Connector getSrgbIdentity$fleet_noria_ui() {
            return SrgbIdentity;
        }

        @NotNull
        public final Connector getSrgbToOklabPerceptual$fleet_noria_ui() {
            return SrgbToOklabPerceptual;
        }

        @NotNull
        public final Connector getOklabToSrgbPerceptual$fleet_noria_ui() {
            return OklabToSrgbPerceptual;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J/\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector$RgbConnector;", "Landroidx/compose/ui/graphics/colorspace/Connector;", "mSource", "Landroidx/compose/ui/graphics/colorspace/Rgb;", "mDestination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "<init>", "(Landroidx/compose/ui/graphics/colorspace/Rgb;Landroidx/compose/ui/graphics/colorspace/Rgb;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "mTransform", "", "transform", "v", "transformToColor", "Landroidx/compose/ui/graphics/Color;", "r", "", "g", "b", "a", "transformToColor-wmQWz5c$fleet_noria_ui", "(FFFF)J", "computeTransform", "source", "destination", "computeTransform-YBCOT_4", "(Landroidx/compose/ui/graphics/colorspace/Rgb;Landroidx/compose/ui/graphics/colorspace/Rgb;I)[F", "fleet.noria.ui"})
    public static final class RgbConnector
    extends Connector {
        @NotNull
        private final Rgb mSource;
        @NotNull
        private final Rgb mDestination;
        @NotNull
        private final float[] mTransform;

        private RgbConnector(Rgb mSource, Rgb mDestination, int intent) {
            Intrinsics.checkNotNullParameter((Object)mSource, (String)"mSource");
            Intrinsics.checkNotNullParameter((Object)mDestination, (String)"mDestination");
            super(mSource, mDestination, mSource, mDestination, intent, null, null);
            this.mSource = mSource;
            this.mDestination = mDestination;
            this.mTransform = this.computeTransform-YBCOT_4(this.mSource, this.mDestination, intent);
        }

        @Override
        @NotNull
        public float[] transform(@NotNull float[] v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            v[0] = (float)this.mSource.getEotfFunc$fleet_noria_ui().invoke(v[0]);
            v[1] = (float)this.mSource.getEotfFunc$fleet_noria_ui().invoke(v[1]);
            v[2] = (float)this.mSource.getEotfFunc$fleet_noria_ui().invoke(v[2]);
            ColorSpaceKt.mul3x3Float3(this.mTransform, v);
            v[0] = (float)this.mDestination.getOetfFunc$fleet_noria_ui().invoke(v[0]);
            v[1] = (float)this.mDestination.getOetfFunc$fleet_noria_ui().invoke(v[1]);
            v[2] = (float)this.mDestination.getOetfFunc$fleet_noria_ui().invoke(v[2]);
            return v;
        }

        @Override
        public long transformToColor-wmQWz5c$fleet_noria_ui(float r, float g, float b, float a) {
            float v0 = (float)this.mSource.getEotfFunc$fleet_noria_ui().invoke(r);
            float v1 = (float)this.mSource.getEotfFunc$fleet_noria_ui().invoke(g);
            float v2 = (float)this.mSource.getEotfFunc$fleet_noria_ui().invoke(b);
            float v01 = ColorSpaceKt.mul3x3Float3_0(this.mTransform, v0, v1, v2);
            float v11 = ColorSpaceKt.mul3x3Float3_1(this.mTransform, v0, v1, v2);
            float v21 = ColorSpaceKt.mul3x3Float3_2(this.mTransform, v0, v1, v2);
            float v02 = (float)this.mDestination.getOetfFunc$fleet_noria_ui().invoke(v01);
            float v12 = (float)this.mDestination.getOetfFunc$fleet_noria_ui().invoke(v11);
            float v22 = (float)this.mDestination.getOetfFunc$fleet_noria_ui().invoke(v21);
            return ColorKt.Color(v02, v12, v22, a, this.mDestination);
        }

        private final float[] computeTransform-YBCOT_4(Rgb source, Rgb destination, int intent) {
            if (ColorSpaceKt.compare(source.getWhitePoint(), destination.getWhitePoint())) {
                return ColorSpaceKt.mul3x3(destination.getInverseTransform$fleet_noria_ui(), source.getTransform$fleet_noria_ui());
            }
            float[] transform2 = source.getTransform$fleet_noria_ui();
            float[] inverseTransform = destination.getInverseTransform$fleet_noria_ui();
            float[] srcXYZ = source.getWhitePoint().toXyz$fleet_noria_ui();
            float[] dstXYZ = destination.getWhitePoint().toXyz$fleet_noria_ui();
            if (!ColorSpaceKt.compare(source.getWhitePoint(), Illuminant.INSTANCE.getD50())) {
                float[] fArray = Adaptation.Companion.getBradford().getTransform$fleet_noria_ui();
                float[] fArray2 = Illuminant.INSTANCE.getD50Xyz$fleet_noria_ui();
                float[] fArray3 = Arrays.copyOf(fArray2, fArray2.length);
                Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"copyOf(...)");
                float[] srcAdaptation = ColorSpaceKt.chromaticAdaptation(fArray, srcXYZ, fArray3);
                transform2 = ColorSpaceKt.mul3x3(srcAdaptation, source.getTransform$fleet_noria_ui());
            }
            if (!ColorSpaceKt.compare(destination.getWhitePoint(), Illuminant.INSTANCE.getD50())) {
                float[] fArray = Adaptation.Companion.getBradford().getTransform$fleet_noria_ui();
                float[] fArray4 = Illuminant.INSTANCE.getD50Xyz$fleet_noria_ui();
                float[] fArray5 = Arrays.copyOf(fArray4, fArray4.length);
                Intrinsics.checkNotNullExpressionValue((Object)fArray5, (String)"copyOf(...)");
                float[] dstAdaptation = ColorSpaceKt.chromaticAdaptation(fArray, dstXYZ, fArray5);
                inverseTransform = ColorSpaceKt.inverse3x3(ColorSpaceKt.mul3x3(dstAdaptation, destination.getTransform$fleet_noria_ui()));
            }
            if (RenderIntent.equals-impl0(intent, RenderIntent.Companion.getAbsolute-uksYyKA())) {
                float[] fArray = new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
                transform2 = ColorSpaceKt.mul3x3Diag(fArray, transform2);
            }
            return ColorSpaceKt.mul3x3(inverseTransform, transform2);
        }

        public /* synthetic */ RgbConnector(Rgb mSource, Rgb mDestination, int intent, DefaultConstructorMarker $constructor_marker) {
            this(mSource, mDestination, intent);
        }
    }
}

