/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.geometry;

import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.Stable;
import androidx.compose.ui.geometry.GeometryUtilsKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.SizeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u0000 V2\u00020\u0001:\u0001VB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(H\u0007\u00a2\u0006\u0004\b)\u0010*J\u0018\u0010&\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0007J\u0010\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003H\u0007J\u0010\u0010/\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003H\u0007J\u0010\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0000H\u0007J\u000e\u00102\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u0000J\u0018\u0010I\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0086\u0002\u00a2\u0006\u0004\bJ\u0010KJ\b\u0010L\u001a\u00020MH\u0016J\t\u0010N\u001a\u00020\u0003H\u00c6\u0003J\t\u0010O\u001a\u00020\u0003H\u00c6\u0003J\t\u0010P\u001a\u00020\u0003H\u00c6\u0003J\t\u0010Q\u001a\u00020\u0003H\u00c6\u0003J1\u0010R\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010S\u001a\u00020\u001f2\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010T\u001a\u00020UH\u00d6\u0001R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u001c\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\fR\u001c\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\n\u001a\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\n\u001a\u0004\b\u0015\u0010\fR\u001a\u0010\u0016\u001a\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\n\u001a\u0004\b\u0018\u0010\fR\u001a\u0010\u0019\u001a\u00020\u001a8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\n\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b \u0010\n\u001a\u0004\b\u001e\u0010!R\u001a\u0010\"\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b#\u0010\n\u001a\u0004\b\"\u0010!R\u001a\u0010$\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b%\u0010\n\u001a\u0004\b$\u0010!R\u0011\u00103\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\fR\u0011\u00105\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\fR\u0011\u00107\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u001dR\u0011\u00109\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001dR\u0011\u0010;\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u001dR\u0011\u0010=\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u001dR\u0011\u0010?\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u001dR\u0011\u0010A\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u001dR\u0011\u0010C\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u001dR\u0011\u0010E\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u001dR\u0011\u0010G\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u001d\u00a8\u0006W"}, d2={"Landroidx/compose/ui/geometry/Rect;", "", "left", "", "top", "right", "bottom", "<init>", "(FFFF)V", "getLeft$annotations", "()V", "getLeft", "()F", "getTop$annotations", "getTop", "getRight$annotations", "getRight", "getBottom$annotations", "getBottom", "width", "getWidth$annotations", "getWidth", "height", "getHeight$annotations", "getHeight", "size", "Landroidx/compose/ui/geometry/Size;", "getSize-NH-jbRc$annotations", "getSize-NH-jbRc", "()J", "isInfinite", "", "isInfinite$annotations", "()Z", "isFinite", "isFinite$annotations", "isEmpty", "isEmpty$annotations", "translate", "offset", "Landroidx/compose/ui/geometry/Offset;", "translate-k-4lQ0M", "(J)Landroidx/compose/ui/geometry/Rect;", "translateX", "translateY", "inflate", "delta", "deflate", "intersect", "other", "overlaps", "minDimension", "getMinDimension", "maxDimension", "getMaxDimension", "topLeft", "getTopLeft-F1C5BW0", "topCenter", "getTopCenter-F1C5BW0", "topRight", "getTopRight-F1C5BW0", "centerLeft", "getCenterLeft-F1C5BW0", "center", "getCenter-F1C5BW0", "centerRight", "getCenterRight-F1C5BW0", "bottomLeft", "getBottomLeft-F1C5BW0", "bottomCenter", "getBottomCenter-F1C5BW0", "bottomRight", "getBottomRight-F1C5BW0", "contains", "contains-k-4lQ0M", "(J)Z", "toString", "", "component1", "component2", "component3", "component4", "copy", "equals", "hashCode", "", "Companion", "fleet.noria.ui"})
@Immutable
public final class Rect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;
    @NotNull
    private static final Rect Zero = new Rect(0.0f, 0.0f, 0.0f, 0.0f);

    public Rect(float left2, float top, float right2, float bottom) {
        this.left = left2;
        this.top = top;
        this.right = right2;
        this.bottom = bottom;
    }

    public final float getLeft() {
        return this.left;
    }

    @Stable
    public static /* synthetic */ void getLeft$annotations() {
    }

    public final float getTop() {
        return this.top;
    }

    @Stable
    public static /* synthetic */ void getTop$annotations() {
    }

    public final float getRight() {
        return this.right;
    }

    @Stable
    public static /* synthetic */ void getRight$annotations() {
    }

    public final float getBottom() {
        return this.bottom;
    }

    @Stable
    public static /* synthetic */ void getBottom$annotations() {
    }

    public final float getWidth() {
        return this.right - this.left;
    }

    @Stable
    public static /* synthetic */ void getWidth$annotations() {
    }

    public final float getHeight() {
        return this.bottom - this.top;
    }

    @Stable
    public static /* synthetic */ void getHeight$annotations() {
    }

    public final long getSize-NH-jbRc() {
        return SizeKt.Size(this.getWidth(), this.getHeight());
    }

    @Stable
    public static /* synthetic */ void getSize-NH-jbRc$annotations() {
    }

    public final boolean isInfinite() {
        return this.left >= Float.POSITIVE_INFINITY || this.top >= Float.POSITIVE_INFINITY || this.right >= Float.POSITIVE_INFINITY || this.bottom >= Float.POSITIVE_INFINITY;
    }

    @Stable
    public static /* synthetic */ void isInfinite$annotations() {
    }

    public final boolean isFinite() {
        float f = this.left;
        return !Float.isInfinite(f) && !Float.isNaN(f) && !Float.isInfinite(f = this.top) && !Float.isNaN(f) && !Float.isInfinite(f = this.right) && !Float.isNaN(f) && !Float.isInfinite(f = this.bottom) && !Float.isNaN(f);
    }

    @Stable
    public static /* synthetic */ void isFinite$annotations() {
    }

    public final boolean isEmpty() {
        return this.left >= this.right || this.top >= this.bottom;
    }

    @Stable
    public static /* synthetic */ void isEmpty$annotations() {
    }

    @Stable
    @NotNull
    public final Rect translate-k-4lQ0M(long offset) {
        return new Rect(this.left + Offset.getX-impl(offset), this.top + Offset.getY-impl(offset), this.right + Offset.getX-impl(offset), this.bottom + Offset.getY-impl(offset));
    }

    @Stable
    @NotNull
    public final Rect translate(float translateX, float translateY) {
        return new Rect(this.left + translateX, this.top + translateY, this.right + translateX, this.bottom + translateY);
    }

    @Stable
    @NotNull
    public final Rect inflate(float delta) {
        return new Rect(this.left - delta, this.top - delta, this.right + delta, this.bottom + delta);
    }

    @Stable
    @NotNull
    public final Rect deflate(float delta) {
        return this.inflate(-delta);
    }

    @Stable
    @NotNull
    public final Rect intersect(@NotNull Rect other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Rect(Math.max(this.left, other.left), Math.max(this.top, other.top), Math.min(this.right, other.right), Math.min(this.bottom, other.bottom));
    }

    public final boolean overlaps(@NotNull Rect other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.right <= other.left || other.right <= this.left) {
            return false;
        }
        return !(this.bottom <= other.top) && !(other.bottom <= this.top);
    }

    public final float getMinDimension() {
        return Math.min(Math.abs(this.getWidth()), Math.abs(this.getHeight()));
    }

    public final float getMaxDimension() {
        return Math.max(Math.abs(this.getWidth()), Math.abs(this.getHeight()));
    }

    public final long getTopLeft-F1C5BW0() {
        return OffsetKt.Offset(this.left, this.top);
    }

    public final long getTopCenter-F1C5BW0() {
        return OffsetKt.Offset(this.left + this.getWidth() / 2.0f, this.top);
    }

    public final long getTopRight-F1C5BW0() {
        return OffsetKt.Offset(this.right, this.top);
    }

    public final long getCenterLeft-F1C5BW0() {
        return OffsetKt.Offset(this.left, this.top + this.getHeight() / 2.0f);
    }

    public final long getCenter-F1C5BW0() {
        return OffsetKt.Offset(this.left + this.getWidth() / 2.0f, this.top + this.getHeight() / 2.0f);
    }

    public final long getCenterRight-F1C5BW0() {
        return OffsetKt.Offset(this.right, this.top + this.getHeight() / 2.0f);
    }

    public final long getBottomLeft-F1C5BW0() {
        return OffsetKt.Offset(this.left, this.bottom);
    }

    public final long getBottomCenter-F1C5BW0() {
        return OffsetKt.Offset(this.left + this.getWidth() / 2.0f, this.bottom);
    }

    public final long getBottomRight-F1C5BW0() {
        return OffsetKt.Offset(this.right, this.bottom);
    }

    public final boolean contains-k-4lQ0M(long offset) {
        return Offset.getX-impl(offset) >= this.left && Offset.getX-impl(offset) < this.right && Offset.getY-impl(offset) >= this.top && Offset.getY-impl(offset) < this.bottom;
    }

    @NotNull
    public String toString() {
        return "Rect.fromLTRB(" + GeometryUtilsKt.toStringAsFixed(this.left, 1) + ", " + GeometryUtilsKt.toStringAsFixed(this.top, 1) + ", " + GeometryUtilsKt.toStringAsFixed(this.right, 1) + ", " + GeometryUtilsKt.toStringAsFixed(this.bottom, 1) + ")";
    }

    public final float component1() {
        return this.left;
    }

    public final float component2() {
        return this.top;
    }

    public final float component3() {
        return this.right;
    }

    public final float component4() {
        return this.bottom;
    }

    @NotNull
    public final Rect copy(float left2, float top, float right2, float bottom) {
        return new Rect(left2, top, right2, bottom);
    }

    public static /* synthetic */ Rect copy$default(Rect rect, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = rect.left;
        }
        if ((n & 2) != 0) {
            f2 = rect.top;
        }
        if ((n & 4) != 0) {
            f3 = rect.right;
        }
        if ((n & 8) != 0) {
            f4 = rect.bottom;
        }
        return rect.copy(f, f2, f3, f4);
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.left);
        result2 = result2 * 31 + Float.hashCode(this.top);
        result2 = result2 * 31 + Float.hashCode(this.right);
        result2 = result2 * 31 + Float.hashCode(this.bottom);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rect)) {
            return false;
        }
        Rect rect = (Rect)other;
        if (Float.compare(this.left, rect.left) != 0) {
            return false;
        }
        if (Float.compare(this.top, rect.top) != 0) {
            return false;
        }
        if (Float.compare(this.right, rect.right) != 0) {
            return false;
        }
        return Float.compare(this.bottom, rect.bottom) == 0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/geometry/Rect$Companion;", "", "<init>", "()V", "Zero", "Landroidx/compose/ui/geometry/Rect;", "getZero$annotations", "getZero", "()Landroidx/compose/ui/geometry/Rect;", "fleet.noria.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rect getZero() {
            return Zero;
        }

        @Stable
        public static /* synthetic */ void getZero$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

