/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.Arrangement;
import androidx.compose.foundation.layout.CrossAxisAlignment;
import androidx.compose.foundation.layout.LayoutOrientation;
import androidx.compose.foundation.layout.OrientationIndependentConstraints;
import androidx.compose.foundation.layout.RowColumnImplKt;
import androidx.compose.foundation.layout.RowColumnMeasureHelperResult;
import androidx.compose.foundation.layout.RowColumnParentData;
import androidx.compose.foundation.layout.SizeMode;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\n\u0010/\u001a\u000200*\u00020\u0015J\n\u0010\n\u001a\u000200*\u00020\u0015J&\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002002\u0006\u00108\u001a\u000200J(\u00109\u001a\u00020:2\u0006\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020:2\u0006\u00109\u001a\u00020:2\u0006\u00103\u001a\u000204H\u0002J2\u0010=\u001a\u0002002\u0006\u0010>\u001a\u00020\u00152\b\u0010?\u001a\u0004\u0018\u00010-2\u0006\u0010@\u001a\u0002002\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u000200H\u0002J&\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u0002022\u0006\u0010I\u001a\u0002002\u0006\u0010A\u001a\u00020BR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\b\u001a\u00020\t\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001b\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014\u00a2\u0006\n\n\u0002\u0010+\u001a\u0004\b)\u0010*R\u0018\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010.\u00a8\u0006J"}, d2={"Landroidx/compose/foundation/layout/RowColumnMeasurementHelper;", "", "orientation", "Landroidx/compose/foundation/layout/LayoutOrientation;", "horizontalArrangement", "Landroidx/compose/foundation/layout/Arrangement$Horizontal;", "verticalArrangement", "Landroidx/compose/foundation/layout/Arrangement$Vertical;", "arrangementSpacing", "Landroidx/compose/ui/unit/Dp;", "crossAxisSize", "Landroidx/compose/foundation/layout/SizeMode;", "crossAxisAlignment", "Landroidx/compose/foundation/layout/CrossAxisAlignment;", "propagateCrossAxisMinConstraint", "", "measurables", "", "Landroidx/compose/ui/layout/Measurable;", "placeables", "", "Landroidx/compose/ui/layout/Placeable;", "<init>", "(Landroidx/compose/foundation/layout/LayoutOrientation;Landroidx/compose/foundation/layout/Arrangement$Horizontal;Landroidx/compose/foundation/layout/Arrangement$Vertical;FLandroidx/compose/foundation/layout/SizeMode;Landroidx/compose/foundation/layout/CrossAxisAlignment;ZLjava/util/List;[Landroidx/compose/ui/layout/Placeable;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getOrientation", "()Landroidx/compose/foundation/layout/LayoutOrientation;", "getHorizontalArrangement", "()Landroidx/compose/foundation/layout/Arrangement$Horizontal;", "getVerticalArrangement", "()Landroidx/compose/foundation/layout/Arrangement$Vertical;", "getArrangementSpacing-D9Ej5fM", "()F", "F", "getCrossAxisSize", "()Landroidx/compose/foundation/layout/SizeMode;", "getCrossAxisAlignment", "()Landroidx/compose/foundation/layout/CrossAxisAlignment;", "getPropagateCrossAxisMinConstraint", "()Z", "getMeasurables", "()Ljava/util/List;", "getPlaceables", "()[Landroidx/compose/ui/layout/Placeable;", "[Landroidx/compose/ui/layout/Placeable;", "rowColumnParentData", "Landroidx/compose/foundation/layout/RowColumnParentData;", "[Landroidx/compose/foundation/layout/RowColumnParentData;", "mainAxisSize", "", "measureWithoutPlacing", "Landroidx/compose/foundation/layout/RowColumnMeasureHelperResult;", "measureScope", "Landroidx/compose/ui/layout/MeasureScope;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "startIndex", "endIndex", "mainAxisPositions", "", "mainAxisLayoutSize", "childrenMainAxisSize", "getCrossAxisPosition", "placeable", "parentData", "crossAxisLayoutSize", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "beforeCrossAxisAlignmentLine", "placeHelper", "", "placeableScope", "Landroidx/compose/ui/layout/Placeable$PlacementScope;", "measureResult", "crossAxisOffset", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nRowColumnMeasurementHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RowColumnMeasurementHelper.kt\nandroidx/compose/foundation/layout/RowColumnMeasurementHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n1#2:345\n*E\n"})
public final class RowColumnMeasurementHelper {
    @NotNull
    private final LayoutOrientation orientation;
    @Nullable
    private final Arrangement.Horizontal horizontalArrangement;
    @Nullable
    private final Arrangement.Vertical verticalArrangement;
    private final float arrangementSpacing;
    @NotNull
    private final SizeMode crossAxisSize;
    @NotNull
    private final CrossAxisAlignment crossAxisAlignment;
    private final boolean propagateCrossAxisMinConstraint;
    @NotNull
    private final List<Measurable> measurables;
    @NotNull
    private final Placeable[] placeables;
    @NotNull
    private final RowColumnParentData[] rowColumnParentData;

    private RowColumnMeasurementHelper(LayoutOrientation orientation, Arrangement.Horizontal horizontalArrangement, Arrangement.Vertical verticalArrangement, float arrangementSpacing, SizeMode crossAxisSize, CrossAxisAlignment crossAxisAlignment, boolean propagateCrossAxisMinConstraint, List<? extends Measurable> measurables, Placeable[] placeables) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)((Object)crossAxisSize), (String)"crossAxisSize");
        Intrinsics.checkNotNullParameter((Object)crossAxisAlignment, (String)"crossAxisAlignment");
        Intrinsics.checkNotNullParameter(measurables, (String)"measurables");
        Intrinsics.checkNotNullParameter((Object)placeables, (String)"placeables");
        this.orientation = orientation;
        this.horizontalArrangement = horizontalArrangement;
        this.verticalArrangement = verticalArrangement;
        this.arrangementSpacing = arrangementSpacing;
        this.crossAxisSize = crossAxisSize;
        this.crossAxisAlignment = crossAxisAlignment;
        this.propagateCrossAxisMinConstraint = propagateCrossAxisMinConstraint;
        this.measurables = measurables;
        this.placeables = placeables;
        int n = 0;
        int n2 = this.measurables.size();
        RowColumnParentData[] rowColumnParentDataArray = new RowColumnParentData[n2];
        RowColumnMeasurementHelper rowColumnMeasurementHelper = this;
        while (n < n2) {
            int n3 = n++;
            rowColumnParentDataArray[n3] = RowColumnImplKt.getRowColumnParentData(this.measurables.get(n3));
        }
        rowColumnMeasurementHelper.rowColumnParentData = rowColumnParentDataArray;
    }

    @NotNull
    public final LayoutOrientation getOrientation() {
        return this.orientation;
    }

    @Nullable
    public final Arrangement.Horizontal getHorizontalArrangement() {
        return this.horizontalArrangement;
    }

    @Nullable
    public final Arrangement.Vertical getVerticalArrangement() {
        return this.verticalArrangement;
    }

    public final float getArrangementSpacing-D9Ej5fM() {
        return this.arrangementSpacing;
    }

    @NotNull
    public final SizeMode getCrossAxisSize() {
        return this.crossAxisSize;
    }

    @NotNull
    public final CrossAxisAlignment getCrossAxisAlignment() {
        return this.crossAxisAlignment;
    }

    public final boolean getPropagateCrossAxisMinConstraint() {
        return this.propagateCrossAxisMinConstraint;
    }

    @NotNull
    public final List<Measurable> getMeasurables() {
        return this.measurables;
    }

    @NotNull
    public final Placeable[] getPlaceables() {
        return this.placeables;
    }

    public final int mainAxisSize(@NotNull Placeable $this$mainAxisSize) {
        Intrinsics.checkNotNullParameter((Object)$this$mainAxisSize, (String)"<this>");
        return this.orientation == LayoutOrientation.Horizontal ? $this$mainAxisSize.getWidth() : $this$mainAxisSize.getHeight();
    }

    public final int crossAxisSize(@NotNull Placeable $this$crossAxisSize) {
        Intrinsics.checkNotNullParameter((Object)$this$crossAxisSize, (String)"<this>");
        return this.orientation == LayoutOrientation.Horizontal ? $this$crossAxisSize.getHeight() : $this$crossAxisSize.getWidth();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RowColumnMeasureHelperResult measureWithoutPlacing(@NotNull MeasureScope measureScope, @NotNull Constraints constraints, int startIndex, int endIndex) {
        int n;
        int n2;
        Iterator iterator2;
        int n3;
        Object placeable;
        Intrinsics.checkNotNullParameter((Object)measureScope, (String)"measureScope");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        OrientationIndependentConstraints constraints2 = new OrientationIndependentConstraints(constraints, this.orientation);
        MeasureScope $this$measureWithoutPlacing_u24lambda_u240 = measureScope;
        boolean bl = false;
        int arrangementSpacingPx = $this$measureWithoutPlacing_u24lambda_u240.roundToPx-0680j_4(this.arrangementSpacing);
        float totalWeight = 0.0f;
        int fixedSpace = 0;
        int crossAxisSpace = 0;
        int weightChildrenCount = 0;
        boolean anyAlignBy = false;
        int subSize = endIndex - startIndex;
        int spaceAfterLastNoWeight = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            Measurable child2 = this.measurables.get(i);
            RowColumnParentData parentData2 = this.rowColumnParentData[i];
            float weight = RowColumnImplKt.getWeight(parentData2);
            if (weight > 0.0f) {
                totalWeight += weight;
                ++weightChildrenCount;
                continue;
            }
            int mainAxisMax = constraints2.getMainAxisMax();
            Placeable placeable2 = this.placeables[i];
            if (placeable2 == null) {
                placeable2 = child2.measure(OrientationIndependentConstraints.copy$default(constraints2, 0, mainAxisMax == Integer.MAX_VALUE ? Integer.MAX_VALUE : mainAxisMax - fixedSpace, this.propagateCrossAxisMinConstraint ? constraints2.getCrossAxisMin() : 0, 0, 8, null).toBoxConstraints(this.orientation));
            }
            placeable = placeable2;
            spaceAfterLastNoWeight = Math.min(arrangementSpacingPx, mainAxisMax - fixedSpace - this.mainAxisSize((Placeable)placeable));
            fixedSpace += this.mainAxisSize((Placeable)placeable) + spaceAfterLastNoWeight;
            crossAxisSpace = Math.max(crossAxisSpace, this.crossAxisSize((Placeable)placeable));
            anyAlignBy = anyAlignBy || RowColumnImplKt.isRelative(parentData2);
            this.placeables[i] = placeable;
        }
        int weightedSpace = 0;
        if (weightChildrenCount == 0) {
            fixedSpace -= spaceAfterLastNoWeight;
        } else {
            int targetSpace = totalWeight > 0.0f && constraints2.getMainAxisMax() != Integer.MAX_VALUE ? constraints2.getMainAxisMax() : constraints2.getMainAxisMin();
            int remainingToTarget = targetSpace - fixedSpace - arrangementSpacingPx * (weightChildrenCount - 1);
            float weightUnitSpace = totalWeight > 0.0f ? (float)remainingToTarget / totalWeight : 0.0f;
            placeable = (Iterable)RangesKt.until((int)startIndex, (int)endIndex);
            n3 = remainingToTarget;
            int n4 = 0;
            iterator2 = placeable.iterator();
            while (iterator2.hasNext()) {
                void it;
                int n5;
                n2 = n5 = ((IntIterator)iterator2).nextInt();
                n = n4;
                boolean bl2 = false;
                int n6 = MathKt.roundToInt((float)(weightUnitSpace * RowColumnImplKt.getWeight(this.rowColumnParentData[it])));
                n4 = n + n6;
            }
            n = n4;
            int remainder = n3 - n;
            for (int i = startIndex; i < endIndex; ++i) {
                if (this.placeables[i] != null) continue;
                Measurable child3 = this.measurables.get(i);
                RowColumnParentData parentData3 = this.rowColumnParentData[i];
                float weight = RowColumnImplKt.getWeight(parentData3);
                if (!(weight > 0.0f)) {
                    boolean $i$a$-check-RowColumnMeasurementHelper$measureWithoutPlacing$22 = false;
                    String $i$a$-check-RowColumnMeasurementHelper$measureWithoutPlacing$22 = "All weights <= 0 should have placeables";
                    throw new IllegalStateException($i$a$-check-RowColumnMeasurementHelper$measureWithoutPlacing$22.toString());
                }
                int remainderUnit = MathKt.getSign((int)remainder);
                remainder -= remainderUnit;
                int childMainAxisSize = Math.max(0, MathKt.roundToInt((float)(weightUnitSpace * weight)) + remainderUnit);
                Placeable placeable3 = child3.measure(new OrientationIndependentConstraints(RowColumnImplKt.getFill(parentData3) && childMainAxisSize != Integer.MAX_VALUE ? childMainAxisSize : 0, childMainAxisSize, this.propagateCrossAxisMinConstraint ? constraints2.getCrossAxisMin() : 0, constraints2.getCrossAxisMax()).toBoxConstraints(this.orientation));
                weightedSpace += this.mainAxisSize(placeable3);
                crossAxisSpace = Math.max(crossAxisSpace, this.crossAxisSize(placeable3));
                anyAlignBy = anyAlignBy || RowColumnImplKt.isRelative(parentData3);
                this.placeables[i] = placeable3;
            }
            weightedSpace = RangesKt.coerceAtMost((int)(weightedSpace + arrangementSpacingPx * (weightChildrenCount - 1)), (int)(constraints2.getMainAxisMax() - fixedSpace));
        }
        int beforeCrossAxisAlignmentLine = 0;
        int afterCrossAxisAlignmentLine = 0;
        if (anyAlignBy) {
            for (int i = startIndex; i < endIndex; ++i) {
                Placeable placeable4;
                Integer alignmentLinePosition;
                Intrinsics.checkNotNull((Object)this.placeables[i]);
                RowColumnParentData parentData4 = this.rowColumnParentData[i];
                iterator2 = RowColumnImplKt.getCrossAxisAlignment(parentData4);
                Integer n7 = alignmentLinePosition = iterator2 != null ? ((CrossAxisAlignment)((Object)iterator2)).calculateAlignmentLinePosition$fleet_noria_ui(placeable4) : null;
                if (alignmentLinePosition == null) continue;
                int it = ((Number)alignmentLinePosition).intValue();
                boolean bl3 = false;
                int n8 = it != Integer.MIN_VALUE ? it : 0;
                beforeCrossAxisAlignmentLine = Math.max(beforeCrossAxisAlignmentLine, n8);
                it = ((Number)alignmentLinePosition).intValue();
                n3 = this.crossAxisSize(placeable4);
                boolean bl4 = false;
                n = it != Integer.MIN_VALUE ? it : this.crossAxisSize(placeable4);
                n8 = n3 - n;
                afterCrossAxisAlignmentLine = Math.max(afterCrossAxisAlignmentLine, n8);
            }
        }
        int mainAxisLayoutSize = Math.max(fixedSpace + weightedSpace, constraints2.getMainAxisMin());
        int crossAxisLayoutSize = constraints2.getCrossAxisMax() != Integer.MAX_VALUE && this.crossAxisSize == SizeMode.Expand ? constraints2.getCrossAxisMax() : Math.max(crossAxisSpace, Math.max(constraints2.getCrossAxisMin(), beforeCrossAxisAlignmentLine + afterCrossAxisAlignmentLine));
        int alignmentLinePosition = 0;
        iterator2 = (Iterator)new int[subSize];
        while (alignmentLinePosition < subSize) {
            int n9 = alignmentLinePosition++;
            iterator2[n9] = (Iterator)false;
        }
        Iterator mainAxisPositions = iterator2;
        int n10 = 0;
        int[] nArray = new int[subSize];
        while (n10 < subSize) {
            n2 = n10++;
            Placeable placeable5 = this.placeables[n2 + startIndex];
            Intrinsics.checkNotNull((Object)placeable5);
            nArray[n2] = this.mainAxisSize(placeable5);
        }
        int[] childrenMainAxisSize = nArray;
        n10 = beforeCrossAxisAlignmentLine;
        nArray = this.mainAxisPositions(mainAxisLayoutSize, childrenMainAxisSize, (int[])mainAxisPositions, measureScope);
        return new RowColumnMeasureHelperResult(crossAxisLayoutSize, mainAxisLayoutSize, startIndex, endIndex, n10, nArray);
    }

    private final int[] mainAxisPositions(int mainAxisLayoutSize, int[] childrenMainAxisSize, int[] mainAxisPositions, MeasureScope measureScope) {
        if (this.orientation == LayoutOrientation.Vertical) {
            Arrangement.Vertical vertical = this.verticalArrangement;
            if (vertical == null) {
                boolean $i$a$-requireNotNull-RowColumnMeasurementHelper$mainAxisPositions$22 = false;
                String $i$a$-requireNotNull-RowColumnMeasurementHelper$mainAxisPositions$22 = "null verticalArrangement in Column";
                throw new IllegalArgumentException($i$a$-requireNotNull-RowColumnMeasurementHelper$mainAxisPositions$22.toString());
            }
            Arrangement.Vertical $this$mainAxisPositions_u24lambda_u246 = vertical;
            boolean bl = false;
            $this$mainAxisPositions_u24lambda_u246.arrange(measureScope, mainAxisLayoutSize, childrenMainAxisSize, mainAxisPositions);
        } else {
            Arrangement.Horizontal horizontal = this.horizontalArrangement;
            if (horizontal == null) {
                boolean $i$a$-requireNotNull-RowColumnMeasurementHelper$mainAxisPositions$42 = false;
                String $i$a$-requireNotNull-RowColumnMeasurementHelper$mainAxisPositions$42 = "null horizontalArrangement in Row";
                throw new IllegalArgumentException($i$a$-requireNotNull-RowColumnMeasurementHelper$mainAxisPositions$42.toString());
            }
            Arrangement.Horizontal $this$mainAxisPositions_u24lambda_u248 = horizontal;
            boolean bl = false;
            $this$mainAxisPositions_u24lambda_u248.arrange(measureScope, mainAxisLayoutSize, childrenMainAxisSize, measureScope.getLayoutDirection(), mainAxisPositions);
        }
        return mainAxisPositions;
    }

    private final int getCrossAxisPosition(Placeable placeable, RowColumnParentData parentData2, int crossAxisLayoutSize, LayoutDirection layoutDirection, int beforeCrossAxisAlignmentLine) {
        Object object = parentData2;
        if (object == null || (object = ((RowColumnParentData)object).getCrossAxisAlignment()) == null) {
            object = this.crossAxisAlignment;
        }
        Object childCrossAlignment = object;
        return ((CrossAxisAlignment)childCrossAlignment).align$fleet_noria_ui(crossAxisLayoutSize - this.crossAxisSize(placeable), this.orientation == LayoutOrientation.Horizontal ? LayoutDirection.Ltr : layoutDirection, placeable, beforeCrossAxisAlignmentLine);
    }

    public final void placeHelper(@NotNull Placeable.PlacementScope placeableScope, @NotNull RowColumnMeasureHelperResult measureResult2, int crossAxisOffset, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)placeableScope, (String)"placeableScope");
        Intrinsics.checkNotNullParameter((Object)measureResult2, (String)"measureResult");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        Placeable.PlacementScope $this$placeHelper_u24lambda_u249 = placeableScope;
        boolean bl = false;
        int n = measureResult2.getEndIndex();
        for (int i = measureResult2.getStartIndex(); i < n; ++i) {
            Placeable placeable = this.placeables[i];
            Intrinsics.checkNotNull((Object)placeable);
            int[] mainAxisPositions = measureResult2.getMainAxisPositions();
            Object object = this.measurables.get(i).getParentData();
            int crossAxisPosition = this.getCrossAxisPosition(placeable, object instanceof RowColumnParentData ? (RowColumnParentData)object : null, measureResult2.getCrossAxisSize(), layoutDirection, measureResult2.getBeforeCrossAxisAlignmentLine()) + crossAxisOffset;
            if (this.orientation == LayoutOrientation.Horizontal) {
                Placeable.PlacementScope.place$default($this$placeHelper_u24lambda_u249, placeable, mainAxisPositions[i - measureResult2.getStartIndex()], crossAxisPosition, 0.0f, 4, null);
                continue;
            }
            Placeable.PlacementScope.place$default($this$placeHelper_u24lambda_u249, placeable, crossAxisPosition, mainAxisPositions[i - measureResult2.getStartIndex()], 0.0f, 4, null);
        }
    }

    public /* synthetic */ RowColumnMeasurementHelper(LayoutOrientation orientation, Arrangement.Horizontal horizontalArrangement, Arrangement.Vertical verticalArrangement, float arrangementSpacing, SizeMode crossAxisSize, CrossAxisAlignment crossAxisAlignment, boolean propagateCrossAxisMinConstraint, List measurables, Placeable[] placeables, DefaultConstructorMarker $constructor_marker) {
        this(orientation, horizontalArrangement, verticalArrangement, arrangementSpacing, crossAxisSize, crossAxisAlignment, propagateCrossAxisMinConstraint, measurables, placeables);
    }
}

