/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.DurationBasedAnimationSpec;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedKeyframesSpec;
import androidx.compose.runtime.Immutable;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u0015\u0016B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\b\b\u0001\u0010\u0011*\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00110\u0014H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Landroidx/compose/animation/core/KeyframesSpec;", "T", "Landroidx/compose/animation/core/DurationBasedAnimationSpec;", "config", "Landroidx/compose/animation/core/KeyframesSpec$KeyframesSpecConfig;", "<init>", "(Landroidx/compose/animation/core/KeyframesSpec$KeyframesSpecConfig;)V", "getConfig", "()Landroidx/compose/animation/core/KeyframesSpec$KeyframesSpecConfig;", "equals", "", "other", "", "hashCode", "", "vectorize", "Landroidx/compose/animation/core/VectorizedKeyframesSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "converter", "Landroidx/compose/animation/core/TwoWayConverter;", "KeyframesSpecConfig", "KeyframeEntity", "fleet.noria.ui"})
@Immutable
@SourceDebugExtension(value={"SMAP\nAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationSpec.kt\nandroidx/compose/animation/core/KeyframesSpec\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,651:1\n462#2:652\n412#2:653\n1246#3,4:654\n*S KotlinDebug\n*F\n+ 1 AnimationSpec.kt\nandroidx/compose/animation/core/KeyframesSpec\n*L\n496#1:652\n496#1:653\n496#1:654,4\n*E\n"})
public final class KeyframesSpec<T>
implements DurationBasedAnimationSpec<T> {
    @NotNull
    private final KeyframesSpecConfig<T> config;

    public KeyframesSpec(@NotNull KeyframesSpecConfig<T> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.config = config;
    }

    @NotNull
    public final KeyframesSpecConfig<T> getConfig() {
        return this.config;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof KeyframesSpec && Intrinsics.areEqual(this.config, ((KeyframesSpec)other).config);
    }

    public int hashCode() {
        return this.config.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedKeyframesSpec<V> vectorize(@NotNull TwoWayConverter<T, V> converter) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        Map<Integer, KeyframeEntity<T>> $this$mapValues$iv = this.config.getKeyframes$fleet_noria_ui();
        boolean $i$f$mapValues = false;
        Map<Integer, KeyframeEntity<T>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Pair<V, Easing> pair = ((KeyframeEntity)it.getValue()).toPair$fleet_noria_ui(converter.getConvertToVector());
            map3.put(k, pair);
        }
        int n = this.config.getDelayMillis();
        int n2 = this.config.getDurationMillis();
        Map map4 = destination$iv$iv;
        return new VectorizedKeyframesSpec(map4, n2, n);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001b\b\u0000\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J7\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00050\u0010\"\b\b\u0002\u0010\u0011*\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00110\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0016\u0010\u0003\u001a\u00028\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;", "T", "", "value", "easing", "Landroidx/compose/animation/core/Easing;", "<init>", "(Ljava/lang/Object;Landroidx/compose/animation/core/Easing;)V", "getValue$fleet_noria_ui", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getEasing$fleet_noria_ui", "()Landroidx/compose/animation/core/Easing;", "setEasing$fleet_noria_ui", "(Landroidx/compose/animation/core/Easing;)V", "toPair", "Lkotlin/Pair;", "V", "Landroidx/compose/animation/core/AnimationVector;", "convertToVector", "Lkotlin/Function1;", "toPair$fleet_noria_ui", "equals", "", "other", "hashCode", "", "fleet.noria.ui"})
    public static final class KeyframeEntity<T> {
        private final T value;
        @NotNull
        private Easing easing;

        public KeyframeEntity(T value2, @NotNull Easing easing) {
            Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
            this.value = value2;
            this.easing = easing;
        }

        public /* synthetic */ KeyframeEntity(Object object, Easing easing, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                easing = EasingKt.getLinearEasing();
            }
            this(object, easing);
        }

        public final T getValue$fleet_noria_ui() {
            return this.value;
        }

        @NotNull
        public final Easing getEasing$fleet_noria_ui() {
            return this.easing;
        }

        public final void setEasing$fleet_noria_ui(@NotNull Easing easing) {
            Intrinsics.checkNotNullParameter((Object)easing, (String)"<set-?>");
            this.easing = easing;
        }

        @NotNull
        public final <V extends AnimationVector> Pair<V, Easing> toPair$fleet_noria_ui(@NotNull Function1<? super T, ? extends V> convertToVector) {
            Intrinsics.checkNotNullParameter(convertToVector, (String)"convertToVector");
            return TuplesKt.to((Object)convertToVector.invoke(this.value), (Object)this.easing);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof KeyframeEntity && Intrinsics.areEqual(((KeyframeEntity)other).value, this.value) && Intrinsics.areEqual((Object)((KeyframeEntity)other).easing, (Object)this.easing);
        }

        public int hashCode() {
            T t = this.value;
            return (t != null ? t.hashCode() : 0) * 31 + this.easing.hashCode();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010*\u00028\u00012\u0006\u0010\u0014\u001a\u00020\u0006H\u0086\u0004\u00a2\u0006\u0002\u0010\u0015J \u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010*\u00028\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0086\u0004\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\u00020\u001b*\b\u0012\u0004\u0012\u00028\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\u0004J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010!\u001a\u00020\u0006H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR&\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00100\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Landroidx/compose/animation/core/KeyframesSpec$KeyframesSpecConfig;", "T", "", "<init>", "()V", "durationMillis", "", "getDurationMillis", "()I", "setDurationMillis", "(I)V", "delayMillis", "getDelayMillis", "setDelayMillis", "keyframes", "", "Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;", "getKeyframes$fleet_noria_ui", "()Ljava/util/Map;", "at", "timeStamp", "(Ljava/lang/Object;I)Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;", "atFraction", "fraction", "", "(Ljava/lang/Object;F)Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;", "with", "", "easing", "Landroidx/compose/animation/core/Easing;", "equals", "", "other", "hashCode", "fleet.noria.ui"})
    public static final class KeyframesSpecConfig<T> {
        private int durationMillis = 300;
        private int delayMillis;
        @NotNull
        private final Map<Integer, KeyframeEntity<T>> keyframes = new LinkedHashMap();

        public final int getDurationMillis() {
            return this.durationMillis;
        }

        public final void setDurationMillis(int n) {
            this.durationMillis = n;
        }

        public final int getDelayMillis() {
            return this.delayMillis;
        }

        public final void setDelayMillis(int n) {
            this.delayMillis = n;
        }

        @NotNull
        public final Map<Integer, KeyframeEntity<T>> getKeyframes$fleet_noria_ui() {
            return this.keyframes;
        }

        @NotNull
        public final KeyframeEntity<T> at(T $this$at, int timeStamp) {
            KeyframeEntity keyframeEntity;
            KeyframeEntity it = keyframeEntity = new KeyframeEntity($this$at, null, 2, null);
            boolean bl = false;
            Integer n = timeStamp;
            this.keyframes.put(n, it);
            return keyframeEntity;
        }

        @NotNull
        public final KeyframeEntity<T> atFraction(T $this$atFraction, float fraction) {
            return this.at($this$atFraction, MathKt.roundToInt((float)((float)this.durationMillis * fraction)));
        }

        public final void with(@NotNull KeyframeEntity<T> $this$with, @NotNull Easing easing) {
            Intrinsics.checkNotNullParameter($this$with, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
            $this$with.setEasing$fleet_noria_ui(easing);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof KeyframesSpecConfig && this.delayMillis == ((KeyframesSpecConfig)other).delayMillis && this.durationMillis == ((KeyframesSpecConfig)other).durationMillis && Intrinsics.areEqual(this.keyframes, ((KeyframesSpecConfig)other).keyframes);
        }

        public int hashCode() {
            return (this.durationMillis * 31 + this.delayMillis) * 31 + ((Object)this.keyframes).hashCode();
        }
    }
}

