/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.jcef.frontend.javascript;

import fleet.plugins.jcef.frontend.JcefBrowserClient;
import fleet.plugins.jcef.frontend.javascript.JcefMessageRouterPoolKt;
import fleet.util.logging.KLogger;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.cef.browser.CefMessageRouter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J+\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00100\u0012H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"Lfleet/plugins/jcef/frontend/javascript/JcefMessageRouterPool;", "", "client", "Lfleet/plugins/jcef/frontend/JcefBrowserClient;", "maxQueryCount", "", "<init>", "(Lfleet/plugins/jcef/frontend/JcefBrowserClient;I)V", "routers", "", "Lorg/cef/browser/CefMessageRouter;", "createRouters", "createRouter", "functionName", "", "useRouter", "R", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "takeRouter", "returnRouter", "", "router", "fleet.plugins.jcef.frontend"})
@SourceDebugExtension(value={"SMAP\nJcefMessageRouterPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JcefMessageRouterPool.kt\nfleet/plugins/jcef/frontend/javascript/JcefMessageRouterPool\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n10#2,2:57\n10#2,2:60\n10#2,2:62\n1#3:59\n*S KotlinDebug\n*F\n+ 1 JcefMessageRouterPool.kt\nfleet/plugins/jcef/frontend/javascript/JcefMessageRouterPool\n*L\n14#1:57,2\n47#1:60,2\n52#1:62,2\n*E\n"})
public final class JcefMessageRouterPool {
    @NotNull
    private final JcefBrowserClient client;
    private final int maxQueryCount;
    @NotNull
    private final List<CefMessageRouter> routers;

    public JcefMessageRouterPool(@NotNull JcefBrowserClient client, int maxQueryCount) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.maxQueryCount = maxQueryCount;
        this.routers = this.createRouters();
        KLogger this_$iv = JcefMessageRouterPoolKt.access$getLogger$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)("Allocated " + this.routers.size() + " routers"));
        }
    }

    private final List<CefMessageRouter> createRouters() {
        List list;
        List $this$createRouters_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int index = 0;
        int n = this.maxQueryCount;
        if (index <= n) {
            while (true) {
                CefMessageRouter router = this.createRouter("jcef_query_" + index);
                this.client.getBackendClient().addMessageRouter(router);
                $this$createRouters_u24lambda_u241.add(router);
                if (index == n) break;
                ++index;
            }
        }
        List routers = CollectionsKt.build((List)list);
        return new CopyOnWriteArrayList(routers);
    }

    private final CefMessageRouter createRouter(String functionName) {
        String cancelFunction = functionName + "_cancel";
        CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig(functionName, cancelFunction);
        CefMessageRouter cefMessageRouter = CefMessageRouter.create((CefMessageRouter.CefMessageRouterConfig)config);
        Intrinsics.checkNotNullExpressionValue((Object)cefMessageRouter, (String)"create(...)");
        return cefMessageRouter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R useRouter(@NotNull Function1<? super CefMessageRouter, ? extends R> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$useRouter = false;
        CefMessageRouter router = this.takeRouter();
        try {
            Object object = block.invoke((Object)router);
            return (R)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.returnRouter(router);
            InlineMarker.finallyEnd((int)1);
        }
    }

    @NotNull
    public final CefMessageRouter takeRouter() {
        CefMessageRouter router = (CefMessageRouter)CollectionsKt.removeFirstOrNull(this.routers);
        if (router == null) {
            boolean $i$a$-checkNotNull-JcefMessageRouterPool$takeRouter$22 = false;
            String $i$a$-checkNotNull-JcefMessageRouterPool$takeRouter$22 = "There are no free routers left (maxQueryCount=" + this.maxQueryCount + ")";
            throw new IllegalStateException($i$a$-checkNotNull-JcefMessageRouterPool$takeRouter$22.toString());
        }
        KLogger this_$iv = JcefMessageRouterPoolKt.access$getLogger$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)("Removing (" + router + ") from the pool"));
        }
        return router;
    }

    public final void returnRouter(@NotNull CefMessageRouter router) {
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        KLogger this_$iv = JcefMessageRouterPoolKt.access$getLogger$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)("Returning (" + router + ") to the pool"));
        }
        this.routers.add(router);
    }
}

