/*
 * Decompiled with CFR 0.152.
 */
package fleet.toolchain.common.impl;

import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.EntityType;
import fleet.api.HostId;
import fleet.common.settings.SettingsKey;
import fleet.common.topology.Host;
import fleet.common.topology.HostKt;
import fleet.kernel.Durable;
import fleet.kernel.SharedChangeScope;
import fleet.toolchain.common.api.ToolchainProviderId;
import fleet.toolchain.common.impl.ActiveToolchainBindEntity;
import fleet.toolchain.common.impl.HostOrRoot;
import fleet.toolchain.common.impl.ProvidedToolchainsEntity;
import fleet.toolchain.common.impl.ToolchainBindRuleEntity;
import fleet.toolchain.protocol.ToolchainDescription;
import fleet.toolchain.protocol.ToolchainKind;
import fleet.util.UID;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a0\u0010\u0014\u001a\u00020\u0015*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u001a\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u001a\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0019\u0010!\u001a\u00020\u0018*\u0006\u0012\u0002\b\u00030\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"durableId", "Lfleet/util/UID;", "Lfleet/toolchain/common/impl/HostOrRoot;", "getDurableId", "(Lfleet/toolchain/common/impl/HostOrRoot;)Lfleet/util/UID;", "hostId", "Lfleet/api/HostId;", "Lfleet/toolchain/common/impl/HostOrRoot$Host;", "getHostId", "(Lfleet/toolchain/common/impl/HostOrRoot$Host;)Lfleet/api/HostId;", "entity", "Lcom/jetbrains/rhizomedb/Entity;", "getEntity", "(Lfleet/toolchain/common/impl/HostOrRoot;)Lcom/jetbrains/rhizomedb/Entity;", "ActiveToolchainBindEntity", "", "Lfleet/kernel/SharedChangeScope;", "owner", "rule", "Lfleet/toolchain/common/impl/ToolchainBindRuleEntity;", "ProvidedToolchainsEntity", "Lfleet/toolchain/common/impl/ProvidedToolchainsEntity;", "lifetime", "providerId", "Lfleet/toolchain/common/api/ToolchainProviderId;", "toolchainKind", "Lfleet/toolchain/protocol/ToolchainKind;", "toolchains", "", "Lfleet/toolchain/protocol/ToolchainDescription;", "getProvidedToolchains", "", "kind", "toolchainProviderId", "Lfleet/common/settings/SettingsKey;", "getToolchainProviderId", "(Lfleet/common/settings/SettingsKey;)Lfleet/toolchain/common/api/ToolchainProviderId;", "fleet.toolchain.common"})
@SourceDebugExtension(value={"SMAP\nToolchainEntities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolchainEntities.kt\nfleet/toolchain/common/impl/ToolchainEntitiesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1#2:141\n*E\n"})
public final class ToolchainEntitiesKt {
    @NotNull
    public static final UID getDurableId(@NotNull HostOrRoot $this$durableId) {
        UID uID;
        Intrinsics.checkNotNullParameter((Object)$this$durableId, (String)"<this>");
        HostOrRoot hostOrRoot = $this$durableId;
        if (hostOrRoot instanceof HostOrRoot.Host) {
            uID = (UID)EntityAttributeKt.getRequired((Entity)((Entity)((HostOrRoot.Host)$this$durableId).getHost()), (Attributes.Required)Durable.INSTANCE.getId());
        } else if (hostOrRoot instanceof HostOrRoot.Root) {
            uID = (UID)EntityAttributeKt.getRequired((Entity)((Entity)((HostOrRoot.Root)$this$durableId).getRoot()), (Attributes.Required)Durable.INSTANCE.getId());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return uID;
    }

    @NotNull
    public static final HostId getHostId(@NotNull HostOrRoot.Host $this$hostId) {
        HostId hostId;
        Intrinsics.checkNotNullParameter((Object)$this$hostId, (String)"<this>");
        Map map = $this$hostId.getHost().getMeta();
        if (map != null && (map = (JsonElement)map.get(HostKt.getServingHostKey().getKey())) != null) {
            Map it = map;
            boolean bl = false;
            hostId = (HostId)Json.Default.decodeFromJsonElement((DeserializationStrategy)HostKt.getServingHostKey().getValueSerializer(), (JsonElement)it);
        } else {
            hostId = null;
        }
        if (hostId == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return hostId;
    }

    @NotNull
    public static final Entity getEntity(@NotNull HostOrRoot $this$entity) {
        Entity entity;
        Intrinsics.checkNotNullParameter((Object)$this$entity, (String)"<this>");
        HostOrRoot hostOrRoot = $this$entity;
        if (hostOrRoot instanceof HostOrRoot.Host) {
            entity = (Entity)((HostOrRoot.Host)$this$entity).getHost();
        } else if (hostOrRoot instanceof HostOrRoot.Root) {
            entity = (Entity)((HostOrRoot.Root)$this$entity).getRoot();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return entity;
    }

    public static final void ActiveToolchainBindEntity(@NotNull SharedChangeScope $this$ActiveToolchainBindEntity, @NotNull HostOrRoot owner, @NotNull ToolchainBindRuleEntity rule) {
        Intrinsics.checkNotNullParameter((Object)$this$ActiveToolchainBindEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        $this$ActiveToolchainBindEntity.new((EntityType)ActiveToolchainBindEntity.Companion, arg_0 -> ToolchainEntitiesKt.ActiveToolchainBindEntity$lambda$1(owner, rule, arg_0));
    }

    @NotNull
    public static final ProvidedToolchainsEntity ProvidedToolchainsEntity(@NotNull SharedChangeScope $this$ProvidedToolchainsEntity, @NotNull Entity lifetime, @NotNull ToolchainProviderId providerId, @NotNull ToolchainKind toolchainKind, @NotNull List<ToolchainDescription> toolchains) {
        Intrinsics.checkNotNullParameter((Object)$this$ProvidedToolchainsEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)toolchainKind, (String)"toolchainKind");
        Intrinsics.checkNotNullParameter(toolchains, (String)"toolchains");
        return (ProvidedToolchainsEntity)$this$ProvidedToolchainsEntity.new((EntityType)ProvidedToolchainsEntity.Companion, arg_0 -> ToolchainEntitiesKt.ProvidedToolchainsEntity$lambda$2(lifetime, providerId, toolchainKind, toolchains, arg_0));
    }

    @NotNull
    public static final Set<ProvidedToolchainsEntity> getProvidedToolchains(@NotNull HostOrRoot entity, @NotNull ToolchainKind kind) {
        Set set;
        Set explicitToolchains;
        block4: {
            block2: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                    Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                    explicitToolchains = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)ProvidedToolchainsEntity.Companion.getKindIndex()), (Object)TuplesKt.to((Object)ToolchainEntitiesKt.getDurableId(entity), (Object)kind));
                    if (!(entity instanceof HostOrRoot.Root)) break block2;
                    set = Host.Companion.lookup(((HostOrRoot.Root)entity).getRoot().getFileAddress().getHostId());
                    if (set == null) break block3;
                    Set host = set;
                    boolean bl = false;
                    Set set2 = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)ProvidedToolchainsEntity.Companion.getKindIndex()), (Object)TuplesKt.to((Object)EntityAttributeKt.getRequired((Entity)((Entity)host.getProvider()), (Attributes.Required)Durable.INSTANCE.getId()), (Object)kind));
                    set = set2;
                    if (set2 != null) break block4;
                }
                set = SetsKt.emptySet();
                break block4;
            }
            set = SetsKt.emptySet();
        }
        Set implicitToolchains = set;
        return SetsKt.plus((Set)explicitToolchains, (Iterable)implicitToolchains);
    }

    @NotNull
    public static final ToolchainProviderId getToolchainProviderId(@NotNull SettingsKey<?> $this$toolchainProviderId) {
        Intrinsics.checkNotNullParameter($this$toolchainProviderId, (String)"<this>");
        return new ToolchainProviderId("toolchainProvider.settings." + $this$toolchainProviderId.getKey());
    }

    private static final void ActiveToolchainBindEntity$lambda$1(HostOrRoot $owner, ToolchainBindRuleEntity $rule, EntityBuilder.Target e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.set(ActiveToolchainBindEntity.Companion.getBoundEntity$fleet_toolchain_common(), (Object)ToolchainEntitiesKt.getEntity($owner));
        e.set(ActiveToolchainBindEntity.Companion.getKey(), (Object)$rule.getKey());
        e.set(ActiveToolchainBindEntity.Companion.getIndex(), (Object)TuplesKt.to((Object)$rule.getKey(), (Object)ToolchainEntitiesKt.getDurableId($owner)));
        e.set(ActiveToolchainBindEntity.Companion.getRule(), (Object)$rule);
    }

    private static final void ProvidedToolchainsEntity$lambda$2(Entity $lifetime, ToolchainProviderId $providerId, ToolchainKind $toolchainKind, List $toolchains, EntityBuilder.Target e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.set(ProvidedToolchainsEntity.Companion.getOwner$fleet_toolchain_common(), (Object)$lifetime);
        e.set(ProvidedToolchainsEntity.Companion.getProviderId(), (Object)$providerId);
        e.set(ProvidedToolchainsEntity.Companion.getKind(), (Object)$toolchainKind);
        e.set(ProvidedToolchainsEntity.Companion.getProviderIndex(), (Object)TuplesKt.to((Object)EntityAttributeKt.getRequired((Entity)$lifetime, (Attributes.Required)Durable.INSTANCE.getId()), (Object)$providerId));
        e.set(ProvidedToolchainsEntity.Companion.getKindIndex(), (Object)TuplesKt.to((Object)EntityAttributeKt.getRequired((Entity)$lifetime, (Attributes.Required)Durable.INSTANCE.getId()), (Object)$toolchainKind));
        e.set(ProvidedToolchainsEntity.Companion.getToolchains(), (Object)$toolchains);
    }
}

