/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.psi;

import fleet.com.intellij.openapi.util.TextRange;
import fleet.com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public abstract class LiteralTextEscaper<T extends PsiLanguageInjectionHost> {
    protected final T myHost;

    protected LiteralTextEscaper(@NotNull T host) {
        this.myHost = host;
    }

    public abstract boolean decode(@NotNull TextRange var1, @NotNull StringBuilder var2);

    public abstract int getOffsetInHost(int var1, @NotNull TextRange var2);

    @NotNull
    public TextRange getRelevantTextRange() {
        return TextRange.from(0, this.myHost.getTextLength());
    }

    public abstract boolean isOneLine();

    @NotNull
    public static <T extends PsiLanguageInjectionHost> LiteralTextEscaper<T> createSimple(@NotNull T element) {
        return LiteralTextEscaper.createSimple(element, true);
    }

    @NotNull
    public static <T extends PsiLanguageInjectionHost> LiteralTextEscaper<T> createSimple(@NotNull T element, final boolean isOneLine) {
        return new LiteralTextEscaper<T>(element){

            @Override
            public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
                outChars.append(rangeInsideHost.substring(this.myHost.getText()));
                return true;
            }

            @Override
            public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
                return rangeInsideHost.getStartOffset() + offsetInDecoded;
            }

            @Override
            public boolean isOneLine() {
                return isOneLine;
            }
        };
    }
}

