/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.WhitespacesBinders;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.openapi.progress.ProgressManager;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiBuilderUtil {
    private PsiBuilderUtil() {
    }

    public static void advance(PsiBuilder builder, int count) {
        for (int i = 0; i < count && !builder.eof(); ++i) {
            builder.getTokenType();
            builder.advanceLexer();
        }
    }

    public static boolean expect(PsiBuilder builder, IElementType expectedType) {
        if (builder.getTokenType() == expectedType) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean expect(PsiBuilder builder, TokenSet expectedTypes) {
        if (expectedTypes.contains(builder.getTokenType())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static void drop(PsiBuilder.Marker ... markers) {
        for (PsiBuilder.Marker marker : markers) {
            if (marker == null) continue;
            marker.drop();
        }
    }

    public static void rollbackTo(@Nullable PsiBuilder.Marker marker) {
        if (marker != null) {
            marker.rollbackTo();
        }
    }

    @NotNull
    public static CharSequence rawTokenText(PsiBuilder builder, int index) {
        return new CharSequenceSubSequence(builder.getOriginalText(), builder.rawTokenTypeStart(index), builder.rawTokenTypeStart(index + 1));
    }

    @Nullable
    public static PsiBuilder.Marker parseBlockLazy(@NotNull PsiBuilder builder, @NotNull IElementType leftBrace, @NotNull IElementType rightBrace, @NotNull IElementType codeBlock) {
        if (builder.getTokenType() != leftBrace) {
            return null;
        }
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        int braceCount = 1;
        while (braceCount > 0 && !builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == leftBrace) {
                ++braceCount;
            } else if (tokenType == rightBrace) {
                --braceCount;
            }
            builder.advanceLexer();
        }
        marker.collapse(codeBlock);
        if (braceCount > 0) {
            marker.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return marker;
    }

    public static boolean hasProperBraceBalance(@NotNull CharSequence text, @NotNull Lexer lexer, @NotNull IElementType leftBrace, @NotNull IElementType rightBrace) {
        lexer.start(text);
        if (lexer.getTokenType() != leftBrace) {
            return false;
        }
        lexer.advance();
        int balance = 1;
        while (true) {
            ProgressManager.checkCanceled();
            IElementType type = lexer.getTokenType();
            if (type == null) {
                return balance == 0;
            }
            if (balance == 0) {
                return false;
            }
            if (type == leftBrace) {
                ++balance;
            } else if (type == rightBrace) {
                --balance;
            }
            lexer.advance();
        }
    }
}

