/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.abstract_pointer;
import org.clank.support.aliases.char$iterator;
import org.clank.support.aliases.char$ptr;
import org.clank.support.aliases.long$iterator;
import org.clank.support.aliases.type$memory;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.uint$iterator;
import org.clank.support.aliases.uint$ptr;
import org.clank.support.aliases.ulong$iterator;
import org.clank.support.aliases.ulong$ptr;
import org.clank.support.void$ptr;

public class CollectionUtils {
    public static <F, T> T[] transform(F[] from, NativeCallback.Converter<F, T> converter, boolean nullTerminate, boolean SkipConvertedToNull) {
        List<Object> toList = CollectionUtils.transform(Arrays.asList(from), converter, nullTerminate, SkipConvertedToNull);
        Object[] to = (Object[])Array.newInstance(converter.getToClass(), toList.size());
        to = toList.toArray(to);
        return to;
    }

    public static <F, T> List<T> transform(List<F> from, NativeCallback.Converter<F, T> converter, boolean nullTerminate, boolean SkipConvertedToNull) {
        ArrayList<T> to = new ArrayList<T>(from.size() + (nullTerminate ? 1 : 0));
        for (F f : from) {
            T converted = converter.$call(f);
            if (SkipConvertedToNull && converted == null) continue;
            to.add(converted);
        }
        if (nullTerminate) {
            to.add(null);
        }
        return to;
    }

    public static <T> Set<T> asSet(T ... values) {
        HashSet<T> result = new HashSet<T>();
        for (T value : values) {
            result.add(value);
        }
        return result;
    }

    public static <K, V> Map<K, V> asMap(std_pair.pair<K, V> ... pairs) {
        HashMap result = new HashMap();
        for (std_pair.pair<K, V> kv : pairs) {
            result.put(kv.first, kv.second);
        }
        return result;
    }

    public static uint$ptr transform_Integers2uint$ptr(type$ptr<Integer> orig) {
        class Integer2UIntValue
        extends AbstractPointerAdaptor<Integer2UIntValue, uint$ptr, type$ptr<Integer>>
        implements uint$ptr {
            public Integer2UIntValue(type$ptr<Integer> delegate) {
                super(delegate);
            }

            public Integer2UIntValue(Integer2UIntValue $Prm0) {
                super($Prm0);
            }

            @Override
            public int $star() {
                return (Integer)((type$ptr)this.delegate).$star();
            }

            @Override
            public Integer2UIntValue clone() {
                return new Integer2UIntValue(this);
            }

            @Override
            public int $set(int value) {
                return this.$set(0, value);
            }

            @Override
            public int $at(int index) {
                return (Integer)((type$ptr)this.delegate).$at(index);
            }

            @Override
            public int $set(int index, int value) {
                return ((type$ptr)this.delegate).$set(index, Integer.valueOf(value));
            }
        }
        return new Integer2UIntValue(orig);
    }

    public static ulong$ptr transform_long2ulong$ptr(long$iterator<?> orig) {
        class Long2ULongValue
        extends AbstractPointerAdaptor<Long2ULongValue, ulong$ptr, long$iterator>
        implements ulong$ptr {
            public Long2ULongValue(long$iterator delegate) {
                super(delegate);
            }

            public Long2ULongValue(Long2ULongValue $Prm0) {
                super($Prm0);
            }

            @Override
            public long $star() {
                return Unsigned.$long2ulong(((long$iterator)this.delegate).$star());
            }

            @Override
            public Long2ULongValue clone() {
                return new Long2ULongValue(this);
            }
        }
        return new Long2ULongValue(orig);
    }

    public static ulong$ptr transform_uint2ulong$ptr(uint$iterator<?> orig) {
        class UInt2ULongValue
        extends AbstractPointerAdaptor<UInt2ULongValue, ulong$ptr, uint$iterator>
        implements ulong$ptr {
            public UInt2ULongValue(uint$iterator delegate) {
                super(delegate);
            }

            public UInt2ULongValue(UInt2ULongValue $Prm0) {
                super($Prm0);
            }

            @Override
            public long $star() {
                return Unsigned.$uint2ulong(((uint$iterator)this.delegate).$star());
            }

            @Override
            public UInt2ULongValue clone() {
                return new UInt2ULongValue(this);
            }
        }
        return new UInt2ULongValue(orig);
    }

    public static ulong$ptr transform_char2ulong$ptr(char$iterator<?> orig) {
        class Char2ULongValue
        extends AbstractPointerAdaptor<Char2ULongValue, ulong$ptr, char$iterator>
        implements ulong$ptr {
            public Char2ULongValue(char$iterator delegate) {
                super(delegate);
            }

            public Char2ULongValue(Char2ULongValue $Prm0) {
                super($Prm0);
            }

            @Override
            public long $star() {
                return Unsigned.$uchar2ulong(((char$iterator)this.delegate).$star());
            }

            @Override
            public Char2ULongValue clone() {
                return new Char2ULongValue(this);
            }
        }
        return new Char2ULongValue(orig);
    }

    public static char$ptr transform_ulong2char$ptr(ulong$iterator<?> orig) {
        class ULong2CharValue
        extends AbstractPointerAdaptor<ULong2CharValue, char$ptr, ulong$iterator>
        implements char$ptr {
            public ULong2CharValue(ulong$iterator delegate) {
                super(delegate);
            }

            public ULong2CharValue(ULong2CharValue $Prm0) {
                super($Prm0);
            }

            @Override
            public byte $star() {
                return Unsigned.$ulong2uchar(((ulong$iterator)this.delegate).$star());
            }

            @Override
            public ULong2CharValue clone() {
                return new ULong2CharValue(this);
            }
        }
        return new ULong2CharValue(orig);
    }

    public static uint$ptr transform_ulong2uint$ptr(ulong$iterator<?> orig) {
        class ULong2UIntValue
        extends AbstractPointerAdaptor<ULong2UIntValue, uint$ptr, ulong$iterator>
        implements uint$ptr {
            public ULong2UIntValue(ulong$iterator delegate) {
                super(delegate);
            }

            public ULong2UIntValue(ULong2UIntValue $Prm0) {
                super($Prm0);
            }

            @Override
            public int $star() {
                return Unsigned.$ulong2uint(((ulong$iterator)this.delegate).$star());
            }

            @Override
            public ULong2UIntValue clone() {
                return new ULong2UIntValue(this);
            }
        }
        return new ULong2UIntValue(orig);
    }

    private static abstract class AbstractPointerAdaptor<Derived extends AbstractPointerAdaptor, PtrType extends abstract_pointer, OrigIter extends abstract_iterator>
    implements abstract_pointer<PtrType> {
        protected final OrigIter delegate;

        protected AbstractPointerAdaptor(OrigIter delegate) {
            this.delegate = (abstract_iterator)Native.$noClone(delegate);
        }

        protected AbstractPointerAdaptor(Derived $Prm0) {
            this.delegate = (abstract_iterator)Native.$Clone(((AbstractPointerAdaptor)$Prm0).delegate);
        }

        @Override
        public PtrType $sub(int amount) {
            AbstractPointerAdaptor out = Native.$Clone(this);
            out.$dec(amount);
            return (PtrType)out;
        }

        @Override
        public PtrType $add(int amount) {
            AbstractPointerAdaptor out = Native.$Clone(this);
            out.$inc(amount);
            return (PtrType)out;
        }

        @Override
        public PtrType $dec(int amount) {
            this.delegate.$dec(amount);
            return (PtrType)this;
        }

        @Override
        public PtrType $inc(int amount) {
            this.delegate.$inc(amount);
            return (PtrType)this;
        }

        @Override
        public PtrType $postDec() {
            AbstractPointerAdaptor out = Native.$Clone(this);
            out.$preDec();
            return (PtrType)out;
        }

        @Override
        public PtrType $postInc() {
            AbstractPointerAdaptor out = Native.$Clone(this);
            out.$preInc();
            return (PtrType)out;
        }

        @Override
        public PtrType $preDec() {
            this.delegate.$preDec();
            return (PtrType)this;
        }

        @Override
        public PtrType $preInc() {
            this.delegate.$preInc();
            return (PtrType)this;
        }

        @Override
        public int $sub(PtrType iter) {
            return this.delegate.$sub(((AbstractPointerAdaptor)iter).delegate);
        }

        @Override
        public boolean $eq(Object other) {
            if (other instanceof AbstractPointerAdaptor) {
                return this.delegate.$eq(((AbstractPointerAdaptor)other).delegate);
            }
            return this.delegate.$eq((Object)other);
        }

        @Override
        public boolean $noteq(Object other) {
            return !this.$eq(other);
        }

        @Override
        public abstract PtrType clone();

        @Override
        public PtrType const_clone() {
            return (PtrType)this.clone();
        }

        @Override
        public boolean $isNull() {
            return ((void$ptr)this.delegate).$isNull();
        }

        @Override
        public boolean isComparableTo(void$ptr other) {
            throw new UnsupportedOperationException("Not yet implemented isComparableTo " + this.getClass() + " vs " + NativeTrace.getIdentityStr(other));
        }

        @Override
        public int $hashcode() {
            throw new UnsupportedOperationException("Not yet implemented $hashcode " + this.getClass());
        }

        @Override
        public boolean $greater(Object other) {
            throw new UnsupportedOperationException("Not yet implemented $greater " + this.getClass() + " vs " + NativeTrace.getIdentityStr(other));
        }

        @Override
        public PtrType $assign(PtrType $Prm0) {
            ((Native.assignable)this.delegate).$assign(((AbstractPointerAdaptor)$Prm0).delegate);
            return (PtrType)this;
        }

        @Override
        public type$memory<PtrType> getSelfMemory() {
            throw new UnsupportedOperationException("Why not implemented in " + this.getClass());
        }

        @Override
        public int getSelfIndex() {
            throw new UnsupportedOperationException("Why not implemented in " + this.getClass());
        }
    }

    @FunctionalInterface
    public static interface Equalizer<T1, T2> {
        public boolean areEqual(T1 var1, T2 var2);
    }
}

