/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.clank.java.std;
import org.clank.support.ByteUtils;
import org.clank.support.Casts;
import org.clank.support.DebuggableAbstractPointerType;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.UTF_8;
import org.clank.support.aliases.char$mem;
import org.clank.support.aliases.char$memory;
import org.clank.support.aliases.char$ptr;
import org.clank.support.aliases.char$ptr$heavy;
import org.clank.support.aliases.int$ptr;
import org.clank.support.aliases.int$ptr$heavy;
import org.clank.support.aliases.long$ptr;
import org.clank.support.aliases.long$ptr$heavy;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$memory;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.uchar$mem;
import org.clank.support.aliases.uchar$ptr;
import org.clank.support.aliases.uchar$ptr$heavy;
import org.clank.support.aliases.uint$memory;
import org.clank.support.aliases.uint$ptr;
import org.clank.support.aliases.uint$ptr$heavy;
import org.clank.support.aliases.ulong$memory;
import org.clank.support.aliases.ulong$ptr;
import org.clank.support.aliases.ulong$ptr$heavy;
import org.clank.support.aliases.ushort$ptr;
import org.clank.support.aliases.ushort$ptr$heavy;
import org.clank.support.char$ptr$CharSequence;
import org.clank.support.void$ptr;

public final class Casts {
    private static final AtomicLong counter = new AtomicLong(1L);
    private static final HashMap<Long, Reference<Object>> longToObjectMap = new HashMap();
    private static final WeakHashMap<Object, Long> objTolongMap = new WeakHashMap();
    private static long callReinterpret_cast = 0L;
    private static long callReinterpret_cast_long = 0L;
    private static long callReinterpret_cast_long_bytes = 0L;
    private static long callReinterpret_cast_int_bytes = 0L;

    private Casts() {
    }

    public static <T> T static_cast(Object o, Class<T> cls) {
        if (o != null && cls.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        if (!(o instanceof void$ptr) && cls == void$ptr.class) {
            return (T)new void.ptr.impl(o);
        }
        if (o instanceof void.ptr.impl) {
            return (T)((void.ptr.impl)o).value;
        }
        throw new UnsupportedOperationException("Static conversion from " + o.getClass() + " to " + cls + " is not implemented!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T reinterpret_cast(Class<T> cls, long val) {
        assert ((val & 7L) == 0L) : "Incorrect val = " + val;
        if ((val >>= 3) == 0L) {
            return null;
        }
        if (val == -1L) {
            throw new AssertionError();
        }
        Casts.trackReinterpret_cast();
        AtomicLong atomicLong2 = counter;
        synchronized (atomicLong2) {
            Reference<Object> res = longToObjectMap.get(val);
            assert (res != null && res.get() != null) : "No " + cls + " for " + val;
            return cls.cast(res.get());
        }
    }

    public static <T> T reinterpret_cast(Class<T> cls, int val) {
        return Casts.reinterpret_cast(cls, (long)val);
    }

    public static Object reinterpret_cast_Object(Object o) {
        return o;
    }

    public static int $uint(byte c) {
        return 0xFF & c;
    }

    public static char $char(byte c) {
        return (char)(0xFF & c);
    }

    public static char $char(int c) {
        return (char)(0xFF & c);
    }

    public static char $char(char c) {
        return c;
    }

    public static char $char(long c) {
        return (char)(0xFFL & c);
    }

    public static int reinterpret_cast_int(Object o) {
        return ((Number)o).intValue();
    }

    public static int reinterpret_cast_uint(Object o) {
        return ((Number)o).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long reinterpret_cast_long(Object obj) {
        if (obj == null) {
            return 0L;
        }
        new Exception(obj.getClass().getSimpleName() + " => long").printStackTrace(System.err);
        Casts.trackReinterpret_cast_long();
        AtomicLong atomicLong2 = counter;
        synchronized (atomicLong2) {
            if (objTolongMap.containsKey(obj)) {
                return objTolongMap.get(obj) << 3;
            }
            long current = counter.incrementAndGet();
            objTolongMap.put(obj, current);
            longToObjectMap.put(current, new WeakReference<Object>(obj));
            return current << 3;
        }
    }

    public static <T> type$ptr<T> reinterpret_ptr_cast(Class<T> cls, void$ptr Ptr) {
        throw new UnsupportedOperationException();
    }

    public static char$ptr reinterpret_cast_const_char$ptr(Object val) {
        assert (false) : "no conversion to char$ptr from " + val;
        return NativePointer.create_char$ptr(val.toString());
    }

    public static char$ptr reinterpret_cast_const_char$ptr(int val) {
        Casts.trackReinterpret_cast_int_bytes();
        return NativePointer.create_char$ptr(ByteUtils.intToBytes(val));
    }

    public static char$ptr reinterpret_cast_const_char$ptr(long val) {
        Casts.trackReinterpret_cast_long_bytes();
        return NativePointer.create_char$ptr(ByteUtils.longToBytes(val));
    }

    public static <T> T reinterpret_cast(Class<T> cls, Object val) {
        return (T)val;
    }

    public static <T> T reinterpret_cast(Class<T> toClass, void$ptr Ptr) {
        if (Ptr == null) {
            return null;
        }
        Class<?> fromClass = Ptr.getClass();
        if (toClass.isAssignableFrom(fromClass)) {
            return (T)Ptr.clone();
        }
        if (Ptr instanceof void.ptr.impl) {
            return toClass.cast(((void.ptr.impl)Ptr).value);
        }
        NativeMemory.MemoryPoint data = NativeMemory.unfoldMemoryPoint(NativePointer.extractMemoryPoint(Ptr));
        boolean uCharMem = false;
        if (data.memory instanceof char$memory || (uCharMem = data.memory instanceof uchar$mem)) {
            char$memory byteMemory = uCharMem ? new char$mem(((uchar$mem)data.memory).$array()) : (char$memory)data.memory;
            int byteIndex = data.byteIndex;
            if (char$ptr.class == toClass) {
                return (T)new char$ptr$heavy(byteMemory, byteIndex);
            }
            if (uchar$ptr.class == toClass) {
                uchar$mem ucharMemory = new uchar$mem(((char$mem)byteMemory).$array());
                return (T)new uchar$ptr$heavy(ucharMemory, byteIndex);
            }
            if (ushort$ptr.class == toClass) {
                NativeMemory.ushort.uchar.memproj ushortMemory = new NativeMemory.ushort.uchar.memproj(byteMemory, byteIndex % 4);
                int intIndex = ushortMemory.fromByteIndex(byteIndex - ushortMemory.getByteShift());
                return (T)new ushort$ptr$heavy(ushortMemory, intIndex);
            }
            if (int$ptr.class == toClass) {
                NativeMemory.uint.uchar.memproj intMemory = new NativeMemory.uint.uchar.memproj(byteMemory, byteIndex % 4);
                int intIndex = intMemory.fromByteIndex(byteIndex - intMemory.getByteShift());
                return (T)new int$ptr$heavy(intMemory, intIndex);
            }
            if (uint$ptr.class == toClass) {
                NativeMemory.uint.uchar.memproj uintMemory = new NativeMemory.uint.uchar.memproj(byteMemory, byteIndex % 4);
                int intIndex = uintMemory.fromByteIndex(byteIndex - uintMemory.getByteShift());
                return (T)new uint$ptr$heavy(uintMemory, intIndex);
            }
            if (long$ptr.class == toClass) {
                NativeMemory.ulong.uchar.memproj longMemory = new NativeMemory.ulong.uchar.memproj(byteMemory, byteIndex % 8);
                int longIndex = longMemory.fromByteIndex(byteIndex - longMemory.getByteShift());
                return (T)new long$ptr$heavy(longMemory, longIndex);
            }
            if (ulong$ptr.class == toClass) {
                NativeMemory.ulong.uchar.memproj ulongMemory = new NativeMemory.ulong.uchar.memproj(byteMemory, byteIndex % 8);
                int ulongIndex = ulongMemory.fromByteIndex(byteIndex - ulongMemory.getByteShift());
                return (T)new ulong$ptr$heavy(ulongMemory, ulongIndex);
            }
        } else if (data.memory instanceof uint$memory) {
            uint$memory uintMemory = (uint$memory)data.memory;
            int byteIndex = data.byteIndex;
            if (uint$ptr.class == toClass) {
                return (T)new uint$ptr$heavy(uintMemory, byteIndex);
            }
            if (uchar$ptr.class == toClass) {
                NativeMemory.uchar.uint.memproj ucharMemory = new NativeMemory.uchar.uint.memproj(uintMemory);
                int charIndex = ucharMemory.fromByteIndex(byteIndex - ucharMemory.getByteShift());
                return (T)new uchar$ptr$heavy(ucharMemory, charIndex);
            }
            if (char$ptr.class == toClass) {
                NativeMemory.uchar.uint.memproj ucharMemory = new NativeMemory.uchar.uint.memproj(uintMemory);
                int charIndex = ucharMemory.fromByteIndex(byteIndex - ucharMemory.getByteShift());
                return (T)new char$ptr$heavy(ucharMemory, charIndex);
            }
        } else if (data.memory instanceof ulong$memory) {
            ulong$memory ulongMemory = (ulong$memory)data.memory;
            int byteIndex = data.byteIndex;
            if (uchar$ptr.class == toClass) {
                NativeMemory.uchar.ulong.memproj ucharMemory = new NativeMemory.uchar.ulong.memproj(ulongMemory);
                int charIndex = ucharMemory.fromByteIndex(byteIndex - ucharMemory.getByteShift());
                return (T)new uchar$ptr$heavy(ucharMemory, charIndex);
            }
            if (char$ptr.class == toClass) {
                NativeMemory.uchar.ulong.memproj ucharMemory = new NativeMemory.uchar.ulong.memproj(ulongMemory);
                int charIndex = ucharMemory.fromByteIndex(byteIndex - ucharMemory.getByteShift());
                return (T)new char$ptr$heavy(ucharMemory, charIndex);
            }
        }
        throw new UnsupportedOperationException("Reinterpret conversion from " + fromClass + " to " + toClass + " is not implemented!");
    }

    public static <Iter extends type$iterator<Iter, T>, T> char$ptr reinterpret_cast(Class<char$ptr> toClass, Iter orig, int sizeof$T, NativeCallback.Object2BinaryStreamConverter<T> conv) {
        assert (toClass == char$ptr.class);
        assert (sizeof$T > 0);
        assert (orig != null);
        class ConverterFromObjectToSizeOfTBytesStream<Iter extends type$iterator<Iter, T>, T>
        implements char$ptr,
        DebuggableAbstractPointerType<ConverterFromObjectToSizeOfTBytesStream<Iter, T>> {
            private final Iter delegate;
            private final int sizeof$T;
            private final NativeCallback.Object2BinaryStreamConverter<T> conv;
            int $index_in_object;
            T $star;
            private byte _flags;

            ConverterFromObjectToSizeOfTBytesStream(Iter delegate, int sizeof$T, NativeCallback.Object2BinaryStreamConverter<T> conv) {
                this.delegate = (type$iterator)Native.$noClone(delegate);
                this.sizeof$T = sizeof$T;
                this.conv = conv;
                this.$index_in_object = 0;
                this.$star = null;
            }

            ConverterFromObjectToSizeOfTBytesStream(ConverterFromObjectToSizeOfTBytesStream<Iter, T> $Prm0) {
                this.delegate = (type$iterator)Native.$Clone($Prm0.delegate);
                this.sizeof$T = $Prm0.sizeof$T;
                this.conv = $Prm0.conv;
                this.$index_in_object = $Prm0.$index_in_object;
                this.$star = $Prm0.$star;
            }

            @Override
            public ConverterFromObjectToSizeOfTBytesStream<Iter, T> clone() {
                return new ConverterFromObjectToSizeOfTBytesStream<Iter, T>(this);
            }

            @Override
            public ConverterFromObjectToSizeOfTBytesStream const_clone() {
                return ((ConverterFromObjectToSizeOfTBytesStream)this.clone()).$toConstPtr();
            }

            @Override
            public char$ptr $assign(char$ptr $Prm0) {
                return this.$assign((ConverterFromObjectToSizeOfTBytesStream)$Prm0);
            }

            @Override
            public char$ptr $assign(ConverterFromObjectToSizeOfTBytesStream<Iter, T> $Prm0) {
                assert (this.sizeof$T == $Prm0.sizeof$T);
                assert (this.conv == $Prm0.conv);
                ((Native.assignable)this.delegate).$assign($Prm0.delegate);
                this.$index_in_object = $Prm0.$index_in_object;
                this.$star = $Prm0.$star;
                return this;
            }

            @Override
            public char$ptr $preInc() {
                ++this.$index_in_object;
                this.advanceIfNeeded();
                return this;
            }

            @Override
            public char$ptr $postInc() {
                char$ptr out = Native.$Clone(this);
                this.$preInc();
                return out;
            }

            @Override
            public boolean $eq(Object other) {
                return this.$eq((ConverterFromObjectToSizeOfTBytesStream)other);
            }

            public boolean $eq(ConverterFromObjectToSizeOfTBytesStream<Iter, T> RHS) {
                assert (this.sizeof$T == RHS.sizeof$T);
                assert (this.conv == RHS.conv);
                return this.$index_in_object == RHS.$index_in_object && Native.$eq_iter(this.delegate, RHS.delegate);
            }

            @Override
            public byte $star() {
                this.queryDelegateIfNeeded();
                return this.conv.char$at(this.$index_in_object, this.$star);
            }

            private void advanceIfNeeded() {
                assert (!this._isConstPtr()) : "Can not modify const iterator ";
                assert (this.$index_in_object >= 0);
                assert (this.$index_in_object <= this.sizeof$T);
                if (this.$index_in_object == this.sizeof$T) {
                    this.delegate.$preInc();
                    this.$star = null;
                    this.$index_in_object = 0;
                }
            }

            private void queryDelegateIfNeeded() {
                assert (this.$index_in_object >= 0);
                assert (this.$index_in_object < this.sizeof$T);
                if (this.$star == null) {
                    assert (this.$index_in_object == 0);
                    this.$star = this.delegate.$star();
                    assert (this.$star != null) : "how can streamed object be null?" + this.delegate;
                }
            }

            @Override
            public int $index() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte[] $array() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set(byte value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $at(int index) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set(int index, byte value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$andassign(int index, byte value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$xorassign(int index, byte value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$orassign(int index, byte value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$addassign(int index, byte value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$minusassign(int index, byte value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$starassign(int index, byte value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$slashassign(int index, byte value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$modassign(int index, byte value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$lshiftassign(int index, byte value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$rshiftassign(int index, byte value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$postInc(int index) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$postDec(int index) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$preInc(int index) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte $set$preDec(int index) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public type$ptr<char$ptr> $addr() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public type$memory<char$ptr> getSelfMemory() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public int getSelfIndex() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean $isNull() {
                return false;
            }

            @Override
            public boolean $noteq(Object p) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean isComparableTo(void$ptr other) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean $greater(Object obj) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public int $hashcode() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public final boolean _isConstPtr() {
                return (this._flags & 1) != 0;
            }

            @Override
            public ConverterFromObjectToSizeOfTBytesStream<Iter, T> $toConstPtr() {
                this._flags = (byte)(this._flags | 1);
                return this;
            }

            @Override
            public ConverterFromObjectToSizeOfTBytesStream<Iter, T> $cleanConstPtr() {
                assert (this._isConstPtr()) : "only marked as const can be cleared; may be you are doing something not completely investigated?";
                this.$cleanConstPtrWithoutAssert();
                return this;
            }

            @Override
            public final void $cleanConstPtrWithoutAssert() {
                this._flags = (byte)(this._flags & 0xFFFFFFFE);
            }

            @Override
            public final boolean _isConstContent() {
                return (this._flags & 2) != 0;
            }

            @Override
            public ConverterFromObjectToSizeOfTBytesStream<Iter, T> $toConstContent() {
                this._flags = (byte)(this._flags | 2);
                return this;
            }

            @Override
            public ConverterFromObjectToSizeOfTBytesStream<Iter, T> $cleanConstContent() {
                assert (this._isConstContent()) : "only marked as const can be cleared; may be you are doing something not completely investigated?";
                this.$cleanConstContentWithoutAssert();
                return this;
            }

            @Override
            public final void $cleanConstContentWithoutAssert() {
                this._flags = (byte)(this._flags & 0xFFFFFFFD);
            }

            public String toString() {
                return (this.$star == null ? " NOT YET QUERIED [" : "[") + this.$index_in_object + "]-byte of [" + this.delegate + "]";
            }
        }
        return new ConverterFromObjectToSizeOfTBytesStream<Iter, T>(orig, sizeof$T, conv);
    }

    public static <T> T dynamic_cast(Class<T> cls, Object o) {
        if (cls.isInstance(o)) {
            return cls.cast(o);
        }
        return null;
    }

    public static <T> T const_cast(Object o) {
        return (T)o;
    }

    public static String toJavaString(char$ptr str) {
        return Casts.toCharSequence(str).toString();
    }

    public static String toJavaString(char$ptr str, int Len) {
        return Casts.toCharSequence(str, Len).toString();
    }

    public static String toJavaString(byte[] bytes, int start, int len) {
        return Casts.toCharSequence(bytes, start, len).toString();
    }

    public static CharSequence toCharSequence(byte[] bytes, int start, int len) {
        return Casts.toCharSequenceImpl(null, bytes, start, len);
    }

    public static void toStringBuilder(StringBuilder buf, byte[] bytes, int start, int len) {
        assert (buf != null);
        Casts.toCharSequenceImpl(buf, bytes, start, len);
    }

    public static CharSequence toCharSequence(char$ptr str) {
        return Casts.toCharSequence(str, -1);
    }

    public static CharSequence toCharSequence(char$ptr str, int len) {
        if (Native.$is_array_based(str)) {
            return Casts.toCharSequenceImpl((StringBuilder)null, str.$array(), str.$index(), len);
        }
        if (str instanceof char$ptr$CharSequence) {
            return Casts.toCharSequenceImpl((StringBuilder)null, ((char$ptr$CharSequence)str).getCharSequence(), str.$index(), len);
        }
        StringBuilder buf = new StringBuilder(16);
        return Casts.toCharSequenceNonArrayBasedAsciiPtr(buf, str, len);
    }

    public static void toStringBuilder(StringBuilder buf, char$ptr str) {
        assert (buf != null);
        Casts.toStringBuilderImpl(buf, str, -1);
    }

    public static void toStringBuilder(StringBuilder buf, char$ptr str, int len) {
        assert (buf != null);
        Casts.toStringBuilderImpl(buf, str, len);
    }

    private static void toStringBuilderImpl(StringBuilder buf, char$ptr str, int len) {
        if (Native.$is_array_based(str)) {
            Casts.toCharSequenceImpl(buf, str.$array(), str.$index(), len);
            return;
        }
        if (str instanceof char$ptr$CharSequence) {
            Casts.toCharSequenceImpl(buf, ((char$ptr$CharSequence)str).getCharSequence(), str.$index(), len);
            return;
        }
        Casts.toCharSequenceNonArrayBasedAsciiPtr(buf, str, len);
    }

    private static CharSequence toCharSequenceImpl(StringBuilder buf, CharSequence text, int start, int len) {
        CharSequence out;
        int textLen = text.length();
        len = len < 0 ? textLen - start : len;
        CharSequence charSequence = out = start == 0 && len == textLen ? text : text.subSequence(start, start + len);
        if (buf == null) {
            return out;
        }
        buf.append(out);
        return buf;
    }

    private static CharSequence toCharSequenceImpl(StringBuilder buf, byte[] bytes, int start, int len) {
        try {
            len = len < 0 ? std.strlen(bytes, start) : len;
            CharSequence out = UTF_8.decode(bytes, start, len);
            if (buf != null) {
                buf.append(out);
                return buf;
            }
            return out;
        }
        catch (Exception e) {
            if (buf == null) {
                buf = new StringBuilder(16);
            }
            return Casts.toCharSequenceNonArrayBasedAsciiPtr(buf, NativePointer.create_char$ptr(bytes, start), len);
        }
    }

    private static StringBuilder toCharSequenceNonArrayBasedAsciiPtr(StringBuilder buf, char$ptr str, int len) {
        assert (buf != null);
        if (str == null) {
            buf.append("<null>");
            return buf;
        }
        int idx = 0;
        if (len < 0) {
            try {
                char c;
                while ((c = Casts.$char(str.$at(idx++))) != '\u0000') {
                    buf.append(c);
                }
            }
            catch (Exception e) {
                buf.replace(buf.length() - idx + 1, buf.length(), "###Corrupted IDX=" + str.$index() + "###");
            }
        } else {
            while (len-- > 0) {
                buf.append(Casts.$char(str.$at(idx++)));
            }
        }
        return buf;
    }

    private static void trackReinterpret_cast_long() {
        ++callReinterpret_cast_long;
    }

    private static void trackReinterpret_cast_long_bytes() {
        ++callReinterpret_cast_long_bytes;
    }

    private static void trackReinterpret_cast_int_bytes() {
        ++callReinterpret_cast_int_bytes;
    }

    private static void trackReinterpret_cast() {
        ++callReinterpret_cast;
    }

    public static void clearStatistics() {
        callReinterpret_cast = 0L;
        callReinterpret_cast_long = 0L;
        callReinterpret_cast_long_bytes = 0L;
        callReinterpret_cast_int_bytes = 0L;
    }

    public static long printStatistics(PrintWriter out) {
        out.printf("%22s  called:\t%s.%n", "Cast [Object->long]", NativeTrace.formatNumber(callReinterpret_cast_long));
        out.printf("%22s  called:\t%s.%n", "Cast [long->Object]", NativeTrace.formatNumber(callReinterpret_cast));
        out.printf("%22s  called:\t%s.%n", "Cast [long->byte[]]", NativeTrace.formatNumber(callReinterpret_cast_long_bytes));
        out.printf("%22s  called:\t%s.%n", "Cast [int->byte[]]", NativeTrace.formatNumber(callReinterpret_cast_int_bytes));
        long Value = callReinterpret_cast_long + callReinterpret_cast + callReinterpret_cast_long_bytes + callReinterpret_cast_int_bytes;
        NativeTrace.dumpStatisticValue(out, "TotalLibStdCastsValue", Value);
        return Value;
    }
}

