/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Sequence;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.NativeContainer;
import org.clank.support.aliases.char$ptr;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

public abstract class StdVectorCharPtr
extends NativeTrace.CreateDestroy.Tracker
implements Native.NativePOD<std.vectorCharPtr>,
NativeMoveable<std.vectorCharPtr>,
Native.NativeComparable<std.vectorCharPtr>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<char$ptr>,
Sequence<type$ref<char$ptr>>,
NativeContainer<char$ptr>,
Destructors.ClassWithDestructor {
    protected final char$ptr defaultValue;
    protected char$ptr[] array;
    private static final Object[] EMPTY = new char$ptr[0];
    protected int end;

    protected StdVectorCharPtr(char$ptr defaultValue) {
        this.array = (char$ptr[])EMPTY;
        this.end = 0;
        assert (NativeTrace.assertDefaultValue(defaultValue));
        this.defaultValue = defaultValue;
    }

    protected StdVectorCharPtr(int initialSize, char$ptr defaultValue) {
        this(initialSize, defaultValue, defaultValue);
    }

    protected StdVectorCharPtr(int initialSize, char$ptr initialValue, char$ptr defaultValue) {
        this(defaultValue);
        this.assignWithSupplier(initialSize, initialValue);
    }

    protected StdVectorCharPtr(char$ptr[] array2, int length, char$ptr defaultValue) {
        this.array = array2;
        this.end = length;
        assert (NativeTrace.assertDefaultValue(defaultValue));
        this.defaultValue = defaultValue;
    }

    protected StdVectorCharPtr(type$iterator<?, char$ptr> iter, int length, char$ptr defaultValue) {
        this(iter, (type$iterator)iter.$add(length), defaultValue);
    }

    protected StdVectorCharPtr(type$iterator<?, char$ptr> begin, type$iterator<?, char$ptr> end, char$ptr defaultValue) {
        this(defaultValue);
        this.append(begin, end);
    }

    protected StdVectorCharPtr(std.vectorCharPtr other) {
        this(other.defaultValue);
        assert (other.checkAlive());
        this.append(other.begin(), other.end());
    }

    protected StdVectorCharPtr(JavaDifferentiators.JD.Move _dparam, std.vectorCharPtr other) {
        this(other.defaultValue);
        this.$assignMove(other);
    }

    @Override
    public std.vectorCharPtr $assign(std.vectorCharPtr other) {
        assert (other.checkAlive());
        if (this == other) {
            return (std.vectorCharPtr)this;
        }
        assert (this.checkAlive());
        this.clear();
        this.array = (char$ptr[])EMPTY;
        this.append(other.begin(), other.end());
        return (std.vectorCharPtr)this;
    }

    @Override
    public std.vectorCharPtr $assignMove(std.vectorCharPtr other) {
        assert (other.checkAlive());
        if (this == other) {
            return (std.vectorCharPtr)this;
        }
        assert (this.checkAlive());
        this.clear();
        this.array = other.array;
        this.end = other.end;
        other.array = (char$ptr[])EMPTY;
        other.end = 0;
        return (std.vectorCharPtr)this;
    }

    public boolean shrink_to_fit() {
        return false;
    }

    public void clear() {
        assert (this.checkAlive());
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    @Override
    public void resize(int newSize) {
        this.resize(newSize, this.defaultValue);
    }

    public void resize(int newSize, char$ptr defaultValue) {
        assert (this.checkAlive());
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
            }
            for (int i = this.end; i < newSize; ++i) {
                assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
                this.array[i] = Native.$tryClone(defaultValue);
            }
        }
        this.setEnd(newSize);
    }

    public void reserve(int N) {
        assert (this.checkAlive());
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public void assign(int NumElts, char$ptr Elt) {
        assert (this.checkAlive());
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    private void assignWithSupplier(int NumElts, char$ptr Supplier2) {
        assert (this.checkAlive());
        assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.array[i] = Supplier2;
        }
    }

    public void assign$T(type$iterator<?, char$ptr> __first, type$iterator<?, char$ptr> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public void swap(StdVectorCharPtr RHS) {
        assert (RHS.checkAlive());
        assert (this.checkAlive());
        char$ptr[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(Object elem) {
        assert (this.checkAlive());
        return this.find(elem, 0);
    }

    public final int find(Object elem, int from) {
        assert (this.checkAlive());
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq(this.array[i], elem, isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(Object elem) {
        assert (this.checkAlive());
        return this.find(elem) != std.string.npos;
    }

    public final void remove_if(NativeCallback.BoolPredicate<char$ptr> predicate) {
        assert (this.checkAlive());
        if (this.empty()) {
            return;
        }
        for (int i = 0; i < this.end; ++i) {
            if (!predicate.$call(this.array[i])) continue;
            boolean res = this.erase_at(i);
            assert (res);
            --i;
        }
    }

    public final boolean erase(Object elem) {
        assert (this.checkAlive());
        int index = this.find(elem);
        return this.erase_at(index);
    }

    private final boolean erase_at(int index) {
        if (index == std.string.npos) {
            return false;
        }
        assert (this.checkIndex(index));
        this.destroy_range(index, index + 1);
        if (index < this.end - 1) {
            std.copy(this.array, index + 1, this.end - index - 1, this.array, index);
        }
        this.$set(this.end - 1, this.$getDefaultVal());
        --this.end;
        return true;
    }

    public iterator erase(iterator I) {
        assert (this.checkAlive());
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.move(I.$add(1), this.end(), I, this.isDataPointerLike());
        this.pop_back();
        return N;
    }

    public iterator erase(iterator S, iterator E) {
        assert (this.checkAlive());
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = std.move(E, this.end(), S, this.isDataPointerLike());
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public iterator insert(iterator I, char$ptr Elt) {
        assert (this.checkAlive());
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward(I, this.end().$sub(1), this.end(), this.isDataPointerLike());
        I.star$ref().$set(Native.$tryAssign(I.$star(), Elt, this.isDataPointerLike()));
        return I;
    }

    public iterator insert_T$RR(iterator I, char$ptr Elt) {
        assert (this.checkAlive());
        if (I.$eq(this.end())) {
            this.push_back_T$RR(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward(I, this.end().$sub(1), this.end(), this.isDataPointerLike());
        I.star$ref().$set(Native.$tryMove(I.$star(), Elt, this.isDataPointerLike()));
        return I;
    }

    public iterator insert(iterator I, int NumToInsert, char$ptr Elt) {
        assert (this.checkAlive());
        assert (NumToInsert >= 0);
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd, this.isDataPointerLike());
            std.fill_n(I, NumToInsert, Elt);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub(I);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten), this.isDataPointerLike());
        std.fill_n(I, NumOverwritten, Elt);
        std.fill_n(OldEnd, NumToInsert - NumOverwritten, Elt);
        return I;
    }

    public final iterator insert$T(iterator I, type$iterator<?, char$ptr> From, type$iterator<?, char$ptr> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public iterator insert(iterator I, type$iterator<?, char$ptr> From, type$iterator<?, char$ptr> To) {
        int NumOverwritten;
        assert (this.checkAlive());
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (NumToInsert == 0) {
            return I;
        }
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd, this.isDataPointerLike());
            std.copy(From, To, I, this.isDataPointerLike());
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten), this.isDataPointerLike());
        From = Native.$tryClone(From);
        iterator J = Native.$Clone(I);
        for (NumOverwritten = OldEnd.$sub(I); NumOverwritten > 0; --NumOverwritten) {
            J.star$ref().$set(From.$star());
            J.$preInc();
            From.$preInc();
        }
        std.copy(From, To, OldEnd, this.isDataPointerLike());
        return I;
    }

    public void append(type$iterator<?, char$ptr> in_start, type$iterator<?, char$ptr> in_end) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type$iterator<?, char$ptr> iter = Native.$Clone(in_start);
        while (!iter.$eq((char$ptr)((Object)in_end))) {
            ++this.end;
            this.$set(this.end - 1, iter.$star());
            iter.$preInc();
        }
    }

    public void append(int NumInputs, char$ptr Elt) {
        assert (this.checkAlive());
        assert (NumInputs >= 0);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            ++this.end;
            this.$set(this.end - 1, Elt);
        }
    }

    @Override
    public boolean $eq(std.vectorCharPtr RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        if (this.size() != RHS.size()) {
            return false;
        }
        return std.equal(this.begin(), this.end(), RHS.begin());
    }

    @Override
    public boolean $noteq(std.vectorCharPtr RHS) {
        return !this.$eq(RHS);
    }

    @Override
    public boolean $less(Object obj) {
        assert (this.checkAlive());
        assert (((StdVectorCharPtr)obj).checkAlive());
        return std.lexicographical_compare(this.begin(), this.end(), ((StdVectorCharPtr)obj).begin(), ((StdVectorCharPtr)obj).end());
    }

    @Override
    public boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((std.vectorCharPtr)obj);
    }

    @Override
    public type$ref<char$ptr> ref$at(int idx) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        return NativePointer.create_type$ref(this.array, idx);
    }

    public char$ptr $at(int idx) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        return this.array[idx];
    }

    public char$ptr $at$Const(int idx) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        return this.array[idx];
    }

    public char$ptr $set(int idx, char$ptr value) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
        this.array[idx] = this.defaultValue == null ? value : Native.$tryAssign(this.array[idx], value, false);
        return this.array[idx];
    }

    protected final char$ptr $set$move(int idx, char$ptr value) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
        this.array[idx] = this.defaultValue == null ? value : Native.$tryMove(this.array[idx], value, false);
        return this.array[idx];
    }

    public boolean empty() {
        assert (this.checkAlive());
        return this.size() == 0;
    }

    @Override
    public void $destroy() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
        this.set$destroyed();
    }

    @Override
    public final void push_back_T$C$R(char$ptr val) {
        assert (this.checkAlive());
        this.push_back(val);
    }

    @Override
    public final void push_back_T$RR(char$ptr val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow(2 * this.capacity() + 1);
        }
        ++this.end;
        this.$set$move(this.end - 1, val);
    }

    @Override
    public void push_back(char$ptr val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow(2 * this.capacity() + 1);
        }
        ++this.end;
        this.$set(this.end - 1, val);
    }

    public final void emplace_back(char$ptr val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        int index = this.size();
        this.array[index] = val;
        this.setEnd(index + 1);
    }

    public final void emplace_back() {
        assert (this.checkAlive());
        this.push_back(this.$getDefaultVal());
    }

    public void pop_back() {
        assert (this.checkAlive());
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public char$ptr pop_back_val() {
        assert (this.checkAlive());
        char$ptr val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator begin() {
        assert (this.checkAlive());
        return new iterator(this, 0, false);
    }

    public final iterator cbegin() {
        return this.begin$Const();
    }

    public final iterator begin$Const() {
        assert (this.checkAlive());
        return this.begin();
    }

    public final iterator end() {
        assert (this.checkAlive());
        return new iterator(this, this.end, false);
    }

    public final iterator cend() {
        return this.end$Const();
    }

    public final iterator end$Const() {
        assert (this.checkAlive());
        return this.end();
    }

    public std.reverse_iterator<char$ptr> rbegin() {
        assert (this.checkAlive());
        return new std.reverse_iterator<char$ptr>(this.end());
    }

    public final std.reverse_iterator<char$ptr> rbegin$Const() {
        assert (this.checkAlive());
        return this.rbegin();
    }

    public std.reverse_iterator<char$ptr> rend() {
        assert (this.checkAlive());
        return new std.reverse_iterator<char$ptr>(this.begin());
    }

    public final std.reverse_iterator<char$ptr> rend$Const() {
        assert (this.checkAlive());
        return this.rend();
    }

    public type$ptr<char$ptr> data() {
        assert (this.checkAlive());
        return NativePointer.create_type$ptr(this.array);
    }

    public char$ptr front() {
        assert (this.checkAlive());
        assert (this.checkIndex(0));
        return this.array[0];
    }

    public final char$ptr front$Const() {
        assert (this.checkAlive());
        return this.front();
    }

    public char$ptr back() {
        assert (this.checkAlive());
        assert (this.checkIndex(this.end - 1));
        return this.array[this.end - 1];
    }

    public final char$ptr back$Const() {
        assert (this.checkAlive());
        return this.back();
    }

    public type$ref<char$ptr> ref$front() {
        return new type$ref<char$ptr>(){
            private final char$ptr stored;
            private final int index = 0;
            {
                assert (StdVectorCharPtr.this.checkAlive());
                assert (StdVectorCharPtr.this.checkIndex(0));
                this.stored = StdVectorCharPtr.this.array[0];
                this.index = 0;
            }

            @Override
            public char$ptr $deref() {
                assert (StdVectorCharPtr.this.checkAlive());
                assert (StdVectorCharPtr.this.checkIndex(0));
                return this.stored;
            }

            @Override
            public char$ptr $set(char$ptr value) {
                assert (StdVectorCharPtr.this.checkAlive());
                assert (StdVectorCharPtr.this.checkIndex(0));
                assert (NativeTrace.assertArrayHasMutableContent(StdVectorCharPtr.this.array, this));
                StdVectorCharPtr.this.array[0] = StdVectorCharPtr.this.defaultValue == null ? value : Native.$tryAssign(StdVectorCharPtr.this.array[0], value, false);
                return StdVectorCharPtr.this.array[0];
            }

            @Override
            public type$ptr<char$ptr> deref$ptr() {
                assert (StdVectorCharPtr.this.checkAlive());
                assert (StdVectorCharPtr.this.checkIndex(0));
                return (type$ptr)StdVectorCharPtr.this.data().$add(0);
            }
        };
    }

    public type$ref<char$ptr> ref$back() {
        return new type$ref<char$ptr>(){
            private final char$ptr stored;
            private final int index;
            {
                assert (StdVectorCharPtr.this.checkAlive());
                assert (StdVectorCharPtr.this.checkIndex(StdVectorCharPtr.this.end - 1));
                this.stored = StdVectorCharPtr.this.array[StdVectorCharPtr.this.end - 1];
                this.index = StdVectorCharPtr.this.end - 1;
            }

            @Override
            public char$ptr $deref() {
                assert (StdVectorCharPtr.this.checkAlive());
                assert (StdVectorCharPtr.this.checkIndex(this.index));
                return this.stored;
            }

            @Override
            public char$ptr $set(char$ptr value) {
                assert (StdVectorCharPtr.this.checkAlive());
                assert (StdVectorCharPtr.this.checkIndex(this.index));
                assert (NativeTrace.assertArrayHasMutableContent(StdVectorCharPtr.this.array, this));
                StdVectorCharPtr.this.array[this.index] = StdVectorCharPtr.this.defaultValue == null ? value : Native.$tryAssign(StdVectorCharPtr.this.array[this.index], value, false);
                return StdVectorCharPtr.this.array[this.index];
            }

            @Override
            public type$ptr<char$ptr> deref$ptr() {
                assert (StdVectorCharPtr.this.checkAlive());
                assert (StdVectorCharPtr.this.checkIndex(this.index));
                return (type$ptr)StdVectorCharPtr.this.data().$add(this.index);
            }
        };
    }

    @Override
    public int size() {
        assert (this.checkAlive());
        return this.end;
    }

    public int max_size() {
        assert (this.checkAlive());
        return Integer.MAX_VALUE;
    }

    public int capacity() {
        assert (this.checkAlive());
        return this.array.length;
    }

    @Override
    public int $sizeof() {
        int oneElemSize = NativeType.sizeof(this.defaultValue);
        for (char$ptr elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof(elem);
            break;
        }
        return this.capacity() * oneElemSize;
    }

    public type$ptr<char$ptr> ptr$at(int idx) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        return NativePointer.create_type$ptr(this.array, idx);
    }

    @Override
    public std.vectorCharPtr clone() {
        assert (this.checkAlive());
        std.vectorCharPtr out = new std.vectorCharPtr((std.vectorCharPtr)this);
        assert (this.getClass() == out.getClass()) : "forgot to override clone in " + out.getClass();
        return out;
    }

    @Override
    public std.vectorCharPtr move() {
        assert (this.checkAlive());
        std.vectorCharPtr out = new std.vectorCharPtr(JavaDifferentiators.JD.Move.INSTANCE, (std.vectorCharPtr)this);
        assert (this.getClass() == out.getClass()) : "forgot to override move in " + out.getClass();
        return out;
    }

    public void set_size(int N) {
        assert (this.checkAlive());
        assert (N >= 0);
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
        for (int i = from; i < to; ++i) {
            if (this.defaultValue != null) {
                Native.destroy(this.array[i]);
            }
            this.array[i] = null;
        }
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    protected void grow(int newSize) {
        this.array = NativePointer.copyOf$Object(this.array, newSize);
    }

    private void grow() {
        this.grow(this.capacity() > 0 ? this.capacity() * 2 : 1);
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    @Override
    public Iterator<char$ptr> iterator() {
        assert (this.checkAlive());
        return new JavaIterator<char$ptr>(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        String arrName = NativeTrace.getArrayName(this.array);
        if (this.end == 0) {
            return arrName + (super.is$destroyed() ? "DESTROYED " : "") + "<EMPTY>";
        }
        StringBuilder out = new StringBuilder(arrName);
        if (super.is$destroyed()) {
            out.append("DESTROYED");
        }
        out.append("\n").append(this.getClass().getSimpleName()).append("{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            char$ptr element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}").append(this.getClass().getSimpleName()).append("}\n");
        return out.toString();
    }

    private char$ptr $getDefaultVal() {
        return this.defaultValue;
    }

    protected final boolean checkIndex(int index) {
        assert (index < this.end) : "invalid index " + index + " when size is " + this.end;
        return true;
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }

    public static final class iterator
    implements type$iterator<iterator, char$ptr>,
    Native.assignable<iterator>,
    NativeMoveable<iterator>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final StdVectorCharPtr delegate;
        private int index;

        public iterator(StdVectorCharPtr delegate, int index, boolean makeConst) {
            assert (delegate.checkAlive());
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator(iterator other) {
            assert (other.delegate.checkAlive());
            this.delegate = other.delegate;
            this.index = other.index;
            this._const = other._const;
        }

        public iterator(JavaDifferentiators.JD.Move _dparam, iterator other) {
            assert (other.delegate.checkAlive());
            this.delegate = other.delegate;
            this.index = other.index;
            this._const = other._const;
        }

        @Override
        public iterator $assign(iterator other) {
            assert (this.delegate.checkAlive());
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        @Override
        public iterator $assignMove(iterator other) {
            assert (this.delegate.checkAlive());
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        @Override
        public char$ptr $arrow() {
            assert (this.delegate.checkAlive());
            return this.$at(0);
        }

        @Override
        public char$ptr $star() {
            assert (this.delegate.checkAlive());
            return this.$at(0);
        }

        @Override
        public type$ref<char$ptr> star$ref() {
            assert (this.delegate.checkAlive());
            return this.ref$at(0);
        }

        @Override
        public int $sub(iterator iter) {
            assert (this.delegate.checkAlive());
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        @Override
        public iterator $preInc() {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            ++this.index;
            return this;
        }

        @Override
        public iterator $preDec() {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            --this.index;
            return this;
        }

        @Override
        public iterator $postInc() {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        @Override
        public iterator $postDec() {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        @Override
        public iterator $inc(int amount) {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            this.index += amount;
            return this;
        }

        @Override
        public iterator $dec(int amount) {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        @Override
        public iterator $add(int amount) {
            assert (this.delegate.checkAlive());
            return new iterator(this.delegate, this.index + amount, false);
        }

        @Override
        public iterator $sub(int amount) {
            assert (this.delegate.checkAlive());
            return new iterator(this.delegate, this.index - amount, false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate.checkAlive());
            assert (((iterator)other).delegate.checkAlive());
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate.checkAlive());
            assert (((iterator)other).delegate.checkAlive());
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        @Override
        public iterator move() {
            assert (this.delegate.checkAlive());
            return new iterator(JavaDifferentiators.JD.Move.INSTANCE, this);
        }

        @Override
        public iterator clone() {
            assert (this.delegate.checkAlive());
            return new iterator(this.delegate, this.index, false);
        }

        @Override
        public iterator const_clone() {
            assert (this.delegate.checkAlive());
            return new iterator(this.delegate, this.index, true);
        }

        @Override
        public boolean $less(Object obj) {
            assert (this.delegate.checkAlive());
            assert (((iterator)obj).delegate.checkAlive());
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        @Override
        public boolean $lesseq(Object obj) {
            assert (this.delegate.checkAlive());
            assert (((iterator)obj).delegate.checkAlive());
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        @Override
        public boolean $greater(Object obj) {
            assert (this.delegate.checkAlive());
            assert (((iterator)obj).delegate.checkAlive());
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        @Override
        public boolean $greatereq(Object obj) {
            assert (this.delegate.checkAlive());
            assert (((iterator)obj).delegate.checkAlive());
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public char$ptr $at(int index) {
            assert (this.delegate.checkAlive());
            return this.delegate.$at(this.index + index);
        }

        public type$ref<char$ptr> ref$at(int index) {
            assert (this.delegate.checkAlive());
            return this.delegate.ref$at(this.index + index);
        }

        public type$ptr<char$ptr> toPointer() {
            assert (this.delegate.checkAlive());
            return NativePointer.create_type$ptr(this.delegate.array, this.index);
        }

        public int $index() {
            assert (this.delegate.checkAlive());
            assert (this.delegate.checkIndex(this.index));
            return this.index;
        }

        public String toString() {
            return "[" + (this.delegate.is$destroyed() ? "DESTROYED " : "") + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

