/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.clank.java.std;
import org.clank.java.std_map;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.int$ptr;
import org.clank.support.aliases.int$ref;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

public abstract class StdMapIntInt
extends NativeTrace.CreateDestroy.Tracker
implements Native.NativePOD<std_map.mapIntInt>,
Iterable<std_pair.pairIntInt>,
Destructors.ClassWithDestructor {
    protected int defaultValue;
    protected TreeMap<Integer, std_pair.pairIntInt> treeMap;

    protected StdMapIntInt(int defaultValue) {
        this(null, defaultValue);
    }

    protected StdMapIntInt(Comparator<Integer> comparator, int defaultValue) {
        if (comparator == null) {
            comparator = Native::$compare_type_int;
        }
        this.treeMap = new TreeMap(comparator);
        this.defaultValue = defaultValue;
    }

    protected StdMapIntInt(std_map.mapIntInt other) {
        this(other.treeMap.comparator(), other.defaultValue);
        this.$assign(other);
    }

    protected StdMapIntInt(JavaDifferentiators.JD.Move _dparam, std_map.mapIntInt other) {
        this(other.treeMap.comparator(), other.defaultValue);
        this.$assign(other);
        other.$destroy();
        other.treeMap = null;
    }

    public Comparator<? super Integer> keyComparator() {
        return this.treeMap.comparator();
    }

    @Override
    public std_map.mapIntInt $assign(std_map.mapIntInt other) {
        assert (other.checkAlive());
        assert (this.checkAlive());
        this.clear();
        for (Map.Entry entry : other.treeMap.entrySet()) {
            this.treeMap.put(this.$cloneKeyIfNeed((Integer)entry.getKey()), Native.$Clone((std_pair.pairIntInt)entry.getValue()));
        }
        return (std_map.mapIntInt)this;
    }

    public void swap(std_map.mapIntInt other) {
        assert (other.checkAlive());
        assert (this.checkAlive());
        TreeMap<Integer, std_pair.pairIntInt> tmpMap = this.treeMap;
        this.treeMap = other.treeMap;
        other.treeMap = tmpMap;
        int tmpDefVal = this.defaultValue;
        this.defaultValue = other.defaultValue;
        other.defaultValue = tmpDefVal;
    }

    public int $at_T$C$R(Integer key) {
        assert (this.checkAlive());
        return this.$at(key);
    }

    public int $at_T$RR(Integer key) {
        assert (this.checkAlive());
        return this.$at(key);
    }

    public int $at(Integer key) {
        assert (this.checkAlive());
        std_pair.pairIntInt out = this.treeMap.get(key);
        if (out == null) {
            out = std.make_pair_int_int(this.$cloneKeyIfNeed(key), this.$cloneValIfNeed(this.defaultValue));
            this.treeMap.put(this.$cloneKeyIfNeed(key), out);
        }
        return out.second;
    }

    public void $set(Integer key, int val) {
        assert (this.checkAlive());
        this.treeMap.put(this.$cloneKeyIfNeed(key), std.make_pair_int_int(this.$cloneKeyIfNeed(key), this.$cloneValIfNeed(val)));
    }

    public int$ref ref$at(final Integer key) {
        assert (this.checkAlive());
        if (!this.treeMap.containsKey(key)) {
            this.treeMap.put(this.$cloneKeyIfNeed(key), std.make_pair_int_int(this.$cloneKeyIfNeed(key), this.$cloneValIfNeed(this.defaultValue)));
        }
        return new int$ref(){

            @Override
            public int $deref() {
                assert (StdMapIntInt.this.checkAlive());
                return StdMapIntInt.this.treeMap.get((Object)key).second;
            }

            @Override
            public int $set(int value) {
                assert (StdMapIntInt.this.checkAlive());
                StdMapIntInt.this.treeMap.get((Object)key).second = Native.$tryAssign(StdMapIntInt.this.treeMap.get((Object)key).second, value, StdMapIntInt.this.isDataPointerLike());
                return value;
            }

            @Override
            public int$ptr deref$ptr() {
                assert (StdMapIntInt.this.checkAlive());
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public int size() {
        assert (this.checkAlive());
        return this.treeMap.size();
    }

    public boolean empty() {
        assert (this.checkAlive());
        return this.treeMap.isEmpty();
    }

    public void clear() {
        assert (this.checkAlive());
        if (!this.isKeyPointerLike() || !this.isDataPointerLike()) {
            for (Map.Entry<Integer, std_pair.pairIntInt> entry : this.treeMap.entrySet()) {
                if (!this.isKeyPointerLike()) {
                    Native.destroy(entry.getKey());
                }
                Native.destroy(entry.getValue());
            }
        }
        this.treeMap.clear();
    }

    public std_pair.pairTypeBool<iterator> insert$T$RR(std_pair.pairIntInt val) {
        assert (this.checkAlive());
        Integer Key = this.$cloneKeyIfNeed(val.first);
        boolean newElement = !this.treeMap.containsKey(Key);
        this.treeMap.put(Key, Native.$Move(val));
        return std.make_pair_Ptr_bool(this.find(Key), newElement);
    }

    public final std_pair.pairTypeBool<iterator> insert$T(std_pair.pairIntInt val) {
        assert (this.checkAlive());
        return this.insert(val);
    }

    public std_pair.pairTypeBool<iterator> insert(std_pair.pairIntInt val) {
        assert (this.checkAlive());
        boolean newElement = !this.treeMap.containsKey(val.first);
        this.treeMap.put(this.$cloneKeyIfNeed(val.first), Native.$Clone(val));
        return std.make_pair_Ptr_bool(this.find(val.first), newElement);
    }

    public void insert(type$iterator<?, std_pair.pairIntInt> I, type$iterator<?, std_pair.pairIntInt> E) {
        assert (this.checkAlive());
        while (Native.$noteq_iter(I, E)) {
            std_pair.pairIntInt val = I.$star();
            this.treeMap.put(this.$cloneKeyIfNeed(val.first), Native.$Clone(val));
            I.$preInc();
        }
    }

    public void erase(iterator position) {
        assert (this.checkAlive());
        Native.destroy(position.$star());
        position.erase();
    }

    public boolean erase(Integer key) {
        assert (this.checkAlive());
        if (!this.treeMap.containsKey(key)) {
            return false;
        }
        Map.Entry<Integer, std_pair.pairIntInt> entry = this.treeMap.ceilingEntry(key);
        if (!this.isKeyPointerLike()) {
            Native.destroy(entry.getKey());
        }
        Native.destroy(entry.getValue());
        this.treeMap.remove(key);
        return true;
    }

    public iterator lower_bound(Integer key) {
        assert (this.checkAlive());
        Integer lowerBoundKey = this.treeMap.ceilingKey(key);
        return lowerBoundKey != null ? this.find(lowerBoundKey) : this.end();
    }

    public iterator upper_bound(Integer key) {
        assert (this.checkAlive());
        Integer upperBoundKey = this.treeMap.higherKey(key);
        return upperBoundKey != null ? this.find(upperBoundKey) : this.end();
    }

    public iterator begin$Const() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, this.treeMap.firstEntry(), this.defaultValue, true);
    }

    public iterator end$Const() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, null, this.defaultValue, true);
    }

    public iterator begin() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, this.treeMap.firstEntry(), this.defaultValue, false);
    }

    public iterator end() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, null, this.defaultValue, false);
    }

    @Override
    public Iterator<std_pair.pairIntInt> iterator() {
        assert (this.checkAlive());
        return new JavaIterator<std_pair.pairIntInt>(this.begin(), this.end());
    }

    public boolean count(Integer key) {
        assert (this.checkAlive());
        return this.treeMap.containsKey(key);
    }

    public boolean replaceValueReference(Integer key, int val) {
        assert (this.checkAlive());
        std_pair.pairIntInt entry = this.treeMap.get(key);
        assert (entry != null) : "must be called only for existing entry " + key + " => " + val;
        entry.second = val;
        return true;
    }

    public final iterator find$Const(Integer key) {
        assert (this.checkAlive());
        return this.find(key);
    }

    public iterator find(Integer key) {
        assert (this.checkAlive());
        if (!this.treeMap.containsKey(key)) {
            return this.end();
        }
        return new iterator(this.treeMap, this.treeMap.ceilingEntry(key), this.defaultValue, false);
    }

    @Override
    public boolean $eq(std_map.mapIntInt other) {
        if (this.size() != other.size()) {
            return false;
        }
        return std.equal((type$iterator)this.begin(), (type$iterator)this.end(), (type$iterator)other.begin(), false);
    }

    @Override
    public std_map.mapIntInt clone() {
        assert (this.checkAlive());
        std_map.mapIntInt out = new std_map.mapIntInt((std_map.mapIntInt)this);
        assert (this.getClass() == out.getClass()) : "forgot to override clone in " + out.getClass();
        return out;
    }

    @Override
    public void $destroy() {
        assert (this.checkAlive());
        this.clear();
        super.set$destroyed();
    }

    private boolean isKeyPointerLike() {
        return false;
    }

    private Integer $cloneKeyIfNeed(Integer Key) {
        return this.isKeyPointerLike() ? Key : Native.$tryClone(Key);
    }

    private boolean isDataPointerLike() {
        return false;
    }

    private int $cloneValIfNeed(int Val) {
        return this.isDataPointerLike() ? Val : Native.$tryClone(Val);
    }

    public String toString() {
        return "StdMapIntInt " + (super.is$destroyed() ? "DESTROYED" : "") + "{" + this.treeMap + "}";
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }

    public static class iterator
    implements type$iterator<iterator, std_pair.pairIntInt> {
        private final int defaultValue;
        private final TreeMap<Integer, std_pair.pairIntInt> map;
        private final boolean _const;
        private Map.Entry<Integer, std_pair.pairIntInt> currentEntry;

        public iterator(iterator other) {
            this.defaultValue = Native.$tryClone(other.defaultValue);
            this.map = Native.$tryClone(other.map);
            this.currentEntry = Native.$tryClone(other.currentEntry);
            this._const = other._const;
        }

        public iterator(JavaDifferentiators.JD.Move _dparam, iterator other) {
            this.defaultValue = other.defaultValue;
            this.map = other.map;
            this.currentEntry = other.currentEntry;
            this._const = other._const;
        }

        private iterator(TreeMap<Integer, std_pair.pairIntInt> map, Map.Entry<Integer, std_pair.pairIntInt> curr, int defaultValue, boolean asConst) {
            this.defaultValue = defaultValue;
            this.map = map;
            this.currentEntry = curr;
            this._const = asConst;
        }

        private Integer getKey() {
            return this.currentEntry.getKey();
        }

        private void erase() {
            this.map.remove(this.currentEntry.getKey());
        }

        @Override
        public std_pair.pairIntInt $arrow() {
            return this.currentEntry.getValue();
        }

        @Override
        public std_pair.pairIntInt $star() {
            return this.currentEntry.getValue();
        }

        @Override
        public type$ref<std_pair.pairIntInt> star$ref() {
            return new type$ref<std_pair.pairIntInt>(){
                private final Map.Entry<Integer, std_pair.pairIntInt> localEntry;
                {
                    this.localEntry = currentEntry;
                }

                @Override
                public std_pair.pairIntInt $deref() {
                    return this.localEntry.getValue();
                }

                @Override
                public std_pair.pairIntInt $set(std_pair.pairIntInt value) {
                    assert (map.comparator().compare(value.first, this.localEntry.getKey()) == 0) : "Trying to change key of entry via iterator!";
                    this.localEntry.getValue().second = Native.$tryAssign(this.localEntry.getValue().second, value.second, this.isDataPointerLike());
                    return value;
                }

                @Override
                public type$ptr<std_pair.pairIntInt> deref$ptr() {
                    throw new UnsupportedOperationException("Not supported.");
                }
            };
        }

        @Override
        public iterator $preInc() {
            this.currentEntry = this.map.higherEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator $postInc() {
            iterator cloned = Native.$Clone(this);
            this.$preInc();
            return cloned;
        }

        @Override
        public iterator clone() {
            return new iterator(this.map, this.currentEntry, this.defaultValue, false);
        }

        @Override
        public iterator const_clone() {
            return new iterator(this.map, this.currentEntry, this.defaultValue, true);
        }

        public boolean $eq(Object other) {
            if (other instanceof iterator) {
                iterator otherIter = (iterator)other;
                if (otherIter.map == this.map) {
                    if (otherIter.currentEntry == null) {
                        return this.currentEntry == null;
                    }
                    if (this.currentEntry == null) {
                        return otherIter.currentEntry == null;
                    }
                    return Native.$eq(otherIter.currentEntry.getKey(), this.currentEntry.getKey());
                }
            }
            return false;
        }

        public boolean $noteq(Object other) {
            return !this.$eq(other);
        }

        @Override
        public int $sub(iterator iter) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator $preDec() {
            this.currentEntry = this.currentEntry == null ? this.map.lastEntry() : this.map.lowerEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator $postDec() {
            iterator cloned = Native.$Clone(this);
            this.$preDec();
            return cloned;
        }

        @Override
        public iterator $inc(int amount) {
            if (amount == 0) {
                return this;
            }
            if (amount > 0) {
                do {
                    this.$preInc();
                } while (--amount > 0);
                return this;
            }
            return this.$dec(-amount);
        }

        @Override
        public iterator $dec(int amount) {
            if (amount == 0) {
                return this;
            }
            if (amount > 0) {
                do {
                    this.$preDec();
                } while (--amount > 0);
                return this;
            }
            return this.$inc(-amount);
        }

        @Override
        public iterator $add(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator $sub(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        private boolean isDataPointerLike() {
            return false;
        }
    }
}

