/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java;

import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

public interface std_ptr {
    public static <T> boolean $eq_shared_ptr(shared_ptr<T> primary, shared_ptr<T> second) {
        return std_ptr.$eq_shared_ptr$C(primary, second);
    }

    public static <T> boolean $eq_shared_ptr$C(shared_ptr<T> primary, shared_ptr<T> second) {
        if (primary == second) {
            return true;
        }
        return primary.$eq(second);
    }

    public static <T> boolean $eq_unique_ptr(unique_ptr<T> primary, unique_ptr<T> second) {
        return std_ptr.$eq_unique_ptr$C(primary, second);
    }

    public static <T> boolean $eq_unique_ptr$C(unique_ptr<T> primary, unique_ptr<T> second) {
        if (primary == second) {
            return true;
        }
        return primary.$eq(second);
    }

    public static <T> boolean $eq_unique_ptr(unique_ptr_with_deleter<T> primary, unique_ptr_with_deleter<T> second) {
        return std_ptr.$eq_unique_ptr$C(primary, second);
    }

    public static <T> boolean $eq_unique_ptr$C(unique_ptr_with_deleter<T> primary, unique_ptr_with_deleter<T> second) {
        if (primary == second) {
            return true;
        }
        return primary.$eq(second);
    }

    public static class auto_ptr<T>
    extends unique_ptr<T> {
        public auto_ptr() {
        }

        public auto_ptr(T P2) {
            super(P2);
        }

        public auto_ptr(JavaDifferentiators.JD.NullPtr _dparam, Object __p) {
            super(_dparam, __p);
        }

        public auto_ptr(auto_ptr<? extends T> $Prm0) {
            super($Prm0);
        }

        public auto_ptr(JavaDifferentiators.JD.Move _dparam, auto_ptr<T> $Prm0) {
            super(_dparam, $Prm0);
        }

        public auto_ptr<T> $assign(auto_ptr<T> __a) {
            this.reset(__a.release());
            return this;
        }
    }

    public static class unique_ptr_null_eq<T extends Native.NativeComparable>
    extends NativeTrace.CreateDestroy.Tracker
    implements Destructors.ClassWithDestructor,
    Native.Native.Bool {
        private T Ptr;
        private static long instances = 0L;

        private unique_ptr_null_eq(unique_ptr_null_eq<T> $Prm0) {
            throw new AssertionError((Object)"LLVM_DELETED_FUNCTION");
        }

        private unique_ptr_null_eq<T> $assign(unique_ptr_null_eq<T> $Prm0) {
            throw new AssertionError((Object)"LLVM_DELETED_FUNCTION");
        }

        public unique_ptr_null_eq() {
            this((Native.NativeComparable)null);
        }

        public unique_ptr_null_eq(JavaDifferentiators.JD.NullPtr _dparam, Object __p) {
            this((Native.NativeComparable)__p);
            assert (__p == null) : "only for nullptr_t";
        }

        public unique_ptr_null_eq(T P2) {
            super(P2);
            this.Ptr = P2;
            assert (P2 == null || Native.$eq(P2, null)) : "this object is not $eq to null, use OwningPtr instead";
            unique_ptr_null_eq.trackInstance();
        }

        @Override
        public void $destroy() {
            assert (this.checkAlive());
            if (this.Ptr != null) {
                Destructors.$destroy(this.Ptr);
            }
            this.Ptr = null;
            super.set$destroyed();
        }

        public void reset() {
            this.reset(null);
        }

        public void reset(T P2) {
            assert (this.checkAlive());
            if (P2 == this.Ptr) {
                return;
            }
            assert (P2 == null || Native.$eq(P2, null)) : "this object is not $eq to null, use OwningPtr instead";
            T Tmp = this.Ptr;
            this.Ptr = P2;
            if (Tmp != null) {
                Destructors.$destroy(Tmp);
            }
        }

        public T take() {
            assert (this.checkAlive());
            T Tmp = this.Ptr;
            this.Ptr = null;
            return Tmp;
        }

        public T $star() {
            assert (this.checkAlive());
            if (this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return this.Ptr;
        }

        public T $arrow() {
            assert (this.checkAlive());
            if (this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return this.Ptr;
        }

        public T get() {
            assert (this.checkAlive());
            return this.Ptr;
        }

        @Override
        public boolean $bool() {
            if (this.is$destroyed()) {
                return false;
            }
            return this.Ptr == null ? false : Native.$noteq(this.Ptr, null);
        }

        @Override
        public boolean $not() {
            if (this.is$destroyed()) {
                return true;
            }
            return this.Ptr == null ? true : Native.$eq(this.Ptr, null);
        }

        public boolean isValid() {
            assert (this.checkAlive());
            return this.Ptr == null ? false : Native.$noteq(this.Ptr, null);
        }

        public void swap(unique_ptr_null_eq<T> RHS) {
            assert (super.checkAlive());
            assert (this.checkAlive());
            T Tmp = RHS.Ptr;
            RHS.Ptr = this.Ptr;
            this.Ptr = Tmp;
        }

        private boolean checkAlive() {
            if (unique_ptr_null_eq.should$check()) {
                this.check$Alive();
            }
            return true;
        }

        public String toString() {
            return "unique_ptr_null_eq{destroyed=" + this.is$destroyed() + ", Ptr=" + this.Ptr + '}';
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long printStatistics(PrintWriter out) {
            out.printf("%22s created:\t%s%n", unique_ptr_null_eq.class.getSimpleName(), NativeTrace.formatNumber(instances));
            NativeTrace.dumpStatisticValue(unique_ptr_null_eq.class.getSimpleName(), instances);
            return instances;
        }
    }

    public static class unique_ptr_array<T>
    extends unique_ptr<T[]> {
        private static long instances = 0L;

        public unique_ptr_array(JavaDifferentiators.JD.NullPtr _dparam, Object __p) {
            this((Object[])__p);
            assert (__p == null) : "only for nullptr_t";
        }

        public unique_ptr_array() {
            unique_ptr_array.trackInstance();
        }

        public unique_ptr_array(T[] P2) {
            super(P2);
            unique_ptr_array.trackInstance();
        }

        public unique_ptr_array(unique_ptr $Prm0) {
            super($Prm0);
            assert ($Prm0.getClass() == unique_ptr_array.class) : "Copy constructor called for different class!";
            unique_ptr_array.trackInstance();
        }

        public unique_ptr_array(JavaDifferentiators.JD.Move _dparam, unique_ptr_array<T[]> $Prm0) {
            super(_dparam, $Prm0);
            assert ($Prm0.getClass() == unique_ptr_array.class) : "Move constructor called for different class!";
            unique_ptr_array.trackInstance();
        }

        public unique_ptr_array(JavaDifferentiators.JD.Move _dparam, unique_ptr<T[]> $Prm0) {
            super(_dparam, $Prm0);
            assert ($Prm0.getClass() == unique_ptr_array.class) : "Move constructor called for different class!";
            unique_ptr_array.trackInstance();
        }

        @Override
        public unique_ptr_array<T> $assignMove(unique_ptr<T[]> __u) {
            super.$assignMove(__u);
            assert (__u.getClass() == unique_ptr_array.class) : "Move constructor called for different class!";
            return this;
        }

        public T $set(int i, T val) {
            ((Object[])this.get())[i] = Native.$tryAssign(((Object[])this.get())[i], val, true);
            return (T)((Object[])this.get())[i];
        }

        public type$ptr<T> ptr$at(int i) {
            return NativePointer.create_type$ptr((Object[])this.get(), i);
        }

        public T $at(int i) {
            return (T)((Object[])this.get())[i];
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long printStatistics(PrintWriter out) {
            out.printf("%22s created:%s%n", unique_ptr_array.class.getSimpleName(), NativeTrace.formatNumber(instances));
            NativeTrace.dumpStatisticValue(unique_ptr_array.class.getSimpleName(), instances);
            return instances;
        }
    }

    public static class unique_ptr_with_deleter<T>
    extends unique_ptr<T> {
        private final deleter<T> _Dp;
        private static long instances = 0L;

        public unique_ptr_with_deleter(JavaDifferentiators.JD.NullPtr _dparam, Object __p) {
            this(__p);
            assert (__p == null) : "only for nullptr_t";
        }

        public unique_ptr_with_deleter(JavaDifferentiators.JD.Unique_ptr._Up._Ep _dparam, Object __p) {
            this(__p);
            assert (__p == null) : "only for nullptr_t";
        }

        public unique_ptr_with_deleter() {
            this._Dp = new default_delete();
            unique_ptr_with_deleter.trackInstance();
        }

        public unique_ptr_with_deleter(T P2) {
            super(P2);
            this._Dp = new default_delete();
            unique_ptr_with_deleter.trackInstance();
        }

        public unique_ptr_with_deleter(T P2, deleter<T> _Dp) {
            super(P2);
            this._Dp = _Dp;
            unique_ptr_with_deleter.trackInstance();
        }

        public unique_ptr_with_deleter(unique_ptr $Prm0) {
            super($Prm0);
            assert ($Prm0.getClass() == unique_ptr_with_deleter.class) : "Copy constructor called for different class!";
            this._Dp = ((unique_ptr_with_deleter)$Prm0)._Dp;
            unique_ptr_with_deleter.trackInstance();
        }

        public unique_ptr_with_deleter(JavaDifferentiators.JD.Move _dparam, unique_ptr<T> $Prm0) {
            super(_dparam, $Prm0);
            assert ($Prm0.getClass() == unique_ptr_with_deleter.class) : "Move constructor called for different class!";
            this._Dp = ((unique_ptr_with_deleter)$Prm0)._Dp;
            unique_ptr_with_deleter.trackInstance();
        }

        @Override
        public unique_ptr<T> $assignMove(unique_ptr<T> __u) {
            super.$assignMove(__u);
            assert (__u.getClass() == unique_ptr_with_deleter.class) : "Move constructor called for different class!";
            assert (this._Dp.getClass() == ((unique_ptr_with_deleter)__u)._Dp.getClass()) : "Moving to the ptr with differnet deleter!";
            return this;
        }

        @Override
        public void $destroy() {
            this.checkAlive();
            this._Dp.$call(this.get());
            this.Ptr = null;
            super.set$destroyed();
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long printStatistics(PrintWriter out) {
            out.printf("%22s created:%s%n", unique_ptr_with_deleter.class.getSimpleName(), NativeTrace.formatNumber(instances));
            NativeTrace.dumpStatisticValue(unique_ptr_with_deleter.class.getSimpleName(), instances);
            return instances;
        }
    }

    public static class unique_ptr<T>
    extends NativeTrace.CreateDestroy.Tracker
    implements Destructors.ClassWithDestructor,
    Native.Native.Bool,
    NativeMoveable<unique_ptr<T>>,
    NativeCloneable<unique_ptr<T>>,
    Native.NativeComparable<unique_ptr<T>>,
    NativeSwappable {
        protected T Ptr;
        private static final unique_ptr DEFAULT = new unique_ptr();
        private static long instances = 0L;

        public static <T> unique_ptr_array<T> $unique_ptr_array(unique_ptr_array<T> $Prm0) {
            assert ($Prm0.checkAlive());
            return new unique_ptr_array<Object>((Object[])$Prm0.release());
        }

        public static <T> unique_ptr<T> $unique_ptr(unique_ptr<T> $Prm0) {
            assert ($Prm0.checkAlive());
            return new unique_ptr<T>($Prm0.release());
        }

        public static <T> unique_ptr_with_deleter<T> $unique_ptr_with_deleter(unique_ptr_with_deleter<T> $Prm0) {
            assert ($Prm0.checkAlive());
            return new unique_ptr_with_deleter<T>($Prm0.release(), ((unique_ptr_with_deleter)$Prm0)._Dp);
        }

        private unique_ptr<T> $assign(unique_ptr<T> $Prm0) {
            throw new AssertionError((Object)"LLVM_DELETED_FUNCTION");
        }

        public unique_ptr() {
            this(null);
        }

        public unique_ptr(T P2) {
            super(P2);
            this.Ptr = P2;
            assert (P2 == null || Native.$noteq(P2, null)) : "this object is $eq to null, use OwningPtrNullEq instead";
            unique_ptr.trackInstance();
        }

        public unique_ptr(JavaDifferentiators.JD.NullPtr _dparam, Object __p) {
            this(__p);
            assert (__p == null) : "only for nullptr_t";
        }

        public <X> unique_ptr(unique_ptr<? extends X> $Prm0) {
            super($Prm0.Ptr);
            assert ($Prm0.checkAlive());
            this.Ptr = $Prm0.release();
            unique_ptr.trackInstance();
        }

        public <X> unique_ptr(JavaDifferentiators.JD.Unique_ptr._Up._Ep _dparam, unique_ptr<? extends X> $Prm0) {
            super($Prm0.Ptr);
            assert ($Prm0.checkAlive());
            this.Ptr = $Prm0.release();
            unique_ptr.trackInstance();
        }

        public <X> unique_ptr(JavaDifferentiators.JD.Move _dparam, unique_ptr<X> $Prm0) {
            this($Prm0.release());
            assert ($Prm0.checkAlive());
        }

        @Override
        public void $destroy() {
            assert (this.checkAlive());
            if (this.Ptr != null) {
                Destructors.$destroy(this.Ptr);
            }
            this.Ptr = null;
            super.set$destroyed();
        }

        public unique_ptr<T> $assignMove(unique_ptr<T> $Prm0) {
            assert ($Prm0.checkAlive());
            this.reset($Prm0.release());
            return this;
        }

        public unique_ptr<T> $assign_nullptr_t(Object obj) {
            assert (obj == null) : "Operator can be used only to assign nullptr_t!";
            this.reset();
            return this;
        }

        public unique_ptr<T> $assign$ConvertibleNotArray(Object obj) {
            assert (obj == null) : "Operator can be used only to assign nullptr_t!";
            this.reset();
            return this;
        }

        public unique_ptr<T> $assign$ConvertibleNotArray(unique_ptr<? extends T> $Prm0) {
            assert ($Prm0.checkAlive());
            this.reset($Prm0.release());
            return this;
        }

        public T release() {
            assert (this.checkAlive());
            T result = this.get();
            this.Ptr = null;
            return result;
        }

        public void reset() {
            this.reset(null);
        }

        public <Derived extends T> void reset(Derived P2) {
            assert (this.checkAlive());
            if (P2 == this.Ptr) {
                return;
            }
            T Tmp = this.Ptr;
            this.Ptr = P2;
            assert (P2 == null || Native.$noteq(P2, null)) : "this object is $eq to null, use OwningPtrNullEq instead";
            if (Tmp != null) {
                Destructors.$destroy(Tmp);
            }
        }

        public T take() {
            assert (this.checkAlive());
            T Tmp = this.Ptr;
            this.Ptr = null;
            return Tmp;
        }

        public T $star() {
            assert (this.checkAlive());
            if (this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return this.Ptr;
        }

        @Override
        public unique_ptr<T> clone() {
            assert (this.checkAlive());
            if (this.Ptr != null) {
                throw new IllegalStateException("Expected Only empty unique_ptr to be cloned by collections defaultValue! May be push vs. push_RR mistake?");
            }
            return new unique_ptr<T>();
        }

        @Override
        public unique_ptr<T> move() {
            assert (this.checkAlive());
            return new unique_ptr<T>(JavaDifferentiators.JD.Move.INSTANCE, this);
        }

        public type$ref<T> star$ref() {
            assert (this.checkAlive());
            if (this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return new type$ref<T>(){

                @Override
                public T $deref() {
                    assert (this.checkAlive());
                    return Ptr;
                }

                @Override
                public T $set(T value) {
                    assert (this.checkAlive());
                    Ptr = Native.$tryAssign(Ptr, value, false);
                    return Ptr;
                }

                @Override
                public type$ptr<T> deref$ptr() {
                    assert (this.checkAlive());
                    throw new UnsupportedOperationException("Not implemented yet!");
                }
            };
        }

        public T $arrow() {
            assert (this.checkAlive());
            if (this.Ptr == null) {
                throw new NullPointerException("Cannot dereference null pointer");
            }
            return this.Ptr;
        }

        public T get() {
            assert (this.checkAlive());
            return this.Ptr;
        }

        @Override
        public boolean $bool() {
            if (this.is$destroyed()) {
                return false;
            }
            return this.Ptr != null;
        }

        @Override
        public boolean $not() {
            if (this.is$destroyed()) {
                return true;
            }
            return this.Ptr == null;
        }

        public boolean isValid() {
            assert (this.checkAlive());
            return this.Ptr != null;
        }

        public void swap(unique_ptr<T> RHS) {
            assert (RHS.checkAlive());
            assert (this.checkAlive());
            T Tmp = RHS.Ptr;
            RHS.Ptr = this.Ptr;
            this.Ptr = Tmp;
        }

        @Override
        public boolean $eq(unique_ptr<T> other) {
            assert (other.checkAlive());
            assert (this.checkAlive());
            if (other == null) {
                return Native.$eq(this.Ptr, null, true);
            }
            return Native.$eq(this.Ptr, other.Ptr);
        }

        @Override
        public void swap(NativeSwappable RHS) {
            this.swap((unique_ptr)RHS);
        }

        public String toString() {
            return "unique_ptr{destroyed=" + this.is$destroyed() + ", Ptr=" + this.Ptr + '}';
        }

        protected final boolean checkAlive() {
            if (unique_ptr.should$check()) {
                super.check$Alive();
            }
            return true;
        }

        public static <T> unique_ptr<T> $Default() {
            return DEFAULT;
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long printStatistics(PrintWriter out) {
            out.printf("%22s created:\t%s%n", unique_ptr.class.getSimpleName() + "(+derived)", NativeTrace.formatNumber(instances));
            NativeTrace.dumpStatisticValue(unique_ptr.class.getSimpleName(), instances);
            return instances;
        }
    }

    public static class shared_ptr<T>
    extends NativeTrace.CreateDestroy.Tracker
    implements Destructors.ClassWithDestructor,
    Native.NativeComparable<shared_ptr<T>>,
    Native.Native.Bool,
    NativeCloneable<shared_ptr>,
    NativeMoveable<shared_ptr> {
        private T Obj;
        private AtomicInteger _M_refcount;
        private static long instances = 0L;

        public shared_ptr() {
            super(null);
            this.Obj = null;
            this._M_refcount = null;
            shared_ptr.trackInstance();
        }

        public shared_ptr(JavaDifferentiators.JD.NullPtr _dparam, Object __p) {
            this(__p);
            assert (__p == null) : "only for nullptr_t";
        }

        public shared_ptr(T obj) {
            super(obj);
            this.Obj = obj;
            this.retain();
            shared_ptr.trackInstance();
        }

        public <Tp1> shared_ptr(JavaDifferentiators.JD.Shared_ptr._Tp1.C _dparam, shared_ptr<Tp1> S) {
            this(S);
        }

        public shared_ptr(shared_ptr<T> S) {
            super(S.Obj);
            assert (super.checkAlive());
            this.Obj = S.Obj;
            this._M_refcount = S._M_refcount;
            this.retain();
            shared_ptr.trackInstance();
        }

        public shared_ptr(JavaDifferentiators.JD.Move $Prm, shared_ptr<T> S) {
            super(S.Obj);
            assert (super.checkAlive());
            this.Obj = null;
            this._M_refcount = null;
            this.swap(S);
            shared_ptr.trackInstance();
        }

        public shared_ptr<T> $assign(shared_ptr<T> S) {
            assert (super.checkAlive());
            if (this.is$destroyed()) {
                assert (this.Obj == null);
                this.clear$destroyed();
            }
            if (this != S) {
                this.release();
                this.Obj = S.Obj;
                this._M_refcount = S._M_refcount;
                this.retain();
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public shared_ptr<T> $assignMove(shared_ptr<T> S) {
            assert (super.checkAlive());
            if (this.is$destroyed()) {
                assert (this.Obj == null);
                this.clear$destroyed();
            }
            shared_ptr<T> tmp = new shared_ptr<T>(JavaDifferentiators.JD.Move.INSTANCE, S);
            try {
                tmp.swap(this);
                shared_ptr shared_ptr2 = this;
                return shared_ptr2;
            }
            finally {
                tmp.$destroy();
            }
        }

        @Override
        public void $destroy() {
            assert (this.checkAlive());
            this.release();
            this.Obj = null;
            super.set$destroyed();
        }

        public T $star() {
            assert (this.checkAlive());
            return this.Obj;
        }

        public T $arrow() {
            assert (this.checkAlive());
            return this.Obj;
        }

        public T getPtr() {
            assert (this.checkAlive());
            return this.Obj;
        }

        @Override
        public boolean $bool() {
            assert (this.checkAlive());
            return this.Obj != null;
        }

        public T $Void2RetType() {
            assert (this.checkAlive());
            return this.Obj == null ? null : (T)this.Obj;
        }

        public void swap(shared_ptr<T> other) {
            assert (super.checkAlive());
            assert (this.checkAlive());
            T tmp = other.Obj;
            AtomicInteger _M_refcount_Tmp = other._M_refcount;
            other.Obj = this.Obj;
            other._M_refcount = this._M_refcount;
            this.Obj = tmp;
            this._M_refcount = _M_refcount_Tmp;
        }

        public void reset() {
            assert (this.checkAlive());
            this.release();
            this.Obj = null;
        }

        public void resetWithoutRelease() {
            assert (this.checkAlive());
            this.Obj = null;
        }

        private void retain() {
            assert (this.checkAlive());
            if (this.Obj != null) {
                if (this._M_refcount == null) {
                    this._M_refcount = new AtomicInteger(0);
                }
                this._M_refcount.incrementAndGet();
            }
        }

        private void release() {
            assert (this.checkAlive());
            if (this.Obj != null) {
                assert (this._M_refcount != null);
                if (this._M_refcount.decrementAndGet() == 0) {
                    Destructors.$destroy(this.Obj);
                    this.Obj = null;
                    this._M_refcount = null;
                }
            }
        }

        public String toString() {
            return "shared_ptr{counter=" + this._M_refcount + (this.is$destroyed() ? "DESTROYED;" : "") + ", Obj=" + this.Obj + '}';
        }

        public T get() {
            assert (this.checkAlive());
            return this.Obj;
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long printStatistics(PrintWriter out) {
            out.printf("%22s created:\t%s%n", shared_ptr.class.getSimpleName(), NativeTrace.formatNumber(instances));
            NativeTrace.dumpStatisticValue(shared_ptr.class.getSimpleName(), instances);
            return instances;
        }

        @Override
        public boolean $eq(shared_ptr<T> other) {
            assert (super.checkAlive());
            if (other == null) {
                return Native.$eq(this.Obj, null);
            }
            return Native.$eq(this.Obj, other.Obj);
        }

        @Override
        public shared_ptr<T> clone() {
            if (this.Obj != null) {
                throw new IllegalStateException("Expected Only empty shared_ptr to be cloned by collections defaultValue! May be push vs. push_RR mistake?");
            }
            return new shared_ptr<T>();
        }

        @Override
        public shared_ptr<T> move() {
            return new shared_ptr<T>(JavaDifferentiators.JD.Move.INSTANCE, this);
        }

        private boolean checkAlive() {
            if (shared_ptr.should$check()) {
                this.check$Alive();
            }
            return true;
        }
    }

    public static class default_delete<T>
    implements deleter<T> {
        @Override
        public void $call(T __ptr) {
            Native.destroy(__ptr);
        }
    }

    public static interface deleter<T> {
        public void $call(T var1);
    }
}

