/*
 * Decompiled with CFR 0.152.
 */
package fleet.reporting.opentelemetry.exporters.jaeger;

import fleet.reporting.opentelemetry.TelemetrySeparationKt;
import fleet.reporting.opentelemetry.exporters.jaeger.JSpanData;
import fleet.reporting.opentelemetry.exporters.jaeger.JTraceData;
import fleet.reporting.opentelemetry.exporters.jaeger.JTraceDati;
import fleet.reporting.opentelemetry.exporters.jaeger.JaegerJsonFileSpanExporterKt;
import fleet.reporting.opentelemetry.exporters.jaeger.JaegerProtoKt;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u0012\u0010\u0016\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\u0019\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\f\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00100\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lfleet/reporting/opentelemetry/exporters/jaeger/JaegerJsonFileSpanExporter;", "Lio/opentelemetry/sdk/trace/export/SpanExporter;", "resource", "Lio/opentelemetry/sdk/resources/Resource;", "basePath", "Ljava/nio/file/Path;", "<init>", "(Lio/opentelemetry/sdk/resources/Resource;Ljava/nio/file/Path;)V", "lastDir", "", "dataHolder", "Lfleet/reporting/opentelemetry/exporters/jaeger/JTraceDati;", "collectedSpans", "", "Lio/opentelemetry/sdk/trace/data/SpanData;", "kotlin.jvm.PlatformType", "", "Ljava/util/List;", "export", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "spans", "", "flush", "shutdown", "subDir", "emptyData", "fleet.reporting.opentelemetry"})
@SourceDebugExtension(value={"SMAP\nJaegerJsonFileSpanExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JaegerJsonFileSpanExporter.kt\nfleet/reporting/opentelemetry/exporters/jaeger/JaegerJsonFileSpanExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n*L\n1#1,93:1\n1557#2:94\n1628#2,2:95\n1557#2:97\n1628#2,3:98\n1630#2:101\n1#3:102\n42#4:103\n*S KotlinDebug\n*F\n+ 1 JaegerJsonFileSpanExporter.kt\nfleet/reporting/opentelemetry/exporters/jaeger/JaegerJsonFileSpanExporter\n*L\n72#1:94\n72#1:95,2\n73#1:97\n73#1:98,3\n72#1:101\n85#1:103\n*E\n"})
public final class JaegerJsonFileSpanExporter
implements SpanExporter {
    @NotNull
    private final Resource resource;
    @NotNull
    private final Path basePath;
    @Nullable
    private volatile String lastDir;
    @NotNull
    private JTraceDati dataHolder;
    private final List<SpanData> collectedSpans;

    public JaegerJsonFileSpanExporter(@NotNull Resource resource, @NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.resource = resource;
        this.basePath = basePath;
        JaegerJsonFileSpanExporterKt.access$getExporterRegistry$p().add(this);
        this.dataHolder = this.emptyData();
        this.collectedSpans = Collections.synchronizedList(new ArrayList());
    }

    @NotNull
    public CompletableResultCode export(@NotNull Collection<? extends SpanData> spans) {
        Intrinsics.checkNotNullParameter(spans, (String)"spans");
        String subDir = (String)TelemetrySeparationKt.getTelemetrySubdir().get();
        if (!Intrinsics.areEqual((Object)subDir, (Object)this.lastDir)) {
            this.flush(this.lastDir);
            this.lastDir = subDir;
        }
        List<SpanData> list = this.collectedSpans;
        Intrinsics.checkNotNullExpressionValue(list, (String)"collectedSpans");
        CollectionsKt.addAll((Collection)list, (Iterable)spans);
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    @NotNull
    public CompletableResultCode flush() {
        return this.flush(this.lastDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableResultCode shutdown() {
        try {
            CompletableResultCode completableResultCode = this.flush();
            return completableResultCode;
        }
        finally {
            JaegerJsonFileSpanExporterKt.access$getExporterRegistry$p().remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompletableResultCode flush(String subDir) {
        Object object;
        JTraceDati dataToFlush;
        Json $this$mapTo$iv$iv;
        Object object2;
        block13: {
            block12: {
                void $this$map$iv;
                ArrayList spansToFlush = new ArrayList(this.collectedSpans);
                this.collectedSpans.clear();
                JTraceDati $this$flush_u24lambda_u242 = this.dataHolder;
                boolean bl = false;
                object2 = $this$flush_u24lambda_u242.getData();
                JTraceDati jTraceDati = $this$flush_u24lambda_u242;
                boolean $i$f$map = false;
                void var10_13 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Collection<JSpanData> collection;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    void data1;
                    JTraceData jTraceData = (JTraceData)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    Iterable iterable = spansToFlush;
                    String string = null;
                    void var20_23 = data1;
                    boolean $i$f$map2 = false;
                    void var22_25 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        SpanData spanData = (SpanData)item$iv$iv2;
                        collection = destination$iv$iv2;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(JaegerProtoKt.wrapData((SpanData)it));
                    }
                    collection = (List)destination$iv$iv2;
                    collection2.add(JTraceData.copy$default((JTraceData)var20_23, string, (List)collection, null, 5, null));
                }
                dataToFlush = jTraceDati.copy((List)destination$iv$iv);
                this.dataHolder = this.emptyData();
                if (spansToFlush.isEmpty()) {
                    CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
                    Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
                    return completableResultCode;
                }
                object = subDir;
                if (object == null) break block12;
                String it = object;
                boolean bl4 = false;
                Path path = this.basePath.resolve(it);
                object = path;
                if (path != null) break block13;
            }
            object = this.basePath;
        }
        Object subDirAwarePath = object;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createDirectories((Path)subDirAwarePath, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(...)");
        Path spansFile = path.resolve("spans.json");
        Object object3 = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE};
        object3 = Files.newOutputStream(spansFile, object3);
        object2 = null;
        try {
            void $this$encodeToStream$iv;
            OutputStream os = (OutputStream)object3;
            boolean bl = false;
            $this$mapTo$iv$iv = JaegerProtoKt.getJaegerJson();
            Intrinsics.checkNotNull((Object)os);
            OutputStream stream$iv = os;
            boolean $i$f$encodeToStream = false;
            $this$encodeToStream$iv.getSerializersModule();
            JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv, (SerializationStrategy)((SerializationStrategy)JTraceDati.Companion.serializer()), (Object)dataToFlush, (OutputStream)stream$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)object2);
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    private final JTraceDati emptyData() {
        Object object = this.resource.getAttribute(AttributeKey.stringKey((String)"service.name"));
        Intrinsics.checkNotNull((Object)object);
        return JaegerProtoKt.initEmptyData((String)object, (String)this.resource.getAttribute(AttributeKey.stringKey((String)"service.version")), (String)this.resource.getAttribute(AttributeKey.stringKey((String)"service.namespace")));
    }
}

