/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.files.model;

import ai.grazie.code.files.model.Language;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\u00020\u0001:\u0005\r\u000e\u000f\u0010\u0011B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\nJ\b\u0010\u000b\u001a\u00020\fH\u0016\u0082\u0001\u0003\u0012\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lai/grazie/code/files/model/LanguageSet;", "", "()V", "contains", "", "language", "Lai/grazie/code/files/model/Language;", "forEach", "", "action", "Lkotlin/Function1;", "toString", "", "Any", "Companion", "Completion", "None", "Some", "Lai/grazie/code/files/model/LanguageSet$Any;", "Lai/grazie/code/files/model/LanguageSet$None;", "Lai/grazie/code/files/model/LanguageSet$Some;", "code-files-model"})
@SourceDebugExtension(value={"SMAP\nLanguageProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageProvider.kt\nai/grazie/code/files/model/LanguageSet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1855#2,2:127\n*S KotlinDebug\n*F\n+ 1 LanguageProvider.kt\nai/grazie/code/files/model/LanguageSet\n*L\n77#1:127,2\n*E\n"})
public abstract class LanguageSet {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private LanguageSet() {
    }

    public final boolean contains(@NotNull Language language) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        LanguageSet languageSet = this;
        if (languageSet instanceof Any) {
            bl = true;
        } else if (languageSet instanceof None) {
            bl = false;
        } else if (languageSet instanceof Some) {
            bl = ((Some)this).getLanguages().contains((Object)language);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final void forEach(@NotNull Function1<? super Language, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        LanguageSet languageSet = this;
        if (languageSet instanceof Any) {
            throw new UnsupportedOperationException("Cannot iterate over Any LanguageSet");
        }
        if (!(languageSet instanceof None) && languageSet instanceof Some) {
            Iterable $this$forEach$iv = ((Some)this).getLanguages();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke(element$iv);
            }
        }
    }

    @NotNull
    public String toString() {
        String string;
        LanguageSet languageSet = this;
        if (languageSet instanceof Any) {
            string = "[any]";
        } else if (languageSet instanceof None) {
            string = "[none]";
        } else if (languageSet instanceof Some) {
            string = ((Some)this).getLanguages().size() == 1 ? ((Language)((Object)CollectionsKt.single((Iterable)((Some)this).getLanguages()))).toString() : ((Some)this).getLanguages().toString();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public /* synthetic */ LanguageSet(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lai/grazie/code/files/model/LanguageSet$Any;", "Lai/grazie/code/files/model/LanguageSet;", "()V", "code-files-model"})
    public static final class Any
    extends LanguageSet {
        @NotNull
        public static final Any INSTANCE = new Any();

        private Any() {
            super(null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\b\"\u00020\u0006\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lai/grazie/code/files/model/LanguageSet$Companion;", "", "()V", "of", "Lai/grazie/code/files/model/LanguageSet;", "language", "Lai/grazie/code/files/model/Language;", "languages", "", "(Lai/grazie/code/files/model/Language;[Lai/grazie/code/files/model/Language;)Lai/grazie/code/files/model/LanguageSet;", "code-files-model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LanguageSet of(@NotNull Language language, Language ... languages) {
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            Intrinsics.checkNotNullParameter((Object)languages, (String)"languages");
            return new Some(language, Arrays.copyOf(languages, languages.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/grazie/code/files/model/LanguageSet$Completion;", "", "()V", "Jet", "code-files-model"})
    public static final class Completion {
        @NotNull
        public static final Completion INSTANCE = new Completion();

        private Completion() {
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b1\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0011\u0010+\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0011\u0010-\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0011\u0010/\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0011\u00101\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0006R\u0011\u00103\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0006\u00a8\u00065"}, d2={"Lai/grazie/code/files/model/LanguageSet$Completion$Jet;", "", "()V", "CPP", "Lai/grazie/code/files/model/LanguageSet;", "getCPP", "()Lai/grazie/code/files/model/LanguageSet;", "CSS", "getCSS", "CSharp", "getCSharp", "Go", "getGo", "Groovy", "getGroovy", "HCL", "getHCL", "HTML", "getHTML", "JSON", "getJSON", "Java", "getJava", "JavaScript", "getJavaScript", "Jupyter", "getJupyter", "Kotlin", "getKotlin", "Markdown", "getMarkdown", "PHP", "getPHP", "Python", "getPython", "Ruby", "getRuby", "Rust", "getRust", "Scala", "getScala", "Shell", "getShell", "Swift", "getSwift", "TOML", "getTOML", "TypeScript", "getTypeScript", "XML", "getXML", "YAML", "getYAML", "code-files-model"})
        public static final class Jet {
            @NotNull
            public static final Jet INSTANCE = new Jet();
            @NotNull
            private static final LanguageSet CPP;
            @NotNull
            private static final LanguageSet CSS;
            @NotNull
            private static final LanguageSet CSharp;
            @NotNull
            private static final LanguageSet Go;
            @NotNull
            private static final LanguageSet Groovy;
            @NotNull
            private static final LanguageSet HCL;
            @NotNull
            private static final LanguageSet HTML;
            @NotNull
            private static final LanguageSet JSON;
            @NotNull
            private static final LanguageSet Java;
            @NotNull
            private static final LanguageSet JavaScript;
            @NotNull
            private static final LanguageSet Jupyter;
            @NotNull
            private static final LanguageSet Kotlin;
            @NotNull
            private static final LanguageSet Markdown;
            @NotNull
            private static final LanguageSet PHP;
            @NotNull
            private static final LanguageSet Python;
            @NotNull
            private static final LanguageSet Ruby;
            @NotNull
            private static final LanguageSet Rust;
            @NotNull
            private static final LanguageSet Scala;
            @NotNull
            private static final LanguageSet Shell;
            @NotNull
            private static final LanguageSet Swift;
            @NotNull
            private static final LanguageSet TOML;
            @NotNull
            private static final LanguageSet TypeScript;
            @NotNull
            private static final LanguageSet XML;
            @NotNull
            private static final LanguageSet YAML;

            private Jet() {
            }

            @NotNull
            public final LanguageSet getCPP() {
                return CPP;
            }

            @NotNull
            public final LanguageSet getCSS() {
                return CSS;
            }

            @NotNull
            public final LanguageSet getCSharp() {
                return CSharp;
            }

            @NotNull
            public final LanguageSet getGo() {
                return Go;
            }

            @NotNull
            public final LanguageSet getGroovy() {
                return Groovy;
            }

            @NotNull
            public final LanguageSet getHCL() {
                return HCL;
            }

            @NotNull
            public final LanguageSet getHTML() {
                return HTML;
            }

            @NotNull
            public final LanguageSet getJSON() {
                return JSON;
            }

            @NotNull
            public final LanguageSet getJava() {
                return Java;
            }

            @NotNull
            public final LanguageSet getJavaScript() {
                return JavaScript;
            }

            @NotNull
            public final LanguageSet getJupyter() {
                return Jupyter;
            }

            @NotNull
            public final LanguageSet getKotlin() {
                return Kotlin;
            }

            @NotNull
            public final LanguageSet getMarkdown() {
                return Markdown;
            }

            @NotNull
            public final LanguageSet getPHP() {
                return PHP;
            }

            @NotNull
            public final LanguageSet getPython() {
                return Python;
            }

            @NotNull
            public final LanguageSet getRuby() {
                return Ruby;
            }

            @NotNull
            public final LanguageSet getRust() {
                return Rust;
            }

            @NotNull
            public final LanguageSet getScala() {
                return Scala;
            }

            @NotNull
            public final LanguageSet getShell() {
                return Shell;
            }

            @NotNull
            public final LanguageSet getSwift() {
                return Swift;
            }

            @NotNull
            public final LanguageSet getTOML() {
                return TOML;
            }

            @NotNull
            public final LanguageSet getTypeScript() {
                return TypeScript;
            }

            @NotNull
            public final LanguageSet getXML() {
                return XML;
            }

            @NotNull
            public final LanguageSet getYAML() {
                return YAML;
            }

            static {
                Language[] languageArray = new Language[]{Language.CPP};
                CPP = Companion.of(Language.C, languageArray);
                languageArray = new Language[]{Language.HTML};
                CSS = Companion.of(Language.CSS, languageArray);
                CSharp = Companion.of(Language.CSharp, new Language[0]);
                Go = Companion.of(Language.Go, new Language[0]);
                Groovy = Companion.of(Language.Groovy, new Language[0]);
                HCL = Companion.of(Language.HCL, new Language[0]);
                languageArray = new Language[]{Language.HTML};
                HTML = Companion.of(Language.CSS, languageArray);
                JSON = Companion.of(Language.JSON, new Language[0]);
                Java = Companion.of(Language.Java, new Language[0]);
                languageArray = new Language[]{Language.TypeScript};
                JavaScript = Companion.of(Language.JavaScript, languageArray);
                Jupyter = Companion.of(Language.Jupyter, new Language[0]);
                languageArray = new Language[]{Language.KotlinScript};
                Kotlin = Companion.of(Language.Kotlin, languageArray);
                Markdown = Companion.of(Language.Markdown, new Language[0]);
                PHP = Companion.of(Language.PHP, new Language[0]);
                Python = Companion.of(Language.Python, new Language[0]);
                Ruby = Companion.of(Language.Ruby, new Language[0]);
                Rust = Companion.of(Language.Rust, new Language[0]);
                Scala = Companion.of(Language.Scala, new Language[0]);
                Shell = Companion.of(Language.Shell, new Language[0]);
                Swift = Companion.of(Language.Swift, new Language[0]);
                TOML = Companion.of(Language.TOML, new Language[0]);
                languageArray = new Language[]{Language.TypeScript};
                TypeScript = Companion.of(Language.JavaScript, languageArray);
                XML = Companion.of(Language.XML, new Language[0]);
                YAML = Companion.of(Language.YAML, new Language[0]);
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lai/grazie/code/files/model/LanguageSet$None;", "Lai/grazie/code/files/model/LanguageSet;", "()V", "code-files-model"})
    public static final class None
    extends LanguageSet {
        @NotNull
        public static final None INSTANCE = new None();

        private None() {
            super(null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u0015\b\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/code/files/model/LanguageSet$Some;", "Lai/grazie/code/files/model/LanguageSet;", "language", "Lai/grazie/code/files/model/Language;", "languages", "", "(Lai/grazie/code/files/model/Language;[Lai/grazie/code/files/model/Language;)V", "", "(Ljava/util/Set;)V", "getLanguages", "()Ljava/util/Set;", "code-files-model"})
    public static final class Some
    extends LanguageSet {
        @NotNull
        private final Set<Language> languages;

        private Some(Set<? extends Language> languages) {
            super(null);
            this.languages = languages;
            if (!(!((Collection)this.languages).isEmpty())) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        }

        @NotNull
        public final Set<Language> getLanguages() {
            return this.languages;
        }

        public Some(@NotNull Language language, Language ... languages) {
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            Intrinsics.checkNotNullParameter((Object)languages, (String)"languages");
            this(SetsKt.plus((Set)ArraysKt.toSet((Object[])languages), (Object)((Object)language)));
        }
    }
}

