/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.tokenizer.sentence;

import ai.grazie.Direction;
import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.patterns.AggregatedPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.RegexPattern;
import ai.grazie.nlp.patterns.standard.LikelyPatterns;
import ai.grazie.nlp.patterns.standard.StrictPatterns;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.rule.PatternSplitTokenizer;
import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import ai.grazie.nlp.utils.normalization.UnicodePunctuationNormalizer;
import ai.grazie.text.ExtensionsKt;
import ai.grazie.text.Text;
import ai.grazie.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000K\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000e\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0013\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0013\u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "Lai/grazie/nlp/tokenizer/Tokenizer;", "splitByNewLinesNumber", "", "(Ljava/lang/Integer;)V", "language", "Lai/grazie/nlp/langs/Language;", "(Ljava/lang/Integer;Lai/grazie/nlp/langs/Language;)V", "ignore", "Lai/grazie/nlp/patterns/AggregatedPattern;", "newLineTokenizer", "Lai/grazie/nlp/tokenizer/rule/PatternSplitTokenizer;", "punctuationTokenizer", "newLinesPattern", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$newLinesPattern$1", "(I)Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$newLinesPattern$1;", "tokenRanges", "", "Lai/grazie/text/TextRange;", "text", "", "tokenize", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "Lai/grazie/text/Text;", "Companion", "nlp-tokenizer"})
@SourceDebugExtension(value={"SMAP\nStandardSentenceTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardSentenceTokenizer.kt\nai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1549#2:175\n1620#2,3:176\n1360#2:179\n1446#2,2:180\n1549#2:182\n1620#2,3:183\n1448#2,3:186\n*S KotlinDebug\n*F\n+ 1 StandardSentenceTokenizer.kt\nai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer\n*L\n162#1:175\n162#1:176,3\n168#1:179\n168#1:180,2\n169#1:182\n169#1:183,3\n168#1:186,3\n*E\n"})
public final class StandardSentenceTokenizer
implements Tokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PatternSplitTokenizer newLineTokenizer;
    @NotNull
    private final AggregatedPattern ignore;
    @NotNull
    private final PatternSplitTokenizer punctuationTokenizer;
    @NotNull
    private static final String quotes = "'\"`\u2018\u2019" + CollectionsKt.joinToString$default((Iterable)UnicodePunctuationNormalizer.Companion.getDoubleQuotes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    @NotNull
    private static final Companion.Parenthetical.1 Parenthetical;
    @NotNull
    private static final Companion.Ellipsis.1 Ellipsis;
    @NotNull
    private static final Companion.ShortQuotationWithEllipsis.1 ShortQuotationWithEllipsis;
    @NotNull
    private static final Companion.QuotedIdWithTrailingDot.1 QuotedIdWithTrailingDot;
    @NotNull
    private static final Companion.SymbolsInQuotes.1 SymbolsInQuotes;
    @NotNull
    private static final String normalSentenceEnd;
    @NotNull
    private static final String romanBullet;
    @NotNull
    private static final String braceBulletContents = "[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*";
    @NotNull
    private static final String braceBullet = "(^|\n)(\\([\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\)|\\[[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\])";
    @NotNull
    private static final String spaceOrEnd = "\n+|\\s+|$";
    @NotNull
    private static final Regex sentenceContinuation;
    @NotNull
    private static final Companion.endPunctuation.1 endPunctuation;
    @NotNull
    private static final StandardSentenceTokenizer Default;

    public StandardSentenceTokenizer(@Nullable Integer splitByNewLinesNumber, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.newLineTokenizer = splitByNewLinesNumber == null ? null : new PatternSplitTokenizer((Pattern)this.newLinesPattern(splitByNewLinesNumber), Direction.Right, null);
        Object[] objectArray = new Pattern[]{Parenthetical, Ellipsis, ShortQuotationWithEllipsis, SymbolsInQuotes, QuotedIdWithTrailingDot, LikelyPatterns.NameInitials, LikelyPatterns.ActionNameEllipsis, LikelyPatterns.PunctuationOperator, LikelyPatterns.IsEmail, LikelyPatterns.IsAbbreviation, language == Language.UNKNOWN || language == Language.GERMAN ? LikelyPatterns.IsGermanNumeral : null, LikelyPatterns.IsIPv4, LikelyPatterns.IsURL, LikelyPatterns.IsFilePath, StrictPatterns.INSTANCE.getIsUUID()};
        this.ignore = new AggregatedPattern(CollectionsKt.listOfNotNull((Object[])objectArray));
        this.punctuationTokenizer = new PatternSplitTokenizer(endPunctuation, Direction.Right, (Pattern)this.ignore);
    }

    public /* synthetic */ StandardSentenceTokenizer(Integer n, Language language, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n, language);
    }

    @Deprecated(message="Specify the language")
    public StandardSentenceTokenizer(@Nullable Integer splitByNewLinesNumber) {
        this(splitByNewLinesNumber, Language.UNKNOWN);
    }

    public /* synthetic */ StandardSentenceTokenizer(Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    private final newLinesPattern.1 newLinesPattern(int splitByNewLinesNumber) {
        Regex regex = new Regex("\n{" + splitByNewLinesNumber + ",}");
        return new RegexPattern(regex){

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Tokenizer.Token> tokenize(@NotNull Text text) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Iterable $this$map$iv = this.tokenRanges((CharSequence)text);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Tokenizer.Token(text.substring((TextRange)it), (TextRange)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> tokenRanges(@NotNull CharSequence text) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = this.newLineTokenizer;
        if (object == null || (object = ((PatternSplitTokenizer)object).tokenRanges(text)) == null) {
            object = CollectionsKt.listOf((Object)new TextRange(0, text.length()));
        }
        Object hard = object;
        Iterable $this$flatMap$iv = (Iterable)hard;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            TextRange chunk = (TextRange)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.punctuationTokenizer.tokenRanges(text.subSequence(chunk.getStart(), chunk.getEndExclusive()));
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TextRange textRange = (TextRange)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(ExtensionsKt.withOffset((TextRange)it, (int)chunk.getStart()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final StandardSentenceTokenizer defaultFor(@NotNull Language language) {
        return Companion.defaultFor(language);
    }

    public static final /* synthetic */ String access$getNormalSentenceEnd$cp() {
        return normalSentenceEnd;
    }

    public static final /* synthetic */ String access$getRomanBullet$cp() {
        return romanBullet;
    }

    public static final /* synthetic */ Regex access$getSentenceContinuation$cp() {
        return sentenceContinuation;
    }

    static {
        Regex regex = new Regex[]{StandardSentenceTokenizer.Companion.pairedParentheses(), StandardSentenceTokenizer.Companion.pairedDashes()};
        Regex regex2 = regex;
        Parenthetical = new AggregatedPattern((Pattern[])regex2){

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
        regex2 = new Regex("(^|[" + quotes + "]|\\s)(\\.{3,}|\u2026)($|[" + quotes + "]|\\s)|\\[(\\.{3,}|\u2026)\\]|\\.[ \u00a0]\\.[ \u00a0]\\.");
        Ellipsis = new RegexPattern(regex2){

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
        regex2 = new Regex("[" + quotes + "][\\p{L}\\s\\d]{1,42}(\\.{3,}|\u2026)[" + quotes + "]\\s+\\p{Ll}");
        ShortQuotationWithEllipsis = new RegexPattern(regex2){

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
        regex2 = new Regex("[" + quotes + "]\\p{L}+\\.[" + quotes + "]([,;:]|\\s+\\p{Ll})");
        QuotedIdWithTrailingDot = new RegexPattern(regex2){

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
        regex2 = new Regex("[" + quotes + "][^\\s\\p{L}]*[" + quotes + "]");
        SymbolsInQuotes = new RegexPattern(regex2){

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
        normalSentenceEnd = "[?!.]+[)}\\]" + quotes + "]?";
        String string2 = "IVXLMCD".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        romanBullet = "(^|\n)([IVXLMCD]{1,4}|[" + string2 + "]{1,4})\\)";
        Companion $this$sentenceContinuation_u24lambda_u243 = Companion;
        boolean bl = false;
        String dashes = "(\\s+[-\u2013\u2014]+)";
        String emotionalPunctuation = "([?!]\\.*|([:;]-?[()]+))";
        String directSpeechEnd = "(\\?[" + quotes + "]|!(\\.+[" + quotes + "]?|\\.*[" + quotes + "])|\\.{3,}[" + quotes + "?]*)";
        sentenceContinuation = new Regex("(" + directSpeechEnd + dashes + "?|" + emotionalPunctuation + dashes + ")\\s+([\\[({<])?\\p{Ll}");
        endPunctuation = new Pattern(){
            @NotNull
            private final char[] startChars;
            @NotNull
            private final Regex regex;
            {
                char[] cArray = "?!.:;\n".toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                this.startChars = cArray;
                this.regex = new Regex("(" + StandardSentenceTokenizer.access$getNormalSentenceEnd$cp() + "|" + StandardSentenceTokenizer.access$getRomanBullet$cp() + "|(^|\n)(\\([\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\)|\\[[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\]))(\n+|\\s+|$)|([:;]-?[()]+)(\n+|\\s+|$|" + StandardSentenceTokenizer.access$getNormalSentenceEnd$cp() + ")+");
            }

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                int offset = 0;
                ArrayList<TextRange> result = new ArrayList<TextRange>();
                while (offset >= 0) {
                    MatchResult mr = this.regex.matchAt(text, offset);
                    if (mr != null) {
                        if (!StandardSentenceTokenizer.access$getSentenceContinuation$cp().matchesAt(text, offset)) {
                            result.add(TextRange.Companion.invoke(mr.getRange()));
                        }
                        offset = mr.getRange().getLast() + 1;
                    }
                    offset = StringsKt.indexOfAny$default((CharSequence)text, (char[])this.startChars, (int)(offset + 1), (boolean)false, (int)4, null);
                }
                return result;
            }
        };
        Default = new StandardSentenceTokenizer(2, Language.UNKNOWN);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0006\t\f\u000f\u0012\u0015\u001b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%H\u0007J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020)H\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion;", "", "()V", "Default", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "getDefault$annotations", "getDefault", "()Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "Ellipsis", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Ellipsis$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Ellipsis$1;", "Parenthetical", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Parenthetical$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Parenthetical$1;", "QuotedIdWithTrailingDot", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$QuotedIdWithTrailingDot$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$QuotedIdWithTrailingDot$1;", "ShortQuotationWithEllipsis", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$ShortQuotationWithEllipsis$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$ShortQuotationWithEllipsis$1;", "SymbolsInQuotes", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$SymbolsInQuotes$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$SymbolsInQuotes$1;", "braceBullet", "", "braceBulletContents", "endPunctuation", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$endPunctuation$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$endPunctuation$1;", "normalSentenceEnd", "quotes", "romanBullet", "sentenceContinuation", "Lkotlin/text/Regex;", "spaceOrEnd", "defaultFor", "language", "Lai/grazie/nlp/langs/Language;", "pairedDashes", "Lai/grazie/nlp/patterns/Pattern;", "pairedParentheses", "Lai/grazie/nlp/patterns/RegexPattern;", "nlp-tokenizer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final StandardSentenceTokenizer defaultFor(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return new StandardSentenceTokenizer(2, language);
        }

        private final RegexPattern pairedParentheses() {
            String noParentheses = "[^()]";
            String nestedParentheses = "\\(" + noParentheses + "{1,500}\\)" + noParentheses + "{0,500}";
            return new RegexPattern(new Regex("\\(" + noParentheses + "{1,500}(" + nestedParentheses + ")*\\)"));
        }

        private final Pattern pairedDashes() {
            Regex dashRegex = new Regex("\\s+[-\u2013\u2014]+\\s+([^-\u2013\u2014]{1,100})\\s+[-\u2013\u2014]+\\s+");
            Regex smileyRegex = new Regex("[:;]-?[()]+");
            return (Pattern)new RegexPattern(dashRegex, smileyRegex){
                final /* synthetic */ Regex $dashRegex;
                final /* synthetic */ Regex $smileyRegex;
                {
                    this.$dashRegex = $dashRegex;
                    this.$smileyRegex = $smileyRegex;
                    super($dashRegex);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public List<TextRange> find(@NotNull CharSequence text) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    Iterable iterable = super.find(text);
                    Regex regex = this.$dashRegex;
                    Regex regex2 = this.$smileyRegex;
                    boolean $i$f$filter = false;
                    void var6_6 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        TextRange it = (TextRange)element$iv$iv;
                        boolean bl = false;
                        CharSequence withDashes = text.subSequence(it.getStart(), it.getEndExclusive());
                        MatchResult matchResult = regex.matchEntire(withDashes);
                        Intrinsics.checkNotNull((Object)matchResult);
                        String withoutDashes = (String)matchResult.getGroupValues().get(1);
                        if (!(Regex.find$default((Regex)regex2, (CharSequence)withoutDashes, (int)0, (int)2, null) == null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
            };
        }

        @NotNull
        public final StandardSentenceTokenizer getDefault() {
            return Default;
        }

        @Deprecated(message="Use defaultFor with a language")
        public static /* synthetic */ void getDefault$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

