/*
 * Decompiled with CFR 0.152.
 */
package noria.ui.platform;

import androidx.compose.ui.platform.ClipboardManager;
import androidx.compose.ui.text.AnnotatedString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.windowManagement.api.Clipboard;
import noria.windowManagement.api.WindowManager;
import noria.windowManagement.extensions.ClipboardKt;
import noria.windowManagement.extensions.WindowManagerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lnoria/ui/platform/ClipboardManagerImpl;", "Landroidx/compose/ui/platform/ClipboardManager;", "windowManager", "Lnoria/windowManagement/api/WindowManager;", "(Lnoria/windowManagement/api/WindowManager;)V", "getWindowManager", "()Lnoria/windowManagement/api/WindowManager;", "getText", "Landroidx/compose/ui/text/AnnotatedString;", "hasText", "", "setText", "", "annotatedString", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nClipboardManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClipboardManagerImpl.kt\nnoria/ui/platform/ClipboardManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,23:1\n1#2:24\n*E\n"})
public final class ClipboardManagerImpl
implements ClipboardManager {
    @NotNull
    private final WindowManager windowManager;

    public ClipboardManagerImpl(@NotNull WindowManager windowManager) {
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        this.windowManager = windowManager;
    }

    @NotNull
    public final WindowManager getWindowManager() {
        return this.windowManager;
    }

    @Override
    public void setText(@NotNull AnnotatedString annotatedString) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"annotatedString");
        ClipboardKt.setText((Clipboard)WindowManagerKt.getClipboard((WindowManager)this.windowManager), (String)annotatedString.toString());
    }

    @Override
    @Nullable
    public AnnotatedString getText() {
        AnnotatedString annotatedString;
        String string = ClipboardKt.getText((Clipboard)WindowManagerKt.getClipboard((WindowManager)this.windowManager));
        if (string != null) {
            String it = string;
            boolean bl = false;
            annotatedString = new AnnotatedString(it, null, null, 6, null);
        } else {
            annotatedString = null;
        }
        return annotatedString;
    }

    @Override
    public boolean hasText() {
        CharSequence charSequence = ClipboardKt.getText((Clipboard)WindowManagerKt.getClipboard((WindowManager)this.windowManager));
        return !(charSequence == null || charSequence.length() == 0);
    }
}

