/*
 * Decompiled with CFR 0.152.
 */
package noria.ui.components.editor;

import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.text.FontRasterizationSettings;
import androidx.compose.ui.unit.Density;
import fleet.compose.theme.text.FontFeatureTag;
import fleet.compose.theme.text.NoriaParagraphStyle;
import fleet.compose.theme.text.ParagraphKt;
import fleet.compose.theme.text.TextComponentsKt;
import fleet.compose.theme.text.TextSpec;
import fleet.compose.theme.text.TextSpecKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import noria.ui.components.editor.PositionWithinViewport;
import noria.ui.components.editor.TextSpanContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.paragraph.FontCollection;
import org.jetbrains.skia.paragraph.Paragraph;
import org.jetbrains.skia.paragraph.ParagraphBuilder;
import org.jetbrains.skia.paragraph.RectHeightMode;
import org.jetbrains.skia.paragraph.RectWidthMode;
import org.jetbrains.skia.paragraph.TextBox;
import org.jetbrains.skia.paragraph.TextStyle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\u001c\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u001b\u001a\u00020\bH\u0016J-\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020\u0006H\u00d6\u0001J\u0014\u0010!\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lnoria/ui/components/editor/TextSpanLineContent;", "Lnoria/ui/components/editor/TextSpanContent;", "line", "Lorg/jetbrains/skia/paragraph/Paragraph;", "charOffsets", "", "", "rtl", "", "(Lorg/jetbrains/skia/paragraph/Paragraph;Ljava/util/List;Z)V", "getCharOffsets", "()Ljava/util/List;", "getLine", "()Lorg/jetbrains/skia/paragraph/Paragraph;", "getRtl", "()Z", "width", "", "Lnoria/ui/components/editor/FractionalPx;", "getWidth", "()F", "component1", "component2", "component3", "coordToOffset", "Lnoria/ui/components/editor/PositionWithinViewport;", "coord", "snapToLeft", "copy", "equals", "other", "", "hashCode", "offsetToCoord", "offset", "", "toString", "", "Companion", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nSpans.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Spans.kt\nnoria/ui/components/editor/TextSpanLineContent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,621:1\n1#2:622\n*E\n"})
public final class TextSpanLineContent
extends TextSpanContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Paragraph line;
    @NotNull
    private final List<Integer> charOffsets;
    private final boolean rtl;

    public TextSpanLineContent(@NotNull Paragraph line, @NotNull List<Integer> charOffsets, boolean rtl) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter(charOffsets, (String)"charOffsets");
        super(null);
        this.line = line;
        this.charOffsets = charOffsets;
        this.rtl = rtl;
    }

    @NotNull
    public final Paragraph getLine() {
        return this.line;
    }

    @NotNull
    public final List<Integer> getCharOffsets() {
        return this.charOffsets;
    }

    @Override
    public boolean getRtl() {
        return this.rtl;
    }

    @Override
    @NotNull
    public PositionWithinViewport coordToOffset(float coord, boolean snapToLeft) {
        int it = this.line.getGlyphPositionAtCoordinate(coord, 0.0f).getPosition();
        boolean bl = false;
        long offset = RangesKt.coerceAtLeast((int)(snapToLeft && coord < this.offsetToCoord(it) ? it - 1 : it), (int)0);
        boolean coversText = coord >= 0.0f && coord < this.line.getMaxIntrinsicWidth();
        return new PositionWithinViewport(offset, coversText);
    }

    @Override
    public float offsetToCoord(long offset) {
        if (offset >= (long)((Number)CollectionsKt.last(this.charOffsets)).intValue()) {
            return this.getRtl() ? 0.0f : this.line.getMaxIntrinsicWidth();
        }
        int it = CollectionsKt.binarySearch$default(this.charOffsets, (Comparable)Integer.valueOf((int)offset), (int)0, (int)0, (int)6, null);
        boolean bl = false;
        int pos = it < 0 ? -it - 2 : it;
        TextBox[] rects = this.line.getRectsForRange(((Number)this.charOffsets.get(pos)).intValue(), ((Number)this.charOffsets.get(pos + 1)).intValue(), RectHeightMode.MAX, RectWidthMode.TIGHT);
        while (rects.length == 0) {
            int n = pos = this.getRtl() ? pos - 1 : pos + 1;
            if (pos <= 0) {
                return 0.0f;
            }
            if (pos >= this.charOffsets.size() - 1) {
                return this.line.getMaxIntrinsicWidth();
            }
            rects = this.line.getRectsForRange(((Number)this.charOffsets.get(pos)).intValue(), ((Number)this.charOffsets.get(pos + 1)).intValue(), RectHeightMode.MAX, RectWidthMode.TIGHT);
        }
        if (!(!(rects.length == 0))) {
            boolean bl2 = false;
            String string = "empty rects for " + offset;
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.getRtl()) {
            return rects[0].getRect().getLeft();
        }
        return rects[0].getRect().getRight();
    }

    @Override
    public float getWidth() {
        return this.line.getMaxIntrinsicWidth();
    }

    @NotNull
    public final Paragraph component1() {
        return this.line;
    }

    @NotNull
    public final List<Integer> component2() {
        return this.charOffsets;
    }

    public final boolean component3() {
        return this.rtl;
    }

    @NotNull
    public final TextSpanLineContent copy(@NotNull Paragraph line, @NotNull List<Integer> charOffsets, boolean rtl) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter(charOffsets, (String)"charOffsets");
        return new TextSpanLineContent(line, charOffsets, rtl);
    }

    public static /* synthetic */ TextSpanLineContent copy$default(TextSpanLineContent textSpanLineContent, Paragraph paragraph2, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            paragraph2 = textSpanLineContent.line;
        }
        if ((n & 2) != 0) {
            list = textSpanLineContent.charOffsets;
        }
        if ((n & 4) != 0) {
            bl = textSpanLineContent.rtl;
        }
        return textSpanLineContent.copy(paragraph2, list, bl);
    }

    @NotNull
    public String toString() {
        return "TextSpanLineContent(line=" + this.line + ", charOffsets=" + this.charOffsets + ", rtl=" + this.rtl + ")";
    }

    public int hashCode() {
        int result2 = this.line.hashCode();
        result2 = result2 * 31 + ((Object)this.charOffsets).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.rtl);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextSpanLineContent)) {
            return false;
        }
        TextSpanLineContent textSpanLineContent = (TextSpanLineContent)other;
        if (!Intrinsics.areEqual((Object)this.line, (Object)textSpanLineContent.line)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.charOffsets, textSpanLineContent.charOffsets)) {
            return false;
        }
        return this.rtl == textSpanLineContent.rtl;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0015"}, d2={"Lnoria/ui/components/editor/TextSpanLineContent$Companion;", "", "()V", "create", "Lnoria/ui/components/editor/TextSpanContent;", "text", "", "rtl", "", "textSpec", "Lfleet/compose/theme/text/TextSpec;", "foreground", "Landroidx/compose/ui/graphics/Color;", "pixelDensity", "Landroidx/compose/ui/unit/Density;", "fontCollection", "Lorg/jetbrains/skia/paragraph/FontCollection;", "fontRasterSettings", "Landroidx/compose/ui/text/FontRasterizationSettings;", "create-ww6aTOc", "(Ljava/lang/String;ZLfleet/compose/theme/text/TextSpec;JLandroidx/compose/ui/unit/Density;Lorg/jetbrains/skia/paragraph/FontCollection;Landroidx/compose/ui/text/FontRasterizationSettings;)Lnoria/ui/components/editor/TextSpanContent;", "fleet.noria.ui"})
    @SourceDebugExtension(value={"SMAP\nSpans.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Spans.kt\nnoria/ui/components/editor/TextSpanLineContent$Companion\n+ 2 Helpers.kt\nfleet/util/HelpersKt\n*L\n1#1,621:1\n9#2,4:622\n*S KotlinDebug\n*F\n+ 1 Spans.kt\nnoria/ui/components/editor/TextSpanLineContent$Companion\n*L\n272#1:622,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final TextSpanContent create-ww6aTOc(@NotNull String text, boolean rtl, @NotNull TextSpec textSpec, long foreground, @NotNull Density pixelDensity, @NotNull FontCollection fontCollection, @NotNull FontRasterizationSettings fontRasterSettings) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)textSpec, (String)"textSpec");
            Intrinsics.checkNotNullParameter((Object)pixelDensity, (String)"pixelDensity");
            Intrinsics.checkNotNullParameter((Object)fontCollection, (String)"fontCollection");
            Intrinsics.checkNotNullParameter((Object)fontRasterSettings, (String)"fontRasterSettings");
            var10_8 = textSpec;
            if (!rtl) ** GOTO lbl-1000
            v0 = textSpec.getFontFeatures().get(FontFeatureTag.box-impl(FontFeatureTag.Companion.getCalt-yd_S18Q()));
            if (v0 == null || v0 != 0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            condition$iv = v1;
            $i$f$letIf = false;
            if (condition$iv) {
                it = $this$letIf$iv;
                $i$a$-letIf-TextSpanLineContent$Companion$create$style$1 = false;
                v2 = TextSpec.copy-76MNOIk$default(textSpec, null, null, 0L, 0L, 0.0f, MapsKt.plus(textSpec.getFontFeatures(), (Pair)TuplesKt.to((Object)FontFeatureTag.box-impl(FontFeatureTag.Companion.getCalt-yd_S18Q()), (Object)0)), 0, 95, null);
            } else {
                v2 = $this$letIf$iv;
            }
            style = TextSpecKt.toSkTextStyle-cLQcjuY$default(v2, pixelDensity, Color.box-impl(foreground), null, null, fontCollection, 12, null);
            paragraph = ParagraphKt.buildParagraph$default(NoriaParagraphStyle.Companion.getOneLine(), null, fontCollection, fontRasterSettings, (Function1)new Function1<ParagraphBuilder, Unit>(text, style){
                final /* synthetic */ String $text;
                final /* synthetic */ TextStyle $style;
                {
                    this.$text = $text;
                    this.$style = $style;
                    super(1);
                }

                public final void invoke(@NotNull ParagraphBuilder $this$buildParagraph) {
                    Intrinsics.checkNotNullParameter((Object)$this$buildParagraph, (String)"$this$buildParagraph");
                    ParagraphKt.styledText($this$buildParagraph, this.$text, this.$style);
                }
            }, 2, null);
            paragraph.layout(Infinityf);
            charOffsets = new ArrayList<E>();
            iter = TextComponentsKt.getCharacterIterators().get();
            iter.setText(text);
            charOffsets.add(iter.current());
            while (iter.next() != -1) {
                charOffsets.add(iter.current());
            }
            return new TextSpanLineContent(paragraph, charOffsets, rtl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

