/*
 * Decompiled with CFR 0.152.
 */
package noria.ui.components;

import fleet.compose.theme.util.RoundingKt;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import noria.ui.components.ItemVerticalPosition;
import noria.ui.components.Row;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001c\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\r\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\nH\u0086\u0002\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0005H\u0086\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019\u00b2\u0006\n\u0010\u001a\u001a\u00020\u0005X\u008a\u0084\u0002\u00b2\u0006\n\u0010\u001a\u001a\u00020\u0005X\u008a\u0084\u0002"}, d2={"Lnoria/ui/components/HeightCacheAvg;", "", "()V", "heightKeyHeightMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "average", "rows", "", "Lnoria/ui/components/Row;", "estimateRowIndexAt", "y", "estimateTotalHeight", "estimateVerticalItemPosition", "Lnoria/ui/components/ItemVerticalPosition;", "index", "get", "row", "(Lnoria/ui/components/Row;)Ljava/lang/Integer;", "isEmpty", "", "set", "", "height", "fleet.noria.ui", "averageHeight"})
final class HeightCacheAvg {
    @NotNull
    private final HashMap<Object, Integer> heightKeyHeightMap = new HashMap();

    public final void set(@NotNull Row row, int height2) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Integer n = height2;
        ((Map)this.heightKeyHeightMap).put(row.getHeightKey(), n);
    }

    @Nullable
    public final Integer get(@NotNull Row row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return this.heightKeyHeightMap.get(row.getHeightKey());
    }

    public final boolean isEmpty() {
        return this.heightKeyHeightMap.isEmpty();
    }

    public final int average(@NotNull List<Row> rows2) {
        Intrinsics.checkNotNullParameter(rows2, (String)"rows");
        if (rows2.isEmpty() || this.isEmpty()) {
            return 0;
        }
        int totalHeight = 0;
        int knownCount = 0;
        for (Row row : rows2) {
            Integer knownHeight = this.heightKeyHeightMap.get(row.getHeightKey());
            if (knownHeight == null) continue;
            totalHeight += knownHeight.intValue();
            ++knownCount;
        }
        return totalHeight != 0 ? RoundingKt.round$default((double)totalHeight / (double)knownCount, null, 1, null) : 0;
    }

    public final int estimateTotalHeight(@NotNull List<Row> rows2) {
        Intrinsics.checkNotNullParameter(rows2, (String)"rows");
        if (rows2.isEmpty() || this.isEmpty()) {
            return 0;
        }
        int averageHeight2 = this.average(rows2);
        int totalHeight = 0;
        for (Row row : rows2) {
            Integer n = this.heightKeyHeightMap.get(row.getHeightKey());
            if (n == null) {
                n = averageHeight2;
            }
            totalHeight += ((Number)n).intValue();
        }
        return totalHeight;
    }

    @NotNull
    public final ItemVerticalPosition estimateVerticalItemPosition(int index2, @NotNull List<Row> rows2) {
        Intrinsics.checkNotNullParameter(rows2, (String)"rows");
        Lazy averageHeight$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this, rows2){
            final /* synthetic */ HeightCacheAvg this$0;
            final /* synthetic */ List<Row> $rows;
            {
                this.this$0 = $receiver;
                this.$rows = $rows;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.average(this.$rows);
            }
        }));
        int y = 0;
        for (Row row : CollectionsKt.take((Iterable)rows2, (int)index2)) {
            Integer knownHeight = this.heightKeyHeightMap.get(row.getHeightKey());
            if (knownHeight != null) {
                y += knownHeight.intValue();
                continue;
            }
            y += HeightCacheAvg.estimateVerticalItemPosition$lambda$0((Lazy<Integer>)averageHeight$delegate);
        }
        Row row = rows2.get(index2);
        Integer n = this.heightKeyHeightMap.get(row.getHeightKey());
        if (n == null) {
            n = HeightCacheAvg.estimateVerticalItemPosition$lambda$0((Lazy<Integer>)averageHeight$delegate);
        }
        return new ItemVerticalPosition(y, ((Number)n).intValue());
    }

    public final int estimateRowIndexAt(int y, @NotNull List<Row> rows2) {
        Intrinsics.checkNotNullParameter(rows2, (String)"rows");
        Lazy averageHeight$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this, rows2){
            final /* synthetic */ HeightCacheAvg this$0;
            final /* synthetic */ List<Row> $rows;
            {
                this.this$0 = $receiver;
                this.$rows = $rows;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.average(this.$rows);
            }
        }));
        int coveredY = 0;
        Iterator<Row> iterator2 = rows2.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int height2;
            int index2 = n++;
            Row row = iterator2.next();
            Integer n2 = this.heightKeyHeightMap.get(row.getHeightKey());
            if (n2 == null) {
                n2 = HeightCacheAvg.estimateRowIndexAt$lambda$1((Lazy<Integer>)averageHeight$delegate);
            }
            if ((coveredY += (height2 = ((Number)n2).intValue())) <= y) continue;
            return index2;
        }
        return CollectionsKt.getLastIndex(rows2);
    }

    private static final int estimateVerticalItemPosition$lambda$0(Lazy<Integer> $averageHeight$delegate) {
        Lazy<Integer> lazy = $averageHeight$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private static final int estimateRowIndexAt$lambda$1(Lazy<Integer> $averageHeight$delegate) {
        Lazy<Integer> lazy = $averageHeight$delegate;
        return ((Number)lazy.getValue()).intValue();
    }
}

