/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.ParagraphBuilder;
import androidx.compose.ui.text.platform.ParagraphLayouter_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Density;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.Paragraph;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u0012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\u001aH\u0000\u00a2\u0006\u0004\b&\u0010'J\u000e\u0010(\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,\u00f8\u0001\u0000\u00a2\u0006\u0004\b-\u0010.J\u0010\u0010/\u001a\u00020*2\b\u00100\u001a\u0004\u0018\u000101J\u0016\u00102\u001a\u00020*2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0003J@\u00106\u001a\u00020*2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020!2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010>\u001a\u0004\u0018\u00010?H\u0007\u00f8\u0001\u0000\u00a2\u0006\u0004\b@\u0010AJ,\u00106\u001a\u00020*2\u0006\u0010B\u001a\u00020C2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010>\u001a\u0004\u0018\u00010?\u00f8\u0001\u0000\u00a2\u0006\u0004\bD\u0010ER\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006F"}, d2={"Landroidx/compose/ui/text/platform/ParagraphLayouter;", "", "text", "", "textDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "style", "Landroidx/compose/ui/text/TextStyle;", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "placeholders", "Landroidx/compose/ui/text/Placeholder;", "density", "Landroidx/compose/ui/unit/Density;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "(Ljava/lang/String;Landroidx/compose/ui/text/style/ResolvedTextDirection;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;Ljava/util/List;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/FontFamily$Resolver;)V", "builder", "Landroidx/compose/ui/text/platform/ParagraphBuilder;", "defaultFont", "Lorg/jetbrains/skia/Font;", "getDefaultFont", "()Lorg/jetbrains/skia/Font;", "paragraphCache", "Lorg/jetbrains/skia/paragraph/Paragraph;", "getText", "()Ljava/lang/String;", "textStyle", "getTextStyle", "()Landroidx/compose/ui/text/TextStyle;", "width", "", "emptyLineMetrics", "", "Lorg/jetbrains/skia/paragraph/LineMetrics;", "paragraph", "emptyLineMetrics$fleet_noria_ui", "(Lorg/jetbrains/skia/paragraph/Paragraph;)[Lorg/jetbrains/skia/paragraph/LineMetrics;", "layoutParagraph", "setBlendMode", "", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "setBlendMode-s9anfk8", "(I)V", "setDrawStyle", "drawStyle", "Landroidx/compose/ui/graphics/drawscope/DrawStyle;", "setParagraphStyle", "maxLines", "", "ellipsis", "setTextStyle", "brush", "Landroidx/compose/ui/graphics/Brush;", "brushSize", "Landroidx/compose/ui/geometry/Size;", "alpha", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "setTextStyle-eZhPAX0", "(Landroidx/compose/ui/graphics/Brush;JFLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "color", "Landroidx/compose/ui/graphics/Color;", "setTextStyle-ek8zF_U", "(JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nParagraphLayouter.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphLayouter.skiko.kt\nandroidx/compose/ui/text/platform/ParagraphLayouter\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n*L\n1#1,177:1\n658#2:178\n646#2:179\n159#3:180\n*S KotlinDebug\n*F\n+ 1 ParagraphLayouter.skiko.kt\nandroidx/compose/ui/text/platform/ParagraphLayouter\n*L\n102#1:178\n102#1:179\n126#1:180\n*E\n"})
public final class ParagraphLayouter {
    @NotNull
    private final String text;
    @NotNull
    private final ParagraphBuilder builder;
    @Nullable
    private Paragraph paragraphCache;
    private float width;

    public ParagraphLayouter(@NotNull String text2, @NotNull ResolvedTextDirection textDirection, @NotNull TextStyle style, @NotNull List<AnnotatedString.Range<SpanStyle>> spanStyles, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, @NotNull Density density, @NotNull FontFamily.Resolver fontFamilyResolver2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)textDirection), (String)"textDirection");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver2, (String)"fontFamilyResolver");
        this.text = text2;
        this.builder = new ParagraphBuilder(fontFamilyResolver2, this.text, style, 0L, null, 0, spanStyles, placeholders, density, textDirection, null, 0, 3128, null);
        this.width = Float.NaN;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final Font getDefaultFont() {
        return this.builder.getDefaultFont$fleet_noria_ui();
    }

    @NotNull
    public final TextStyle getTextStyle() {
        return this.builder.getTextStyle();
    }

    @NotNull
    public final LineMetrics[] emptyLineMetrics$fleet_noria_ui(@NotNull Paragraph paragraph2) {
        Intrinsics.checkNotNullParameter((Object)paragraph2, (String)"paragraph");
        return this.builder.emptyLineMetrics$fleet_noria_ui(paragraph2);
    }

    public final void setParagraphStyle(int maxLines, @NotNull String ellipsis) {
        Intrinsics.checkNotNullParameter((Object)ellipsis, (String)"ellipsis");
        if (this.builder.getMaxLines() != maxLines || !Intrinsics.areEqual((Object)this.builder.getEllipsis(), (Object)ellipsis)) {
            this.builder.setMaxLines(maxLines);
            this.builder.setEllipsis(ellipsis);
            this.paragraphCache = null;
        }
    }

    public final void setTextStyle-ek8zF_U(long color2, @Nullable Shadow shadow2, @Nullable TextDecoration textDecoration) {
        long l;
        long $this$takeOrElse_u2dDxMtmZc$iv = color2;
        boolean bl = false;
        long $this$isSpecified$iv$iv = $this$takeOrElse_u2dDxMtmZc$iv;
        boolean bl2 = false;
        if ($this$isSpecified$iv$iv != Color.Companion.getUnspecified-0d7_KjU()) {
            l = $this$takeOrElse_u2dDxMtmZc$iv;
        } else {
            boolean bl3 = false;
            l = this.builder.getTextStyle().getColor-0d7_KjU();
        }
        long actualColor = l;
        if (!(Color.equals-impl0(this.builder.getTextStyle().getColor-0d7_KjU(), actualColor) && Intrinsics.areEqual((Object)this.builder.getTextStyle().getShadow(), (Object)shadow2) && Intrinsics.areEqual((Object)this.builder.getTextStyle().getTextDecoration(), (Object)textDecoration))) {
            this.builder.setTextStyle(TextStyle.copy-p1EtxEg$default(this.builder.getTextStyle(), actualColor, 0L, null, null, null, null, null, 0L, null, null, null, 0L, textDecoration, shadow2, null, 0, 0, 0L, null, null, null, 0, 0, null, 0xFFCFFE, null));
            this.paragraphCache = null;
        }
    }

    @ExperimentalTextApi
    public final void setTextStyle-eZhPAX0(@Nullable Brush brush, long brushSize, float alpha2, @Nullable Shadow shadow2, @Nullable TextDecoration textDecoration) {
        block3: {
            block2: {
                long actualSize = this.builder.getBrushSize-NH-jbRc();
                if (!Intrinsics.areEqual((Object)this.builder.getTextStyle().getBrush(), (Object)brush)) break block2;
                long $this$isUnspecified$iv = actualSize;
                boolean bl = false;
                if (!($this$isUnspecified$iv == Size.Companion.getUnspecified-NH-jbRc()) && ParagraphLayouter_skikoKt.access$sameValueAs(Size.getWidth-impl(actualSize), Size.getWidth-impl(brushSize)) && ParagraphLayouter_skikoKt.access$sameValueAs(Size.getHeight-impl(actualSize), Size.getHeight-impl(brushSize)) && ParagraphLayouter_skikoKt.access$sameValueAs(this.builder.getTextStyle().getAlpha(), alpha2) && Intrinsics.areEqual((Object)this.builder.getTextStyle().getShadow(), (Object)shadow2) && Intrinsics.areEqual((Object)this.builder.getTextStyle().getTextDecoration(), (Object)textDecoration)) break block3;
            }
            this.builder.setTextStyle(TextStyle.copy-Ns73l9s$default(this.builder.getTextStyle(), brush, alpha2, 0L, null, null, null, null, null, 0L, null, null, null, 0L, textDecoration, shadow2, null, 0, 0, 0L, null, null, null, 0, 0, null, 33529852, null));
            this.builder.setBrushSize-uvyYCjk(brushSize);
            this.paragraphCache = null;
        }
    }

    public final void setDrawStyle(@Nullable DrawStyle drawStyle) {
        if (!Intrinsics.areEqual((Object)this.builder.getDrawStyle(), (Object)drawStyle)) {
            this.builder.setDrawStyle(drawStyle);
            this.paragraphCache = null;
        }
    }

    public final void setBlendMode-s9anfk8(int blendMode) {
        if (!BlendMode.equals-impl0(this.builder.getBlendMode-0nO6VwU(), blendMode)) {
            this.builder.setBlendMode-s9anfk8(blendMode);
            this.paragraphCache = null;
        }
    }

    @NotNull
    public final Paragraph layoutParagraph(float width2) {
        Paragraph paragraph2;
        Paragraph paragraph3 = this.paragraphCache;
        if (paragraph3 != null) {
            if (!ParagraphLayouter_skikoKt.access$sameValueAs(this.width, width2)) {
                this.width = width2;
                paragraph3.layout(width2);
            }
            paragraph2 = paragraph3;
        } else {
            Paragraph paragraph4;
            Paragraph $this$layoutParagraph_u24lambda_u241 = paragraph4 = this.builder.build();
            boolean bl = false;
            this.paragraphCache = $this$layoutParagraph_u24lambda_u241;
            $this$layoutParagraph_u24lambda_u241.layout(width2);
            paragraph2 = paragraph4;
        }
        return paragraph2;
    }
}

