/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.Direction;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.LayoutModifier;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import noria.ClosureContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BB\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012#\u0010\u0006\u001a\u001f\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0002\b\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0006\u001a\u001f\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/compose/foundation/layout/WrapContentModifier;", "Landroidx/compose/ui/layout/LayoutModifier;", "direction", "Landroidx/compose/foundation/layout/Direction;", "unbounded", "", "alignmentCallback", "Lkotlin/Function3;", "Lnoria/ClosureContext;", "Landroidx/compose/ui/unit/IntSize;", "Landroidx/compose/ui/unit/LayoutDirection;", "Landroidx/compose/ui/unit/IntOffset;", "Lkotlin/ExtensionFunctionType;", "align", "", "(Landroidx/compose/foundation/layout/Direction;ZLkotlin/jvm/functions/Function3;Ljava/lang/Object;)V", "equals", "other", "hashCode", "", "measure", "Landroidx/compose/ui/layout/MeasureResult;", "Landroidx/compose/ui/layout/MeasureScope;", "measurable", "Landroidx/compose/ui/layout/Measurable;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "fleet.noria.ui"})
final class WrapContentModifier
implements LayoutModifier {
    @NotNull
    private final Direction direction;
    private final boolean unbounded;
    @NotNull
    private final Function3<ClosureContext, IntSize, LayoutDirection, IntOffset> alignmentCallback;
    @NotNull
    private final Object align;

    public WrapContentModifier(@NotNull Direction direction, boolean unbounded, @NotNull Function3<? super ClosureContext, ? super IntSize, ? super LayoutDirection, IntOffset> alignmentCallback, @NotNull Object align) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter(alignmentCallback, (String)"alignmentCallback");
        Intrinsics.checkNotNullParameter((Object)align, (String)"align");
        this.direction = direction;
        this.unbounded = unbounded;
        this.alignmentCallback = alignmentCallback;
        this.align = align;
    }

    @Override
    @NotNull
    public MeasureResult measure(@NotNull MeasureScope $this$measure, @NotNull Measurable measurable, @NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$measure, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        int n = this.direction != Direction.Vertical ? 0 : constraints.getMinWidth();
        int n2 = this.direction != Direction.Horizontal ? 0 : constraints.getMinHeight();
        int n3 = this.direction != Direction.Vertical && this.unbounded ? Integer.MAX_VALUE : constraints.getMaxWidth();
        int n4 = this.direction != Direction.Horizontal && this.unbounded ? Integer.MAX_VALUE : constraints.getMaxHeight();
        Constraints wrappedConstraints = new Constraints(n, n3, n2, n4);
        Placeable placeable = measurable.measure(wrappedConstraints);
        int wrapperWidth = RangesKt.coerceIn((int)placeable.getWidth(), (int)constraints.getMinWidth(), (int)constraints.getMaxWidth());
        int wrapperHeight = RangesKt.coerceIn((int)placeable.getHeight(), (int)constraints.getMinHeight(), (int)constraints.getMaxHeight());
        return MeasureScope.DefaultImpls.layout$default($this$measure, wrapperWidth, wrapperHeight, null, (Function1)new Function1<Placeable.PlacementScope, Unit>(this, wrapperWidth, placeable, wrapperHeight, $this$measure){
            final /* synthetic */ WrapContentModifier this$0;
            final /* synthetic */ int $wrapperWidth;
            final /* synthetic */ Placeable $placeable;
            final /* synthetic */ int $wrapperHeight;
            final /* synthetic */ MeasureScope $this_measure;
            {
                this.this$0 = $receiver;
                this.$wrapperWidth = $wrapperWidth;
                this.$placeable = $placeable;
                this.$wrapperHeight = $wrapperHeight;
                this.$this_measure = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull Placeable.PlacementScope $this$layout) {
                Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                long position = ((IntOffset)WrapContentModifier.access$getAlignmentCallback$p(this.this$0).invoke((Object)ClosureContext.Companion, (Object)IntSize.box-impl(IntSizeKt.IntSize(this.$wrapperWidth - this.$placeable.getWidth(), this.$wrapperHeight - this.$placeable.getHeight())), (Object)((Object)this.$this_measure.getLayoutDirection()))).unbox-impl();
                Placeable.PlacementScope.place-70tqf50$default($this$layout, this.$placeable, position, 0.0f, 2, null);
            }
        }, 4, null);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof WrapContentModifier)) {
            return false;
        }
        return this.direction == ((WrapContentModifier)other).direction && this.unbounded == ((WrapContentModifier)other).unbounded && Intrinsics.areEqual((Object)this.align, (Object)((WrapContentModifier)other).align);
    }

    public int hashCode() {
        return (this.direction.hashCode() * 31 + Boolean.hashCode(this.unbounded)) * 31 + this.align.hashCode();
    }

    @Override
    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2) {
        return LayoutModifier.DefaultImpls.minIntrinsicWidth(this, $this$minIntrinsicWidth, measurable, height2);
    }

    @Override
    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2) {
        return LayoutModifier.DefaultImpls.minIntrinsicHeight(this, $this$minIntrinsicHeight, measurable, width2);
    }

    @Override
    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2) {
        return LayoutModifier.DefaultImpls.maxIntrinsicWidth(this, $this$maxIntrinsicWidth, measurable, height2);
    }

    @Override
    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2) {
        return LayoutModifier.DefaultImpls.maxIntrinsicHeight(this, $this$maxIntrinsicHeight, measurable, width2);
    }

    @Override
    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        return LayoutModifier.DefaultImpls.foldIn(this, initial, operation);
    }

    @Override
    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        return LayoutModifier.DefaultImpls.foldOut(this, initial, operation);
    }

    @Override
    public boolean any(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return LayoutModifier.DefaultImpls.any(this, predicate);
    }

    @Override
    public boolean all(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return LayoutModifier.DefaultImpls.all(this, predicate);
    }

    @Override
    @NotNull
    public Modifier then(@NotNull Modifier other) {
        return LayoutModifier.DefaultImpls.then(this, other);
    }

    public static final /* synthetic */ Function3 access$getAlignmentCallback$p(WrapContentModifier $this) {
        return $this.alignmentCallback;
    }
}

