/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.schema.generation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/fus/reporting/schema/generation/ValidationResult;", "", "()V", "errors", "", "", "", "(Ljava/util/Map;)V", "getErrors", "()Ljava/util/Map;", "addError", "", "groupId", "message", "addErrors", "messages", "", "isCorrectGroup", "", "merge", "other", "scheme"})
public final class ValidationResult {
    @NotNull
    private final Map<String, Set<String>> errors;

    public ValidationResult(@NotNull Map<String, Set<String>> errors) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        this.errors = errors;
    }

    @NotNull
    public final Map<String, Set<String>> getErrors() {
        return this.errors;
    }

    public ValidationResult() {
        this(new HashMap());
    }

    public final void addError(@NotNull String groupId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Set set = this.errors.get(groupId);
        if (set == null) {
            set = new HashSet();
        }
        Set existingErrors = set;
        existingErrors.add((String)message);
        this.errors.put(groupId, existingErrors);
    }

    private final void addErrors(String groupId, Set<String> messages) {
        Set set = this.errors.get(groupId);
        if (set == null) {
            set = new HashSet();
        }
        Set existingErrors = set;
        existingErrors.addAll((Collection)messages);
        this.errors.put(groupId, existingErrors);
    }

    public final boolean isCorrectGroup(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.errors.get(groupId) == null;
    }

    @NotNull
    public final ValidationResult merge(@NotNull ValidationResult other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ValidationResult result = new ValidationResult(this.errors);
        for (Map.Entry<String, Set<String>> entry : other.errors.entrySet()) {
            String group = entry.getKey();
            Set<String> errors = entry.getValue();
            result.addErrors(group, errors);
        }
        return result;
    }
}

