module fleet.run.frontend {
    requires fleet.frontend.ui;
    /* transitive */ requires fleet.run.common;
    requires fleet.frontend;
    requires kotlinx.coroutines.core;
    requires org.jetbrains.annotations;
    requires fleet.preferences;
    requires fleet.run.protocol;
    requires fleet.schema.common;
    requires kotlin.reflect;
    requires bifurcan;
    requires jediterm.core;
    requires fleet.reporting.api;
    requires fleet.schema.protocol;
    requires fleet.schema.frontend;
    requires fleet.ast.core;
    requires scheme;
    requires fleet.dock.connectors;
    requires fleet.reporting.fus.api;
    requires fleet.reporting.shared;
    requires fleet.code.frontend;
    requires util.base.squashed;
    requires fleet.util.os;
    requires fleet.plugins.smartMode.frontend;
    requires json.parser;
    requires fleet.plugins.json.parsing.common;
    requires fleet.frontend.lang;
    requires fleet.navigation.frontend.api;
    requires fleet.bundles;
    requires fleet.plugins.misc.frontend;
    requires fleet.plugins.authentication.frontend;

    exports fleet.frontend.run.api;
    exports fleet.frontend.run.api.macro;
    exports fleet.frontend.run.api.schema;
    exports fleet.frontend.run.api.ssh;
    exports fleet.frontend.run.api.view;
    exports fleet.frontend.run.api.terminal;
    exports fleet.frontend.run.api.terminal.internal to fleet.plugins.mercury.frontend, fleet.plugins.ai.frontend, fleet.rhizomedb;
    exports fleet.frontend.run.impl to fleet.rhizomedb, fleet.run.test, fleet.app.fleet.tests;
    exports fleet.frontend.run.impl.build to fleet.rhizomedb, fleet.run.test, fleet.app.fleet.tests;
    exports fleet.frontend.run.impl.config to fleet.rhizomedb, fleet.run.test, fleet.app.fleet.tests, fleet.webHelp.generator;
    exports fleet.frontend.run.impl.ssh to fleet.rhizomedb, fleet.run.test, fleet.app.fleet.tests;
    exports fleet.frontend.run.impl.test to fleet.rhizomedb, fleet.run.test, fleet.app.fleet.tests;
    exports fleet.frontend.run.impl.test.rerun to fleet.rhizomedb, fleet.run.test, fleet.app.fleet.tests;
    exports fleet.frontend.run.impl.test.view to fleet.rhizomedb, fleet.run.test, fleet.app.fleet.tests;
    exports fleet.frontend.run.impl.terminal to fleet.plugins.marine.frontend, fleet.plugins.mercury.frontend, fleet.plugins.docker.frontend, fleet.plugins.ai.frontend, kotlinx.serialization.core, kotlin.reflect, fleet.app.fleet.tests, fleet.plugins.java.test, fleet.run.test, fleet.testFramework, fleet.rhizomedb, fleet.space.tests;
    exports fleet.frontend.run.impl.terminal.view to fleet.plugins.marine.frontend, fleet.plugins.ai.frontend, fleet.plugins.mercury.frontend, fleet.plugins.docker.frontend, fleet.app.fleet.tests, fleet.run.test.integration, fleet.testFramework, fleet.rhizomedb, fleet.space.tests;
    exports fleet.frontend.run.impl.macro to fleet.plugins.json.frontend, fleet.rhizomedb;
    exports fleet.frontend.run.impl.terminal.profile to fleet.rhizomedb;
    exports fleet.frontend.run.impl.survey to fleet.rhizomedb;

    provides Plugin with RunPlugin;

}

