/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.modules;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public final class ResourcesResolver {
    public static String toResourceName(Path baseDir, Path filepath) {
        Object pathAsString = baseDir.relativize(filepath).toString();
        if (((String)pathAsString).isEmpty()) {
            return "";
        }
        if (File.separatorChar != '/') {
            pathAsString = ((String)pathAsString).replace(File.separatorChar, '/');
        }
        if (Files.isDirectory(filepath, new LinkOption[0])) {
            pathAsString = (String)pathAsString + "/";
        }
        return pathAsString;
    }

    public static Path resourceNameToPath(Path baseDir, String name) throws IOException {
        Path path;
        boolean containsDots;
        if (File.separatorChar != '/') {
            name = name.replace('/', File.separatorChar);
        }
        boolean bl = containsDots = !(path = Path.of(name, new String[0])).normalize().equals(path);
        if (path.isAbsolute() || containsDots) {
            return null;
        }
        Path target = baseDir.resolve(path);
        BasicFileAttributes attrs = ResourcesResolver.readAttributes(target);
        boolean namedLikeDir = name.endsWith(File.separator);
        return attrs == null || attrs.isDirectory() && !namedLikeDir || attrs.isRegularFile() && namedLikeDir ? null : target;
    }

    private static BasicFileAttributes readAttributes(Path target) throws IOException {
        try {
            return Files.readAttributes(target, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }
}

