/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.modules;

import fleet.util.modules.DebugProbesHack;
import fleet.util.modules.FleetModuleFinderLogger;
import fleet.util.modules.ModuleInfo;
import fleet.util.modules.UnqualifyExports;
import fleet.util.modules.WithDescriptorModuleFinder;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ModuleLayers {
    public static ModuleDescriptor deserializeModuleDescriptor(String data) {
        return ModuleLayers.convertOpenToAutomatic(ModuleDescriptor.read(ByteBuffer.wrap(Base64.getDecoder().decode(data))));
    }

    public static ModuleLayer moduleLayer(List<ModuleLayer> parentLayers, Collection<ModuleInfo> modulePath, FleetModuleFinderLogger logger) {
        PatchedFleetModuleFinder before = ModuleLayers.moduleFinder(modulePath, logger);
        ArrayList<ModuleLayer> parentLayers1 = new ArrayList<ModuleLayer>(parentLayers);
        parentLayers1.add(ModuleLayer.boot());
        List<Configuration> parents = parentLayers1.stream().map(x -> x.configuration()).toList();
        ModuleFinder after = ModuleFinder.of(new Path[0]);
        Set<ModuleReference> beforeFindAll = before.findAll();
        Set<String> rootModuleNames = beforeFindAll.stream().map(x -> x.descriptor().name()).collect(Collectors.toSet());
        Configuration configuration = Configuration.resolve(before, parents, after, rootModuleNames);
        ClassLoader parentClassLoader = ClassLoader.getSystemClassLoader();
        ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(configuration, parentLayers1, parentClassLoader);
        return controller.layer();
    }

    private static PatchedFleetModuleFinder moduleFinder(Collection<ModuleInfo> modulePath, FleetModuleFinderLogger logger) {
        Stream<ModuleInfo.WithDescriptor> jarDescriptors = ModuleLayers.paths(modulePath.stream()).filter(x -> x.path().endsWith(".jar")).map(x -> {
            List moduleReferences = ModuleFinder.of(Path.of(x.path(), new String[0])).findAll().stream().toList();
            if (moduleReferences.size() != 1) {
                throw new RuntimeException("expected single module reference");
            }
            ModuleReference moduleReference = (ModuleReference)moduleReferences.get(0);
            return new ModuleInfo.WithDescriptor(moduleReference.descriptor(), x.path());
        });
        WithDescriptorModuleFinder jarFinder = WithDescriptorModuleFinder.build(jarDescriptors, logger);
        WithDescriptorModuleFinder descriptorsFinder = WithDescriptorModuleFinder.build(ModuleLayers.descriptors(modulePath.stream()), logger);
        Path[] dirs = (Path[])ModuleLayers.paths(modulePath.stream()).filter(x -> !x.path().endsWith(".jar")).map(x -> Path.of(x.path(), new String[0])).toArray(Path[]::new);
        if (dirs.length == 0) {
            return new PatchedFleetModuleFinder(new ModuleFinder[]{descriptorsFinder, jarFinder});
        }
        ModuleFinder dirFinder = ModuleFinder.of(dirs);
        return new PatchedFleetModuleFinder(new ModuleFinder[]{descriptorsFinder, jarFinder, dirFinder});
    }

    private static Stream<ModuleInfo.WithDescriptor> descriptors(Stream<ModuleInfo> stream) {
        return stream.filter(x -> x instanceof ModuleInfo.WithDescriptor).map(x -> (ModuleInfo.WithDescriptor)x);
    }

    private static Stream<ModuleInfo.Path> paths(Stream<ModuleInfo> stream) {
        return stream.filter(x -> x instanceof ModuleInfo.Path).map(x -> (ModuleInfo.Path)x);
    }

    private static ModuleDescriptor convertOpenToAutomatic(ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor.isOpen()) {
            ModuleDescriptor.Builder builder = ModuleDescriptor.newAutomaticModule(moduleDescriptor.name());
            if (moduleDescriptor.version().isPresent()) {
                builder.version(moduleDescriptor.version().get());
            }
            builder.packages(moduleDescriptor.packages());
            return builder.build();
        }
        return moduleDescriptor;
    }

    private static final class PatchedFleetModuleFinder
    implements ModuleFinder {
        private final ConcurrentHashMap<String, FleetModuleReference> nameToModule;
        private final ModuleFinder[] finders;
        private volatile Set<ModuleReference> all;

        PatchedFleetModuleFinder(ModuleFinder[] finders) {
            this.finders = finders;
            this.nameToModule = new ConcurrentHashMap();
        }

        @Override
        public Optional<ModuleReference> find(String name) {
            return Optional.ofNullable(this.doFind(PatchedFleetModuleFinder.translatedName(name)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<ModuleReference> findAll() {
            if (this.all == null) {
                PatchedFleetModuleFinder patchedFleetModuleFinder = this;
                synchronized (patchedFleetModuleFinder) {
                    if (this.all == null) {
                        HashSet<ModuleReference> result = new HashSet<ModuleReference>(this.nameToModule.size());
                        result.addAll(this.nameToModule.values());
                        for (ModuleFinder finder : this.finders) {
                            for (ModuleReference ref : finder.findAll()) {
                                FleetModuleReference fleetRef;
                                String name = PatchedFleetModuleFinder.translatedName(ref.descriptor().name());
                                if (this.nameToModule.putIfAbsent(name, fleetRef = new FleetModuleReference(ref)) != null) continue;
                                result.add(fleetRef);
                            }
                        }
                        this.all = result;
                    }
                }
            }
            return this.all;
        }

        private static String translatedName(String name) {
            return DebugProbesHack.kotlinRuntimeModuleNames.contains(name) ? "fleet.kotlin.runtime" : name;
        }

        private FleetModuleReference doFind(String name) {
            FleetModuleReference cached = this.nameToModule.computeIfAbsent(name, k -> {
                for (ModuleFinder finder : this.finders) {
                    Optional<ModuleReference> found = finder.find(name);
                    if (!found.isPresent()) continue;
                    return new FleetModuleReference(found.get());
                }
                return FleetModuleReference.mockModuleReference;
            });
            return cached == FleetModuleReference.mockModuleReference ? null : cached;
        }

        private static class FleetModuleReference
        extends ModuleReference {
            static FleetModuleReference mockModuleReference = new FleetModuleReference(new DummyModuleReference());
            private final ModuleReference moduleReference;

            FleetModuleReference(ModuleReference moduleReference) {
                super(UnqualifyExports.unqualifyExports(moduleReference.descriptor()), moduleReference.location().orElse(null));
                this.moduleReference = moduleReference;
            }

            @Override
            public ModuleReader open() throws IOException {
                return this.moduleReference.open();
            }
        }

        private static class DummyModuleReference
        extends ModuleReference {
            DummyModuleReference() {
                super(ModuleDescriptor.newModule("com.example").build(), URI.create("dummy:module"));
            }

            @Override
            public ModuleReader open() {
                throw new RuntimeException("dummy");
            }
        }
    }
}

