/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.modules;

import fleet.util.modules.FleetModuleRuntimeVersion;
import fleet.util.modules.ResourcesResolver;
import java.io.BufferedInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleReader;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class FleetFileSystemModuleReader
implements ModuleReader {
    private final Path path;
    private final Map<String, String> versionedFiles;

    FleetFileSystemModuleReader(Path path) {
        this.path = path;
        this.versionedFiles = FleetFileSystemModuleReader.loadVersionedFiles(path);
    }

    private static Map<String, String> loadVersionedFiles(@NotNull Path path) {
        Map<String, String> map;
        block10: {
            if (path == null) {
                FleetFileSystemModuleReader.$$$reportNull$$$0(0);
            }
            Runtime.Version runtimeVersion = Runtime.version();
            Path versionsDir = path.resolve("META-INF/versions");
            Stream<Path> list = Files.list(versionsDir);
            try {
                final HashMap versions = new HashMap();
                list.forEach(versionDir -> {
                    final FleetModuleRuntimeVersion version = FleetModuleRuntimeVersion.parseVersion(versionDir.getFileName().toString());
                    if (version != null && runtimeVersion.compareTo(version.getRuntimeVersion()) >= 0) {
                        try {
                            Files.walkFileTree(versionDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                                @Override
                                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                                    return FileVisitResult.CONTINUE;
                                }

                                @Override
                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                                    String pathToClass = versionDir.relativize(file).toString();
                                    FleetModuleRuntimeVersion registeredVersion = (FleetModuleRuntimeVersion)versions.get(pathToClass);
                                    if (registeredVersion == null || version.compareTo(registeredVersion) > 0) {
                                        versions.put(pathToClass, version);
                                    }
                                    return FileVisitResult.CONTINUE;
                                }

                                @Override
                                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                                    return FileVisitResult.CONTINUE;
                                }

                                @Override
                                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                Map<String, String> map2 = map = versions.isEmpty() ? null : versions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FleetModuleRuntimeVersion)e.getValue()).getRawVersion()));
                if (list == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e2) {
                    return null;
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
            }
            list.close();
        }
        return map;
    }

    @Override
    public Optional<InputStream> open(String name) throws IOException {
        Path path = this.toVersionedFilePath(name);
        if (path == null) {
            return Optional.empty();
        }
        int DEFAULT_BUFFER_SIZE = 8192;
        InputStream stream = Files.newInputStream(path, new OpenOption[0]);
        if (stream instanceof BufferedInputStream) {
            return Optional.of(stream);
        }
        BufferedInputStream buffered = new BufferedInputStream(stream, DEFAULT_BUFFER_SIZE);
        return Optional.of(buffered);
    }

    @Override
    public Optional<URI> find(String name) throws IOException {
        try {
            Path filePath = this.toVersionedFilePath(name);
            return filePath == null ? Optional.empty() : Optional.of(filePath.toUri());
        }
        catch (IOError e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    @Override
    public Stream<String> list() throws IOException {
        try (Stream<Path> walker = Files.walk(this.path, Integer.MAX_VALUE, new FileVisitOption[0]);){
            Stream<String> stream = walker.map(x -> ResourcesResolver.toResourceName(this.path, x)).filter(x -> !x.isEmpty());
            return stream;
        }
    }

    @Override
    public void close() {
    }

    private Path toVersionedFilePath(@NotNull String name) throws IOException {
        String version;
        if (name == null) {
            FleetFileSystemModuleReader.$$$reportNull$$$0(1);
        }
        if (this.versionedFiles != null && !name.startsWith("META-INF/") && (version = this.versionedFiles.get(name)) != null) {
            return ResourcesResolver.resourceNameToPath(this.path, "META-INF/versions/" + version + "/" + name);
        }
        return ResourcesResolver.resourceNameToPath(this.path, name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "fleet/util/modules/FleetFileSystemModuleReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadVersionedFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "toVersionedFilePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

