/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.modules;

import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleReader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class CompositeModuleReader
implements ModuleReader {
    private final ModuleReader[] myReaders;
    private final ConcurrentHashMap<ByteBuffer, ModuleReader> bbToReaders;

    public CompositeModuleReader(ModuleReader ... readers) {
        if (readers.length < 2) {
            throw new IllegalArgumentException("must have at least two readers");
        }
        this.myReaders = readers;
        this.bbToReaders = new ConcurrentHashMap();
    }

    @Override
    public Optional<URI> find(String name) throws IOException {
        for (ModuleReader r : this.myReaders) {
            Optional<URI> found = r.find(name);
            if (!found.isPresent()) continue;
            return found;
        }
        return Optional.empty();
    }

    @Override
    public Optional<InputStream> open(String name) throws IOException {
        for (ModuleReader r : this.myReaders) {
            Optional<InputStream> opened = r.open(name);
            if (!opened.isPresent()) continue;
            return opened;
        }
        return Optional.empty();
    }

    @Override
    public Optional<ByteBuffer> read(String name) throws IOException {
        for (ModuleReader r : this.myReaders) {
            Optional<ByteBuffer> byteBuffer = r.read(name);
            if (!byteBuffer.isPresent()) continue;
            this.bbToReaders.put(byteBuffer.get(), r);
            return byteBuffer;
        }
        return Optional.empty();
    }

    @Override
    public void release(ByteBuffer bb) {
        ModuleReader r = this.bbToReaders.remove(bb);
        if (r != null) {
            r.release(bb);
        }
    }

    @Override
    public Stream<String> list() throws IOException {
        HashSet<Stream<String>> streams = new HashSet<Stream<String>>();
        for (ModuleReader r : this.myReaders) {
            streams.add(r.list());
        }
        return streams.stream().flatMap(s -> s);
    }

    @Override
    public void close() throws IOException {
        Throwable exception = null;
        for (ModuleReader r : this.myReaders) {
            try {
                r.close();
            }
            catch (Throwable e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IOException(exception);
        }
    }
}

