/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.filetree;

import androidx.compose.runtime.Composable;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.EntityType;
import fleet.api.FileAddress;
import fleet.common.FleetCommonSettingsKeysKt;
import fleet.common.FsService;
import fleet.common.fs.FsdKt;
import fleet.common.settings.SettingsEntityKt;
import fleet.common.topology.HostKt;
import fleet.common.topology.HostServiceEntity;
import fleet.compose.theme.components.ContextMenuKt;
import fleet.compose.theme.components.MenuItem;
import fleet.frontend.filetree.CombinedFolderWorkspaceTreeItem;
import fleet.frontend.filetree.ExternalLibraryTreeItem;
import fleet.frontend.filetree.FileWorkspaceTreeItem;
import fleet.frontend.filetree.NewFileInTreeEntity;
import fleet.frontend.filetree.NewFileWorkspaceTreeItem;
import fleet.frontend.filetree.WorkspaceRootTreeItem;
import fleet.frontend.filetree.WorkspaceTreeActions;
import fleet.frontend.filetree.WorkspaceTreeCellHighlighting;
import fleet.frontend.filetree.WorkspaceTreeItem;
import fleet.frontend.filetree.WorkspaceTreeRoot;
import fleet.frontend.filetree.WorkspaceTreeSettingsKeys;
import fleet.frontend.filetree.WorkspaceTreeTabEntity;
import fleet.frontend.filetree.extension.internal.FilesTreeMenuExtenderKt;
import fleet.frontend.filetree.fsentry.internal.FSDKt;
import fleet.frontend.filetree.fsentry.internal.FSDirectory;
import fleet.frontend.filetree.fsentry.internal.FSEntry;
import fleet.frontend.filetree.fsentry.internal.FetchRequest;
import fleet.plugins.misc.frontend.clipboard.FileClipboardActionsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.ReadScope;
import noria.model.Action;
import noria.model.ActionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0017J\u001e\u0010$\u001a\u0004\u0018\u00010!*\u00020%2\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u000bH\u0016J\u0014\u0010(\u001a\u00020)*\u00020%2\u0006\u0010*\u001a\u00020!H\u0016J\u0014\u0010+\u001a\u00020)*\u00020%2\u0006\u0010*\u001a\u00020!H\u0016J\u0014\u0010,\u001a\u00020)*\u00020%2\u0006\u0010*\u001a\u00020!H\u0016J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\u0013\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u00102\u001a\u00020\u000b2\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\t\u00105\u001a\u000206H\u00d6\u0001J\t\u00107\u001a\u000208H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010-\u001a\u0004\u0018\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00069"}, d2={"Lfleet/frontend/filetree/FSWorkspaceTreeRoot;", "Lfleet/frontend/filetree/WorkspaceTreeRoot;", "workspaceTreeTabEntity", "Lfleet/frontend/filetree/WorkspaceTreeTabEntity;", "<init>", "(Lfleet/frontend/filetree/WorkspaceTreeTabEntity;)V", "getWorkspaceTreeTabEntity", "()Lfleet/frontend/filetree/WorkspaceTreeTabEntity;", "entity", "getEntity", "combineFolders", "", "getCombineFolders", "()Z", "fetchRequest", "Lfleet/frontend/filetree/fsentry/internal/FetchRequest;", "getFetchRequest", "()Lfleet/frontend/filetree/fsentry/internal/FetchRequest;", "showRootsStatus", "getShowRootsStatus", "openEditorForNewFile", "getOpenEditorForNewFile", "showHiddenFiles", "getShowHiddenFiles", "cellHighlighting", "Lfleet/frontend/filetree/WorkspaceTreeCellHighlighting;", "getCellHighlighting", "()Lfleet/frontend/filetree/WorkspaceTreeCellHighlighting;", "menuItems", "", "Lfleet/compose/theme/components/MenuItem;", "Lnoria/ReadScope;", "child", "Lfleet/frontend/filetree/WorkspaceTreeItem;", "actionContext", "Lnoria/model/ActionContext;", "newFile", "Lcom/jetbrains/rhizomedb/ChangeScope;", "parent", "directory", "startRenaming", "", "item", "stopRenaming", "revealEntry", "renamedItem", "getRenamedItem", "()Lfleet/frontend/filetree/WorkspaceTreeItem;", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "fleet.filetree.frontend"})
@SourceDebugExtension(value={"SMAP\nFSWorkspaceTreeRoot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FSWorkspaceTreeRoot.kt\nfleet/frontend/filetree/FSWorkspaceTreeRoot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1863#2,2:118\n*S KotlinDebug\n*F\n+ 1 FSWorkspaceTreeRoot.kt\nfleet/frontend/filetree/FSWorkspaceTreeRoot\n*L\n62#1:118,2\n*E\n"})
public final class FSWorkspaceTreeRoot
implements WorkspaceTreeRoot {
    @NotNull
    private final WorkspaceTreeTabEntity workspaceTreeTabEntity;
    @NotNull
    private final WorkspaceTreeTabEntity entity;
    @NotNull
    private final FetchRequest fetchRequest;
    private final boolean showRootsStatus;
    private final boolean openEditorForNewFile;
    private final boolean showHiddenFiles;
    @NotNull
    private final WorkspaceTreeCellHighlighting cellHighlighting;

    public FSWorkspaceTreeRoot(@NotNull WorkspaceTreeTabEntity workspaceTreeTabEntity) {
        Intrinsics.checkNotNullParameter((Object)workspaceTreeTabEntity, (String)"workspaceTreeTabEntity");
        this.entity = this.workspaceTreeTabEntity = workspaceTreeTabEntity;
        this.fetchRequest = FetchRequest.FETCH_WHILE_SINGLE_CHILD;
        this.showRootsStatus = FleetCommonSettingsKeysKt.isInternalMode();
        this.openEditorForNewFile = true;
        this.showHiddenFiles = true;
        this.cellHighlighting = WorkspaceTreeCellHighlighting.DEFAULT;
    }

    @NotNull
    public final WorkspaceTreeTabEntity getWorkspaceTreeTabEntity() {
        return this.workspaceTreeTabEntity;
    }

    @Override
    @NotNull
    public WorkspaceTreeTabEntity getEntity() {
        return this.entity;
    }

    @Override
    public boolean getCombineFolders() {
        return (Boolean)SettingsEntityKt.querySettingsKey$default(WorkspaceTreeSettingsKeys.INSTANCE.getCompactDirectories(), null, null, (int)6, null);
    }

    @Override
    @NotNull
    public FetchRequest getFetchRequest() {
        return this.fetchRequest;
    }

    @Override
    public boolean getShowRootsStatus() {
        return this.showRootsStatus;
    }

    @Override
    public boolean getOpenEditorForNewFile() {
        return this.openEditorForNewFile;
    }

    @Override
    public boolean getShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    @Override
    @NotNull
    public WorkspaceTreeCellHighlighting getCellHighlighting() {
        return this.cellHighlighting;
    }

    @Override
    @Composable
    @NotNull
    public List<MenuItem> menuItems(@NotNull ReadScope $this$menuItems, @NotNull WorkspaceTreeItem child, @NotNull ActionContext actionContext2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$menuItems, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        WorkspaceTreeItem workspaceTreeItem = child;
        if (workspaceTreeItem instanceof FileWorkspaceTreeItem) {
            WorkspaceTreeActions $this$menuItems_u24lambda_u240 = WorkspaceTreeActions.INSTANCE;
            boolean bl = false;
            list = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)$this$menuItems_u24lambda_u240.newContextMenuItems($this$menuItems, actionContext2), (Object)MenuItem.Separator.INSTANCE), (Iterable)$this$menuItems_u24lambda_u240.addRemoveFolderMenuItems$fleet_filetree_frontend($this$menuItems, child instanceof WorkspaceRootTreeItem, actionContext2)), (Object)MenuItem.Separator.INSTANCE), (Iterable)$this$menuItems_u24lambda_u240.openContextMenuItems($this$menuItems, ((FileWorkspaceTreeItem)child).getDeepestEntry(), actionContext2)), (Object)MenuItem.Separator.INSTANCE), (Iterable)$this$menuItems_u24lambda_u240.modificationContextMenuItems($this$menuItems, child instanceof WorkspaceRootTreeItem, actionContext2)), (Object)MenuItem.Separator.INSTANCE), (Iterable)$this$menuItems_u24lambda_u240.copyPasteContextMenuItems($this$menuItems, actionContext2)), (Object)MenuItem.Separator.INSTANCE), (Iterable)FilesTreeMenuExtenderKt.filesTreeExtensionMenuItems($this$menuItems, actionContext2));
        } else {
            list = workspaceTreeItem instanceof ExternalLibraryTreeItem ? CollectionsKt.listOfNotNull((Object)ContextMenuKt.ActionMenuItem$default((ReadScope)$this$menuItems, (Action)FileClipboardActionsKt.getCopyFileAction(), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null)) : CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public WorkspaceTreeItem newFile(@NotNull ChangeScope $this$newFile, @NotNull WorkspaceTreeItem parent, boolean directory) {
        WorkspaceTreeItem workspaceTreeItem;
        WorkspaceTreeItem adjustedParent;
        Intrinsics.checkNotNullParameter((Object)$this$newFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        WorkspaceTreeItem workspaceTreeItem2 = adjustedParent = parent instanceof FileWorkspaceTreeItem && !(((FileWorkspaceTreeItem)parent).getDeepestEntry() instanceof FSDirectory) ? parent.getParent() : parent;
        if (adjustedParent instanceof FileWorkspaceTreeItem) {
            NewFileWorkspaceTreeItem newFileWorkspaceTreeItem;
            FSEntry parentFsEntry = ((FileWorkspaceTreeItem)adjustedParent).getDeepestEntry();
            if (parentFsEntry != null) {
                FsService fsService = FsdKt.fsService((FileAddress)FSDKt.fileAddress(parentFsEntry));
                if (fsService != null && parentFsEntry instanceof FSDirectory) {
                    WorkspaceTreeRoot root2 = ((FileWorkspaceTreeItem)adjustedParent).getRoot();
                    Iterable $this$forEach$iv = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)NewFileInTreeEntity.Companion.getRootAttr()), (Object)root2);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        NewFileInTreeEntity it = (NewFileInTreeEntity)element$iv;
                        boolean bl = false;
                        $this$newFile.delete((Entity)it);
                    }
                    NewFileInTreeEntity newFileInTreeEntity = (NewFileInTreeEntity)$this$newFile.new((EntityType)NewFileInTreeEntity.Companion, arg_0 -> FSWorkspaceTreeRoot.newFile$lambda$2(fsService, parentFsEntry, root2, directory, arg_0));
                    NewFileWorkspaceTreeItem renamingItem = new NewFileWorkspaceTreeItem(newFileInTreeEntity, directory, adjustedParent instanceof CombinedFolderWorkspaceTreeItem ? ((CombinedFolderWorkspaceTreeItem)adjustedParent).getDelegate() : (FileWorkspaceTreeItem)adjustedParent, root2);
                    $this$newFile.set((Entity)this.workspaceTreeTabEntity, WorkspaceTreeTabEntity.Companion.getRenamingItemAttr(), (Object)renamingItem);
                    newFileWorkspaceTreeItem = renamingItem;
                } else {
                    newFileWorkspaceTreeItem = null;
                }
            } else {
                newFileWorkspaceTreeItem = null;
            }
            workspaceTreeItem = newFileWorkspaceTreeItem;
        } else {
            workspaceTreeItem = null;
        }
        return workspaceTreeItem;
    }

    @Override
    public void startRenaming(@NotNull ChangeScope $this$startRenaming, @NotNull WorkspaceTreeItem item) {
        Intrinsics.checkNotNullParameter((Object)$this$startRenaming, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (EntitiesKt.exists((Entity)this.workspaceTreeTabEntity)) {
            $this$startRenaming.set((Entity)this.workspaceTreeTabEntity, WorkspaceTreeTabEntity.Companion.getRenamingItemAttr(), (Object)item);
        }
    }

    @Override
    public void stopRenaming(@NotNull ChangeScope $this$stopRenaming, @NotNull WorkspaceTreeItem item) {
        Intrinsics.checkNotNullParameter((Object)$this$stopRenaming, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (EntitiesKt.exists((Entity)this.workspaceTreeTabEntity)) {
            WorkspaceTreeItem workspaceTreeItem = this.workspaceTreeTabEntity.getRenamingItem();
            if (Intrinsics.areEqual((Object)item.getKey(), (Object)(workspaceTreeItem != null ? workspaceTreeItem.getKey() : null))) {
                $this$stopRenaming.set((Entity)this.workspaceTreeTabEntity, WorkspaceTreeTabEntity.Companion.getRenamingItemAttr(), null);
            }
        }
    }

    @Override
    public void revealEntry(@NotNull ChangeScope $this$revealEntry, @NotNull WorkspaceTreeItem item) {
        Intrinsics.checkNotNullParameter((Object)$this$revealEntry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (EntitiesKt.exists((Entity)this.workspaceTreeTabEntity) && item instanceof FileWorkspaceTreeItem) {
            $this$revealEntry.set((Entity)this.workspaceTreeTabEntity, WorkspaceTreeTabEntity.Companion.getTargetEntryAttr(), (Object)((FileWorkspaceTreeItem)item).getDeepestEntry());
        }
    }

    @Override
    @Nullable
    public WorkspaceTreeItem getRenamedItem() {
        return EntitiesKt.exists((Entity)this.workspaceTreeTabEntity) ? this.workspaceTreeTabEntity.getRenamingItem() : null;
    }

    @NotNull
    public final WorkspaceTreeTabEntity component1() {
        return this.workspaceTreeTabEntity;
    }

    @NotNull
    public final FSWorkspaceTreeRoot copy(@NotNull WorkspaceTreeTabEntity workspaceTreeTabEntity) {
        Intrinsics.checkNotNullParameter((Object)workspaceTreeTabEntity, (String)"workspaceTreeTabEntity");
        return new FSWorkspaceTreeRoot(workspaceTreeTabEntity);
    }

    public static /* synthetic */ FSWorkspaceTreeRoot copy$default(FSWorkspaceTreeRoot fSWorkspaceTreeRoot, WorkspaceTreeTabEntity workspaceTreeTabEntity, int n, Object object) {
        if ((n & 1) != 0) {
            workspaceTreeTabEntity = fSWorkspaceTreeRoot.workspaceTreeTabEntity;
        }
        return fSWorkspaceTreeRoot.copy(workspaceTreeTabEntity);
    }

    @NotNull
    public String toString() {
        return "FSWorkspaceTreeRoot(workspaceTreeTabEntity=" + this.workspaceTreeTabEntity + ")";
    }

    public int hashCode() {
        return this.workspaceTreeTabEntity.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FSWorkspaceTreeRoot)) {
            return false;
        }
        FSWorkspaceTreeRoot fSWorkspaceTreeRoot = (FSWorkspaceTreeRoot)other;
        return Intrinsics.areEqual((Object)this.workspaceTreeTabEntity, (Object)fSWorkspaceTreeRoot.workspaceTreeTabEntity);
    }

    private static final void newFile$lambda$2(FsService $fsService, FSEntry $parentFsEntry, WorkspaceTreeRoot $root, boolean $directory, EntityBuilder.Target it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(NewFileInTreeEntity.Companion.getHostIdAttr(), (Object)HostKt.getServingHostId((HostServiceEntity)((HostServiceEntity)$fsService)));
        it.set(NewFileInTreeEntity.Companion.getOsAttr(), (Object)$fsService.getOs());
        it.set(NewFileInTreeEntity.Companion.getParentAttr(), (Object)$parentFsEntry);
        it.set(NewFileInTreeEntity.Companion.getRootAttr(), (Object)$root);
        it.set(NewFileInTreeEntity.Companion.getDirectoryAttr(), (Object)$directory);
    }
}

