/*
 * Decompiled with CFR 0.152.
 */
package fleet.lang.intellij.common;

import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.lang.intellij.common.HighlightingNodeExtender;
import fleet.lang.intellij.common.HighlightingToken;
import fleet.lang.intellij.common.SyntaxExtenderKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lfleet/lang/intellij/common/TodoNodeExtender;", "Lfleet/lang/intellij/common/HighlightingNodeExtender;", "<init>", "()V", "extend", "", "Lfleet/lang/intellij/common/HighlightingToken;", "node", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "Companion", "fleet.plugins.ij.parsing.common"})
public final class TodoNodeExtender
implements HighlightingNodeExtender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex todoPattern = new Regex("\\b(TODO|FIXME)\\b.*", RegexOption.IGNORE_CASE);
    @NotNull
    private static final IElementType COMMENT_TODO = new IElementType("COMMENT_TODO", null);

    @Override
    @NotNull
    public List<HighlightingToken> extend(@NotNull SyntaxNode node) {
        List list;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        MatchResult matchResult = Regex.find$default((Regex)todoPattern, (CharSequence)node.getText(), (int)0, (int)2, null);
        if (matchResult == null) {
            return CollectionsKt.emptyList();
        }
        MatchResult match = matchResult;
        HighlightingToken padding = new HighlightingToken(SyntaxExtenderKt.getElementType(node), ((Object)node.getText().subSequence(0, match.getRange().getFirst())).toString(), node.getStartOffset(), node.getStartOffset() + (long)match.getRange().getFirst());
        HighlightingToken token = new HighlightingToken(COMMENT_TODO, match.getValue(), node.getStartOffset() + (long)match.getRange().getFirst(), node.getStartOffset() + (long)match.getRange().getLast() + 1L);
        if (node.getStartOffset() + (long)match.getRange().getLast() + 1L != node.getEndOffset()) {
            Object[] objectArray = node.getText();
            int n = match.getRange().getLast() + 1;
            int n2 = objectArray.length();
            HighlightingToken rest = new HighlightingToken(SyntaxExtenderKt.getElementType(node), ((Object)objectArray.subSequence(n, n2)).toString(), node.getStartOffset() + (long)match.getRange().getLast() + 1L, node.getEndOffset());
            objectArray = new HighlightingToken[]{padding, token, rest};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            Object[] objectArray = new HighlightingToken[]{padding, token};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return list;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lfleet/lang/intellij/common/TodoNodeExtender$Companion;", "", "<init>", "()V", "todoPattern", "Lkotlin/text/Regex;", "COMMENT_TODO", "Lfleet/com/intellij/psi/tree/IElementType;", "getCOMMENT_TODO", "()Lfleet/com/intellij/psi/tree/IElementType;", "fleet.plugins.ij.parsing.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IElementType getCOMMENT_TODO() {
            return COMMENT_TODO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

