/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.lang.quoteHandler;

import andel.text.Text;
import andel.text.TextFragmentCharSequence;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import fleet.ast.AST;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.frontend.lang.quoteHandler.AbstractSingleTokenAstQuoteHandler;
import fleet.frontend.lang.quoteHandler.AstQuoteHandler;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J&\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J&\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J&\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J(\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J \u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0015H&R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\u001f\u001a\u00020 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006#\u00b2\u0006\n\u0010$\u001a\u00020\u0015X\u008a\u0084\u0002"}, d2={"Lfleet/frontend/lang/quoteHandler/AbstractSingleTokenAstQuoteHandler;", "Lfleet/frontend/lang/quoteHandler/AstQuoteHandler;", "tokenTypes", "", "", "<init>", "(Ljava/util/List;)V", "getTokenTypes", "()Ljava/util/List;", "isOpeningQuote", "", "offset", "", "text", "Landel/text/Text;", "ast", "Lfleet/ast/AST;", "isClosingQuote", "missingClosingQuote", "isInsideLiteral", "getClosingQuote", "", "isMultiline", "leafOnOffset", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "getRangeToDeleteOnBackspace", "Lkotlin/ranges/LongRange;", "getOpenQuoteStrIfStartWith", "getCloseQuoteStrIfEndWith", "getCloseQuoteByOpen", "openQuote", "openQuoteMatcher", "Lkotlin/text/Regex;", "getOpenQuoteMatcher", "()Lkotlin/text/Regex;", "fleet.frontend.lang", "leafClosingQuote"})
public abstract class AbstractSingleTokenAstQuoteHandler
extends AstQuoteHandler {
    @NotNull
    private final List<Object> tokenTypes;

    public AbstractSingleTokenAstQuoteHandler(@NotNull List<? extends Object> tokenTypes) {
        Intrinsics.checkNotNullParameter(tokenTypes, (String)"tokenTypes");
        this.tokenTypes = tokenTypes;
    }

    @NotNull
    protected final List<Object> getTokenTypes() {
        return this.tokenTypes;
    }

    @Override
    public boolean isOpeningQuote(long offset, @NotNull Text text, @Nullable AST<?> ast2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (Boolean)this.withLeaf(offset, ast2, (Function1)new Function1<SyntaxNode, Boolean>(this, offset){
            final /* synthetic */ AbstractSingleTokenAstQuoteHandler this$0;
            final /* synthetic */ long $offset;
            {
                this.this$0 = $receiver;
                this.$offset = $offset;
                super(1);
            }

            public final Boolean invoke(SyntaxNode leafOnOffset) {
                if (leafOnOffset == null || !this.this$0.getTokenTypes().contains(leafOnOffset.getType())) {
                    return false;
                }
                String string = this.this$0.getOpenQuoteStrIfStartWith(leafOnOffset);
                if (string == null) {
                    return false;
                }
                String openQuote = string;
                long l = leafOnOffset.getStartOffset();
                return this.$offset < leafOnOffset.getStartOffset() + (long)openQuote.length() ? l <= this.$offset : false;
            }
        });
    }

    @Override
    public boolean isClosingQuote(long offset, @NotNull Text text, @Nullable AST<?> ast2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (Boolean)this.withLeaf(offset, ast2, (Function1)new Function1<SyntaxNode, Boolean>(this, offset){
            final /* synthetic */ AbstractSingleTokenAstQuoteHandler this$0;
            final /* synthetic */ long $offset;
            {
                this.this$0 = $receiver;
                this.$offset = $offset;
                super(1);
            }

            public final Boolean invoke(SyntaxNode leafOnOffset) {
                if (leafOnOffset == null || !this.this$0.getTokenTypes().contains(leafOnOffset.getType())) {
                    return false;
                }
                String string = this.this$0.getCloseQuoteStrIfEndWith(leafOnOffset);
                if (string == null) {
                    return false;
                }
                String closeQuote2 = string;
                long l = leafOnOffset.getEndOffset() - (long)closeQuote2.length();
                return this.$offset < leafOnOffset.getEndOffset() ? l <= this.$offset : false;
            }
        });
    }

    @Override
    public boolean missingClosingQuote(long offset, @NotNull Text text, @Nullable AST<?> ast2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (Boolean)this.withLeaf(offset, ast2, (Function1)new Function1<SyntaxNode, Boolean>(this, offset, text){
            final /* synthetic */ AbstractSingleTokenAstQuoteHandler this$0;
            final /* synthetic */ long $offset;
            final /* synthetic */ Text $text;
            {
                this.this$0 = $receiver;
                this.$offset = $offset;
                this.$text = $text;
                super(1);
            }

            public final Boolean invoke(SyntaxNode leafOnOffset) {
                if (leafOnOffset == null || !this.this$0.getTokenTypes().contains(leafOnOffset.getType())) {
                    return false;
                }
                String string = this.this$0.getOpenQuoteStrIfStartWith(leafOnOffset);
                if (string == null) {
                    return false;
                }
                String openQuoteStr = string;
                if (this.$offset + 1L != leafOnOffset.getStartOffset() + (long)openQuoteStr.length()) {
                    return false;
                }
                if (this.this$0.isMultiline(this.$offset, this.$text, leafOnOffset)) {
                    String closeQuoteStr = this.this$0.getCloseQuoteByOpen(openQuoteStr);
                    if (SyntaxNodeExtKt.getLength((SyntaxNode)leafOnOffset) >= (long)(openQuoteStr.length() + closeQuoteStr.length()) && StringsKt.endsWith$default((CharSequence)leafOnOffset.getText(), (CharSequence)closeQuoteStr, (boolean)false, (int)2, null)) {
                        TextFragmentCharSequence chars = TextViewExtKt.charSequence((TextView)this.$text.view());
                        boolean isOpen = true;
                        int startOffset2 = (int)leafOnOffset.getEndOffset();
                        String closeQuote2 = "";
                        while (true) {
                            if (isOpen) {
                                MatchResult occ = this.this$0.getOpenQuoteMatcher().find((CharSequence)chars, startOffset2);
                                if (occ == null) {
                                    return false;
                                }
                                closeQuote2 = this.this$0.getCloseQuoteByOpen(occ.getValue());
                                isOpen = false;
                                startOffset2 = occ.getRange().getLast() + 1;
                                continue;
                            }
                            int closeQuoteOffset = StringsKt.indexOf$default((CharSequence)((CharSequence)chars), (String)closeQuote2, (int)startOffset2, (boolean)false, (int)4, null);
                            if (closeQuoteOffset == -1) {
                                return true;
                            }
                            isOpen = true;
                            startOffset2 = closeQuoteOffset + closeQuote2.length();
                        }
                    }
                }
                long lineEndOffset = TextViewExtKt.textLines((TextView)this.$text.view(), (boolean)false).lineEndOffset(TextViewExtKt.textLines((TextView)this.$text.view(), (boolean)true).offsetToLineNumber(this.$offset));
                SyntaxNode leaf = leafOnOffset;
                while (leaf != null && leaf.getStartOffset() < lineEndOffset) {
                    if (this.this$0.getTokenTypes().contains(leaf.getType())) {
                        String leafOpenQuoteStr = this.this$0.getOpenQuoteStrIfStartWith(leaf);
                        Lazy leafClosingQuote$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this.this$0, leafOpenQuoteStr){
                            final /* synthetic */ AbstractSingleTokenAstQuoteHandler this$0;
                            final /* synthetic */ String $leafOpenQuoteStr;
                            {
                                this.this$0 = $receiver;
                                this.$leafOpenQuoteStr = $leafOpenQuoteStr;
                                super(0);
                            }

                            public final String invoke() {
                                String string = this.$leafOpenQuoteStr;
                                Intrinsics.checkNotNull((Object)string);
                                return this.this$0.getCloseQuoteByOpen(string);
                            }
                        }));
                        if (!(leafOpenQuoteStr == null || SyntaxNodeExtKt.getLength((SyntaxNode)leaf) >= (long)(leafOpenQuoteStr.length() + missingClosingQuote.1.invoke$lambda$0((Lazy<String>)leafClosingQuote$delegate).length()) && StringsKt.endsWith$default((CharSequence)leaf.getText(), (CharSequence)missingClosingQuote.1.invoke$lambda$0((Lazy<String>)leafClosingQuote$delegate), (boolean)false, (int)2, null))) {
                            return true;
                        }
                    }
                    leaf = SyntaxNodeExtKt.leafRight((SyntaxNode)leaf);
                }
                return false;
            }

            private static final String invoke$lambda$0(Lazy<String> $leafClosingQuote$delegate) {
                Lazy<String> lazy = $leafClosingQuote$delegate;
                return (String)lazy.getValue();
            }
        });
    }

    @Override
    public boolean isInsideLiteral(long offset, @NotNull Text text, @Nullable AST<?> ast2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (Boolean)this.withLeaf(offset, ast2, (Function1)new Function1<SyntaxNode, Boolean>(this){
            final /* synthetic */ AbstractSingleTokenAstQuoteHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(SyntaxNode leafOnOffset) {
                return leafOnOffset != null && this.this$0.getTokenTypes().contains(leafOnOffset.getType());
            }
        });
    }

    @Override
    @Nullable
    public String getClosingQuote(long offset, @NotNull Text text, @Nullable AST<?> ast2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (String)this.withLeaf(offset, ast2, (Function1)new Function1<SyntaxNode, String>(this){
            final /* synthetic */ AbstractSingleTokenAstQuoteHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final String invoke(SyntaxNode leafOnOffset) {
                String string;
                if (leafOnOffset == null || !this.this$0.getTokenTypes().contains(leafOnOffset.getType())) {
                    return null;
                }
                String string2 = this.this$0.getOpenQuoteStrIfStartWith(leafOnOffset);
                if (string2 != null) {
                    String string3 = string2;
                    AbstractSingleTokenAstQuoteHandler abstractSingleTokenAstQuoteHandler = this.this$0;
                    String it = string3;
                    boolean bl = false;
                    string = abstractSingleTokenAstQuoteHandler.getCloseQuoteByOpen(it);
                } else {
                    string = null;
                }
                return string;
            }
        });
    }

    @Override
    public boolean isMultiline(long offset, @NotNull Text text, @NotNull SyntaxNode leafOnOffset) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)leafOnOffset, (String)"leafOnOffset");
        return false;
    }

    @Override
    @Nullable
    public LongRange getRangeToDeleteOnBackspace(long offset, @NotNull Text text, @Nullable AST<?> ast2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (LongRange)this.withLeaf(offset, ast2, (Function1)new Function1<SyntaxNode, LongRange>(this, offset){
            final /* synthetic */ AbstractSingleTokenAstQuoteHandler this$0;
            final /* synthetic */ long $offset;
            {
                this.this$0 = $receiver;
                this.$offset = $offset;
                super(1);
            }

            public final LongRange invoke(SyntaxNode leafOnOffset) {
                if (leafOnOffset == null || !this.this$0.getTokenTypes().contains(leafOnOffset.getType())) {
                    return null;
                }
                String string = this.this$0.getOpenQuoteStrIfStartWith(leafOnOffset);
                if (string == null) {
                    return null;
                }
                String openQuote = string;
                if (this.$offset != leafOnOffset.getStartOffset() + (long)openQuote.length()) {
                    return null;
                }
                String closeQuote2 = this.this$0.getCloseQuoteByOpen(openQuote);
                if (Intrinsics.areEqual((Object)((Object)leafOnOffset.getText()).toString(), (Object)(openQuote + closeQuote2))) {
                    return RangesKt.until((long)leafOnOffset.getStartOffset(), (long)leafOnOffset.getEndOffset());
                }
                return null;
            }
        });
    }

    @Nullable
    public abstract String getOpenQuoteStrIfStartWith(@NotNull SyntaxNode var1);

    @Nullable
    public abstract String getCloseQuoteStrIfEndWith(@NotNull SyntaxNode var1);

    @NotNull
    public abstract String getCloseQuoteByOpen(@NotNull String var1);

    @NotNull
    public abstract Regex getOpenQuoteMatcher();
}

