/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.lang;

import andel.editor.Caret;
import andel.editor.CaretPosition;
import andel.editor.Document;
import andel.editor.EditorCommandType;
import andel.editor.EditorExtKt;
import andel.editor.EditorLayout;
import andel.editor.EditorScrollCommand;
import andel.editor.EditorScrollKind;
import andel.editor.MutableDocument;
import andel.editor.MutableEditor;
import andel.text.Codepoint;
import andel.text.CodepointKt;
import andel.text.NavigationKt;
import andel.text.Text;
import andel.text.TextFragmentCharSequence;
import andel.text.TextLine;
import andel.text.TextRange;
import andel.text.TextRangeKt;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import andel.undo.UndoScope;
import com.jetbrains.rhizomedb.DbContext;
import fleet.api.workspace.document.LanguageId;
import fleet.ast.AST;
import fleet.ast.NodeAspect;
import fleet.ast.NodeAspectId;
import fleet.ast.NodeAspectMap;
import fleet.ast.NodeWithAspect;
import fleet.ast.SyntaxDocumentComponentKt;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.frontend.lang.BraceNodeAspect;
import fleet.frontend.lang.ContextLeafChooser;
import fleet.frontend.lang.LangApiKt;
import fleet.frontend.lang.LanguageExtensionPointsKt;
import fleet.frontend.lang.LanguageSelection;
import fleet.frontend.lang.NodeTypesKt;
import fleet.frontend.lang.PresentableNodeAspect;
import fleet.frontend.lang.StructuralNavigationKt;
import fleet.frontend.lang.StructuralSelectionKt;
import fleet.frontend.lang.ValueNodeAspect;
import fleet.frontend.lang.WordNodeAspect;
import fleet.frontend.lang.aspects.IJNodeAspect;
import fleet.frontend.language.LanguageIdDocumentMetaKey;
import fleet.frontend.language.LanguageKt;
import fleet.util.CollectionsUtilKt;
import fleet.util.CounterKt;
import fleet.util.openmap.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import noria.model.components.editor.CaretActionsKt;
import noria.model.components.editor.Direction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0003H\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u0001*\u00020\u00012\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\f\u001a\u00020\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0002\u001a,\u0010\u0011\u001a\u00020\u0001*\u00020\u00012\n\u0010\u0012\u001a\u00060\bj\u0002`\t2\n\u0010\u0013\u001a\u00060\bj\u0002`\t2\u0006\u0010\u0014\u001a\u00020\rH\u0002\u001a8\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002\u001a4\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\rH\u0002\u001a\u001a\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0017H\u0002\u001a0\u0010$\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\rH\u0002\u001a \u0010%\u001a\u00060\bj\u0002`\t2\u0006\u0010\u001b\u001a\u00020&2\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002\u001a\u0012\u0010'\u001a\u00020(*\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0005\u001a\u0012\u0010)\u001a\u00020(*\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0005\u001a\u0012\u0010*\u001a\u00020(*\u00020\u000e2\u0006\u0010+\u001a\u00020,\u001a\u0014\u0010-\u001a\u00020(*\u00020\u000e2\b\b\u0002\u0010\u001d\u001a\u00020\u0005\u001a\u0012\u0010.\u001a\u00020(*\u00020\u000e2\u0006\u0010+\u001a\u00020,\u001aF\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u0001002\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010+\u001a\u00020,2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\f\u00102\u001a\b\u0012\u0004\u0012\u00020103H\u0002\u00a8\u00064"}, d2={"repeatUntil", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "step", "Lkotlin/Function1;", "condition", "", "contextLeaf", "offset", "", "Landel/text/CharOffset;", "chooser", "Lfleet/frontend/lang/ContextLeafChooser;", "getLanguageSelection", "Lfleet/frontend/lang/LanguageSelection;", "Landel/editor/MutableEditor;", "ast", "Lfleet/ast/AST;", "lowestDescendantContainingRange", "start", "end", "languageSelection", "rangesAtOffset", "", "Landel/text/TextRange;", "tree", "caret", "Landel/editor/CaretPosition;", "document", "Landel/editor/MutableDocument;", "honorCamelHumps", "nodeRangesAtOffset", "", "expandToFullLines", "text", "Landel/text/Text;", "range", "adjacentLinesBlock", "firstCharInLineOffset", "Landel/editor/Document;", "expandSelection", "", "shrinkSelection", "structuralNavigation", "direction", "Lnoria/model/components/editor/Direction;", "selectWord", "gotoNextSymbol", "findNextSymbol", "Lfleet/ast/NodeWithAspect;", "Lfleet/frontend/lang/PresentableNodeAspect;", "aspectMap", "Lfleet/ast/NodeAspectMap;", "fleet.frontend.lang"})
@SourceDebugExtension(value={"SMAP\nStructuralSelection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructuralSelection.kt\nfleet/frontend/lang/StructuralSelectionKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 LanguageExtensionPoints.kt\nfleet/frontend/lang/LanguageExtensionPointsKt\n+ 5 NodeAspects.kt\nfleet/frontend/lang/aspects/NodeAspectsKt\n*L\n1#1,421:1\n183#2,2:422\n320#2,3:444\n323#2,4:454\n1663#3,8:424\n774#3:432\n865#3,2:433\n1053#3:435\n1797#3,3:440\n60#4:436\n60#4:438\n60#4:443\n15#5:437\n15#5:439\n19#5:447\n15#5,6:448\n19#5:458\n15#5,6:459\n*S KotlinDebug\n*F\n+ 1 StructuralSelection.kt\nfleet/frontend/lang/StructuralSelectionKt\n*L\n22#1:422,2\n403#1:444,3\n403#1:454,4\n110#1:424,8\n110#1:432\n110#1:433,2\n110#1:435\n233#1:440,3\n135#1:436\n139#1:438\n359#1:443\n135#1:437\n143#1:439\n403#1:447\n403#1:448,6\n383#1:458\n383#1:459,6\n*E\n"})
public final class StructuralSelectionKt {
    private static final SyntaxNode repeatUntil(SyntaxNode $this$repeatUntil, Function1<? super SyntaxNode, ? extends SyntaxNode> step, Function1<? super SyntaxNode, Boolean> condition) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.drop((Sequence)SequencesKt.generateSequence((Object)$this$repeatUntil, step), (int)1);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                if (!((Boolean)condition.invoke(element$iv)).booleanValue()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final SyntaxNode contextLeaf(@NotNull SyntaxNode $this$contextLeaf, long offset, @NotNull ContextLeafChooser chooser) {
        Intrinsics.checkNotNullParameter((Object)$this$contextLeaf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)chooser, (String)"chooser");
        SyntaxNode leafBefore = SyntaxNodeExtKt.leafByOffset((SyntaxNode)$this$contextLeaf, (long)(offset - 1L));
        SyntaxNode leafAfter = SyntaxNodeExtKt.leafByOffset((SyntaxNode)$this$contextLeaf, (long)offset);
        SyntaxNode syntaxNode = chooser.chooseContextLeaf(leafBefore, leafAfter);
        if (syntaxNode == null) {
            syntaxNode = $this$contextLeaf;
        }
        return syntaxNode;
    }

    private static final LanguageSelection getLanguageSelection(MutableEditor $this$getLanguageSelection, AST<?> ast2) {
        Object object;
        SyntaxNode syntaxNode = ast2;
        Object object2 = object = syntaxNode != null && (syntaxNode = syntaxNode.root()) != null ? syntaxNode.getLanguage() : null;
        LanguageId languageId = object instanceof LanguageId ? (LanguageId)object : null;
        if (languageId == null) {
            languageId = (LanguageId)$this$getLanguageSelection.getDocument().getMeta().get((Key)LanguageIdDocumentMetaKey.INSTANCE);
        }
        LanguageId languageId2 = languageId;
        return LangApiKt.languageSelection(languageId2);
    }

    private static final SyntaxNode lowestDescendantContainingRange(SyntaxNode $this$lowestDescendantContainingRange, long start, long end, LanguageSelection languageSelection) {
        if (start == end) {
            return StructuralSelectionKt.contextLeaf($this$lowestDescendantContainingRange, start, languageSelection);
        }
        return (SyntaxNode)SequencesKt.last((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)$this$lowestDescendantContainingRange, (Function1)((Function1)new Function1<SyntaxNode, SyntaxNode>(start){
            final /* synthetic */ long $start;
            {
                this.$start = $start;
                super(1);
            }

            public final SyntaxNode invoke(SyntaxNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.childByOffset(this.$start);
            }
        })), (Function1)((Function1)new Function1<SyntaxNode, Boolean>(end){
            final /* synthetic */ long $end;
            {
                this.$end = $end;
                super(1);
            }

            public final Boolean invoke(SyntaxNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getEndOffset() >= this.$end;
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TextRange> rangesAtOffset(SyntaxNode tree, CaretPosition caret, MutableDocument document2, LanguageSelection languageSelection, boolean honorCamelHumps) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$distinctBy$iv;
        Iterable iterable;
        List $this$rangesAtOffset_u24lambda_u241 = iterable = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$rangesAtOffset_u24lambda_u241.add(new TextRange(caret.getOffset(), caret.getOffset()));
        $this$rangesAtOffset_u24lambda_u241.add(NavigationKt.textAround((CaretPosition)caret, (MutableDocument)document2, (boolean)honorCamelHumps));
        $this$rangesAtOffset_u24lambda_u241.addAll((Collection)StructuralSelectionKt.nodeRangesAtOffset(document2, caret.getOffset(), tree, languageSelection));
        TextRange textRange = StructuralSelectionKt.adjacentLinesBlock(document2, caret.getOffset(), tree, languageSelection);
        if (textRange != null) {
            TextRange it = textRange;
            boolean bl2 = false;
            $this$rangesAtOffset_u24lambda_u241.add(it);
        }
        iterable = CollectionsKt.build((List)iterable);
        boolean $i$f$distinctBy = false;
        HashSet<Long> set$iv = new HashSet<Long>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            TextRange it = (TextRange)e$iv;
            boolean bl3 = false;
            Long key$iv = it.getLength();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$filter = false;
        set$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextRange it = (TextRange)element$iv$iv;
            boolean bl4 = false;
            long l = it.getStart();
            long l2 = it.getEnd();
            long l3 = caret.getOffset();
            boolean bl5 = l <= l3 ? l3 <= l2 : false;
            if (!bl5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TextRange it = (TextRange)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getLength());
                it = (TextRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getLength()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TextRange> nodeRangesAtOffset(MutableDocument document2, long offset, SyntaxNode tree, LanguageSelection languageSelection) {
        List nodeRanges = new ArrayList();
        TextFragmentCharSequence chars = TextViewExtKt.charSequence((TextView)document2.getText().view());
        if (tree == null) {
            nodeRanges.add(new TextRange(0, chars.length()));
            return nodeRanges;
        }
        LanguageId languageId = LanguageKt.getLanguageId((MutableDocument)document2);
        long firstLeafOffset = ((Number)((Object)CollectionsUtilKt.max((Comparable)Long.valueOf(offset), (Comparable)Long.valueOf(StructuralSelectionKt.firstCharInLineOffset((Document)document2, offset))))).longValue();
        Sequence nodes2 = SequencesKt.filter((Sequence)SyntaxNodeExtKt.ancestors$default((SyntaxNode)StructuralSelectionKt.contextLeaf(tree, firstLeafOffset, languageSelection), (boolean)false, (int)1, null), (Function1)((Function1)new Function1<SyntaxNode, Boolean>((Object)languageSelection){

            public final Boolean invoke(SyntaxNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((LanguageSelection)this.receiver).isSelectable(p0);
            }
        }));
        for (SyntaxNode node : nodes2) {
            boolean bl;
            TextRange nodeRange = new TextRange(node.getStartOffset(), node.getEndOffset());
            if (DbContext.Companion.isBound() && languageId != null) {
                ValueNodeAspect valueNodeAspect;
                NodeAspect nodeAspect;
                void $this$getAspect$iv;
                SyntaxNode syntaxNode = node;
                NodeAspectId aspect$iv = ValueNodeAspect.Companion;
                boolean $i$f$getAspectMap = false;
                NodeAspectMap aspectMap$iv = LanguageExtensionPointsKt.getAspectMap(aspect$iv, Reflection.getOrCreateKotlinClass(ValueNodeAspect.class));
                boolean $i$f$getAspect = false;
                Object object = $this$getAspect$iv.getType();
                if (!(object instanceof ValueNodeAspect)) {
                    object = null;
                }
                if ((nodeAspect = (NodeAspect)((ValueNodeAspect)object)) == null) {
                    nodeAspect = aspectMap$iv.get($this$getAspect$iv.getType());
                }
                if ((valueNodeAspect = (ValueNodeAspect)nodeAspect) != null && (valueNodeAspect = valueNodeAspect.valueTextRange(node)) != null) {
                    ValueNodeAspect range = valueNodeAspect;
                    boolean bl2 = false;
                    if (range.contains(offset)) {
                        nodeRanges.add(range);
                    }
                }
                NodeAspectId aspect$iv2 = BraceNodeAspect.Id;
                boolean $i$f$getAspectMap2 = false;
                NodeAspectMap bracesAspect = LanguageExtensionPointsKt.getAspectMap(aspect$iv2, Reflection.getOrCreateKotlinClass(BraceNodeAspect.class));
                SyntaxNode left = SyntaxNodeExtKt.firstLeaf((SyntaxNode)node);
                SyntaxNode right = SyntaxNodeExtKt.lastLeaf((SyntaxNode)node);
                if (!Intrinsics.areEqual((Object)left, (Object)right)) {
                    BraceNodeAspect braceNodeAspect;
                    boolean $i$f$getAspect2;
                    if (left != null) {
                        NodeAspect nodeAspect2;
                        SyntaxNode $this$getAspect$iv2;
                        $i$f$getAspect2 = false;
                        Object object2 = $this$getAspect$iv2.getType();
                        if (!(object2 instanceof BraceNodeAspect)) {
                            object2 = null;
                        }
                        if ((nodeAspect2 = (NodeAspect)((BraceNodeAspect)object2)) == null) {
                            nodeAspect2 = bracesAspect.get($this$getAspect$iv2.getType());
                        }
                        braceNodeAspect = (BraceNodeAspect)nodeAspect2;
                    } else {
                        braceNodeAspect = null;
                    }
                    if (braceNodeAspect != null) {
                        BraceNodeAspect braceNodeAspect2;
                        if (right != null) {
                            NodeAspect nodeAspect3;
                            SyntaxNode $this$getAspect$iv3;
                            $i$f$getAspect2 = false;
                            Object object3 = $this$getAspect$iv3.getType();
                            if (!(object3 instanceof BraceNodeAspect)) {
                                object3 = null;
                            }
                            if ((nodeAspect3 = (NodeAspect)((BraceNodeAspect)object3)) == null) {
                                nodeAspect3 = bracesAspect.get($this$getAspect$iv3.getType());
                            }
                            braceNodeAspect2 = (BraceNodeAspect)nodeAspect3;
                        } else {
                            braceNodeAspect2 = null;
                        }
                        if (braceNodeAspect2 != null) {
                            long leftOffset = left.getEndOffset();
                            while (leftOffset < (long)(chars.length() - 1) && CharsKt.isWhitespace((char)chars.get(leftOffset))) {
                                long l = leftOffset;
                                leftOffset = l + 1L;
                            }
                            long rightOffset = right.getStartOffset();
                            while (rightOffset > 0L && CharsKt.isWhitespace((char)chars.get(rightOffset - 1L))) {
                                long l = rightOffset;
                                rightOffset = l + -1L;
                            }
                            if (leftOffset < rightOffset) {
                                TextRange range = new TextRange(leftOffset, rightOffset);
                                TextRange textRange = StructuralSelectionKt.expandToFullLines(document2.getText(), range);
                                if (textRange == null) {
                                    textRange = range;
                                }
                                v10 = nodeRanges.add(textRange);
                            } else {
                                v10 = nodeRanges.add(new TextRange(left.getEndOffset(), right.getStartOffset()));
                            }
                        }
                    }
                }
            }
            if (Intrinsics.areEqual((Object)CollectionsKt.lastOrNull((List)nodeRanges), (Object)nodeRange)) continue;
            TextRange fullLinesRange = StructuralSelectionKt.expandToFullLines(document2.getText(), nodeRange);
            if (fullLinesRange != null) {
                TextLine startLine = TextViewExtKt.textLineAtOffset$default((TextView)document2.getText().view(), (int)((int)nodeRange.getStart()), (boolean)false, (int)2, null);
                TextLine endLine = TextViewExtKt.textLineAtOffset$default((TextView)document2.getText().view(), (int)((int)nodeRange.getEnd()), (boolean)false, (int)2, null);
                if (startLine.getLineNumber() == endLine.getLineNumber()) {
                    nodeRanges.add(nodeRange);
                }
                bl = nodeRanges.add(fullLinesRange);
                continue;
            }
            bl = nodeRanges.add(nodeRange);
        }
        return nodeRanges;
    }

    private static final TextRange expandToFullLines(Text text, TextRange range) {
        TextView textView = text.view();
        int rangeStartLine = textView.lineAt-fZAJ6bk((int)range.getStart());
        int rangeEndLine = textView.lineAt-fZAJ6bk((int)range.getEnd());
        int startLineStart = textView.lineStartOffset-8njyGSM(rangeStartLine);
        int endLineEnd = TextViewExtKt.lineEndOffset-g54jA0s((TextView)textView, (int)rangeEndLine, (boolean)true);
        TextRange linesRange = new TextRange(startLineStart, endLineEnd);
        String prefix = text.view().string((int)linesRange.getStart(), (int)range.getStart());
        String suffix = text.view().string((int)range.getEnd(), (int)linesRange.getEnd());
        return StringsKt.isBlank((CharSequence)prefix) && StringsKt.isBlank((CharSequence)suffix) ? linesRange : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final TextRange adjacentLinesBlock(MutableDocument document2, long offset, SyntaxNode tree, LanguageSelection languageSelection) {
        void $this$fold$iv;
        TextLine nextLine;
        TextLine prevLine;
        Text text = document2.getText();
        List allRanges = new ArrayList();
        TextLine curLine = TextViewExtKt.textLineAtOffset$default((TextView)text.view(), (int)((int)offset), (boolean)false, (int)2, null);
        if (StringsKt.isBlank((CharSequence)curLine.toString())) {
            return null;
        }
        allRanges.addAll((Collection)StructuralSelectionKt.nodeRangesAtOffset(document2, curLine.getFromChar(), tree, languageSelection));
        TextLine blockStartLine = curLine;
        while ((prevLine = blockStartLine.prev()) != null && !StringsKt.isBlank((CharSequence)prevLine.toString())) {
            blockStartLine = prevLine;
        }
        if (blockStartLine.getLineNumber() != curLine.getLineNumber()) {
            allRanges.addAll((Collection)StructuralSelectionKt.nodeRangesAtOffset(document2, blockStartLine.getFromChar(), tree, languageSelection));
        }
        TextLine blockEndLine = curLine;
        while ((nextLine = blockEndLine.next()) != null && !StringsKt.isBlank((CharSequence)nextLine.toString())) {
            blockEndLine = nextLine;
        }
        if (blockEndLine.getLineNumber() != curLine.getLineNumber()) {
            allRanges.addAll((Collection)StructuralSelectionKt.nodeRangesAtOffset(document2, blockEndLine.getFromChar(), tree, languageSelection));
        }
        Iterable iterable = allRanges;
        TextRange initial$iv = new TextRange(blockStartLine.getFromChar(), blockEndLine.getToCharIncludingSeparator());
        boolean $i$f$fold = false;
        TextRange accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void b;
            TextRange textRange = (TextRange)element$iv;
            TextRange a = accumulator$iv;
            boolean bl = false;
            accumulator$iv = !a.contains((TextRange)b) && !b.contains(a) && TextRangeKt.intersectsStrict((TextRange)a, (TextRange)b) ? (a.getStart() < b.getStart() ? (offset < b.getStart() ? new TextRange(a.getStart(), b.getStart()) : new TextRange(b.getStart(), a.getEnd())) : (offset < b.getEnd() ? new TextRange(a.getStart(), b.getEnd()) : new TextRange(b.getEnd(), a.getEnd()))) : a;
        }
        TextRange blockRange = accumulator$iv;
        return blockRange;
    }

    private static final long firstCharInLineOffset(Document document2, long offset) {
        int codepoint;
        TextView text = document2.getText().view();
        int lineNumber = text.lineAt-fZAJ6bk((int)offset);
        int lineStart = text.lineStartOffset-8njyGSM(lineNumber);
        Iterator cursor = CodepointKt.codepoints((CharSequence)((CharSequence)TextViewExtKt.charSequence((TextView)text)), (int)lineStart, (andel.text.Direction)andel.text.Direction.FORWARD);
        int charOffset = lineStart;
        Iterator iterator = cursor;
        while (iterator.hasNext() && Character.isSpaceChar(codepoint = ((Codepoint)iterator.next()).unbox-impl())) {
            charOffset += Codepoint.getCharCount-impl((int)codepoint);
        }
        return charOffset;
    }

    public static final void expandSelection(@NotNull MutableEditor $this$expandSelection, boolean honorCamelHumps) {
        Intrinsics.checkNotNullParameter((Object)$this$expandSelection, (String)"<this>");
        MutableEditor.command$default((MutableEditor)$this$expandSelection, (EditorCommandType)EditorCommandType.NAVIGATION, null, (Function1)((Function1)new Function1<UndoScope, Unit>($this$expandSelection, honorCamelHumps){
            final /* synthetic */ MutableEditor $this_expandSelection;
            final /* synthetic */ boolean $honorCamelHumps;
            {
                this.$this_expandSelection = $receiver;
                this.$honorCamelHumps = $honorCamelHumps;
                super(1);
            }

            public final void invoke(UndoScope $this$command) {
                Intrinsics.checkNotNullParameter((Object)$this$command, (String)"$this$command");
                EditorExtKt.moveAllCarets((MutableEditor)this.$this_expandSelection, (Function1)((Function1)new Function1<Caret, Caret>(this.$this_expandSelection, this.$honorCamelHumps){
                    final /* synthetic */ MutableEditor $this_expandSelection;
                    final /* synthetic */ boolean $honorCamelHumps;
                    {
                        this.$this_expandSelection = $receiver;
                        this.$honorCamelHumps = $honorCamelHumps;
                        super(1);
                    }

                    public final Caret invoke(Caret caret) {
                        Object v1;
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                            AST ast2 = SyntaxDocumentComponentKt.getActualAstAtOffset((MutableEditor)this.$this_expandSelection, (long)caret.getOffset(), (long)caret.getPosition().getSelectionStart(), (long)caret.getPosition().getSelectionEnd());
                            LanguageSelection languageSelection = StructuralSelectionKt.access$getLanguageSelection(this.$this_expandSelection, ast2);
                            AST aST = ast2;
                            List ranges = StructuralSelectionKt.access$rangesAtOffset((SyntaxNode)(aST != null ? aST.root() : null), caret.getPosition(), this.$this_expandSelection.getDocument(), languageSelection, this.$honorCamelHumps);
                            Iterable $this$firstOrNull$iv = ranges;
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                TextRange it = (TextRange)element$iv;
                                boolean bl = false;
                                if (!(it.getLength() > caret.getSelection().getLength() && it.contains(caret.getSelection()))) continue;
                                v1 = element$iv;
                                break block1;
                            }
                            v1 = null;
                        }
                        TextRange next = v1;
                        return next != null ? caret.move(new CaretPosition(caret.getOffset(), next.getStart(), next.getEnd()), caret.getVCol()) : caret;
                    }
                }));
            }
        }), (int)2, null);
        $this$expandSelection.addHistoryPlace();
    }

    public static final void shrinkSelection(@NotNull MutableEditor $this$shrinkSelection, boolean honorCamelHumps) {
        Intrinsics.checkNotNullParameter((Object)$this$shrinkSelection, (String)"<this>");
        MutableEditor.command$default((MutableEditor)$this$shrinkSelection, (EditorCommandType)EditorCommandType.NAVIGATION, null, (Function1)((Function1)new Function1<UndoScope, Unit>($this$shrinkSelection, honorCamelHumps){
            final /* synthetic */ MutableEditor $this_shrinkSelection;
            final /* synthetic */ boolean $honorCamelHumps;
            {
                this.$this_shrinkSelection = $receiver;
                this.$honorCamelHumps = $honorCamelHumps;
                super(1);
            }

            public final void invoke(UndoScope $this$command) {
                Intrinsics.checkNotNullParameter((Object)$this$command, (String)"$this$command");
                EditorExtKt.moveAllCarets((MutableEditor)this.$this_shrinkSelection, (Function1)((Function1)new Function1<Caret, Caret>(this.$this_shrinkSelection, this.$honorCamelHumps){
                    final /* synthetic */ MutableEditor $this_shrinkSelection;
                    final /* synthetic */ boolean $honorCamelHumps;
                    {
                        this.$this_shrinkSelection = $receiver;
                        this.$honorCamelHumps = $honorCamelHumps;
                        super(1);
                    }

                    public final Caret invoke(Caret caret) {
                        Object v1;
                        block1: {
                            List ranges;
                            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                            AST ast2 = SyntaxDocumentComponentKt.getActualAstAtOffset((MutableEditor)this.$this_shrinkSelection, (long)caret.getOffset(), (long)caret.getPosition().getSelectionStart(), (long)caret.getPosition().getSelectionEnd());
                            LanguageSelection languageSelection = StructuralSelectionKt.access$getLanguageSelection(this.$this_shrinkSelection, ast2);
                            AST aST = ast2;
                            List $this$lastOrNull$iv = ranges = StructuralSelectionKt.access$rangesAtOffset((SyntaxNode)(aST != null ? aST.root() : null), caret.getPosition(), this.$this_shrinkSelection.getDocument(), languageSelection, this.$honorCamelHumps);
                            boolean $i$f$lastOrNull = false;
                            ListIterator<E> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                            while (iterator$iv.hasPrevious()) {
                                E element$iv = iterator$iv.previous();
                                TextRange it = (TextRange)element$iv;
                                boolean bl = false;
                                if (!(it.getLength() < caret.getSelection().getLength() && caret.getSelection().contains(it))) continue;
                                v1 = element$iv;
                                break block1;
                            }
                            v1 = null;
                        }
                        TextRange next = v1;
                        return next != null ? caret.move(new CaretPosition(caret.getOffset(), next.getStart(), next.getEnd()), caret.getVCol()) : caret;
                    }
                }));
            }
        }), (int)2, null);
        $this$shrinkSelection.addHistoryPlace();
    }

    public static final void structuralNavigation(@NotNull MutableEditor $this$structuralNavigation, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)$this$structuralNavigation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        if (!((Collection)SyntaxDocumentComponentKt.getSyntaxDocumentComponents((MutableDocument)$this$structuralNavigation.getDocument())).isEmpty()) {
            MutableEditor.command$default((MutableEditor)$this$structuralNavigation, (EditorCommandType)EditorCommandType.NAVIGATION, null, (Function1)((Function1)new Function1<UndoScope, Unit>($this$structuralNavigation, direction){
                final /* synthetic */ MutableEditor $this_structuralNavigation;
                final /* synthetic */ Direction $direction;
                {
                    this.$this_structuralNavigation = $receiver;
                    this.$direction = $direction;
                    super(1);
                }

                public final void invoke(UndoScope $this$command) {
                    Intrinsics.checkNotNullParameter((Object)$this$command, (String)"$this$command");
                    EditorExtKt.moveAllCarets((MutableEditor)this.$this_structuralNavigation, (Function1)((Function1)new Function1<Caret, Caret>(this.$this_structuralNavigation, this.$direction){
                        final /* synthetic */ MutableEditor $this_structuralNavigation;
                        final /* synthetic */ Direction $direction;
                        {
                            this.$this_structuralNavigation = $receiver;
                            this.$direction = $direction;
                            super(1);
                        }

                        public final Caret invoke(Caret caret) {
                            Long targetCharOffset2;
                            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                            AST aST = SyntaxDocumentComponentKt.getActualAstAtOffset((MutableEditor)this.$this_structuralNavigation, (long)caret.getOffset(), (long)caret.getPosition().getSelectionStart(), (long)caret.getPosition().getSelectionEnd());
                            Intrinsics.checkNotNull((Object)aST);
                            AST ast2 = aST;
                            LanguageSelection languageSelection = StructuralSelectionKt.access$getLanguageSelection(this.$this_structuralNavigation, ast2);
                            SyntaxNode currentLeaf = StructuralSelectionKt.access$lowestDescendantContainingRange(ast2.root(), caret.getPosition().getOffset(), caret.getPosition().getOffset(), languageSelection);
                            SyntaxNode syntaxNode = (SyntaxNode)SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)SyntaxNodeExtKt.ancestors$default((SyntaxNode)currentLeaf, (boolean)false, (int)1, null), (Function1)((Function1)new Function1<SyntaxNode, Boolean>(caret){
                                final /* synthetic */ Caret $caret;
                                {
                                    this.$caret = $caret;
                                    super(1);
                                }

                                public final Boolean invoke(SyntaxNode it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    return it.getStartOffset() == this.$caret.getPosition().getOffset() || it.getEndOffset() == this.$caret.getPosition().getOffset();
                                }
                            })));
                            if (syntaxNode == null) {
                                syntaxNode = currentLeaf;
                            }
                            SyntaxNode currentElement2 = syntaxNode;
                            Long l = targetCharOffset2 = (switch (structuralNavigation.WhenMappings.$EnumSwitchMapping$0[this.$direction.ordinal()]) {
                                case 1 -> {
                                    if (caret.getPosition().getOffset() == currentElement2.getEndOffset()) {
                                        SyntaxNode v2 = StructuralSelectionKt.access$repeatUntil(currentElement2, structuralNavigation.targetCharOffset.1.INSTANCE, (Function1)new Function1<SyntaxNode, Boolean>((Object)languageSelection){

                                            public final Boolean invoke(SyntaxNode p0) {
                                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                                return ((LanguageSelection)this.receiver).isSelectable(p0);
                                            }
                                        });
                                        if (v2 != null) {
                                            yield v2.getEndOffset();
                                        }
                                        yield null;
                                    }
                                    yield currentElement2.getEndOffset();
                                }
                                case 2 -> {
                                    if (caret.getPosition().getOffset() == currentElement2.getStartOffset()) {
                                        SyntaxNode v4 = StructuralSelectionKt.access$repeatUntil(currentElement2, structuralNavigation.targetCharOffset.3.INSTANCE, (Function1)new Function1<SyntaxNode, Boolean>((Object)languageSelection){

                                            public final Boolean invoke(SyntaxNode p0) {
                                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                                return ((LanguageSelection)this.receiver).isSelectable(p0);
                                            }
                                        });
                                        if (v4 != null) {
                                            yield v4.getStartOffset();
                                        }
                                        yield null;
                                    }
                                    yield currentElement2.getStartOffset();
                                }
                                case 3 -> {
                                    SyntaxNode v5 = currentElement2.parent();
                                    if (v5 != null) {
                                        yield v5.getStartOffset();
                                    }
                                    yield null;
                                }
                                case 4 -> {
                                    if (currentLeaf.getEndOffset() == caret.getPosition().getOffset()) {
                                        SyntaxNode v6 = StructuralSelectionKt.access$repeatUntil(currentElement2, structuralNavigation.targetCharOffset.5.INSTANCE, (Function1)new Function1<SyntaxNode, Boolean>((Object)languageSelection){

                                            public final Boolean invoke(SyntaxNode p0) {
                                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                                return ((LanguageSelection)this.receiver).isSelectable(p0);
                                            }
                                        });
                                        if (v6 != null) {
                                            yield v6.getEndOffset();
                                        }
                                        yield null;
                                    }
                                    yield currentLeaf.getEndOffset();
                                }
                                default -> throw new NoWhenBranchMatchedException();
                            });
                            return Caret.move$default((Caret)caret, (CaretPosition)new CaretPosition(l != null ? l.longValue() : caret.getPosition().getOffset()), null, (int)2, null);
                        }
                    }));
                }
            }), (int)2, null);
            $this$structuralNavigation.addHistoryPlace();
        }
    }

    public static final void selectWord(@NotNull MutableEditor $this$selectWord, boolean honorCamelHumps) {
        Intrinsics.checkNotNullParameter((Object)$this$selectWord, (String)"<this>");
        MutableEditor.command$default((MutableEditor)$this$selectWord, (EditorCommandType)EditorCommandType.NAVIGATION, null, (Function1)((Function1)new Function1<UndoScope, Unit>($this$selectWord, honorCamelHumps){
            final /* synthetic */ MutableEditor $this_selectWord;
            final /* synthetic */ boolean $honorCamelHumps;
            {
                this.$this_selectWord = $receiver;
                this.$honorCamelHumps = $honorCamelHumps;
                super(1);
            }

            public final void invoke(UndoScope $this$command) {
                Intrinsics.checkNotNullParameter((Object)$this$command, (String)"$this$command");
                EditorExtKt.moveAllCarets((MutableEditor)this.$this_selectWord, (Function1)((Function1)new Function1<Caret, Caret>(this.$this_selectWord, this.$honorCamelHumps){
                    final /* synthetic */ MutableEditor $this_selectWord;
                    final /* synthetic */ boolean $honorCamelHumps;
                    {
                        this.$this_selectWord = $receiver;
                        this.$honorCamelHumps = $honorCamelHumps;
                        super(1);
                    }

                    public final Caret invoke(Caret caret) {
                        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                        AST aST = SyntaxDocumentComponentKt.getActualAstAtOffset((MutableEditor)this.$this_selectWord, (long)caret.getOffset(), (long)caret.getPosition().getSelectionStart(), (long)caret.getPosition().getSelectionEnd());
                        SyntaxNode root = aST != null ? aST.root() : null;
                        NodeAspectId aspect$iv = WordNodeAspect.INSTANCE;
                        boolean $i$f$getAspectMap = false;
                        NodeAspectMap<A> aspectMap = LanguageExtensionPointsKt.getAspectMap(aspect$iv, Reflection.getOrCreateKotlinClass(WordNodeAspect.class));
                        TextRange word = StructuralNavigationKt.wordAround(root, aspectMap, caret.getOffset(), this.$this_selectWord.getDocument().getText(), this.$honorCamelHumps);
                        return caret.move(new CaretPosition(word.getEnd(), word.getStart(), word.getEnd()), caret.getVCol());
                    }
                }));
            }
        }), (int)2, null);
        $this$selectWord.addHistoryPlace();
    }

    public static /* synthetic */ void selectWord$default(MutableEditor mutableEditor, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        StructuralSelectionKt.selectWord(mutableEditor, bl);
    }

    public static final void gotoNextSymbol(@NotNull MutableEditor $this$gotoNextSymbol, @NotNull Direction direction) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$gotoNextSymbol, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            if (SyntaxDocumentComponentKt.getSyntaxDocumentComponents((MutableDocument)$this$gotoNextSymbol.getDocument()).isEmpty()) {
                return;
            }
            AST aST = SyntaxDocumentComponentKt.getActualAstAtOffset$default((MutableEditor)$this$gotoNextSymbol, (long)EditorExtKt.getPrimaryCaret((MutableEditor)$this$gotoNextSymbol).getOffset(), (long)0L, (long)0L, (int)6, null);
            Intrinsics.checkNotNull((Object)aST);
            AST ast2 = aST;
            NodeAspectId aspect$iv = PresentableNodeAspect.Id;
            boolean $i$f$getAspectMap = false;
            NodeAspectMap aspectMap = LanguageExtensionPointsKt.getAspectMap(aspect$iv, Reflection.getOrCreateKotlinClass(PresentableNodeAspect.class));
            LanguageSelection languageSelection = StructuralSelectionKt.getLanguageSelection($this$gotoNextSymbol, ast2);
            NodeWithAspect<PresentableNodeAspect> nodeWithAspect = StructuralSelectionKt.findNextSymbol(EditorExtKt.getPrimaryCaret((MutableEditor)$this$gotoNextSymbol).getOffset(), languageSelection, direction, ast2, aspectMap);
            if (nodeWithAspect == null) break block1;
            NodeWithAspect<PresentableNodeAspect> nextSymbol = nodeWithAspect;
            boolean bl = false;
            EditorExtKt.dropMultiCaret((MutableEditor)$this$gotoNextSymbol);
            TextRange idRange = NodeTypesKt.idRange(nextSymbol);
            Function4 move2 = (Function4)new Function4<Caret, Boolean, Text, EditorLayout, Caret>(idRange){
                final /* synthetic */ TextRange $idRange;
                {
                    this.$idRange = $idRange;
                    super(4);
                }

                public final Caret invoke(Caret caret, boolean bl, Text text, EditorLayout editorLayout) {
                    Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                    Intrinsics.checkNotNullParameter((Object)text, (String)"<unused var>");
                    Intrinsics.checkNotNullParameter((Object)editorLayout, (String)"<unused var>");
                    return Caret.move$default((Caret)caret, (CaretPosition)caret.getPosition().move(this.$idRange.getStart(), false), null, (int)2, null);
                }
            };
            CaretActionsKt.navigateAllCarets$default((MutableEditor)$this$gotoNextSymbol, (Function4)move2, (boolean)false, (int)2, null);
            $this$gotoNextSymbol.scrollTo(new EditorScrollCommand(idRange.getStart(), idRange.getEnd(), (EditorScrollKind)EditorScrollKind.Gravitate.INSTANCE, (EditorScrollKind)EditorScrollKind.GoldenRatio.INSTANCE, true, CounterKt.nextLongValue(), null, null, 192, null));
        }
    }

    private static final NodeWithAspect<PresentableNodeAspect> findNextSymbol(long offset, LanguageSelection languageSelection, Direction direction, AST<?> ast2, NodeAspectMap<PresentableNodeAspect> aspectMap) {
        NodeWithAspect matchedParent2;
        SyntaxNode startSymbol;
        SyntaxNode leaf = StructuralSelectionKt.contextLeaf(ast2.root(), offset, languageSelection);
        Sequence $this$lastOrNull$iv = SyntaxNodeExtKt.ancestors$default((SyntaxNode)leaf, (boolean)false, (int)1, null);
        boolean $i$f$lastOrNull = false;
        Object last$iv = null;
        for (Object element$iv : $this$lastOrNull$iv) {
            NodeWithAspect nodeWithAspect;
            NodeAspect nodeAspect;
            SyntaxNode it = (SyntaxNode)element$iv;
            boolean bl = false;
            SyntaxNode $this$asAspect$iv = it;
            boolean $i$f$asAspect = false;
            SyntaxNode $this$getAspect$iv$iv = $this$asAspect$iv;
            boolean $i$f$getAspect = false;
            Object object = $this$getAspect$iv$iv.getType();
            if (!(object instanceof PresentableNodeAspect)) {
                object = null;
            }
            if ((nodeAspect = (NodeAspect)((PresentableNodeAspect)object)) == null) {
                nodeAspect = aspectMap.get($this$getAspect$iv$iv.getType());
            }
            if (nodeAspect == null) {
                nodeWithAspect = null;
            } else {
                NodeAspect aspect$iv = nodeAspect;
                nodeWithAspect = new IJNodeAspect<NodeAspect>($this$asAspect$iv, aspect$iv);
            }
            boolean bl2 = nodeWithAspect != null ? !NodeTypesKt.canContainsPresentableChildren(nodeWithAspect) : false;
            if (!bl2) continue;
            last$iv = element$iv;
        }
        SyntaxNode syntaxNode = last$iv;
        if (syntaxNode == null) {
            syntaxNode = startSymbol = leaf;
        }
        if (direction == Direction.FORWARD && (matchedParent2 = (NodeWithAspect)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SyntaxNodeExtKt.ancestors$default((SyntaxNode)startSymbol, (boolean)false, (int)1, null), (Function1)((Function1)new Function1<SyntaxNode, NodeWithAspect<? extends PresentableNodeAspect>>(aspectMap, direction, offset){
            final /* synthetic */ NodeAspectMap<PresentableNodeAspect> $aspectMap;
            final /* synthetic */ Direction $direction;
            final /* synthetic */ long $offset;
            {
                this.$aspectMap = $aspectMap;
                this.$direction = $direction;
                this.$offset = $offset;
                super(1);
            }

            public final NodeWithAspect<PresentableNodeAspect> invoke(SyntaxNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StructuralSelectionKt.access$findNextSymbol$aspect(it, this.$aspectMap, this.$direction, this.$offset);
            }
        })))) != null) {
            return matchedParent2;
        }
        return (NodeWithAspect)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.flatMap((Sequence)SyntaxNodeExtKt.ancestors$default((SyntaxNode)startSymbol, (boolean)false, (int)1, null), (Function1)((Function1)new Function1<SyntaxNode, Sequence<? extends NodeWithAspect<? extends PresentableNodeAspect>>>(direction, aspectMap, offset){
            final /* synthetic */ Direction $direction;
            final /* synthetic */ NodeAspectMap<PresentableNodeAspect> $aspectMap;
            final /* synthetic */ long $offset;
            {
                this.$direction = $direction;
                this.$aspectMap = $aspectMap;
                this.$offset = $offset;
                super(1);
            }

            public final Sequence<NodeWithAspect<PresentableNodeAspect>> invoke(SyntaxNode ancestor) {
                Intrinsics.checkNotNullParameter((Object)ancestor, (String)"ancestor");
                Object[] objectArray = new NodeWithAspect[]{StructuralSelectionKt.access$findNextSymbol$aspect(ancestor, this.$aspectMap, this.$direction, this.$offset)};
                return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Sequence)SequencesKt.map((Sequence)SyntaxNodeExtKt.siblings((SyntaxNode)ancestor, (this.$direction == Direction.FORWARD ? 1 : 0) != 0, (boolean)true), (Function1)((Function1)new Function1<SyntaxNode, NodeWithAspect<? extends PresentableNodeAspect>>(this.$direction, this.$aspectMap, this.$offset){
                    final /* synthetic */ Direction $direction;
                    final /* synthetic */ NodeAspectMap<PresentableNodeAspect> $aspectMap;
                    final /* synthetic */ long $offset;
                    {
                        this.$direction = $direction;
                        this.$aspectMap = $aspectMap;
                        this.$offset = $offset;
                        super(1);
                    }

                    public final NodeWithAspect<PresentableNodeAspect> invoke(SyntaxNode it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return StructuralSelectionKt.access$findNextSymbol$childAspect(it, this.$direction, this.$aspectMap, this.$offset);
                    }
                })));
            }
        }))));
    }

    private static final NodeWithAspect<PresentableNodeAspect> findNextSymbol$aspect(SyntaxNode $this$findNextSymbol_u24aspect, NodeAspectMap<PresentableNodeAspect> $aspectMap, Direction $direction, long $offset) {
        Object object;
        NodeWithAspect nodeWithAspect;
        NodeAspect nodeAspect;
        SyntaxNode $this$asAspect$iv = $this$findNextSymbol_u24aspect;
        boolean $i$f$asAspect = false;
        SyntaxNode $this$getAspect$iv$iv = $this$asAspect$iv;
        boolean $i$f$getAspect = false;
        Object object2 = $this$getAspect$iv$iv.getType();
        if (!(object2 instanceof PresentableNodeAspect)) {
            object2 = null;
        }
        if ((nodeAspect = (NodeAspect)((PresentableNodeAspect)object2)) == null) {
            nodeAspect = $aspectMap.get($this$getAspect$iv$iv.getType());
        }
        if (nodeAspect == null) {
            nodeWithAspect = null;
        } else {
            NodeAspect aspect$iv = nodeAspect;
            nodeWithAspect = new IJNodeAspect<NodeAspect>($this$asAspect$iv, aspect$iv);
        }
        if (nodeWithAspect != null) {
            NodeWithAspect nodeWithAspect2;
            NodeWithAspect it = nodeWithAspect2 = nodeWithAspect;
            boolean bl = false;
            object = (switch (WhenMappings.$EnumSwitchMapping$0[$direction.ordinal()]) {
                case 1 -> {
                    if (NodeTypesKt.navigationOffset((NodeWithAspect<? extends PresentableNodeAspect>)it) > $offset) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (NodeTypesKt.navigationOffset((NodeWithAspect<? extends PresentableNodeAspect>)it) < $offset) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new UnsupportedOperationException("Unsupported direction: " + $direction);
            }) ? nodeWithAspect2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final NodeWithAspect<PresentableNodeAspect> findNextSymbol$childAspect(SyntaxNode $this$findNextSymbol_u24childAspect, Direction $direction, NodeAspectMap<PresentableNodeAspect> $aspectMap, long $offset) {
        return (NodeWithAspect)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)(switch (WhenMappings.$EnumSwitchMapping$0[$direction.ordinal()]) {
            case 1 -> SyntaxNodeExtKt.descendants((SyntaxNode)$this$findNextSymbol_u24childAspect, (Function1)((Function1)new Function1<SyntaxNode, Boolean>($aspectMap){
                final /* synthetic */ NodeAspectMap<PresentableNodeAspect> $aspectMap;
                {
                    this.$aspectMap = $aspectMap;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Boolean invoke(SyntaxNode it) {
                    NodeWithAspect nodeWithAspect;
                    NodeAspect nodeAspect;
                    void $this$asAspect$iv;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    SyntaxNode syntaxNode = it;
                    NodeAspectMap<PresentableNodeAspect> aspectMap$iv = this.$aspectMap;
                    boolean $i$f$asAspect = false;
                    void $this$getAspect$iv$iv = $this$asAspect$iv;
                    boolean $i$f$getAspect = false;
                    Object object = $this$getAspect$iv$iv.getType();
                    if (!(object instanceof PresentableNodeAspect)) {
                        object = null;
                    }
                    if ((nodeAspect = (NodeAspect)((PresentableNodeAspect)object)) == null) {
                        nodeAspect = aspectMap$iv.get($this$getAspect$iv$iv.getType());
                    }
                    if (nodeAspect == null) {
                        nodeWithAspect = null;
                    } else {
                        NodeAspect aspect$iv = nodeAspect;
                        nodeWithAspect = new IJNodeAspect<NodeAspect>((SyntaxNode)$this$asAspect$iv, aspect$iv);
                    }
                    return !(nodeWithAspect != null ? !NodeTypesKt.canContainsPresentableChildren(nodeWithAspect) : false);
                }
            }));
            case 2 -> SyntaxNodeExtKt.descendantsReversed((SyntaxNode)$this$findNextSymbol_u24childAspect, (Function1)((Function1)new Function1<SyntaxNode, Boolean>($aspectMap){
                final /* synthetic */ NodeAspectMap<PresentableNodeAspect> $aspectMap;
                {
                    this.$aspectMap = $aspectMap;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Boolean invoke(SyntaxNode it) {
                    NodeWithAspect nodeWithAspect;
                    NodeAspect nodeAspect;
                    void $this$asAspect$iv;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    SyntaxNode syntaxNode = it;
                    NodeAspectMap<PresentableNodeAspect> aspectMap$iv = this.$aspectMap;
                    boolean $i$f$asAspect = false;
                    void $this$getAspect$iv$iv = $this$asAspect$iv;
                    boolean $i$f$getAspect = false;
                    Object object = $this$getAspect$iv$iv.getType();
                    if (!(object instanceof PresentableNodeAspect)) {
                        object = null;
                    }
                    if ((nodeAspect = (NodeAspect)((PresentableNodeAspect)object)) == null) {
                        nodeAspect = aspectMap$iv.get($this$getAspect$iv$iv.getType());
                    }
                    if (nodeAspect == null) {
                        nodeWithAspect = null;
                    } else {
                        NodeAspect aspect$iv = nodeAspect;
                        nodeWithAspect = new IJNodeAspect<NodeAspect>((SyntaxNode)$this$asAspect$iv, aspect$iv);
                    }
                    return !(nodeWithAspect != null ? !NodeTypesKt.canContainsPresentableChildren(nodeWithAspect) : false);
                }
            }));
            default -> throw new UnsupportedOperationException("Unsupported direction: " + $direction);
        }), (Function1)((Function1)new Function1<SyntaxNode, NodeWithAspect<? extends PresentableNodeAspect>>($aspectMap, $direction, $offset){
            final /* synthetic */ NodeAspectMap<PresentableNodeAspect> $aspectMap;
            final /* synthetic */ Direction $direction;
            final /* synthetic */ long $offset;
            {
                this.$aspectMap = $aspectMap;
                this.$direction = $direction;
                this.$offset = $offset;
                super(1);
            }

            public final NodeWithAspect<PresentableNodeAspect> invoke(SyntaxNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StructuralSelectionKt.access$findNextSymbol$aspect(it, this.$aspectMap, this.$direction, this.$offset);
            }
        })));
    }

    public static final /* synthetic */ LanguageSelection access$getLanguageSelection(MutableEditor $receiver, AST ast2) {
        return StructuralSelectionKt.getLanguageSelection($receiver, ast2);
    }

    public static final /* synthetic */ List access$rangesAtOffset(SyntaxNode tree, CaretPosition caret, MutableDocument document2, LanguageSelection languageSelection, boolean honorCamelHumps) {
        return StructuralSelectionKt.rangesAtOffset(tree, caret, document2, languageSelection, honorCamelHumps);
    }

    public static final /* synthetic */ SyntaxNode access$lowestDescendantContainingRange(SyntaxNode $receiver, long start, long end, LanguageSelection languageSelection) {
        return StructuralSelectionKt.lowestDescendantContainingRange($receiver, start, end, languageSelection);
    }

    public static final /* synthetic */ SyntaxNode access$repeatUntil(SyntaxNode $receiver, Function1 step, Function1 condition) {
        return StructuralSelectionKt.repeatUntil($receiver, (Function1<? super SyntaxNode, ? extends SyntaxNode>)step, (Function1<? super SyntaxNode, Boolean>)condition);
    }

    public static final /* synthetic */ NodeWithAspect access$findNextSymbol$aspect(SyntaxNode $receiver, NodeAspectMap $aspectMap, Direction $direction, long $offset) {
        return StructuralSelectionKt.findNextSymbol$aspect($receiver, (NodeAspectMap<PresentableNodeAspect>)$aspectMap, $direction, $offset);
    }

    public static final /* synthetic */ NodeWithAspect access$findNextSymbol$childAspect(SyntaxNode $receiver, Direction $direction, NodeAspectMap $aspectMap, long $offset) {
        return StructuralSelectionKt.findNextSymbol$childAspect($receiver, $direction, (NodeAspectMap<PresentableNodeAspect>)$aspectMap, $offset);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.FORWARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.BACKWARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

