/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.lang;

import andel.text.TextRange;
import fleet.ast.AST;
import fleet.ast.CancellableTreeWalkerKt;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.frontend.lang.ASTBraceMatcher;
import fleet.frontend.lang.BraceNodeAspect;
import fleet.frontend.lang.ContextLeafChooser;
import fleet.frontend.lang.SimpleBraceNodeAspect;
import fleet.frontend.lang.SingleCharBraceNodeAspect;
import fleet.frontend.lang.StructuralSelectionKt;
import fleet.util.CancellationToken;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.model.components.editor.BraceMatcher;
import noria.model.components.editor.SuggestClosing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000W\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003*\u0001!\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u0001B7\u0012\u0018\b\u0002\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\u0004\b\n\u0010\u000bB\t\b\u0016\u00a2\u0006\u0004\b\n\u0010\fJ,\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J8\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\bH\u0016J2\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R!\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000eR\u0010\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"\u00a8\u0006#"}, d2={"Lfleet/frontend/lang/ASTBraceMatcher;", "Lnoria/model/components/editor/BraceMatcher;", "Lfleet/ast/AST;", "nodeToAspect", "Lkotlin/Function1;", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "Lfleet/frontend/lang/BraceNodeAspect;", "isLeftBraceFn", "", "", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "()V", "getNodeToAspect", "()Lkotlin/jvm/functions/Function1;", "findLeftmostLBrace", "Landel/text/TextRange;", "syntax", "offset", "", "Landel/text/CharOffset;", "cancellationToken", "Lfleet/util/CancellationToken;", "findBraces", "", "currentBrace", "shouldChooseLeaf", "isLeftBrace", "leftBrace", "suggestClosingPair", "Lnoria/model/components/editor/SuggestClosing;", "s", "braceLeafChooser", "fleet/frontend/lang/ASTBraceMatcher$braceLeafChooser$1", "Lfleet/frontend/lang/ASTBraceMatcher$braceLeafChooser$1;", "fleet.frontend.lang"})
@SourceDebugExtension(value={"SMAP\nASTBraceMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASTBraceMatcher.kt\nfleet/frontend/lang/ASTBraceMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1971#2,14:102\n1#3:116\n*S KotlinDebug\n*F\n+ 1 ASTBraceMatcher.kt\nfleet/frontend/lang/ASTBraceMatcher\n*L\n46#1:102,14\n*E\n"})
public final class ASTBraceMatcher
implements BraceMatcher<AST<?>> {
    @NotNull
    private final Function1<SyntaxNode, BraceNodeAspect> nodeToAspect;
    @NotNull
    private final Function1<String, Boolean> isLeftBraceFn;
    @NotNull
    private final braceLeafChooser.1 braceLeafChooser;

    public ASTBraceMatcher(@NotNull Function1<? super SyntaxNode, ? extends BraceNodeAspect> nodeToAspect2, @NotNull Function1<? super String, Boolean> isLeftBraceFn) {
        Intrinsics.checkNotNullParameter(nodeToAspect2, (String)"nodeToAspect");
        Intrinsics.checkNotNullParameter(isLeftBraceFn, (String)"isLeftBraceFn");
        this.nodeToAspect = nodeToAspect2;
        this.isLeftBraceFn = isLeftBraceFn;
        this.braceLeafChooser = new ContextLeafChooser(this){
            final /* synthetic */ ASTBraceMatcher this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean previousAttracts(SyntaxNode prev, SyntaxNode next) {
                Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
                Intrinsics.checkNotNullParameter((Object)next, (String)"next");
                BraceNodeAspect prevAsBrace = (BraceNodeAspect)this.this$0.getNodeToAspect().invoke((Object)prev);
                if (prevAsBrace != null && this.this$0.getNodeToAspect().invoke((Object)next) != null) {
                    return prevAsBrace.isRight();
                }
                return prevAsBrace != null;
            }

            public SyntaxNode chooseContextLeaf(SyntaxNode leafBefore, SyntaxNode leafAfter) {
                return ContextLeafChooser.DefaultImpls.chooseContextLeaf(this, leafBefore, leafAfter);
            }
        };
    }

    public /* synthetic */ ASTBraceMatcher(Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function12 = 2.INSTANCE;
        }
        this((Function1<? super SyntaxNode, ? extends BraceNodeAspect>)function1, (Function1<? super String, Boolean>)function12);
    }

    @NotNull
    public final Function1<SyntaxNode, BraceNodeAspect> getNodeToAspect() {
        return this.nodeToAspect;
    }

    @NotNull
    public final Function1<String, Boolean> isLeftBraceFn() {
        return this.isLeftBraceFn;
    }

    public ASTBraceMatcher() {
        this((Function1<? super SyntaxNode, ? extends BraceNodeAspect>)((Function1)3.INSTANCE), (Function1<? super String, Boolean>)((Function1)4.INSTANCE));
    }

    @Nullable
    public TextRange findLeftmostLBrace(@Nullable AST<?> syntax2, long offset, @NotNull CancellationToken cancellationToken) {
        SyntaxNode leaf;
        Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
        SyntaxNode syntaxNode = syntax2;
        SyntaxNode syntaxNode2 = syntaxNode != null && (syntaxNode = syntaxNode.root()) != null && (syntaxNode = CancellableTreeWalkerKt.cancellable((SyntaxNode)syntaxNode, (CancellationToken)cancellationToken)) != null ? SyntaxNodeExtKt.leafByOffset((SyntaxNode)syntaxNode, (long)offset) : (leaf = null);
        if (leaf == null) {
            return null;
        }
        Object object = this.nodeToAspect.invoke((Object)leaf);
        SimpleBraceNodeAspect simpleBraceNodeAspect = object instanceof SimpleBraceNodeAspect ? (SimpleBraceNodeAspect)object : null;
        if (simpleBraceNodeAspect == null) {
            return null;
        }
        SimpleBraceNodeAspect aspect = simpleBraceNodeAspect;
        Pair pair = aspect.isRight() ? TuplesKt.to((Object)aspect.getPairedNodeType(), (Object)aspect.getNodeType()) : TuplesKt.to((Object)aspect.getNodeType(), (Object)aspect.getPairedNodeType());
        Object lBraceType = pair.component1();
        Object rBraceType = pair.component2();
        TextRange brace = new TextRange(leaf.getStartOffset(), leaf.getEndOffset());
        ArrayDeque braceStack = new ArrayDeque();
        leaf = SyntaxNodeExtKt.leafLeft((SyntaxNode)leaf);
        while (leaf != null) {
            Object object2 = leaf.getType();
            if (Intrinsics.areEqual((Object)object2, (Object)lBraceType)) {
                if (braceStack.isEmpty()) {
                    brace = new TextRange(leaf.getStartOffset(), leaf.getEndOffset());
                    if (this.findBraces(leaf).isEmpty()) {
                        break;
                    }
                } else {
                    Object v3;
                    TextRange top = (TextRange)braceStack.removeLast();
                    Iterable $this$maxByOrNull$iv = this.findBraces(leaf);
                    boolean $i$f$maxByOrNull = false;
                    Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v3 = null;
                    } else {
                        Object maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v3 = maxElem$iv;
                        } else {
                            TextRange it = (TextRange)maxElem$iv;
                            boolean bl = false;
                            long maxValue$iv = it.getEnd();
                            do {
                                Object e$iv = iterator$iv.next();
                                TextRange it2 = (TextRange)e$iv;
                                $i$a$-maxByOrNull-ASTBraceMatcher$findLeftmostLBrace$1 = false;
                                long v$iv = it2.getEnd();
                                if (maxValue$iv >= v$iv) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v3 = maxElem$iv;
                        }
                    }
                    if (!Intrinsics.areEqual(v3, (Object)top)) {
                        break;
                    }
                }
            } else if (Intrinsics.areEqual((Object)object2, (Object)rBraceType)) {
                braceStack.addLast((Object)new TextRange(leaf.getStartOffset(), leaf.getEndOffset()));
            }
            leaf = SyntaxNodeExtKt.leafLeft((SyntaxNode)leaf);
        }
        return brace;
    }

    private final List<TextRange> findBraces(SyntaxNode currentBrace) {
        BraceNodeAspect braceNodeAspect = (BraceNodeAspect)this.nodeToAspect.invoke((Object)currentBrace);
        if (braceNodeAspect == null || (braceNodeAspect = braceNodeAspect.findPair(currentBrace)) == null) {
            return CollectionsKt.emptyList();
        }
        BraceNodeAspect pairedBrace = braceNodeAspect;
        Object[] objectArray = new TextRange[]{new TextRange(currentBrace.getStartOffset(), currentBrace.getEndOffset()), new TextRange(pairedBrace.getStartOffset(), pairedBrace.getEndOffset())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<TextRange> findBraces(@Nullable AST<?> syntax2, long offset, boolean shouldChooseLeaf, @NotNull CancellationToken cancellationToken) {
        SyntaxNode syntaxNode;
        Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
        if (syntax2 == null) {
            return CollectionsKt.emptyList();
        }
        if (shouldChooseLeaf) {
            syntaxNode = StructuralSelectionKt.contextLeaf(CancellableTreeWalkerKt.cancellable((SyntaxNode)syntax2.root(), (CancellationToken)cancellationToken), offset, this.braceLeafChooser);
        } else {
            syntaxNode = SyntaxNodeExtKt.leafByOffset((SyntaxNode)CancellableTreeWalkerKt.cancellable((SyntaxNode)syntax2.root(), (CancellationToken)cancellationToken), (long)offset);
            if (syntaxNode == null) {
                return CollectionsKt.emptyList();
            }
        }
        SyntaxNode leaf = syntaxNode;
        return this.findBraces(leaf);
    }

    public boolean isLeftBrace(@NotNull String leftBrace) {
        Intrinsics.checkNotNullParameter((Object)leftBrace, (String)"leftBrace");
        return (Boolean)this.isLeftBraceFn.invoke((Object)leftBrace);
    }

    @NotNull
    public SuggestClosing suggestClosingPair(@Nullable AST<?> syntax2, long offset, @NotNull String s, @NotNull CancellationToken cancellationToken) {
        SingleCharBraceNodeAspect singleCharBraceNodeAspect;
        block6: {
            block5: {
                SingleCharBraceNodeAspect singleCharBraceNodeAspect2;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
                if (syntax2 == null) {
                    return (SuggestClosing)SuggestClosing.None.INSTANCE;
                }
                SyntaxNode syntaxNode = SyntaxNodeExtKt.leafByOffset((SyntaxNode)CancellableTreeWalkerKt.cancellable((SyntaxNode)syntax2.root(), (CancellationToken)cancellationToken), (long)offset);
                if (syntaxNode == null) {
                    return (SuggestClosing)SuggestClosing.None.INSTANCE;
                }
                SyntaxNode braceNode = syntaxNode;
                Object object = this.nodeToAspect.invoke((Object)braceNode);
                SingleCharBraceNodeAspect braceAspect = object instanceof SingleCharBraceNodeAspect ? (SingleCharBraceNodeAspect)object : null;
                singleCharBraceNodeAspect = braceAspect;
                if (singleCharBraceNodeAspect == null) break block5;
                SingleCharBraceNodeAspect it = singleCharBraceNodeAspect2 = singleCharBraceNodeAspect;
                boolean bl = false;
                singleCharBraceNodeAspect = !it.isRight() ? singleCharBraceNodeAspect2 : null;
                if (singleCharBraceNodeAspect != null && (singleCharBraceNodeAspect = singleCharBraceNodeAspect.shouldSuggestClosing(braceNode)) != null) break block6;
            }
            singleCharBraceNodeAspect = (SuggestClosing)SuggestClosing.None.INSTANCE;
        }
        return singleCharBraceNodeAspect;
    }
}

