/*
 * Decompiled with CFR 0.152.
 */
package fleet.reporting.opentelemetry;

import fleet.reporting.opentelemetry.ChanSpanEvent;
import fleet.reporting.opentelemetry.ChanSpanInfo;
import fleet.reporting.opentelemetry.Clock;
import fleet.reporting.opentelemetry.FleetTelemetryKt;
import fleet.tracing.runtime.CompletableSpan;
import fleet.tracing.runtime.SpanInfo;
import fleet.tracing.runtime.SpanStatus;
import fleet.util.logging.KLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001f\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lfleet/reporting/opentelemetry/ChanSpan;", "Lfleet/tracing/runtime/CompletableSpan;", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "Lfleet/reporting/opentelemetry/ChanSpanEvent;", "clock", "Lfleet/reporting/opentelemetry/Clock;", "chanSpanInfo", "Lfleet/reporting/opentelemetry/ChanSpanInfo;", "<init>", "(Lkotlinx/coroutines/channels/SendChannel;Lfleet/reporting/opentelemetry/Clock;Lfleet/reporting/opentelemetry/ChanSpanInfo;)V", "getClock", "()Lfleet/reporting/opentelemetry/Clock;", "getChanSpanInfo", "()Lfleet/reporting/opentelemetry/ChanSpanInfo;", "job", "", "getJob", "()Ljava/lang/Object;", "startChild", "childInfo", "Lfleet/tracing/runtime/SpanInfo;", "complete", "", "status", "Lfleet/tracing/runtime/SpanStatus;", "endTimestampNano", "", "(Lfleet/tracing/runtime/SpanStatus;Ljava/lang/Long;)V", "fleet.reporting.opentelemetry"})
@SourceDebugExtension(value={"SMAP\nFleetTelemetry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FleetTelemetry.kt\nfleet/reporting/opentelemetry/ChanSpan\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,417:1\n38#2,2:418\n*S KotlinDebug\n*F\n+ 1 FleetTelemetry.kt\nfleet/reporting/opentelemetry/ChanSpan\n*L\n118#1:418,2\n*E\n"})
final class ChanSpan
implements CompletableSpan {
    @NotNull
    private final SendChannel<ChanSpanEvent> channel;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ChanSpanInfo chanSpanInfo;

    public ChanSpan(@NotNull SendChannel<? super ChanSpanEvent> channel, @NotNull Clock clock, @NotNull ChanSpanInfo chanSpanInfo) {
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)chanSpanInfo, (String)"chanSpanInfo");
        this.channel = channel;
        this.clock = clock;
        this.chanSpanInfo = chanSpanInfo;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final ChanSpanInfo getChanSpanInfo() {
        return this.chanSpanInfo;
    }

    @NotNull
    public Object getJob() {
        return this.chanSpanInfo.getSpanInfo().getJob();
    }

    @NotNull
    public CompletableSpan startChild(@NotNull SpanInfo childInfo) {
        Intrinsics.checkNotNullParameter((Object)childInfo, (String)"childInfo");
        Long l = childInfo.getStartTimestampNano();
        return new ChanSpan(this.channel, this.clock, new ChanSpanInfo(SpanInfo.copy$default((SpanInfo)childInfo, null, (boolean)false, null, null, (Long)(l != null ? l.longValue() : this.clock.nano()), null, (int)47, null), this.chanSpanInfo, null));
    }

    /*
     * WARNING - void declaration
     */
    public void complete(@NotNull SpanStatus status, @Nullable Long endTimestampNano) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Long l = endTimestampNano;
        long endTimestampNanoOrNow = l != null ? l.longValue() : this.clock.nano();
        this.chanSpanInfo.setEndTimestampNano(endTimestampNanoOrNow);
        Object sendResult = this.channel.trySend-JP2dKIU((Object)new ChanSpanEvent(this.chanSpanInfo, status, endTimestampNanoOrNow));
        if (!ChannelResult.isSuccess-impl((Object)sendResult)) {
            void this_$iv;
            KLogger kLogger = FleetTelemetryKt.access$getLogger();
            Throwable t$iv = ChannelResult.exceptionOrNull-impl((Object)sendResult);
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                Throwable throwable = t$iv;
                void var10_9 = this_$iv;
                boolean bl = false;
                String string = "Couldn't send closing span event for " + this.chanSpanInfo.getSpanInfo() + ": " + ChannelResult.toString-impl((Object)sendResult);
                var10_9.warn(throwable, (Object)string);
            }
        }
    }
}

