/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.user;

import com.jetbrains.rhizomedb.Attribute;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.ChangeScopeKt;
import com.jetbrains.rhizomedb.CreateEntity;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.EntityType;
import com.jetbrains.rhizomedb.Instruction;
import com.jetbrains.rhizomedb.Mut;
import com.jetbrains.rhizomedb.OutOfMutableDbContext;
import com.jetbrains.rhizomedb.UtilKt;
import com.jetbrains.rhizomedb.impl.SeedKt;
import fleet.api.UserId;
import fleet.common.settings.SettingsEntityKt;
import fleet.common.user.UserEntity;
import fleet.frontend.FleetFrontendSettingsKeys;
import fleet.frontend.user.CurrentUserEntityKt;
import fleet.frontend.user.HostUserEntity;
import fleet.frontend.user.InitUserKt;
import fleet.kernel.DurableEntityKt;
import fleet.kernel.SharedChangeScope;
import fleet.kernel.SharedKt;
import fleet.kernel.TransactorKt;
import fleet.kernel.rete.QueriesKt;
import fleet.kernel.rete.Query;
import fleet.kernel.rete.ReteKt;
import fleet.rpc.client.ClientId;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0006\u0010\f\u001a\u00020\n\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"createUserEntity", "Lfleet/common/user/UserEntity;", "userId", "Lfleet/api/UserId;", "clientId", "Lfleet/rpc/client/ClientId;", "entityEID", "", "Lcom/jetbrains/rhizomedb/EID;", "userName", "", "initUser", "userNameFromSettingsOrDefault", "initHostUser", "", "Lcom/jetbrains/rhizomedb/ChangeScope;", "updateUserEntityFromSettings", "(Lfleet/api/UserId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fleet.frontend"})
@SourceDebugExtension(value={"SMAP\nInitUser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InitUser.kt\nfleet/frontend/user/InitUserKt\n+ 2 DbContext.kt\ncom/jetbrains/rhizomedb/DbContext\n*L\n1#1,82:1\n78#2,5:83\n*S KotlinDebug\n*F\n+ 1 InitUser.kt\nfleet/frontend/user/InitUserKt\n*L\n23#1:83,5\n*E\n"})
public final class InitUserKt {
    @NotNull
    public static final UserEntity createUserEntity(@NotNull UserId userId, @NotNull ClientId clientId, int entityEID, @NotNull String userName) {
        UserEntity userEntity2;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        UserEntity userEntity3 = (UserEntity)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)UserEntity.Companion.getUserIdAttr()), (Object)userId);
        if (userEntity3 != null && (userEntity3 = InitUserKt.initUser(userEntity3, userName)) != null) {
            UserEntity userEntity4;
            UserEntity userEntity5 = userEntity4 = userEntity3;
            boolean bl = false;
            if (!(userEntity5.getEid() == entityEID)) {
                boolean $i$a$-require-InitUserKt$createUserEntity$1$22 = false;
                String $i$a$-require-InitUserKt$createUserEntity$1$22 = "user ids have clashed! " + userId;
                throw new IllegalArgumentException($i$a$-require-InitUserKt$createUserEntity$1$22.toString());
            }
            userEntity2 = userEntity4;
        } else {
            DbContext this_$iv = DbContext.Companion.getThreadBound();
            boolean $i$f$ensureMutable = false;
            if (this_$iv.get_private_value() instanceof Mut) {
                Intrinsics.checkNotNull((Object)this_$iv, (String)"null cannot be cast to non-null type com.jetbrains.rhizomedb.DbContext<com.jetbrains.rhizomedb.Mut>");
                DbContext $this$createUserEntity_u24lambda_u242 = this_$iv;
                boolean bl = false;
                UtilKt.mutate((DbContext)$this$createUserEntity_u24lambda_u242, (Instruction)((Instruction)new CreateEntity(entityEID, UserEntity.Companion.getEid(), CollectionsKt.listOf((Object)TuplesKt.to((Object)Attribute.box-impl((int)DurableEntityKt.uidAttribute()), (Object)userId.getUid())), SeedKt.generateSeed())));
                Entity entity = EntitiesKt.entity((int)entityEID);
                Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type fleet.common.user.UserEntity");
                UserEntity userEntity6 = (UserEntity)entity;
                userEntity2 = (UserEntity)ChangeScopeKt.requireChangeScope((Function1)((Function1)new Function1<ChangeScope, UserEntity>(userEntity6, userId, clientId, userName){
                    final /* synthetic */ UserEntity $userEntity;
                    final /* synthetic */ UserId $userId;
                    final /* synthetic */ ClientId $clientId;
                    final /* synthetic */ String $userName;
                    {
                        this.$userEntity = $userEntity;
                        this.$userId = $userId;
                        this.$clientId = $clientId;
                        this.$userName = $userName;
                        super(1);
                    }

                    public final UserEntity invoke(ChangeScope $this$requireChangeScope) {
                        Intrinsics.checkNotNullParameter((Object)$this$requireChangeScope, (String)"$this$requireChangeScope");
                        UserEntity userEntity2 = this.$userEntity;
                        UserId userId = this.$userId;
                        ClientId clientId = this.$clientId;
                        String string = this.$userName;
                        UserEntity $this$invoke_u24lambda_u240 = userEntity2;
                        boolean bl = false;
                        $this$requireChangeScope.set((Entity)$this$invoke_u24lambda_u240, UserEntity.Companion.getUserIdAttr(), (Object)userId);
                        $this$requireChangeScope.set((Entity)$this$invoke_u24lambda_u240, UserEntity.Companion.getClientIdAttr(), (Object)clientId);
                        return InitUserKt.access$initUser($this$invoke_u24lambda_u240, string);
                    }
                }));
            } else {
                throw new OutOfMutableDbContext();
            }
        }
        return userEntity2;
    }

    private static final UserEntity initUser(UserEntity $this$initUser, String userName) {
        long now = Instant.now().toEpochMilli();
        ChangeScopeKt.requireChangeScope((Function1)((Function1)new Function1<ChangeScope, Unit>($this$initUser, userName, now){
            final /* synthetic */ UserEntity $this_initUser;
            final /* synthetic */ String $userName;
            final /* synthetic */ long $now;
            {
                this.$this_initUser = $receiver;
                this.$userName = $userName;
                this.$now = $now;
                super(1);
            }

            public final void invoke(ChangeScope $this$requireChangeScope) {
                Intrinsics.checkNotNullParameter((Object)$this$requireChangeScope, (String)"$this$requireChangeScope");
                UserEntity userEntity2 = this.$this_initUser;
                String string = this.$userName;
                long l = this.$now;
                UserEntity it = userEntity2;
                boolean bl = false;
                $this$requireChangeScope.set((Entity)it, UserEntity.Companion.getUsernameAttr(), (Object)string);
                $this$requireChangeScope.set((Entity)it, UserEntity.Companion.getFirstSeenUTCAttr(), (Object)l);
                $this$requireChangeScope.set((Entity)it, UserEntity.Companion.getLastSeenUTCAttr(), (Object)l);
                $this$requireChangeScope.set((Entity)it, UserEntity.Companion.getGoneAttr(), (Object)false);
            }
        }));
        return $this$initUser;
    }

    @NotNull
    public static final String userNameFromSettingsOrDefault() {
        String string;
        String name = (String)SettingsEntityKt.querySettingsKey$default(FleetFrontendSettingsKeys.INSTANCE.getUserName(), null, null, (int)6, null);
        if (!StringsKt.isBlank((CharSequence)name)) {
            string = name;
        } else {
            String string2 = System.getProperty("user.name");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        }
        return string;
    }

    public static final void initHostUser(@NotNull ChangeScope $this$initHostUser) {
        Intrinsics.checkNotNullParameter((Object)$this$initHostUser, (String)"<this>");
        UserEntity current = CurrentUserEntityKt.currentUser();
        SharedKt.shared((ChangeScope)$this$initHostUser, (Function1)((Function1)new Function1<SharedChangeScope, HostUserEntity>(current){
            final /* synthetic */ UserEntity $current;
            {
                this.$current = $current;
                super(1);
            }

            public final HostUserEntity invoke(SharedChangeScope $this$shared) {
                Intrinsics.checkNotNullParameter((Object)$this$shared, (String)"$this$shared");
                return (HostUserEntity)$this$shared.new((EntityType)HostUserEntity.Companion, arg_0 -> initHostUser.1.invoke$lambda$0(this.$current, arg_0));
            }

            private static final void invoke$lambda$0(UserEntity $current, EntityBuilder.Target it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.set(HostUserEntity.Companion.getUserAttr(), (Object)$current);
            }
        }));
    }

    @Nullable
    public static final Object updateUserEntityFromSettings(@NotNull UserId userId, @NotNull Continuation<? super Unit> $completion) {
        Entity entity = EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)UserEntity.Companion.getUserIdAttr()), (Object)userId);
        if (entity == null) {
            boolean bl = false;
            String string = "User " + userId + " not found";
            throw new IllegalArgumentException(string.toString());
        }
        UserEntity user = (UserEntity)entity;
        Object object = ReteKt.collect((Query)QueriesKt.query((Function0)updateUserEntityFromSettings.2.INSTANCE), (Function3)((Function3)new Function3<CoroutineScope, String, Continuation<? super Unit>, Object>(user, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ UserEntity $user;
            {
                this.$user = $user;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        String userName = (String)this.L$0;
                        this.label = 1;
                        Object object3 = TransactorKt.change((Function1)((Function1)new Function1<ChangeScope, Unit>(this.$user, userName){
                            final /* synthetic */ UserEntity $user;
                            final /* synthetic */ String $userName;
                            {
                                this.$user = $user;
                                this.$userName = $userName;
                                super(1);
                            }

                            public final void invoke(ChangeScope $this$change) {
                                Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
                                SharedKt.shared((ChangeScope)$this$change, (Function1)((Function1)new Function1<SharedChangeScope, Unit>(this.$user, this.$userName){
                                    final /* synthetic */ UserEntity $user;
                                    final /* synthetic */ String $userName;
                                    {
                                        this.$user = $user;
                                        this.$userName = $userName;
                                        super(1);
                                    }

                                    public final void invoke(SharedChangeScope $this$shared) {
                                        Intrinsics.checkNotNullParameter((Object)$this$shared, (String)"$this$shared");
                                        if (EntitiesKt.exists((Entity)((Entity)this.$user))) {
                                            $this$shared.set((Entity)this.$user, UserEntity.Companion.getUsernameAttr(), (Object)this.$userName);
                                        }
                                    }
                                }));
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(CoroutineScope p1, String p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ UserEntity access$initUser(UserEntity $receiver, String userName) {
        return InitUserKt.initUser($receiver, userName);
    }
}

