/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.navigation;

import fleet.api.FileAddress;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.frontend.navigation.NavigationLocation;
import fleet.frontend.navigation.NavigationPositionKt;
import fleet.frontend.navigation.RecentNavigationKey;
import fleet.frontend.navigation.RecentNavigationKey$Address$;
import fleet.frontend.navigation.RecentNavigationKey$Document$;
import fleet.util.UID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00122\u00020\u0001:\u0003\u0010\u0011\u0012B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001b\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lfleet/frontend/navigation/RecentNavigationKey;", "", "<init>", "()V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "Address", "Document", "Companion", "Lfleet/frontend/navigation/RecentNavigationKey$Address;", "Lfleet/frontend/navigation/RecentNavigationKey$Document;", "fleet.frontend"})
public abstract class RecentNavigationKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<KSerializer<Object>> $cachedSerializer$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)Companion.1.INSTANCE);

    private RecentNavigationKey() {
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self(RecentNavigationKey self, CompositeEncoder output, SerialDescriptor serialDesc) {
    }

    public /* synthetic */ RecentNavigationKey(int seen0, SerializationConstructorMarker serializationConstructorMarker) {
    }

    public /* synthetic */ RecentNavigationKey(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lfleet/frontend/navigation/RecentNavigationKey$Address;", "Lfleet/frontend/navigation/RecentNavigationKey;", "fileAddress", "Lfleet/api/FileAddress;", "<init>", "(Lfleet/api/FileAddress;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILfleet/api/FileAddress;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getFileAddress", "()Lfleet/api/FileAddress;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$fleet_frontend", "$serializer", "Companion", "fleet.frontend"})
    public static final class Address
    extends RecentNavigationKey {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final FileAddress fileAddress;

        public Address(@NotNull FileAddress fileAddress) {
            Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
            super(null);
            this.fileAddress = fileAddress;
        }

        @NotNull
        public final FileAddress getFileAddress() {
            return this.fileAddress;
        }

        @NotNull
        public final FileAddress component1() {
            return this.fileAddress;
        }

        @NotNull
        public final Address copy(@NotNull FileAddress fileAddress) {
            Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
            return new Address(fileAddress);
        }

        public static /* synthetic */ Address copy$default(Address address, FileAddress fileAddress, int n, Object object) {
            if ((n & 1) != 0) {
                fileAddress = address.fileAddress;
            }
            return address.copy(fileAddress);
        }

        @NotNull
        public String toString() {
            return "Address(fileAddress=" + this.fileAddress + ")";
        }

        public int hashCode() {
            return this.fileAddress.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Address)) {
                return false;
            }
            Address address = (Address)other;
            return Intrinsics.areEqual((Object)this.fileAddress, (Object)address.fileAddress);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$fleet_frontend(Address self, CompositeEncoder output, SerialDescriptor serialDesc) {
            RecentNavigationKey.write$Self(self, output, serialDesc);
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)FileAddress.$serializer.INSTANCE, (Object)self.fileAddress);
        }

        public /* synthetic */ Address(int seen0, FileAddress fileAddress, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Address$$serializer.INSTANCE.getDescriptor());
            }
            super(seen0, serializationConstructorMarker);
            this.fileAddress = fileAddress;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lfleet/frontend/navigation/RecentNavigationKey$Address$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lfleet/frontend/navigation/RecentNavigationKey$Address;", "fleet.frontend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Address> serializer() {
                return (KSerializer)Address$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lfleet/frontend/navigation/RecentNavigationKey$Companion;", "", "<init>", "()V", "fromNavigationLocation", "Lfleet/frontend/navigation/RecentNavigationKey;", "location", "Lfleet/frontend/navigation/NavigationLocation;", "serializer", "Lkotlinx/serialization/KSerializer;", "fleet.frontend"})
    @SourceDebugExtension(value={"SMAP\nRecentNavigation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentNavigation.kt\nfleet/frontend/navigation/RecentNavigationKey$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RecentNavigationKey fromNavigationLocation(@NotNull NavigationLocation location) {
            RecentNavigationKey recentNavigationKey2;
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            NavigationLocation navigationLocation = location;
            if (navigationLocation instanceof NavigationLocation.File) {
                recentNavigationKey2 = new Address(((NavigationLocation.File)location).getFileAddress());
            } else if (navigationLocation instanceof NavigationLocation.Document) {
                DocumentEntity documentEntity = NavigationPositionKt.lookupDocument(location);
                if (documentEntity != null && (documentEntity = DocumentEntityKt.getDocumentFileEntity((DocumentEntity)documentEntity)) != null && (documentEntity = documentEntity.getFileAddress()) != null) {
                    DocumentEntity it = documentEntity;
                    boolean bl = false;
                    recentNavigationKey2 = new Address((FileAddress)it);
                } else {
                    FileAddress fileAddress = ((NavigationLocation.Document)location).getFallbackFileAddress();
                    if (fileAddress != null) {
                        FileAddress it = fileAddress;
                        boolean bl = false;
                        recentNavigationKey2 = new Address(it);
                    } else {
                        recentNavigationKey2 = new Document(((NavigationLocation.Document)location).getDocumentId());
                    }
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return recentNavigationKey2;
        }

        @NotNull
        public final KSerializer<RecentNavigationKey> serializer() {
            return this.get$cachedSerializer();
        }

        private final /* synthetic */ KSerializer get$cachedSerializer() {
            return (KSerializer)$cachedSerializer$delegate.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lfleet/frontend/navigation/RecentNavigationKey$Document;", "Lfleet/frontend/navigation/RecentNavigationKey;", "documentId", "Lfleet/util/UID;", "<init>", "(Lfleet/util/UID;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILfleet/util/UID;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getDocumentId", "()Lfleet/util/UID;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$fleet_frontend", "$serializer", "Companion", "fleet.frontend"})
    public static final class Document
    extends RecentNavigationKey {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final UID documentId;

        public Document(@NotNull UID documentId) {
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            super(null);
            this.documentId = documentId;
        }

        @NotNull
        public final UID getDocumentId() {
            return this.documentId;
        }

        @NotNull
        public final UID component1() {
            return this.documentId;
        }

        @NotNull
        public final Document copy(@NotNull UID documentId) {
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            return new Document(documentId);
        }

        public static /* synthetic */ Document copy$default(Document document2, UID uID, int n, Object object) {
            if ((n & 1) != 0) {
                uID = document2.documentId;
            }
            return document2.copy(uID);
        }

        @NotNull
        public String toString() {
            return "Document(documentId=" + this.documentId + ")";
        }

        public int hashCode() {
            return this.documentId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Document)) {
                return false;
            }
            Document document2 = (Document)other;
            return Intrinsics.areEqual((Object)this.documentId, (Object)document2.documentId);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$fleet_frontend(Document self, CompositeEncoder output, SerialDescriptor serialDesc) {
            RecentNavigationKey.write$Self(self, output, serialDesc);
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)UID.Serializer.INSTANCE, (Object)self.documentId);
        }

        public /* synthetic */ Document(int seen0, UID documentId, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Document$$serializer.INSTANCE.getDescriptor());
            }
            super(seen0, serializationConstructorMarker);
            this.documentId = documentId;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lfleet/frontend/navigation/RecentNavigationKey$Document$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lfleet/frontend/navigation/RecentNavigationKey$Document;", "fleet.frontend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Document> serializer() {
                return (KSerializer)Document$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

