/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.editor.editorconfig;

import andel.UtilsKt;
import andel.text.LineNumberKt;
import andel.text.Text;
import andel.text.TextView;
import fleet.frontend.editor.editorconfig.GuessedIndent;
import fleet.frontend.editor.editorconfig.IndentAutoDetection;
import fleet.frontend.editor.editorconfig.IndentStyle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lfleet/frontend/editor/editorconfig/IndentAutoDetection;", "", "<init>", "()V", "maxIndentSize", "", "guessIndent", "Lfleet/frontend/editor/editorconfig/GuessedIndent;", "text", "Landel/text/Text;", "lineFrom", "", "lineTo", "smallFragment", "", "getIndentCounters", "Lfleet/frontend/editor/editorconfig/IndentAutoDetection$IndentCounters;", "counter", "tolerateLowFrequency", "IndentCounters", "fleet.frontend"})
public final class IndentAutoDetection {
    @NotNull
    public static final IndentAutoDetection INSTANCE = new IndentAutoDetection();
    public static final int maxIndentSize = 8;

    private IndentAutoDetection() {
    }

    @Nullable
    public final GuessedIndent guessIndent(@NotNull Text text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        long linesCount = text2.getLineCount-bcnjDHU();
        long lineNumberToLookup = Math.min(linesCount, 200L);
        return IndentAutoDetection.guessIndent$default(this, text2, 0L, lineNumberToLookup, false, 8, null);
    }

    @Nullable
    public final GuessedIndent guessIndent(@NotNull Text text2, long lineFrom, long lineTo, boolean smallFragment) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        IndentCounters forwardIndentCounters = this.getIndentCounters(text2, lineFrom, lineTo);
        return this.guessIndent(forwardIndentCounters, smallFragment);
    }

    public static /* synthetic */ GuessedIndent guessIndent$default(IndentAutoDetection indentAutoDetection, Text text2, long l, long l2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return indentAutoDetection.guessIndent(text2, l, l2, bl);
    }

    private final IndentCounters getIndentCounters(Text text2, long lineFrom, long lineTo) {
        int prevSpaceIndent = 0;
        int lastDelta = 0;
        IndentCounters contentLineCounters = new IndentCounters();
        IndentCounters wsLineCounters = new IndentCounters();
        TextView textView = text2.view();
        for (long lineNumber = lineFrom; lineNumber < lineTo; ++lineNumber) {
            boolean isWsLine = UtilsKt.isWhiteSpaceLine((TextView)textView, (int)((int)lineNumber));
            IndentCounters currentCounter = isWsLine ? wsLineCounters : contentLineCounters;
            boolean isTabIndent = UtilsKt.lineHasTabIndentation((TextView)textView, (int)((int)lineNumber));
            if (isTabIndent) {
                int n = currentCounter.getTabIndentCount();
                currentCounter.setTabIndentCount(n + 1);
                continue;
            }
            int currentIndent = UtilsKt.indentOfLine-aY10xNE((TextView)textView, (int)LineNumberKt.getLine((long)lineNumber));
            int currentDelta = currentIndent - prevSpaceIndent;
            if (currentDelta == 0) {
                if (lastDelta > 0) {
                    currentDelta = lastDelta;
                }
            } else if (!isWsLine) {
                lastDelta = currentDelta;
            }
            if (currentDelta != 0 && currentDelta <= 8) {
                currentCounter.addSpaceIndent(Math.abs(currentDelta));
            }
            if (isWsLine) continue;
            prevSpaceIndent = currentIndent;
        }
        return contentLineCounters.getCount() > 0 ? contentLineCounters : wsLineCounters;
    }

    private final GuessedIndent guessIndent(IndentCounters counter, boolean tolerateLowFrequency) {
        if ((double)counter.getTabIndentCount() > (double)counter.getCount() * 0.66) {
            return new GuessedIndent(1, IndentStyle.Tab);
        }
        Long l = counter.getMostFrequentSpaceIndent();
        if (l == null) {
            return null;
        }
        long mostFrequentIndent = l;
        int mostFrequentCount = counter.getSpaceIndentCount(mostFrequentIndent);
        double rate = (double)mostFrequentCount / (double)counter.getCount();
        long l2 = mostFrequentIndent;
        boolean canUseIndent = l2 == 2L || l2 == 3L || l2 == 4L ? tolerateLowFrequency || rate >= 0.6 : (l2 == 1L || l2 == 5L || l2 == 6L || l2 == 7L || l2 == 8L ? tolerateLowFrequency || rate >= 0.8 && mostFrequentCount >= 10 : false);
        return canUseIndent ? new GuessedIndent((int)mostFrequentIndent, IndentStyle.Space) : null;
    }

    static /* synthetic */ GuessedIndent guessIndent$default(IndentAutoDetection indentAutoDetection, IndentCounters indentCounters, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return indentAutoDetection.guessIndent(indentCounters, bl);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0006J\r\u0010\u0016\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0017R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0018"}, d2={"Lfleet/frontend/editor/editorconfig/IndentAutoDetection$IndentCounters;", "", "<init>", "()V", "spaceIndentHistogramm", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "spaceIndentCount", "tabIndentCount", "getTabIndentCount", "()I", "setTabIndentCount", "(I)V", "count", "getCount", "addSpaceIndent", "", "size", "getSpaceIndentCount", "indentSize", "getMostFrequentSpaceIndent", "()Ljava/lang/Long;", "fleet.frontend"})
    @SourceDebugExtension(value={"SMAP\nIndentAutoDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndentAutoDetection.kt\nfleet/frontend/editor/editorconfig/IndentAutoDetection$IndentCounters\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1971#2,14:141\n*S KotlinDebug\n*F\n+ 1 IndentAutoDetection.kt\nfleet/frontend/editor/editorconfig/IndentAutoDetection$IndentCounters\n*L\n25#1:141,14\n*E\n"})
    public static final class IndentCounters {
        @NotNull
        private final HashMap<Long, Integer> spaceIndentHistogramm = new HashMap();
        private int spaceIndentCount;
        private int tabIndentCount;

        public final int getTabIndentCount() {
            return this.tabIndentCount;
        }

        public final void setTabIndentCount(int n) {
            this.tabIndentCount = n;
        }

        public final int getCount() {
            return this.tabIndentCount + this.spaceIndentCount;
        }

        public final void addSpaceIndent(int size) {
            this.spaceIndentHistogramm.compute(Long.valueOf(size), (arg_0, arg_1) -> IndentCounters.addSpaceIndent$lambda$0(addSpaceIndent.1.INSTANCE, arg_0, arg_1));
            int n = this.spaceIndentCount;
            this.spaceIndentCount = n + 1;
        }

        public final int getSpaceIndentCount(long indentSize) {
            Integer n = this.spaceIndentHistogramm.get(indentSize);
            return n != null ? n : 0;
        }

        @Nullable
        public final Long getMostFrequentSpaceIndent() {
            Object v1;
            Set<Map.Entry<Long, Integer>> set = this.spaceIndentHistogramm.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable $this$maxByOrNull$iv = set;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    Map.Entry it = (Map.Entry)maxElem$iv;
                    boolean bl = false;
                    long l = (long)((Number)it.getValue()).intValue() << 32;
                    Object k = it.getKey();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                    long maxValue$iv = l - ((Number)k).longValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Map.Entry it2 = (Map.Entry)e$iv;
                        $i$a$-maxByOrNull-IndentAutoDetection$IndentCounters$getMostFrequentSpaceIndent$1 = false;
                        long l2 = (long)((Number)it2.getValue()).intValue() << 32;
                        Object k2 = it2.getKey();
                        Intrinsics.checkNotNullExpressionValue(k2, (String)"<get-key>(...)");
                        long v$iv = l2 - ((Number)k2).longValue();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            Map.Entry entry = v1;
            return entry != null ? (Long)entry.getKey() : null;
        }

        private static final Integer addSpaceIndent$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            return (Integer)$tmp0.invoke(p0, p1);
        }
    }
}

