/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.editor.editorconfig;

import andel.editor.MutableDocument;
import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.EntityType;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.workspace.DocumentLocation;
import fleet.api.workspace.document.LanguageId;
import fleet.api.workspace.document.MediaType;
import fleet.common.document.DocumentCodeProfileEntityKt;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.common.document.DocumentFileEntity;
import fleet.common.document.EditorConfigEntity;
import fleet.common.settings.ConfigParserKt;
import fleet.common.settings.SettingsKey;
import fleet.frontend.document.DocumentApiKt;
import fleet.frontend.document.DocumentEntityExtKt;
import fleet.frontend.editor.EditorApiKt;
import fleet.frontend.editor.EditorIndentStyle;
import fleet.frontend.editor.SharedEditorSettingsKeys;
import fleet.frontend.editor.editorconfig.EditorConfigDocumentData;
import fleet.frontend.editor.editorconfig.EditorConfigDocumentMetaKey;
import fleet.frontend.editor.editorconfig.EditorConfigExtKt;
import fleet.frontend.editor.editorconfig.EditorConfigs;
import fleet.frontend.editor.editorconfig.FileAddressDocumentMetaKey;
import fleet.frontend.editor.editorconfig.GuessedIndent;
import fleet.frontend.editor.editorconfig.IndentAutoDetection;
import fleet.frontend.editor.editorconfig.IndentStyle;
import fleet.kernel.TransactorKt;
import fleet.kernel.plugins.ContributionScope;
import fleet.kernel.plugins.WorkerKt;
import fleet.kernel.rete.QueriesKt;
import fleet.kernel.rete.Query;
import fleet.kernel.rete.ReteKt;
import fleet.util.SequenceKt;
import fleet.util.StringKt;
import fleet.util.openmap.BoundedOpenMap;
import fleet.util.openmap.Key;
import fleet.util.openmap.MutableBoundedOpenMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.coroutines.CoroutineScope;
import org.ec4j.core.EditorConfigLoader;
import org.ec4j.core.Resource;
import org.ec4j.core.model.Ec4jPath;
import org.ec4j.core.model.EditorConfig;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.Section;
import org.ec4j.core.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0014\u0010\n\u001a\u00020\b*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u001e\u0010\f\u001a\u00020\u0001*\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a&\u0010\u000f\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0013\u001a\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0006\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0000\u001a\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u001a\u0018\u0010 \u001a\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\n\u0010!\u001a\u00020\u0002*\u00020\u0004\u001a\u0016\u0010\"\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010#\u001a\u0016\u0010$\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0082@\u00a2\u0006\u0002\u0010#\u001a\u0016\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0082@\u00a2\u0006\u0002\u0010#\u001a\u0012\u0010'\u001a\u0004\u0018\u00010\u00142\u0006\u0010(\u001a\u00020\u001cH\u0002\u001a\u0010\u0010)\u001a\u00020\u00142\u0006\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0006\u0010*\u001a\u00020\u0014\u001a\u0014\u00103\u001a\u00020\u0013*\u0004\u0018\u00010\u00042\u0006\u00104\u001a\u00020\u0006\"\u0015\u0010+\u001a\u00020\u0002*\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\"\u0015\u0010+\u001a\u00020\u0002*\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010/\"\u0017\u00100\u001a\u0004\u0018\u00010\u0004*\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u00065"}, d2={"indentSize", "", "Lfleet/frontend/editor/editorconfig/EditorConfigs;", "path", "Lfleet/api/FileAddress;", "indentStyle", "", "isTabIndent", "", "continuationIndentSize", "smartTabs", "tabWidth", "maxLineLength", "language", "Lfleet/api/workspace/document/LanguageId;", "lookupIdeaLangKey", "key", "lookupIdeaKey", "lookupKey", "Lorg/ec4j/core/model/Ec4jPath;", "Lorg/ec4j/core/model/EditorConfig;", "parseEditorConfig", "text", "editorConfigPlugin", "", "Lfleet/kernel/plugins/ContributionScope;", "computeEditorConfigs", "document", "Lfleet/common/document/DocumentEntity;", "appendWithEditorConfigDefaultsIfNeeded", "mediaType", "Lfleet/api/workspace/document/MediaType;", "appendWithGuessedEditorConfigIfNeeded", "relatedEditorConfig", "getOrCreateEditorConfig", "(Lfleet/common/document/DocumentEntity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOrCreateEditorConfigForFormatting", "getOrCreateEditorConfigData", "Lfleet/frontend/editor/editorconfig/EditorConfigDocumentData;", "guessEditorConfig", "documentEntity", "createSpaceEditorConfig", "createTabEditorConfig", "editorConfig", "Landel/editor/MutableDocument;", "getEditorConfig", "(Landel/editor/MutableDocument;)Lfleet/frontend/editor/editorconfig/EditorConfigs;", "(Lfleet/common/document/DocumentEntity;)Lfleet/frontend/editor/editorconfig/EditorConfigs;", "fileAddress", "getFileAddress", "(Landel/editor/MutableDocument;)Lfleet/api/FileAddress;", "toEc4jPath", "extension", "fleet.frontend"})
@SourceDebugExtension(value={"SMAP\nEditorConfigExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigExt.kt\nfleet/frontend/editor/editorconfig/EditorConfigExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 OpenMap.kt\nfleet/util/openmap/OpenMapKt\n*L\n1#1,272:1\n1#2:273\n1#2:287\n774#3:274\n865#3,2:275\n1611#3,9:277\n1863#3:286\n1864#3:288\n1620#3:289\n21#4,3:290\n*S KotlinDebug\n*F\n+ 1 EditorConfigExt.kt\nfleet/frontend/editor/editorconfig/EditorConfigExtKt\n*L\n106#1:287\n104#1:274\n104#1:275,2\n106#1:277,9\n106#1:286\n106#1:288\n106#1:289\n126#1:290,3\n*E\n"})
public final class EditorConfigExtKt {
    public static final int indentSize(@NotNull EditorConfigs $this$indentSize, @Nullable FileAddress path2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$indentSize, (String)"<this>");
        String indentSize = EditorConfigExtKt.lookupKey($this$indentSize, "indent_size", path2);
        if (Intrinsics.areEqual((Object)indentSize, (Object)"tab")) {
            n = EditorConfigExtKt.tabWidth($this$indentSize, path2);
        } else {
            Object object = indentSize;
            if (object != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
                n = (Integer)object;
            } else {
                DocumentEntity documentEntity;
                SettingsKey<Integer> settingsKey2 = SharedEditorSettingsKeys.INSTANCE.getTabSize();
                FileAddress fileAddress = path2;
                if (fileAddress != null) {
                    FileAddress fileAddress2 = fileAddress;
                    SettingsKey<Integer> settingsKey3 = settingsKey2;
                    boolean bl = false;
                    DocumentFileEntity documentFileEntity = (DocumentFileEntity)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)DocumentFileEntity.Companion.getFileAddressAttr()), (Object)path2);
                    documentEntity = documentFileEntity != null ? documentFileEntity.getDocument() : null;
                    settingsKey2 = settingsKey3;
                } else {
                    documentEntity = null;
                }
                n = ((Number)DocumentEntityExtKt.querySettingsKey(settingsKey2, documentEntity)).intValue();
            }
        }
        return n;
    }

    @NotNull
    public static final String indentStyle(@NotNull EditorConfigs $this$indentStyle, @Nullable FileAddress path2) {
        Intrinsics.checkNotNullParameter((Object)$this$indentStyle, (String)"<this>");
        String string = EditorConfigExtKt.lookupKey($this$indentStyle, "indent_style", path2);
        if (string == null) {
            DocumentEntity documentEntity;
            SettingsKey<EditorIndentStyle> settingsKey2 = SharedEditorSettingsKeys.INSTANCE.getIndentStyle();
            FileAddress fileAddress = path2;
            if (fileAddress != null) {
                FileAddress fileAddress2 = fileAddress;
                SettingsKey<EditorIndentStyle> settingsKey3 = settingsKey2;
                boolean bl = false;
                DocumentFileEntity documentFileEntity = (DocumentFileEntity)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)DocumentFileEntity.Companion.getFileAddressAttr()), (Object)path2);
                documentEntity = documentFileEntity != null ? documentFileEntity.getDocument() : null;
                settingsKey2 = settingsKey3;
            } else {
                documentEntity = null;
            }
            string = DocumentEntityExtKt.querySettingsKey(settingsKey2, documentEntity).getEditorConfigName();
        }
        return string;
    }

    public static final boolean isTabIndent(@NotNull EditorConfigs $this$isTabIndent, @Nullable FileAddress path2) {
        Intrinsics.checkNotNullParameter((Object)$this$isTabIndent, (String)"<this>");
        return Intrinsics.areEqual((Object)EditorConfigExtKt.indentStyle($this$isTabIndent, path2), (Object)"tab");
    }

    public static final int continuationIndentSize(@NotNull EditorConfigs $this$continuationIndentSize, @Nullable FileAddress path2) {
        Intrinsics.checkNotNullParameter((Object)$this$continuationIndentSize, (String)"<this>");
        Object object = EditorConfigExtKt.lookupIdeaKey($this$continuationIndentSize, "continuation_indent_size", path2);
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : EditorConfigExtKt.indentSize($this$continuationIndentSize, path2);
    }

    public static final boolean smartTabs(@NotNull EditorConfigs $this$smartTabs, @Nullable FileAddress path2) {
        Intrinsics.checkNotNullParameter((Object)$this$smartTabs, (String)"<this>");
        return Boolean.parseBoolean(EditorConfigExtKt.lookupIdeaKey($this$smartTabs, "smart_tabs", path2));
    }

    public static final int tabWidth(@NotNull EditorConfigs $this$tabWidth, @Nullable FileAddress path2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$tabWidth, (String)"<this>");
        Object object = EditorConfigExtKt.lookupKey($this$tabWidth, "tab_width", path2);
        if (object != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
            n = (Integer)object;
        } else {
            DocumentEntity documentEntity;
            SettingsKey<Integer> settingsKey2 = SharedEditorSettingsKeys.INSTANCE.getTabSize();
            FileAddress fileAddress = path2;
            if (fileAddress != null) {
                FileAddress fileAddress2 = fileAddress;
                SettingsKey<Integer> settingsKey3 = settingsKey2;
                boolean bl = false;
                DocumentFileEntity documentFileEntity = (DocumentFileEntity)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)DocumentFileEntity.Companion.getFileAddressAttr()), (Object)path2);
                documentEntity = documentFileEntity != null ? documentFileEntity.getDocument() : null;
                settingsKey2 = settingsKey3;
            } else {
                documentEntity = null;
            }
            n = ((Number)DocumentEntityExtKt.querySettingsKey(settingsKey2, documentEntity)).intValue();
        }
        return n;
    }

    public static final int maxLineLength(@NotNull EditorConfigs $this$maxLineLength, @Nullable LanguageId language, @Nullable FileAddress path2) {
        Intrinsics.checkNotNullParameter((Object)$this$maxLineLength, (String)"<this>");
        if (language != null) {
            Integer langMaxLineLength;
            String string = EditorConfigExtKt.lookupIdeaLangKey($this$maxLineLength, "max_line_length", language, path2);
            Integer n = langMaxLineLength = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
            if (langMaxLineLength != null && langMaxLineLength >= 0) {
                return langMaxLineLength;
            }
        }
        return 120;
    }

    @Nullable
    public static final String lookupIdeaLangKey(@NotNull EditorConfigs $this$lookupIdeaLangKey, @NotNull String key, @NotNull LanguageId language, @Nullable FileAddress path2) {
        Intrinsics.checkNotNullParameter((Object)$this$lookupIdeaLangKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String langString = StringKt.lowercaseLocaleAgnostic((String)language.getName());
        return EditorConfigExtKt.lookupKey($this$lookupIdeaLangKey, "ij_" + langString + "_" + key, path2);
    }

    @Nullable
    public static final String lookupIdeaKey(@NotNull EditorConfigs $this$lookupIdeaKey, @NotNull String key, @Nullable FileAddress path2) {
        Intrinsics.checkNotNullParameter((Object)$this$lookupIdeaKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return EditorConfigExtKt.lookupKey($this$lookupIdeaKey, "ij_" + key, path2);
    }

    @Nullable
    public static final String lookupKey(@NotNull EditorConfigs $this$lookupKey, @NotNull String key, @Nullable FileAddress path2) {
        Intrinsics.checkNotNullParameter((Object)$this$lookupKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return EditorConfigExtKt.lookupKey($this$lookupKey, key, EditorConfigExtKt.toEc4jPath(path2, ""));
    }

    @Nullable
    public static final String lookupKey(@NotNull EditorConfigs $this$lookupKey, @NotNull String key, @NotNull Ec4jPath path2) {
        Object object;
        block4: {
            Object object2;
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$lookupKey, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                for (Object config2 : SequenceKt.takeWhileInclusive((Sequence)CollectionsKt.asSequence((Iterable)$this$lookupKey.getConfigs()), (Function1)lookupKey.1.INSTANCE)) {
                    boolean bl = false;
                    if ((config2 = EditorConfigExtKt.lookupKey(config2, key, path2)) == null) continue;
                    object2 = config2;
                    break block3;
                }
                object2 = object = null;
            }
            if (object2 == null) {
                for (EditorConfig fallbackConfig : (Iterable)$this$lookupKey.getFallbackConfigs()) {
                    boolean bl = false;
                    String string = EditorConfigExtKt.lookupKey(fallbackConfig, key, path2);
                    if (string == null) continue;
                    object = string;
                    break block4;
                }
                object = null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final String lookupKey(EditorConfig $this$lookupKey, String key, Ec4jPath path2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        List list = $this$lookupKey.getSections();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSections(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Section section = (Section)element$iv$iv;
            boolean bl = false;
            if (!(section.getProperties().containsKey(key) && section.getGlob().match(path2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Section section = (Section)element$iv$iv;
            boolean bl2 = false;
            Object v = section.getProperties().get(key);
            Intrinsics.checkNotNull(v);
            String string = ((Property)v).getSourceValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSourceValue(...)");
            if (((Object)StringsKt.trim((CharSequence)string)).toString() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (String)CollectionsKt.lastOrNull((List)((List)destination$iv$iv));
    }

    @Nullable
    public static final EditorConfig parseEditorConfig(@NotNull String text2) {
        EditorConfig editorConfig;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        try {
            editorConfig = EditorConfigLoader.default_().load(Resource.Resources.ofString((String)".editorconfig", (String)text2));
        }
        catch (ParseException e) {
            editorConfig = null;
        }
        return editorConfig;
    }

    public static final void editorConfigPlugin(@NotNull ContributionScope $this$editorConfigPlugin) {
        Intrinsics.checkNotNullParameter((Object)$this$editorConfigPlugin, (String)"<this>");
        EditorApiKt.editorConfigDefaults($this$editorConfigPlugin, new MediaType("text", "makefile", null, null, 12, null), (Function0<? extends EditorConfig>)((Function0)editorConfigPlugin.1.INSTANCE));
        DocumentApiKt.documentMetaContributor($this$editorConfigPlugin, EditorConfigExtKt::editorConfigPlugin$lambda$9);
        WorkerKt.worker((ChangeScope)((ChangeScope)$this$editorConfigPlugin), (String)"editor config parsing", (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ConfigParserKt.parseConfigsFromDocument((EntityType)((EntityType)EditorConfigEntity.Companion), (Function1)((Function1)editorConfigPlugin.1.INSTANCE), (Function1)editorConfigPlugin.2.INSTANCE, (Function3)editorConfigPlugin.3.INSTANCE, (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        WorkerKt.worker((ChangeScope)((ChangeScope)$this$editorConfigPlugin), (String)"editor config merging", (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ReteKt.collect((Query)QueriesKt.map((Query)QueriesKt.filter((Query)QueriesKt.each((EntityType)((EntityType)DocumentEntity.Companion)), (Function1)editorConfigPlugin.1.INSTANCE), (Function1)editorConfigPlugin.2.INSTANCE), (Function3)((Function3)new Function3<CoroutineScope, Triple<? extends DocumentEntity, ? extends EditorConfigs, ? extends MediaType>, Continuation<? super Unit>, Object>(null){
                            int label;
                            /* synthetic */ Object L$0;

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Triple triple = (Triple)this.L$0;
                                        DocumentEntity document2 = (DocumentEntity)triple.component1();
                                        EditorConfigs rawEditorConfigs = (EditorConfigs)triple.component2();
                                        MediaType mediaType = (MediaType)triple.component3();
                                        this.label = 1;
                                        Object object3 = TransactorKt.change((Function1)((Function1)new Function1<ChangeScope, Unit>(rawEditorConfigs, document2, mediaType){
                                            final /* synthetic */ EditorConfigs $rawEditorConfigs;
                                            final /* synthetic */ DocumentEntity $document;
                                            final /* synthetic */ MediaType $mediaType;
                                            {
                                                this.$rawEditorConfigs = $rawEditorConfigs;
                                                this.$document = $document;
                                                this.$mediaType = $mediaType;
                                                super(1);
                                            }

                                            public final void invoke(ChangeScope $this$change) {
                                                Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
                                                EditorConfigs editorConfigs = EditorConfigExtKt.access$appendWithEditorConfigDefaultsIfNeeded(EditorConfigExtKt.access$appendWithGuessedEditorConfigIfNeeded(this.$rawEditorConfigs, this.$document), this.$mediaType);
                                                EditorConfigs editorConfigsNoGuessing = EditorConfigExtKt.access$appendWithEditorConfigDefaultsIfNeeded(this.$rawEditorConfigs, this.$mediaType);
                                                $this$change.upsert((EntityType)EditorConfigDocumentData.Companion, (EntityAttribute)EditorConfigDocumentData.Companion.getDocumentAttr(), (Object)this.$document, arg_0 -> editorConfigPlugin.1.invoke$lambda$0(editorConfigs, editorConfigsNoGuessing, arg_0));
                                            }

                                            private static final void invoke$lambda$0(EditorConfigs $editorConfigs, EditorConfigs $editorConfigsNoGuessing, EntityBuilder.Target it) {
                                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                Attributes.Required<EditorConfigs> required = EditorConfigDocumentData.Companion.getEditorConfigAttr();
                                                EditorConfigs editorConfigs = $editorConfigs;
                                                if (editorConfigs == null) {
                                                    editorConfigs = EditorConfigs.Companion.getEmpty();
                                                }
                                                it.set(required, (Object)editorConfigs);
                                                Attributes.Required<EditorConfigs> required2 = EditorConfigDocumentData.Companion.getEditorConfigNoGuessingAttr();
                                                EditorConfigs editorConfigs2 = $editorConfigsNoGuessing;
                                                if (editorConfigs2 == null) {
                                                    editorConfigs2 = EditorConfigs.Companion.getEmpty();
                                                }
                                                it.set(required2, (Object)editorConfigs2);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Object invoke(CoroutineScope p1, Triple<DocumentEntity, EditorConfigs, MediaType> p2, Continuation<? super Unit> p3) {
                                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                                var4_4.L$0 = p2;
                                return var4_4.invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final EditorConfigs computeEditorConfigs(DocumentEntity document2) {
        boolean autoDetectIndent = DocumentEntityExtKt.querySettingsKey(SharedEditorSettingsKeys.INSTANCE.getAutoDetectIndentation(), document2);
        EditorConfigDocumentData editorConfigDocumentData = (EditorConfigDocumentData)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)EditorConfigDocumentData.Companion.getDocumentAttr()), (Object)document2);
        return editorConfigDocumentData != null ? (autoDetectIndent ? editorConfigDocumentData.getEditorConfig() : editorConfigDocumentData.getEditorConfigNoGuessing()) : (autoDetectIndent ? new EditorConfigs(CollectionsKt.listOfNotNull((Object)EditorConfigExtKt.guessEditorConfig(document2)), CollectionsKt.listOfNotNull((Object)EditorApiKt.editorConfigDefaultsByMediaType(DocumentCodeProfileEntityKt.getMediaType((DocumentEntity)document2)))) : new EditorConfigs(CollectionsKt.listOfNotNull((Object)EditorApiKt.editorConfigDefaultsByMediaType(DocumentCodeProfileEntityKt.getMediaType((DocumentEntity)document2))), CollectionsKt.emptyList()));
    }

    private static final EditorConfigs appendWithEditorConfigDefaultsIfNeeded(EditorConfigs $this$appendWithEditorConfigDefaultsIfNeeded, MediaType mediaType) {
        EditorConfig defaults = EditorApiKt.editorConfigDefaultsByMediaType(mediaType);
        return defaults == null ? $this$appendWithEditorConfigDefaultsIfNeeded : ($this$appendWithEditorConfigDefaultsIfNeeded == null ? new EditorConfigs(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)defaults)) : EditorConfigs.copy$default($this$appendWithEditorConfigDefaultsIfNeeded, null, CollectionsKt.plus((Collection)$this$appendWithEditorConfigDefaultsIfNeeded.getFallbackConfigs(), (Object)defaults), 1, null));
    }

    private static final EditorConfigs appendWithGuessedEditorConfigIfNeeded(EditorConfigs $this$appendWithGuessedEditorConfigIfNeeded, DocumentEntity document2) {
        Object object;
        block5: {
            block6: {
                block7: {
                    FileAddress path2;
                    block4: {
                        path2 = DocumentEntityKt.getLocationFileAddress((DocumentEntity)document2);
                        if ($this$appendWithGuessedEditorConfigIfNeeded != null) break block4;
                        EditorConfig editorConfig = EditorConfigExtKt.guessEditorConfig(document2);
                        if (editorConfig != null) {
                            EditorConfig guessedConfig = editorConfig;
                            boolean bl = false;
                            object = new EditorConfigs(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)guessedConfig));
                        } else {
                            object = null;
                        }
                        break block5;
                    }
                    if (EditorConfigExtKt.lookupKey($this$appendWithGuessedEditorConfigIfNeeded, "indent_style", path2) != null && EditorConfigExtKt.lookupKey($this$appendWithGuessedEditorConfigIfNeeded, "indent_size", path2) != null) break block6;
                    object = EditorConfigExtKt.guessEditorConfig(document2);
                    if (object == null) break block7;
                    Object guessed = object;
                    boolean bl = false;
                    EditorConfigs editorConfigs = EditorConfigs.copy$default($this$appendWithGuessedEditorConfigIfNeeded, null, CollectionsKt.plus((Collection)$this$appendWithGuessedEditorConfigIfNeeded.getFallbackConfigs(), (Object)guessed), 1, null);
                    object = editorConfigs;
                    if (editorConfigs != null) break block5;
                }
                object = $this$appendWithGuessedEditorConfigIfNeeded;
                break block5;
            }
            object = $this$appendWithGuessedEditorConfigIfNeeded;
        }
        return object;
    }

    @NotNull
    public static final EditorConfigs relatedEditorConfig(@NotNull FileAddress $this$relatedEditorConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$relatedEditorConfig, (String)"<this>");
        return new EditorConfigs(SequencesKt.toList((Sequence)SequenceKt.takeWhileInclusive((Sequence)SequencesKt.mapNotNull((Sequence)FileAddressKt.getSelfAndParents((FileAddress)$this$relatedEditorConfig), (Function1)relatedEditorConfig.1.INSTANCE), (Function1)relatedEditorConfig.2.INSTANCE)), CollectionsKt.emptyList());
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getOrCreateEditorConfig(@NotNull DocumentEntity var0, @NotNull Continuation<? super EditorConfigs> $completion) {
        if (!($completion instanceof getOrCreateEditorConfig.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EditorConfigExtKt.getOrCreateEditorConfig(null, (Continuation<? super EditorConfigs>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!DocumentEntityExtKt.querySettingsKey(SharedEditorSettingsKeys.INSTANCE.getAutoDetectIndentation(), document).booleanValue()) break;
                $continuation.label = 1;
                v0 = EditorConfigExtKt.getOrCreateEditorConfigData(document, (Continuation<? super EditorConfigDocumentData>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                v1 = ((EditorConfigDocumentData)v0).getEditorConfig();
                ** GOTO lbl32
            }
        }
        $continuation.label = 2;
        v2 = EditorConfigExtKt.getOrCreateEditorConfigData(document, (Continuation<? super EditorConfigDocumentData>)$continuation);
        if (v2 == var4_4) {
            return var4_4;
        }
        ** GOTO lbl31
        {
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl31:
                // 2 sources

                v1 = ((EditorConfigDocumentData)v2).getEditorConfigNoGuessing();
lbl32:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private static final Object getOrCreateEditorConfigForFormatting(DocumentEntity var0, Continuation<? super EditorConfigs> $completion) {
        if (!($completion instanceof getOrCreateEditorConfigForFormatting.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EditorConfigExtKt.access$getOrCreateEditorConfigForFormatting(null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = EditorConfigExtKt.getOrCreateEditorConfigData(document, (Continuation<? super EditorConfigDocumentData>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return ((EditorConfigDocumentData)v0).getEditorConfigNoGuessing();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Object getOrCreateEditorConfigData(DocumentEntity document2, Continuation<? super EditorConfigDocumentData> $completion) {
        EditorConfigDocumentData editorConfig;
        EditorConfigDocumentData editorConfigDocumentData = editorConfig = (EditorConfigDocumentData)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)EditorConfigDocumentData.Companion.getDocumentAttr()), (Object)document2);
        if (editorConfigDocumentData != null) {
            return editorConfigDocumentData;
        }
        EditorConfig guessedEditorConfig = EditorConfigExtKt.guessEditorConfig(document2);
        EditorConfigs editorConfigs = new EditorConfigs(CollectionsKt.listOfNotNull((Object)guessedEditorConfig), CollectionsKt.listOfNotNull((Object)EditorApiKt.editorConfigDefaultsByMediaType(DocumentCodeProfileEntityKt.getMediaType((DocumentEntity)document2))));
        return TransactorKt.change((Function1)((Function1)new Function1<ChangeScope, EditorConfigDocumentData>(document2, editorConfigs, guessedEditorConfig){
            final /* synthetic */ DocumentEntity $document;
            final /* synthetic */ EditorConfigs $editorConfigs;
            final /* synthetic */ EditorConfig $guessedEditorConfig;
            {
                this.$document = $document;
                this.$editorConfigs = $editorConfigs;
                this.$guessedEditorConfig = $guessedEditorConfig;
                super(1);
            }

            public final EditorConfigDocumentData invoke(ChangeScope $this$change) {
                Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
                EditorConfigDocumentData editorConfigDocumentData = (EditorConfigDocumentData)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)EditorConfigDocumentData.Companion.getDocumentAttr()), (Object)this.$document);
                if (editorConfigDocumentData == null) {
                    ChangeScope changeScope = $this$change;
                    DocumentEntity documentEntity = this.$document;
                    EditorConfigs editorConfigs = this.$editorConfigs;
                    EditorConfig editorConfig = this.$guessedEditorConfig;
                    ChangeScope $this$invoke_u24lambda_u241 = changeScope;
                    boolean bl = false;
                    editorConfigDocumentData = (EditorConfigDocumentData)$this$invoke_u24lambda_u241.new((EntityType)EditorConfigDocumentData.Companion, arg_0 -> getOrCreateEditorConfigData.2.invoke$lambda$1$lambda$0(documentEntity, editorConfigs, editorConfig, arg_0));
                }
                return editorConfigDocumentData;
            }

            private static final void invoke$lambda$1$lambda$0(DocumentEntity $document, EditorConfigs $editorConfigs, EditorConfig $guessedEditorConfig, EntityBuilder.Target it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.set(EditorConfigDocumentData.Companion.getDocumentAttr(), (Object)$document);
                it.set(EditorConfigDocumentData.Companion.getEditorConfigAttr(), (Object)$editorConfigs);
                it.set(EditorConfigDocumentData.Companion.getEditorConfigNoGuessingAttr(), (Object)new EditorConfigs(CollectionsKt.listOfNotNull((Object)$guessedEditorConfig), CollectionsKt.emptyList()));
            }
        }), $completion);
    }

    private static final EditorConfig guessEditorConfig(DocumentEntity documentEntity) {
        GuessedIndent guessedIndent;
        GuessedIndent guessedIndent2 = guessedIndent = IndentAutoDetection.INSTANCE.guessIndent(documentEntity.getText());
        IndentStyle indentStyle2 = guessedIndent2 != null ? guessedIndent2.getIndentStyle() : null;
        return switch (indentStyle2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[indentStyle2.ordinal()]) {
            case -1 -> null;
            case 1 -> EditorConfigExtKt.createTabEditorConfig();
            case 2 -> EditorConfigExtKt.createSpaceEditorConfig(guessedIndent.getSize());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final EditorConfig createSpaceEditorConfig(int indentSize) {
        EditorConfig editorConfig = EditorConfigExtKt.parseEditorConfig(StringsKt.trimIndent((String)("\n    [*]\n    indent_style = space\n    indent_size = " + indentSize + "\n  ")));
        Intrinsics.checkNotNull((Object)editorConfig);
        return editorConfig;
    }

    @NotNull
    public static final EditorConfig createTabEditorConfig() {
        EditorConfig editorConfig = EditorConfigExtKt.parseEditorConfig("[*]\nindent_style = tab");
        Intrinsics.checkNotNull((Object)editorConfig);
        return editorConfig;
    }

    @NotNull
    public static final EditorConfigs getEditorConfig(@NotNull MutableDocument $this$editorConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$editorConfig, (String)"<this>");
        EditorConfigs editorConfigs = (EditorConfigs)$this$editorConfig.getMeta().get((Key)EditorConfigDocumentMetaKey.INSTANCE);
        if (editorConfigs == null) {
            editorConfigs = new EditorConfigs(CollectionsKt.listOf((Object)EditorConfig.builder().build()), CollectionsKt.emptyList());
        }
        return editorConfigs;
    }

    @NotNull
    public static final EditorConfigs getEditorConfig(@NotNull DocumentEntity $this$editorConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$editorConfig, (String)"<this>");
        EditorConfigs editorConfigs = (EditorConfigs)DocumentApiKt.collectMeta($this$editorConfig).get((Key)EditorConfigDocumentMetaKey.INSTANCE);
        if (editorConfigs == null) {
            editorConfigs = new EditorConfigs(CollectionsKt.listOf((Object)EditorConfig.builder().build()), CollectionsKt.emptyList());
        }
        return editorConfigs;
    }

    @Nullable
    public static final FileAddress getFileAddress(@NotNull MutableDocument $this$fileAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$fileAddress, (String)"<this>");
        return (FileAddress)$this$fileAddress.getMeta().get((Key)FileAddressDocumentMetaKey.INSTANCE);
    }

    @NotNull
    public static final Ec4jPath toEc4jPath(@Nullable FileAddress $this$toEc4jPath, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Object object = $this$toEc4jPath;
        if (object == null || (object = object.getPath()) == null || (object = object.joinToString()) == null) {
            object = "foo." + extension;
        }
        Ec4jPath ec4jPath = Ec4jPath.Ec4jPaths.of((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)ec4jPath, (String)"of(...)");
        return ec4jPath;
    }

    private static final BoundedOpenMap editorConfigPlugin$lambda$9(DocumentEntity document2) {
        MutableBoundedOpenMap m$iv;
        block0: {
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            boolean $i$f$OpenMap = false;
            MutableBoundedOpenMap $this$editorConfigPlugin_u24lambda_u249_u24lambda_u248 = m$iv = MutableBoundedOpenMap.Companion.from(ExtensionsKt.persistentHashMapOf());
            boolean bl = false;
            $this$editorConfigPlugin_u24lambda_u249_u24lambda_u248.set((Key)EditorConfigDocumentMetaKey.INSTANCE, (Object)EditorConfigExtKt.computeEditorConfigs(document2));
            DocumentLocation documentLocation = DocumentCodeProfileEntityKt.getLocation((DocumentEntity)document2);
            if (documentLocation == null || (documentLocation = documentLocation.getFileAddress()) == null) break block0;
            DocumentLocation it = documentLocation;
            boolean bl2 = false;
            $this$editorConfigPlugin_u24lambda_u249_u24lambda_u248.set((Key)FileAddressDocumentMetaKey.INSTANCE, (Object)it);
        }
        return m$iv.persistent();
    }

    public static final /* synthetic */ EditorConfigs access$appendWithEditorConfigDefaultsIfNeeded(EditorConfigs $receiver, MediaType mediaType) {
        return EditorConfigExtKt.appendWithEditorConfigDefaultsIfNeeded($receiver, mediaType);
    }

    public static final /* synthetic */ EditorConfigs access$appendWithGuessedEditorConfigIfNeeded(EditorConfigs $receiver, DocumentEntity document2) {
        return EditorConfigExtKt.appendWithGuessedEditorConfigIfNeeded($receiver, document2);
    }

    public static final /* synthetic */ Object access$getOrCreateEditorConfigForFormatting(DocumentEntity document2, Continuation $completion) {
        return EditorConfigExtKt.getOrCreateEditorConfigForFormatting(document2, (Continuation<? super EditorConfigs>)$completion);
    }

    public static final /* synthetic */ Object access$getOrCreateEditorConfigData(DocumentEntity document2, Continuation $completion) {
        return EditorConfigExtKt.getOrCreateEditorConfigData(document2, (Continuation<? super EditorConfigDocumentData>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IndentStyle.values().length];
            try {
                nArray[IndentStyle.Tab.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentStyle.Space.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

