/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.actions;

import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.common.FleetCommonSettingsKeysKt;
import fleet.common.fus.validation.CustomValidationKt;
import fleet.dock.connectors.fus.EventContext;
import fleet.dock.connectors.fus.ValidationResult;
import fleet.dock.connectors.fus.ValidationRule;
import fleet.frontend.actions.ActionEntity;
import fleet.frontend.actions.ActionTriggerValidator;
import fleet.frontend.actions.ActionsReportsKt;
import fleet.util.logging.BaseLogger;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.model.ActionId;
import noria.model.CommonTrigger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"Lfleet/frontend/actions/ActionTriggerValidator;", "Lfleet/dock/connectors/fus/ValidationRule;", "<init>", "()V", "validate", "Lfleet/dock/connectors/fus/ValidationResult;", "data", "", "context", "Lfleet/dock/connectors/fus/EventContext;", "isSafeToReport", "", "triggerIdent", "Companion", "fleet.frontend"})
@SourceDebugExtension(value={"SMAP\nActionsReports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionsReports.kt\nfleet/frontend/actions/ActionTriggerValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,394:1\n1755#2,3:395\n1755#2,3:398\n*S KotlinDebug\n*F\n+ 1 ActionsReports.kt\nfleet/frontend/actions/ActionTriggerValidator\n*L\n345#1:395,3\n346#1:398,3\n*E\n"})
public final class ActionTriggerValidator
implements ValidationRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String RULE_ID = "fleet.actions.trigger";

    @NotNull
    public ValidationResult validate(@NotNull String data, @NotNull EventContext context) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean isSafeToReport = this.isSafeToReport(data);
        if (!isSafeToReport && FleetCommonSettingsKeysKt.isInternalMode() && ((Number)ActionsReportsKt.access$getReported$p().getAndUpdate((Function1)validate.1.INSTANCE)).intValue() > 0) {
            BaseLogger.error$default((BaseLogger)((BaseLogger)ActionsReportsKt.access$getLogger()), (Throwable)new Throwable("Action trigger " + data + " was reported, but not registered. This is internal-mode-only error, please report it"), null, (int)2, null);
        }
        return isSafeToReport ? ValidationResult.ACCEPTED : ValidationResult.REJECTED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSafeToReport(@NotNull String triggerIdent) {
        ActionEntity actionEntity;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)triggerIdent, (String)"triggerIdent");
        Iterable $this$any$iv = (Iterable)CommonTrigger.getEntries();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                CommonTrigger it = (CommonTrigger)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)triggerIdent)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)ActionEntity.Companion.getIdentifierAttr()), (Object)new ActionId(triggerIdent));
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            actionEntity = (ActionEntity)element$iv;
            boolean bl3 = false;
        } while (!CustomValidationKt.isFromAllowedPlugin((ValidationRule.Companion)ValidationRule.Companion, (Entity)actionEntity));
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lfleet/frontend/actions/ActionTriggerValidator$Companion;", "", "<init>", "()V", "RULE_ID", "", "getRULE_ID", "()Ljava/lang/String;", "fleet.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getRULE_ID() {
            return RULE_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

