/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.llm.provider.openai.profile.definitions;

import ai.grazie.llm.provider.openai.profile.definitions.OpenAIParameterDefinition;
import ai.grazie.model.cloud.exceptions.ExtensionsKt;
import ai.grazie.model.llm.chat.response.LLMResponseFormat;
import ai.grazie.model.llm.definitions.ParameterDefinition;
import ai.grazie.model.llm.utils.AttributesExtensionKt;
import ai.grazie.utils.attributes.Attributes;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lai/grazie/llm/provider/openai/profile/definitions/OpenAIParameterDefinition;", "Lai/grazie/model/llm/definitions/ParameterDefinition;", "supportedParameters", "", "Lai/grazie/utils/attributes/Attributes$Key;", "(Ljava/util/Set;)V", "getSupportedParameters", "()Ljava/util/Set;", "validateParameters", "", "name", "", "parameters", "Lai/grazie/utils/attributes/Attributes;", "validateResponseFormat", "llm-provider-openai-profile"})
public class OpenAIParameterDefinition
implements ParameterDefinition {
    @NotNull
    private final Set<Attributes.Key> supportedParameters;

    public OpenAIParameterDefinition(@NotNull Set<? extends Attributes.Key> supportedParameters) {
        Intrinsics.checkNotNullParameter(supportedParameters, (String)"supportedParameters");
        this.supportedParameters = supportedParameters;
    }

    @NotNull
    public Set<Attributes.Key> getSupportedParameters() {
        return this.supportedParameters;
    }

    public void validateResponseFormat(@NotNull Attributes parameters) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        try {
            Unit unit;
            boolean bl = false;
            LLMResponseFormat lLMResponseFormat = AttributesExtensionKt.getResponseFormat((Attributes)parameters);
            LLMResponseFormat.Json json = lLMResponseFormat instanceof LLMResponseFormat.Json ? (LLMResponseFormat.Json)lLMResponseFormat : null;
            if (json != null) {
                LLMResponseFormat.Json it = json;
                boolean bl2 = false;
                if (!(it.getSchemaName() == null)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(it.getSchema() == null)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            ExtensionsKt.badRequest((String)"Model doesn't support json schema\nValid example:\n{\n    \"type\": \"json\"\n}");
            throw new KotlinNothingValueException();
        }
    }

    public void validateParameters(@NotNull String name, @NotNull Attributes parameters) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        super.validateParameters(name, parameters);
        Double d = AttributesExtensionKt.getTemperature((Attributes)parameters);
        if (d != null) {
            double temperature = ((Number)d).doubleValue();
            boolean bl = false;
            ExtensionsKt.requireOrBadRequest((boolean)(0.0 <= temperature ? temperature <= 2.0 : false), (Function0)validateParameters.1.1.INSTANCE);
        }
        Double d2 = AttributesExtensionKt.getTopP((Attributes)parameters);
        if (d2 != null) {
            double topP = ((Number)d2).doubleValue();
            boolean bl = false;
            ExtensionsKt.requireOrBadRequest((boolean)(0.0 <= topP ? topP <= 1.0 : false), (Function0)validateParameters.2.1.INSTANCE);
        }
        this.validateResponseFormat(parameters);
    }
}

