/*
 * Decompiled with CFR 0.152.
 */
package fleet.reporting.anonymization;

import fleet.reporting.anonymization.DeviceIdManager;
import fleet.util.os.Os;
import java.io.File;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\u0005J\b\u0010\t\u001a\u00020\u0005H\u0002J(\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lfleet/reporting/anonymization/PermanentInstallationID;", "", "<init>", "()V", "OLD_USER_ON_MACHINE_ID_KEY", "", "INSTALLATION_ID_KEY", "INSTALLATION_ID", "get", "calculateInstallationId", "syncWithSharedFile", "fileName", "installationId", "prefs", "Ljava/util/prefs/Preferences;", "prefsKey", "fleet.reporting.anonymization"})
@SourceDebugExtension(value={"SMAP\nPermanentInstallationID.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermanentInstallationID.kt\nfleet/reporting/anonymization/PermanentInstallationID\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,79:1\n108#2:80\n80#2,22:81\n*S KotlinDebug\n*F\n+ 1 PermanentInstallationID.kt\nfleet/reporting/anonymization/PermanentInstallationID\n*L\n60#1:80\n60#1:81,22\n*E\n"})
public final class PermanentInstallationID {
    @NotNull
    public static final PermanentInstallationID INSTANCE = new PermanentInstallationID();
    @NotNull
    private static final String OLD_USER_ON_MACHINE_ID_KEY = "JetBrains.UserIdOnMachine";
    @NotNull
    private static final String INSTALLATION_ID_KEY = "user_id_on_machine";
    @NotNull
    private static final String INSTALLATION_ID = INSTANCE.calculateInstallationId();

    private PermanentInstallationID() {
    }

    @NotNull
    public final String get() {
        return INSTALLATION_ID;
    }

    private final String calculateInstallationId() {
        String string;
        String installationId = null;
        try {
            CharSequence charSequence;
            Preferences prefs;
            String string2;
            String oldValue;
            Preferences oldPrefs = Preferences.userRoot();
            String string3 = oldPrefs.get(OLD_USER_ON_MACHINE_ID_KEY, null);
            if (string3 == null) {
                string3 = oldValue = null;
            }
            if ((string2 = (prefs = Preferences.userRoot().node("jetbrains")).get(INSTALLATION_ID_KEY, null)) == null) {
                string2 = null;
            }
            if ((charSequence = (CharSequence)(installationId = string2)) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                String string4;
                charSequence = oldValue;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    string4 = oldValue;
                } else {
                    String string5 = UUID.randomUUID().toString();
                    string4 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                }
                installationId = string4;
                prefs.put(INSTALLATION_ID_KEY, installationId);
            }
            if (Os.INSTANCE.isWindows()) {
                Intrinsics.checkNotNull((Object)prefs);
                installationId = this.syncWithSharedFile("PermanentUserId", installationId, prefs, INSTALLATION_ID_KEY);
            }
            if (!Intrinsics.areEqual((Object)installationId, (Object)oldValue)) {
                oldPrefs.put(OLD_USER_ON_MACHINE_ID_KEY, installationId);
            }
        }
        catch (Throwable ex) {
            System.err.println("Unexpected error initializing Installation ID");
        }
        if ((string = installationId) == null) {
            String string6 = UUID.randomUUID().toString();
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        }
        return string;
    }

    private final String syncWithSharedFile(String fileName, String installationId, Preferences prefs, String prefsKey) {
        String installationId2 = installationId;
        try {
            File dir;
            String appdata = System.getenv("APPDATA");
            if (appdata != null && ((dir = new File(appdata, "JetBrains")).exists() || dir.mkdirs())) {
                File permanentIdFile = new File(dir, fileName);
                String fromFile = "";
                if (permanentIdFile.exists()) {
                    String $this$trim$iv = DeviceIdManager.INSTANCE.loadFromFile$fleet_reporting_anonymization(permanentIdFile);
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    fromFile = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                }
                if (!(((CharSequence)fromFile).length() == 0)) {
                    if (!Intrinsics.areEqual((Object)fromFile, (Object)installationId2)) {
                        installationId2 = fromFile;
                        prefs.put(prefsKey, installationId2);
                    }
                } else {
                    DeviceIdManager.INSTANCE.writeToFile$fleet_reporting_anonymization(permanentIdFile, installationId2);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return installationId2;
    }
}

