/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.xml.util.documentation;

import fleet.com.intellij.openapi.util.JDOMUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;

public class HtmlDescriptorsTable {
    private static final HashSet<String> ourAttributeTable = new HashSet();
    @NonNls
    public static final String HTMLTABLE_RESOURCE_NAME = "htmltable.xml";
    @NonNls
    public static final String HTML5TABLE_RESOURCE_NAME = "html5table.xml";
    @NonNls
    private static final String MATHML_RESOURCE_NAME = "mathmltable.xml";
    @NonNls
    private static final String SVG_RESOURCE_NAME = "svgtable.xml";
    @NonNls
    public static final String ATTRIBUTE_ELEMENT_NAME = "attribute";
    @NonNls
    public static final String NAME_ATTR = "name";

    private static void loadHtmlElements(String resourceName) throws JDOMException, IOException {
        Element rootElement = JDOMUtil.load((InputStream)HtmlDescriptorsTable.class.getResourceAsStream(resourceName));
        List attributes = rootElement.getChildren(ATTRIBUTE_ELEMENT_NAME);
        for (Element element : attributes) {
            ourAttributeTable.add(element.getAttributeValue(NAME_ATTR));
        }
    }

    public static boolean isKnownAttributeDescriptor(String attributeName) {
        return ourAttributeTable.contains(attributeName);
    }

    static {
        try {
            HtmlDescriptorsTable.loadHtmlElements(HTMLTABLE_RESOURCE_NAME);
            HtmlDescriptorsTable.loadHtmlElements(HTML5TABLE_RESOURCE_NAME);
            HtmlDescriptorsTable.loadHtmlElements(MATHML_RESOURCE_NAME);
            HtmlDescriptorsTable.loadHtmlElements(SVG_RESOURCE_NAME);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

