/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.html;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.openapi.util.NlsContexts;
import fleet.com.intellij.openapi.util.Ref;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.tree.ICustomParsingType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.ILazyParseableElementType;
import fleet.com.intellij.psi.xml.XmlElementType;
import fleet.com.intellij.psi.xml.XmlTokenType;
import fleet.com.intellij.util.Processor;
import fleet.com.intellij.util.ThreeState;
import fleet.com.intellij.util.containers.Stack;
import fleet.com.intellij.xml.psi.XmlPsiBundle;
import fleet.com.intellij.xml.util.HtmlUtil;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlParsing {
    private final PsiBuilder myBuilder;
    private final Stack<HtmlParserStackItem> myItemsStack = new Stack();
    private static final String COMPLETION_NAME = StringUtil.toLowerCase((String)"IntellijIdeaRulezzz");

    public HtmlParsing(PsiBuilder builder) {
        this.myBuilder = builder;
    }

    public void parseDocument() {
        PsiBuilder.Marker document = this.mark();
        while (this.token() == XmlTokenType.XML_COMMENT_START) {
            this.parseComment();
        }
        this.parseProlog();
        PsiBuilder.Marker error = null;
        while (this.shouldContinueMainLoop()) {
            IElementType tt = this.token();
            if (tt == XmlTokenType.XML_START_TAG_START) {
                error = HtmlParsing.flushError(error);
                this.parseTag();
                continue;
            }
            if (tt == XmlTokenType.XML_COMMENT_START) {
                error = HtmlParsing.flushError(error);
                this.parseComment();
                continue;
            }
            if (tt == XmlTokenType.XML_PI_START) {
                error = HtmlParsing.flushError(error);
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlTokenType.XML_CHAR_ENTITY_REF || tt == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                this.parseReference();
                continue;
            }
            if (tt == XmlTokenType.XML_REAL_WHITE_SPACE || tt == XmlTokenType.XML_DATA_CHARACTERS) {
                error = HtmlParsing.flushError(error);
                this.advance();
                continue;
            }
            if (tt == XmlTokenType.XML_END_TAG_START) {
                PsiBuilder.Marker tagEndError = this.myBuilder.mark();
                this.advance();
                if (this.token() == XmlTokenType.XML_NAME) {
                    this.advance();
                    if (this.token() == XmlTokenType.XML_TAG_END) {
                        this.advance();
                    }
                }
                tagEndError.error(XmlPsiBundle.message("xml.parsing.closing.tag.matches.nothing", new Object[0]));
                continue;
            }
            if (this.hasCustomTopLevelContent()) {
                error = this.parseCustomTopLevelContent(error);
                continue;
            }
            if (error == null) {
                error = this.mark();
            }
            this.advance();
        }
        this.flushIncompleteStackItemsWhile(item -> true);
        if (error != null) {
            error.error(XmlPsiBundle.message("xml.parsing.top.level.element.is.not.completed", new Object[0]));
        }
        document.done(XmlElementType.HTML_DOCUMENT);
    }

    protected final void completeTopStackItem() {
        this.popItemFromStack().done(this.myBuilder, null, false);
    }

    protected final void completeTopStackItemBefore(@Nullable PsiBuilder.Marker beforeMarker) {
        this.popItemFromStack().done(this.myBuilder, beforeMarker, false);
    }

    protected final void flushIncompleteStackItemsWhile(Predicate<HtmlParserStackItem> itemFilter) {
        this.flushIncompleteStackItemsWhile(null, itemFilter);
    }

    protected final void flushIncompleteStackItemsWhile(@Nullable PsiBuilder.Marker beforeMarker, Predicate<HtmlParserStackItem> itemFilter) {
        while (!this.myItemsStack.isEmpty() && itemFilter.test((HtmlParserStackItem)this.myItemsStack.peek())) {
            ((HtmlParserStackItem)this.myItemsStack.pop()).done(this.myBuilder, beforeMarker, true);
        }
    }

    protected boolean hasCustomTopLevelContent() {
        return false;
    }

    @Nullable
    protected PsiBuilder.Marker parseCustomTopLevelContent(@Nullable PsiBuilder.Marker error) {
        return error;
    }

    protected boolean hasCustomTagContent() {
        return false;
    }

    @Nullable
    protected PsiBuilder.Marker parseCustomTagContent(@Nullable PsiBuilder.Marker xmlText) {
        return xmlText;
    }

    protected boolean hasCustomTagHeaderContent() {
        return false;
    }

    protected void parseCustomTagHeaderContent() {
    }

    @Nullable
    protected static PsiBuilder.Marker flushError(PsiBuilder.Marker error) {
        if (error != null) {
            error.error(XmlPsiBundle.message("xml.parsing.unexpected.tokens", new Object[0]));
        }
        return null;
    }

    private void parseDoctype() {
        assert (this.token() == XmlTokenType.XML_DOCTYPE_START) : "Doctype start expected";
        PsiBuilder.Marker doctype = this.mark();
        this.advance();
        while (this.token() != XmlTokenType.XML_DOCTYPE_END && !this.eof()) {
            this.advance();
        }
        if (this.eof()) {
            this.error(XmlPsiBundle.message("xml.parsing.unexpected.end.of.file", new Object[0]));
        } else {
            this.advance();
        }
        doctype.done(XmlElementType.XML_DOCTYPE);
    }

    public void parseTag() {
        assert (this.token() == XmlTokenType.XML_START_TAG_START) : "Tag start expected";
        PsiBuilder.Marker xmlText = null;
        while (this.shouldContinueMainLoop() && this.shouldContinueParsingTag()) {
            IElementType tt = this.token();
            if (tt == XmlTokenType.XML_START_TAG_START) {
                xmlText = HtmlParsing.terminateText(xmlText);
                PsiBuilder.Marker tagStart = this.mark();
                this.advance();
                String originalTagName = this.parseOpenTagName();
                HtmlTagInfo info = this.createHtmlTagInfo(originalTagName, tagStart);
                while (this.openingTagAutoClosesTagInStack(info)) {
                    this.completeTopStackItemBefore(tagStart);
                }
                this.pushItemToStack(info);
                this.parseTagHeader(info.getNormalizedName());
                if (this.token() == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                    this.advance();
                    this.doneTag();
                    continue;
                }
                if (this.token() != XmlTokenType.XML_TAG_END) {
                    this.error(XmlPsiBundle.message("xml.parsing.tag.start.is.not.closed", new Object[0]));
                    this.doneTag();
                    continue;
                }
                this.advance();
                if (!this.isSingleTag(info)) continue;
                PsiBuilder.Marker footer = this.mark();
                while (this.token() == XmlTokenType.XML_REAL_WHITE_SPACE) {
                    this.advance();
                }
                if (this.token() == XmlTokenType.XML_END_TAG_START) {
                    this.advance();
                    if (this.token() == XmlTokenType.XML_NAME && info.getNormalizedName().equalsIgnoreCase(this.myBuilder.getTokenText())) {
                        this.advance();
                        footer.drop();
                        if (this.token() == XmlTokenType.XML_TAG_END) {
                            this.advance();
                        }
                        this.doneTag();
                        continue;
                    }
                }
                footer.rollbackTo();
                this.doneTag();
                continue;
            }
            if (tt == XmlTokenType.XML_PI_START) {
                xmlText = HtmlParsing.terminateText(xmlText);
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlTokenType.XML_ENTITY_REF_TOKEN || tt == XmlTokenType.XML_CHAR_ENTITY_REF) {
                xmlText = this.startText(xmlText);
                this.parseReference();
                continue;
            }
            if (tt == XmlTokenType.XML_CDATA_START) {
                xmlText = this.startText(xmlText);
                this.parseCData();
                continue;
            }
            if (tt == XmlTokenType.XML_COMMENT_START) {
                xmlText = this.startText(xmlText);
                this.parseComment();
                continue;
            }
            if (tt == XmlTokenType.XML_BAD_CHARACTER) {
                xmlText = this.startText(xmlText);
                PsiBuilder.Marker error = this.mark();
                this.advance();
                error.error(XmlPsiBundle.message("xml.parsing.unescaped.ampersand.or.nonterminated.character.entity.reference", new Object[0]));
                continue;
            }
            if (tt instanceof ICustomParsingType || tt instanceof ILazyParseableElementType) {
                xmlText = HtmlParsing.terminateText(xmlText);
                this.maybeRemapCurrentToken(tt);
                this.advance();
                continue;
            }
            if (this.token() == XmlTokenType.XML_END_TAG_START) {
                xmlText = HtmlParsing.terminateText(xmlText);
                PsiBuilder.Marker footer = this.mark();
                this.advance();
                String endTagName = this.parseEndTagName();
                if (endTagName != null) {
                    HtmlTagInfo tagOnStack;
                    HtmlParserStackItem itemOnStack;
                    endTagName = this.normalizeTagName(endTagName);
                    HtmlParserStackItem htmlParserStackItem = itemOnStack = !this.myItemsStack.isEmpty() ? (HtmlParserStackItem)this.myItemsStack.peek() : null;
                    if (itemOnStack instanceof HtmlTagInfo && !(tagOnStack = (HtmlTagInfo)itemOnStack).getNormalizedName().equals(endTagName) && !StringUtil.toLowerCase((String)endTagName).endsWith(COMPLETION_NAME) || !(itemOnStack instanceof HtmlTagInfo)) {
                        if (itemOnStack instanceof HtmlTagInfo) {
                            HtmlTagInfo tagOnStack2 = (HtmlTagInfo)itemOnStack;
                            if (this.isTagFurtherInStack(endTagName)) {
                                footer.rollbackTo();
                                if (!this.canClosingTagAutoClose(tagOnStack2, endTagName)) {
                                    this.error(XmlPsiBundle.message("xml.parsing.named.element.is.not.closed", tagOnStack2.getOriginalName()));
                                }
                                this.doneTag();
                                continue;
                            }
                        }
                        if (this.token() == XmlTokenType.XML_TAG_END) {
                            this.advance();
                        }
                        footer.error(XmlPsiBundle.message("xml.parsing.closing.tag.matches.nothing", new Object[0]));
                        continue;
                    }
                    while (this.token() != XmlTokenType.XML_TAG_END && this.token() != XmlTokenType.XML_START_TAG_START && this.token() != XmlTokenType.XML_END_TAG_START && !this.eof()) {
                        this.error(XmlPsiBundle.message("xml.parsing.unexpected.token", new Object[0]));
                        this.advance();
                    }
                } else {
                    this.error(XmlPsiBundle.message("xml.parsing.closing.tag.name.missing", new Object[0]));
                }
                footer.drop();
                if (this.token() == XmlTokenType.XML_TAG_END) {
                    this.advance();
                } else {
                    this.error(XmlPsiBundle.message("xml.parsing.closing.tag.is.not.done", new Object[0]));
                }
                if (!this.hasTags()) continue;
                this.doneTag();
                continue;
            }
            if ((this.token() == XmlTokenType.XML_REAL_WHITE_SPACE || this.token() == XmlTokenType.XML_DATA_CHARACTERS) && this.stackSize() == 0) {
                xmlText = HtmlParsing.terminateText(xmlText);
                this.advance();
                continue;
            }
            if (this.hasCustomTagContent()) {
                xmlText = this.parseCustomTagContent(xmlText);
                continue;
            }
            xmlText = this.startText(xmlText);
            this.advance();
        }
        HtmlParsing.terminateText(xmlText);
    }

    @NotNull
    protected HtmlTagInfo createHtmlTagInfo(@NotNull String originalTagName, @NotNull PsiBuilder.Marker startMarker) {
        String normalizedTagName = this.normalizeTagName(originalTagName);
        return new HtmlTagInfoImpl(normalizedTagName, originalTagName, startMarker);
    }

    @NotNull
    protected String parseOpenTagName() {
        String originalTagName;
        if (this.token() != XmlTokenType.XML_NAME) {
            this.error(XmlPsiBundle.message("xml.parsing.tag.name.expected", new Object[0]));
            originalTagName = "";
        } else {
            originalTagName = Objects.requireNonNull(this.myBuilder.getTokenText());
            this.advance();
        }
        return originalTagName;
    }

    @Nullable
    protected String parseEndTagName() {
        String endName;
        if (this.token() == XmlTokenType.XML_NAME) {
            endName = Objects.requireNonNull(this.myBuilder.getTokenText());
            this.advance();
        } else {
            endName = null;
        }
        return endName;
    }

    private void parseTagHeader(String tagName) {
        boolean freeMakerTag = !tagName.isEmpty() && '#' == tagName.charAt(0);
        do {
            IElementType tt = this.token();
            if (freeMakerTag) {
                if (tt == XmlTokenType.XML_EMPTY_ELEMENT_END || tt == XmlTokenType.XML_TAG_END || tt == XmlTokenType.XML_END_TAG_START || tt == XmlTokenType.XML_START_TAG_START) break;
                this.advance();
                continue;
            }
            if (tt == XmlTokenType.XML_NAME) {
                this.parseAttribute();
                continue;
            }
            if (tt == XmlTokenType.XML_CHAR_ENTITY_REF || tt == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                this.parseReference();
                continue;
            }
            if (!this.hasCustomTagHeaderContent()) break;
            this.parseCustomTagHeaderContent();
        } while (!this.eof());
    }

    @ApiStatus.OverrideOnly
    protected boolean shouldContinueMainLoop() {
        return !this.eof();
    }

    protected boolean shouldContinueParsingTag() {
        return true;
    }

    protected final boolean hasTags() {
        return !this.myItemsStack.isEmpty() && this.myItemsStack.peek() instanceof HtmlTagInfo;
    }

    protected final void pushItemToStack(@NotNull HtmlParserStackItem item) {
        this.myItemsStack.add((Object)item);
    }

    @NotNull
    protected final HtmlParserStackItem popItemFromStack() {
        return (HtmlParserStackItem)this.myItemsStack.pop();
    }

    protected String normalizeTagName(@NotNull String originalTagName) {
        return StringUtil.toLowerCase((String)originalTagName);
    }

    protected final int stackSize() {
        return this.myItemsStack.size();
    }

    @NotNull
    protected final HtmlParserStackItem peekStackItem() {
        return (HtmlParserStackItem)this.myItemsStack.peek();
    }

    @NotNull
    protected final HtmlTagInfo peekTagInfo() {
        return (HtmlTagInfo)this.myItemsStack.peek();
    }

    protected final void processStackItems(@NotNull Processor<? super HtmlParserStackItem> processor) {
        for (int i = this.myItemsStack.size() - 1; i >= 0; --i) {
            if (processor.process(this.myItemsStack.get(i))) continue;
            return;
        }
    }

    private boolean isTagFurtherInStack(@NotNull String tagName) {
        for (int i = this.myItemsStack.size() - 1; i >= 0; --i) {
            HtmlParserStackItem item = (HtmlParserStackItem)this.myItemsStack.get(i);
            if (item instanceof HtmlTagInfo) {
                HtmlTagInfo tagInfo = (HtmlTagInfo)item;
                if (!tagInfo.getNormalizedName().equals(tagName)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected final void doneTag() {
        if (!(this.peekStackItem() instanceof HtmlTagInfo)) {
            throw new IllegalStateException("Unexpected item on stack: " + this.myItemsStack);
        }
        this.completeTopStackItem();
    }

    protected IElementType getHtmlTagElementType(@NotNull HtmlTagInfo info, int tagLevel) {
        return XmlElementType.HTML_TAG;
    }

    private boolean openingTagAutoClosesTagInStack(HtmlTagInfo openingTag) {
        Ref result = new Ref((Object)false);
        this.processStackItems((Processor<? super HtmlParserStackItem>)((Processor)item -> {
            if (item instanceof HtmlTagInfo) {
                HtmlTagInfo tagToClose = (HtmlTagInfo)item;
                ThreeState canClose = this.canOpeningTagAutoClose(tagToClose, openingTag);
                if (canClose != ThreeState.UNSURE) {
                    result.set((Object)canClose.toBoolean());
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }));
        return (Boolean)result.get();
    }

    protected boolean isSingleTag(@NotNull HtmlTagInfo tagInfo) {
        return HtmlUtil.isSingleHtmlTag(tagInfo.getNormalizedName(), true);
    }

    protected boolean isEndTagRequired(@NotNull HtmlTagInfo tagInfo) {
        return !HtmlUtil.isTagWithOptionalEnd(tagInfo.getNormalizedName(), true) && !"html".equals(tagInfo.getNormalizedName()) && !"body".equals(tagInfo.getNormalizedName());
    }

    @NotNull
    protected ThreeState canOpeningTagAutoClose(@NotNull HtmlTagInfo tagToClose, @NotNull HtmlTagInfo openingTag) {
        return HtmlUtil.canOpeningTagAutoClose(tagToClose.getNormalizedName(), openingTag.getNormalizedName(), true);
    }

    protected boolean canClosingTagAutoClose(@NotNull HtmlTagInfo tagToClose, @NotNull String closingTag) {
        return HtmlUtil.canClosingTagAutoClose(tagToClose.getNormalizedName(), closingTag, true);
    }

    @NotNull
    protected PsiBuilder.Marker startText(@Nullable PsiBuilder.Marker xmlText) {
        if (xmlText == null) {
            xmlText = this.mark();
        }
        return xmlText;
    }

    @Nullable
    protected static PsiBuilder.Marker terminateText(@Nullable PsiBuilder.Marker xmlText) {
        if (xmlText != null) {
            xmlText.done(XmlElementType.XML_TEXT);
        }
        return null;
    }

    protected void parseCData() {
        assert (this.token() == XmlTokenType.XML_CDATA_START);
        PsiBuilder.Marker cdata = this.mark();
        while (this.token() != XmlTokenType.XML_CDATA_END && !this.eof()) {
            this.advance();
        }
        if (!this.eof()) {
            this.advance();
        }
        cdata.done(XmlElementType.XML_CDATA);
    }

    protected void parseComment() {
        IElementType tt;
        PsiBuilder.Marker comment = this.mark();
        this.advance();
        while (true) {
            if ((tt = this.token()) == XmlTokenType.XML_COMMENT_CHARACTERS || tt == XmlTokenType.XML_CONDITIONAL_COMMENT_START || tt == XmlTokenType.XML_CONDITIONAL_COMMENT_START_END || tt == XmlTokenType.XML_CONDITIONAL_COMMENT_END_START || tt == XmlTokenType.XML_CONDITIONAL_COMMENT_END) {
                this.advance();
                continue;
            }
            if (tt == XmlTokenType.XML_ENTITY_REF_TOKEN || tt == XmlTokenType.XML_CHAR_ENTITY_REF) {
                this.parseReference();
                continue;
            }
            if (tt != XmlTokenType.XML_BAD_CHARACTER) break;
            PsiBuilder.Marker error = this.mark();
            this.advance();
            error.error(XmlPsiBundle.message("xml.parsing.bad.character", new Object[0]));
        }
        if (tt == XmlTokenType.XML_COMMENT_END) {
            this.advance();
        }
        comment.done(XmlElementType.XML_COMMENT);
    }

    protected void parseReference() {
        if (this.token() == XmlTokenType.XML_CHAR_ENTITY_REF) {
            this.advance();
        } else if (this.token() == XmlTokenType.XML_ENTITY_REF_TOKEN) {
            PsiBuilder.Marker ref = this.mark();
            this.advance();
            ref.done(XmlElementType.XML_ENTITY_REF);
        } else assert (false) : "Unexpected token";
    }

    protected void parseAttribute() {
        assert (this.token() == XmlTokenType.XML_NAME);
        PsiBuilder.Marker att = this.mark();
        this.advance();
        if (this.token() == XmlTokenType.XML_EQ) {
            this.advance();
            this.parseAttributeValue();
        }
        att.done(this.getHtmlAttributeElementType());
    }

    protected IElementType getHtmlAttributeElementType() {
        return XmlElementType.XML_ATTRIBUTE;
    }

    protected void parseAttributeValue() {
        PsiBuilder.Marker attValue = this.mark();
        if (this.token() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            IElementType tt;
            while ((tt = this.token()) != null && tt != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && tt != XmlTokenType.XML_END_TAG_START && tt != XmlTokenType.XML_EMPTY_ELEMENT_END && tt != XmlTokenType.XML_START_TAG_START) {
                if (tt == XmlTokenType.XML_BAD_CHARACTER) {
                    PsiBuilder.Marker error = this.mark();
                    this.advance();
                    error.error(XmlPsiBundle.message("xml.parsing.unescaped.ampersand.or.nonterminated.character.entity.reference", new Object[0]));
                    continue;
                }
                if (tt == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                    this.parseReference();
                    continue;
                }
                if (this.hasCustomAttributeValueContent()) {
                    this.parseCustomAttributeValueContent();
                    continue;
                }
                this.maybeRemapCurrentToken(tt);
                this.advance();
            }
            if (this.token() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.advance();
            } else {
                this.error(XmlPsiBundle.message("xml.parsing.unclosed.attribute.value", new Object[0]));
            }
        } else if (this.hasCustomAttributeValue()) {
            this.parseCustomAttributeValue();
        } else {
            IElementType tt = this.token();
            if (tt != XmlTokenType.XML_TAG_END && tt != XmlTokenType.XML_EMPTY_ELEMENT_END) {
                if (tt != null) {
                    this.maybeRemapCurrentToken(tt);
                }
                this.advance();
            }
        }
        attValue.done(this.getHtmlAttributeValueElementType());
    }

    protected IElementType getHtmlAttributeValueElementType() {
        return XmlElementType.XML_ATTRIBUTE_VALUE;
    }

    protected boolean hasCustomAttributeValue() {
        return false;
    }

    protected void parseCustomAttributeValue() {
    }

    @ApiStatus.Experimental
    protected boolean hasCustomAttributeValueContent() {
        return false;
    }

    @ApiStatus.Experimental
    protected void parseCustomAttributeValueContent() {
    }

    protected void parseProlog() {
        while (true) {
            IElementType tt;
            if ((tt = this.token()) == XmlTokenType.XML_COMMENT_START) {
                this.parseComment();
                continue;
            }
            if (tt != XmlTokenType.XML_REAL_WHITE_SPACE) break;
            this.advance();
        }
        PsiBuilder.Marker prolog = this.mark();
        while (true) {
            IElementType tt;
            if ((tt = this.token()) == XmlTokenType.XML_PI_START) {
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlTokenType.XML_DOCTYPE_START) {
                this.parseDoctype();
                continue;
            }
            if (tt == XmlTokenType.XML_COMMENT_START) {
                this.parseComment();
                continue;
            }
            if (tt != XmlTokenType.XML_REAL_WHITE_SPACE) break;
            this.advance();
        }
        prolog.done(XmlElementType.XML_PROLOG);
    }

    protected void parseProcessingInstruction() {
        assert (this.token() == XmlTokenType.XML_PI_START);
        PsiBuilder.Marker pi = this.mark();
        this.advance();
        if (this.token() == XmlTokenType.XML_NAME || this.token() == XmlTokenType.XML_PI_TARGET) {
            this.advance();
        }
        while (this.token() == XmlTokenType.XML_NAME) {
            this.advance();
            if (this.token() == XmlTokenType.XML_EQ) {
                this.advance();
            } else {
                this.error(XmlPsiBundle.message("xml.parsing.expected.attribute.eq.sign", new Object[0]));
            }
            this.parseAttributeValue();
        }
        if (this.token() == XmlTokenType.XML_PI_END) {
            this.advance();
        } else {
            this.error(XmlPsiBundle.message("xml.parsing.unterminated.processing.instruction", new Object[0]));
        }
        pi.done(XmlElementType.XML_PROCESSING_INSTRUCTION);
    }

    protected final PsiBuilder getBuilder() {
        return this.myBuilder;
    }

    protected final IElementType token() {
        return this.myBuilder.getTokenType();
    }

    protected final boolean eof() {
        return this.myBuilder.eof();
    }

    protected final void advance() {
        this.myBuilder.advanceLexer();
    }

    protected final PsiBuilder.Marker mark() {
        return this.myBuilder.mark();
    }

    protected void error(@NotNull @NlsContexts.ParsingError String message) {
        this.myBuilder.error(message);
    }

    @ApiStatus.Experimental
    protected void maybeRemapCurrentToken(@NotNull IElementType tokenType) {
    }

    public static interface HtmlParserStackItem {
        public void done(@NotNull PsiBuilder var1, @Nullable PsiBuilder.Marker var2, boolean var3);
    }

    public static interface HtmlTagInfo
    extends HtmlParserStackItem {
        @NotNull
        public String getNormalizedName();

        @NotNull
        public String getOriginalName();
    }

    protected class HtmlTagInfoImpl
    implements HtmlTagInfo {
        @NotNull
        private final String normalizedName;
        @NotNull
        private final String originalName;
        @NotNull
        private final PsiBuilder.Marker startMarker;

        protected HtmlTagInfoImpl(@NotNull String normalizedName, @NotNull String originalName, PsiBuilder.Marker marker) {
            this.normalizedName = normalizedName;
            this.originalName = originalName;
            this.startMarker = marker;
        }

        @Override
        @NotNull
        public String getNormalizedName() {
            return this.normalizedName;
        }

        @Override
        @NotNull
        public String getOriginalName() {
            return this.originalName;
        }

        @Override
        public void done(@NotNull PsiBuilder builder, @Nullable PsiBuilder.Marker beforeMarker, boolean incomplete) {
            IElementType myElementType = HtmlParsing.this.getHtmlTagElementType(this, HtmlParsing.this.myItemsStack.size() + 1);
            if (beforeMarker == null) {
                if (incomplete && HtmlParsing.this.isEndTagRequired(this)) {
                    builder.error(XmlPsiBundle.message("xml.parsing.named.element.is.not.closed", this.getOriginalName()));
                }
                this.startMarker.done(myElementType);
            } else {
                if (incomplete && HtmlParsing.this.isEndTagRequired(this)) {
                    beforeMarker.precede().errorBefore(XmlPsiBundle.message("xml.parsing.named.element.is.not.closed", this.getOriginalName()), beforeMarker);
                }
                this.startMarker.doneBefore(myElementType, beforeMarker);
            }
        }
    }
}

