/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing.statements;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.ListParsingHelper;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.parsing.Statement;
import fleet.com.jetbrains.php.lang.parser.parsing.StatementList;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public final class SwitchStatement {
    private static final TokenSet COLON___SEMICOLON = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opCOLON, PhpTokenTypes.opSEMICOLON});
    private static final TokenSet BRACED_STOPS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chRBRACE, PhpTokenTypes.kwCASE, PhpTokenTypes.kwDEFAULT});
    private static final TokenSet OLD_STOPS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwENDSWITCH, PhpTokenTypes.kwCASE, PhpTokenTypes.kwDEFAULT});

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        if (!builder.compareAndEat(PhpTokenTypes.kwSWITCH)) {
            statement.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }
        builder.match(PhpTokenTypes.chLPAREN);
        IElementType result = Expression.parse(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.getExpressionExpectedMessage());
        }
        builder.match(PhpTokenTypes.chRPAREN);
        SwitchStatement.parseSwitchCaseList(builder);
        statement.done(PhpElementTypes.SWITCH);
        return PhpElementTypes.SWITCH;
    }

    private static void parseSwitchCaseList(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.opCOLON)) {
            builder.compareAndEat(PhpTokenTypes.opSEMICOLON);
            SwitchStatement.parseCaseList(builder, false);
            builder.match(PhpTokenTypes.kwENDSWITCH);
            if (!builder.compare(PhpTokenTypes.PHP_CLOSING_TAG)) {
                builder.match(PhpTokenTypes.opSEMICOLON);
            }
        } else if (builder.compareAndEat(PhpTokenTypes.chLBRACE)) {
            SwitchStatement.parseCaseList(builder, true);
            builder.match(PhpTokenTypes.chRBRACE);
        } else {
            builder.match(PhpTokenTypes.chLBRACE);
        }
    }

    private static void parseCaseList(PhpPsiBuilder builder, boolean braced) {
        while (!builder.eof() && !(!braced ? builder.compare(PhpTokenTypes.kwENDSWITCH) : builder.compare(PhpTokenTypes.chRBRACE))) {
            IElementType result = SwitchStatement.parseCase(builder, braced);
            if (result != PhpElementTypes.EMPTY_INPUT) continue;
            builder.error(PhpParserErrors.unexpected(builder.getTokenType()));
            builder.advanceLexer();
        }
    }

    private static IElementType parseCase(PhpPsiBuilder builder, boolean braced) {
        TokenSet whereToStop = braced ? BRACED_STOPS : OLD_STOPS;
        Statement.parseHTML(builder);
        PsiBuilder.Marker caseMarker = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwDEFAULT)) {
            builder.match(COLON___SEMICOLON);
            StatementList.parseAccurate(builder, whereToStop);
            caseMarker.done(PhpElementTypes.CASE_DEFAULT);
            return PhpElementTypes.CASE_DEFAULT;
        }
        if (builder.compareAndEat(PhpTokenTypes.kwCASE)) {
            int expressionsCount = ListParsingHelper.parseDelimitedExpressionWithLeadExpr(builder, Expression.parse(builder), Expression::parse, PhpTokenTypes.opCOMMA, true, false);
            if (expressionsCount <= 0) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            builder.match(COLON___SEMICOLON);
            StatementList.parseAccurate(builder, whereToStop);
            caseMarker.done(PhpElementTypes.CASE);
            return PhpElementTypes.CASE;
        }
        caseMarker.drop();
        return PhpElementTypes.EMPTY_INPUT;
    }
}

