/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser;

import fleet.com.intellij.lang.ASTNode;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.openapi.project.Project;
import fleet.com.intellij.openapi.util.NlsContexts;
import fleet.com.intellij.openapi.util.NlsSafe;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.config.PhpLanguageFeature;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPsiBuilder {
    private static final int FACTOR = 10000;
    @NotNull
    public static final TokenSet QUESTION_MARKS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opQUEST, PhpTokenTypes.opCOALESCE});
    private final boolean myArrowFunctionSyntaxSupported;
    private final boolean myMatchExpressionSupported;
    private final boolean myAttributesSupported;
    private final boolean myReadonlyPropertiesSupported;
    private final boolean myReadonlyClassesSupported;
    private final IntSet myRemappedFnTokenIndices = new IntOpenHashSet();
    private final PsiBuilder psiBuilder;
    private final int myAllowedAdvanceCount = Integer.MAX_VALUE;
    private int myAdvanceCount;

    public boolean compareArrowOrNullsafeArrow() {
        if (this.compare(PhpTokenTypes.ARROW)) {
            return true;
        }
        return this.compare(QUESTION_MARKS) && this.rawLookup(1) == PhpTokenTypes.ARROW;
    }

    public boolean attributesSupported() {
        return this.myAttributesSupported;
    }

    public boolean endOfLineRawToken() {
        int textEnd;
        int start = this.psiBuilder.rawTokenTypeStart(0);
        if (start == (textEnd = this.psiBuilder.getOriginalText().length())) {
            return true;
        }
        int end = this.psiBuilder.rawTokenTypeStart(1);
        CharSequence tokenText = this.psiBuilder.getOriginalText().subSequence(start, end);
        return StringUtil.endsWith((CharSequence)tokenText, (CharSequence)"\n") || StringUtil.endsWith((CharSequence)tokenText, (CharSequence)"\r") || StringUtil.endsWith((CharSequence)tokenText, (CharSequence)"?>");
    }

    public PhpPsiBuilder(@Nullable Project project, @NotNull PsiBuilder builder) {
        this.psiBuilder = builder;
        this.myArrowFunctionSyntaxSupported = PhpLanguageFeature.ARROW_FUNCTION_SYNTAX.isSupported(project);
        this.myMatchExpressionSupported = PhpLanguageFeature.MATCH_EXPRESSION.isSupported(project);
        this.myAttributesSupported = PhpLanguageFeature.ATTRIBUTES.isSupported(project);
        this.myReadonlyPropertiesSupported = PhpLanguageFeature.READONLY_PROPERTIES.isSupported(project);
        this.myReadonlyClassesSupported = PhpLanguageFeature.READONLY_CLASSES.isSupported(project);
    }

    public boolean compare(IElementType type) {
        return this.getTokenType() == type;
    }

    public boolean compare(TokenSet types) {
        return types.contains(this.getTokenType());
    }

    public IElementType rawLookup(int steps) {
        return this.psiBuilder.rawLookup(steps);
    }

    public IElementType lookAhead() {
        return this.psiBuilder.lookAhead(1);
    }

    public boolean compareAndEat(IElementType type) {
        boolean found = this.compare(type);
        if (found) {
            this.advanceLexer();
        }
        return found;
    }

    public boolean compareAndEat(TokenSet types) {
        boolean found = this.compare(types);
        if (found) {
            this.advanceLexer();
        }
        return found;
    }

    public void match(IElementType token) {
        if (!this.compareAndEat(token)) {
            this.error(PhpParserErrors.expected(token));
        }
    }

    public void match(IElementType token, @NotNull @NlsContexts.ParsingError String errorMessage) {
        if (!this.compareAndEat(token)) {
            this.error(errorMessage);
        }
    }

    public void match(TokenSet tokens) {
        if (!this.compareAndEat(tokens)) {
            this.error(PhpParserErrors.expected(tokens));
        }
    }

    public void match(TokenSet tokens, @NotNull @NlsContexts.ParsingError String errorMessage) {
        if (!this.compareAndEat(tokens)) {
            this.error(errorMessage);
        }
    }

    public void advanceLexer() {
        ++this.myAdvanceCount;
        this.psiBuilder.advanceLexer();
    }

    public PsiBuilder.Marker mark() {
        return this.psiBuilder.mark();
    }

    public void error(@NotNull @NlsContexts.ParsingError String errorMessage) {
        this.psiBuilder.error(errorMessage);
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myAdvanceCount > Integer.MAX_VALUE || this.myAdvanceCount < 0) {
            throw new RuntimeException("Lexer has been advanced " + (this.myAdvanceCount > 0 ? this.myAdvanceCount : Integer.MAX_VALUE) + " times while the amount of lexeme is 0");
        }
        IElementType tokenType = this.psiBuilder.getTokenType();
        if (tokenType == PhpTokenTypes.kwFN && !this.myArrowFunctionSyntaxSupported) {
            this.myRemappedFnTokenIndices.add(this.psiBuilder.rawTokenIndex());
            this.psiBuilder.remapCurrentToken(PhpTokenTypes.IDENTIFIER);
            return PhpTokenTypes.IDENTIFIER;
        }
        return tokenType;
    }

    public boolean compareFnWithoutRemapping() {
        IElementType tokenType = this.getTokenType();
        return tokenType == PhpTokenTypes.kwFN || this.isCurrentTokenRemappedFromFn(tokenType);
    }

    private boolean isCurrentTokenRemappedFromFn(IElementType tokenType) {
        if (this.myArrowFunctionSyntaxSupported) {
            return false;
        }
        return tokenType == PhpTokenTypes.IDENTIFIER && this.myRemappedFnTokenIndices.contains(this.psiBuilder.rawTokenIndex());
    }

    public void remapBackToFnIfNeeded() {
        if (this.myArrowFunctionSyntaxSupported) {
            return;
        }
        IElementType tokenType = this.getTokenType();
        if (this.isCurrentTokenRemappedFromFn(tokenType)) {
            this.psiBuilder.remapCurrentToken(PhpTokenTypes.kwFN);
            this.myRemappedFnTokenIndices.remove(this.psiBuilder.rawTokenIndex());
        }
    }

    @Nullable
    @NlsSafe
    public String getTokenText() {
        return this.psiBuilder.getTokenText();
    }

    public boolean eof() {
        return this.psiBuilder.eof();
    }

    public ASTNode getTreeBuilt() {
        return this.psiBuilder.getTreeBuilt();
    }

    public int getCurrentOffset() {
        return this.psiBuilder.getCurrentOffset();
    }

    public boolean arrowFunctionSyntaxSupported() {
        return this.myArrowFunctionSyntaxSupported;
    }

    public boolean matchExpressionSupported() {
        return this.myMatchExpressionSupported;
    }

    public boolean readonlyPropertiesSupported() {
        return this.myReadonlyPropertiesSupported;
    }

    public boolean readonlyClassesSupported() {
        return this.myReadonlyClassesSupported;
    }

    public void remapCurrentTokenWithDocQuestion() {
        this.psiBuilder.remapCurrentToken(PhpDocTokenTypes.DOC_QUESTION_MARK);
    }

    public void remapToIdentifier() {
        this.psiBuilder.remapCurrentToken(PhpTokenTypes.IDENTIFIER);
    }

    public void remapToMatchKeyword() {
        this.psiBuilder.remapCurrentToken(PhpTokenTypes.kwMATCH);
    }

    public void remapCurrentTokenWithDocPipe() {
        this.psiBuilder.remapCurrentToken(PhpTokenTypes.DOC_PIPE);
    }
}

