/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser;

import fleet.com.intellij.openapi.util.NlsContexts;
import fleet.com.intellij.openapi.util.NlsSafe;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpParserErrors {
    private static final Map<String, String> expectedCache = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> unexpectedCache = new ConcurrentHashMap<String, String>();
    private static final Map<TokenSet, CharSequence> errorCache = new ConcurrentHashMap<TokenSet, CharSequence>();

    private PhpParserErrors() {
    }

    @NlsContexts.ParsingError
    @NotNull
    public static String expected(@Nls String s) {
        return expectedCache.computeIfAbsent(s, k -> "Expected " + s);
    }

    @NlsContexts.ParsingError
    @NotNull
    private static String unexpected(@NotNull String s) {
        return unexpectedCache.computeIfAbsent(s, k -> "Unexpected " + s);
    }

    @NotNull
    @Nls
    @NlsContexts.ParsingError
    public static String expected(IElementType type) {
        return PhpParserErrors.expected(PhpParserErrors.getPresentableName(type));
    }

    @NotNull
    @NlsSafe
    private static String getPresentableName(IElementType type) {
        return type != null ? type.toString() : "";
    }

    @NotNull
    @NlsContexts.ParsingError
    public static String unexpected(IElementType type) {
        return PhpParserErrors.unexpected(PhpParserErrors.getPresentableName(type));
    }

    @NotNull
    @NlsContexts.ParsingError
    public static String expected(TokenSet types) {
        return "Expected " + PhpParserErrors.setToString(types);
    }

    @NotNull
    private static CharSequence setToString(@NotNull TokenSet set) {
        CharSequence cachedString = errorCache.get(set);
        if (cachedString != null) {
            return cachedString;
        }
        ObjectOpenHashSet stringSet = new ObjectOpenHashSet();
        StringBuilder buffer = new StringBuilder();
        for (IElementType myToken : set.getTypes()) {
            String tokenText = PhpParserErrors.getPresentableName(myToken);
            if (tokenText.length() == 0 || !stringSet.add(tokenText)) continue;
            if (buffer.length() != 0) {
                buffer.append(" or ");
            }
            buffer.append(tokenText);
        }
        String errorString = buffer.toString();
        return errorString;
    }

    @Nls
    public static String getExpressionExpectedMessage() {
        return "Expected expression";
    }

    @Nls
    public static String getClassReferenceExpectedMessage() {
        return "Expected class reference";
    }
}

