/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing.expressions.primary;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.PhpBundle;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.PhpStubElementTypes;
import fleet.com.jetbrains.php.lang.parser.parsing.Namespace;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.StaticClassConstant;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.StaticScalar;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.primary.Array;

public final class Scalar {
    private static final TokenSet ENCAPS_LIST = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.HEREDOC_CONTENTS, PhpTokenTypes.STRING_LITERAL, PhpTokenTypes.STRING_NEW_LINE, PhpTokenTypes.ESCAPE_SEQUENCE, PhpTokenTypes.EXEC_COMMAND});

    public static IElementType parse(PhpPsiBuilder builder) {
        if (builder.compare(PhpTokenTypes.VARIABLE_NAME)) {
            PsiBuilder.Marker marker = builder.mark();
            builder.advanceLexer();
            marker.done(PhpStubElementTypes.VARIABLE);
            return PhpStubElementTypes.VARIABLE;
        }
        IElementType result = StaticClassConstant.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            return result;
        }
        if (builder.compare(PhpTokenTypes.IDENTIFIER) || builder.compare(PhpTokenTypes.NAMESPACE_RESOLUTION) || builder.compare(PhpTokenTypes.kwNAMESPACE)) {
            PsiBuilder.Marker marker = builder.mark();
            Namespace.parseReference(builder);
            builder.match(PhpTokenTypes.IDENTIFIER);
            marker.done(PhpElementTypes.CONSTANT_REF);
            Array.tryParsingArrayDeref(builder, marker);
            return PhpElementTypes.CONSTANT_REF;
        }
        if (builder.compare(PhpTokenTypes.HEREDOC_START)) {
            PsiBuilder.Marker marker = builder.mark();
            String identifier = builder.getTokenText();
            builder.advanceLexer();
            if (identifier == null || !identifier.endsWith("\n")) {
                builder.error(PhpParserErrors.expected(PhpBundle.message("line.separator", new Object[0])));
            }
            Scalar.parseEncapsList(builder);
            builder.match(PhpTokenTypes.HEREDOC_END);
            marker.done(PhpElementTypes.HEREDOC);
            return PhpElementTypes.HEREDOC;
        }
        if (builder.compare(PhpTokenTypes.chLDOUBLE_QUOTE)) {
            PsiBuilder.Marker marker = builder.mark();
            marker.done(Scalar.parseStringLiteral(builder));
            return Array.tryParsingArrayDerefOrFunctionCall(builder, PhpElementTypes.STRING, marker);
        }
        result = StaticScalar.parseCommonScalar(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            return result;
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType parseStringLiteral(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.chLDOUBLE_QUOTE)) {
            Scalar.parseEncapsList(builder);
            builder.match(PhpTokenTypes.chRDOUBLE_QUOTE);
            return PhpElementTypes.STRING;
        }
        if (builder.compareAndEat(StaticScalar.STRING_START)) {
            builder.compareAndEat(StaticScalar.STRING_BODY);
            builder.match(StaticScalar.STRING_END);
            return PhpElementTypes.STRING;
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static void parseEncapsList(PhpPsiBuilder builder) {
        while (builder.compareAndEat(ENCAPS_LIST) || Scalar.parseEncapsVar(builder) != PhpElementTypes.EMPTY_INPUT) {
        }
    }

    private static IElementType parseEncapsVar(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.VARIABLE)) {
            marker.done(PhpStubElementTypes.VARIABLE);
            if (builder.compareAndEat(PhpTokenTypes.chLBRACKET)) {
                marker = marker.precede();
                PsiBuilder.Marker var = marker.precede();
                IElementType result = Scalar.parseEncapsVarOffset(builder);
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected(PhpBundle.message("array.index", new Object[0])));
                }
                builder.match(PhpTokenTypes.chRBRACKET);
                marker.done(PhpElementTypes.ARRAY_ACCESS_EXPRESSION);
                var.done(PhpStubElementTypes.VARIABLE);
                return PhpElementTypes.ARRAY_ACCESS_EXPRESSION;
            }
            if (builder.compareArrowOrNullsafeArrow()) {
                builder.compareAndEat(PhpPsiBuilder.QUESTION_MARKS);
                builder.advanceLexer();
                marker = marker.precede();
                PsiBuilder.Marker var = marker.precede();
                builder.match(PhpTokenTypes.IDENTIFIER);
                marker.done(PhpElementTypes.FIELD_REFERENCE);
                var.done(PhpStubElementTypes.VARIABLE);
                return PhpElementTypes.FIELD_REFERENCE;
            }
            return PhpStubElementTypes.VARIABLE;
        }
        if (builder.compareAndEat(PhpTokenTypes.chLBRACE) || builder.compareAndEat(PhpTokenTypes.DOLLAR_LBRACE)) {
            PsiBuilder.Marker v = builder.mark();
            if (builder.compareAndEat(PhpTokenTypes.VARIABLE) && builder.compareAndEat(PhpTokenTypes.chRBRACE)) {
                v.drop();
            } else {
                v.rollbackTo();
                Expression.parse(builder);
                builder.match(PhpTokenTypes.chRBRACE);
            }
            marker.done(PhpStubElementTypes.VARIABLE);
            return PhpStubElementTypes.VARIABLE;
        }
        marker.drop();
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType parseEncapsVarOffset(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        PsiBuilder.Marker stringKeyMarker = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
            stringKeyMarker.done(PhpTokenTypes.STRING_LITERAL);
        } else {
            stringKeyMarker.drop();
            if (!Scalar.parseNumericOffset(builder) && !builder.compareAndEat(StaticScalar.STRING_START)) {
                PsiBuilder.Marker var = builder.mark();
                if (!builder.compareAndEat(PhpTokenTypes.VARIABLE)) {
                    marker.drop();
                    var.drop();
                    return PhpElementTypes.EMPTY_INPUT;
                }
                var.done(PhpStubElementTypes.VARIABLE);
            }
        }
        marker.done(PhpElementTypes.ARRAY_INDEX);
        return PhpElementTypes.ARRAY_INDEX;
    }

    private static boolean parseNumericOffset(PhpPsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        boolean minus = builder.compareAndEat(PhpTokenTypes.opMINUS);
        if (builder.compareAndEat(PhpTokenTypes.tsINTEGERS)) {
            if (minus) {
                mark.done(PhpElementTypes.INFIX_EXPRESSION);
            } else {
                mark.done(PhpElementTypes.NUMBER);
            }
            return true;
        }
        mark.rollbackTo();
        return false;
    }
}

