/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser;

import fleet.com.intellij.lang.Language;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiParser;
import fleet.com.intellij.openapi.progress.ProgressManager;
import fleet.com.intellij.openapi.project.Project;
import fleet.com.intellij.psi.ITokenSequence;
import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.IFileElementType;
import fleet.com.intellij.psi.tree.ILazyParseableElementType;
import fleet.com.intellij.psi.tree.IReparseableElementType;
import fleet.com.intellij.psi.tree.OuterLanguageElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.lang.PhpLanguage;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocStubElementTypes;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.PhpCodeFragmentParser;
import fleet.com.jetbrains.php.lang.parser.PhpExpressionCodeFragmentParser;
import fleet.com.jetbrains.php.lang.parser.PhpPsiParser;
import fleet.com.jetbrains.php.lang.parser.PhpStubElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpTypeCodeFragmentParser;
import fleet.com.jetbrains.php.lang.psi.PhpElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PhpElementTypes
extends PhpStubElementTypes,
TokenType {
    public static final IElementType USE_LIST = new PhpElementType("Use list");
    public static final IElementType USE_BRACES = new PhpElementType("Use braces");
    public static final IElementType NS_REFERENCE = new PhpElementType("NSReference");
    public static final IElementType PARAMETER_LIST = new PhpElementType("Parameter list");
    public static final IElementType FUNCTION_CALL = new PhpElementType("Function call");
    public static final IElementType CALLABLE_FUNCTION = new PhpElementType("Callable Function");
    public static final IElementType CALLABLE_METHOD = new PhpElementType("Callable Method");
    public static final IElementType FIELD_REFERENCE = new PhpElementType("Field reference");
    public static final IElementType METHOD_REFERENCE = new PhpElementType("Method reference");
    public static final IElementType CONSTANT_REF = new PhpElementType("Constant reference");
    public static final IElementType NON_LAZY_GROUP_STATEMENT = new PhpElementType("PsiElement(Non Lazy Group statement)");
    public static final ILazyParseableElementType GROUP_STATEMENT = new GroupStatementElementType();
    public static final TokenSet ANY_GROUP_STATEMENT = TokenSet.create((IElementType[])new IElementType[]{NON_LAZY_GROUP_STATEMENT, GROUP_STATEMENT});
    public static final IElementType STATIC_STATEMENT = new PhpElementType("Static statement");
    public static final IElementType GLOBAL = new PhpElementType("Global");
    public static final IElementType MULTIASSIGNMENT_EXPRESSION = new PhpElementType("Multiassignment expression");
    public static final IElementType EMPTY_INPUT = new PhpElementType("Unrecognised input");
    public static final IElementType HTML = new PhpElementType("HTML");
    public static final IElementType ARRAY_CREATION_EXPRESSION = new PhpElementType("Array creation expression");
    public static final IElementType ARRAY_ACCESS_EXPRESSION = new PhpElementType("Array access expression");
    public static final TokenSet ASSIGNABLE = TokenSet.create((IElementType[])new IElementType[]{VARIABLE, ARRAY_ACCESS_EXPRESSION, FIELD_REFERENCE});
    public static final TokenSet tsARRAY_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{ARRAY_CREATION_EXPRESSION, ARRAY_ACCESS_EXPRESSION});
    public static final IElementType ARRAY_INDEX = new PhpElementType("Array index");
    public static final IElementType ARRAY_KEY = new PhpElementType("Array key");
    public static final IElementType ARRAY_VALUE = new PhpElementType("Array value");
    public static final IElementType HASH_ARRAY_ELEMENT = new PhpElementType("Hash array element");
    public static final IElementType STATEMENT = new PhpElementType("Statement");
    public static final IElementType ASSIGNMENT_EXPRESSION = new PhpElementType("Assignment expression");
    public static final IElementType SELF_ASSIGNMENT_EXPRESSION = new PhpElementType("Self assignment expression");
    public static final IElementType TERNARY_EXPRESSION = new PhpElementType("Ternary expression");
    public static final IElementType COALESCE_EXPRESSION = new PhpElementType("Coalesce expression");
    public static final IElementType INSTANCEOF_EXPRESSION = new PhpElementType("Instanceof expression");
    public static final IElementType PRINT_EXPRESSION = new PhpElementType("Print expression");
    public static final IElementType EXIT_EXPRESSION = new PhpElementType("Exit expression");
    public static final IElementType ISSET_EXPRESSION = new PhpElementType("Isset function");
    public static final IElementType NEW_EXPRESSION = new PhpElementType("New expression");
    public static final IElementType EMPTY_EXPRESSION = new PhpElementType("Empty expression");
    public static final IElementType EVAL_EXPRESSION = new PhpElementType("Eval expression");
    public static final IElementType CLONE_EXPRESSION = new PhpElementType("Clone expression");
    public static final IElementType LITERAL_LOGICAL_EXPRESSION = new PhpElementType("Literal logical expression");
    public static final IElementType LOGICAL_EXPRESSION = new PhpElementType("Logical expression");
    public static final IElementType BIT_EXPRESSION = new PhpElementType("Bint expression");
    public static final IElementType EQUALITY_EXPRESSION = new PhpElementType("Equality expression");
    public static final IElementType RELATIONAL_EXPRESSION = new PhpElementType("Relational expression");
    public static final IElementType SHIFT_EXPRESSION = new PhpElementType("Shift expression");
    public static final IElementType ADDITIVE_EXPRESSION = new PhpElementType("Additive expression");
    public static final IElementType MULTIPLICATIVE_EXPRESSION = new PhpElementType("Multiplicative expression");
    public static final IElementType CAST_EXPRESSION = new PhpElementType("Cast expression");
    public static final IElementType SILENCE_EXPRESSION = new PhpElementType("Silence expression");
    public static final IElementType CONCATENATION_EXPRESSION = new PhpElementType("Concatenation expression");
    public static final IElementType PARENTHESIZED_EXPRESSION = new PhpElementType("Parenthesized expression");
    public static final IElementType INFIX_EXPRESSION = new PhpElementType("Infix expression");
    public static final IElementType INFIX_WRITE_EXPRESSION = new PhpElementType("Infix write expression");
    public static final IElementType POSTFIX_EXPRESSION = new PhpElementType("Postfix expression");
    public static final TokenSet UNARY_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{INFIX_EXPRESSION, INFIX_WRITE_EXPRESSION, POSTFIX_EXPRESSION, CAST_EXPRESSION, SILENCE_EXPRESSION, CLONE_EXPRESSION});
    public static final TokenSet BINARY_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{ADDITIVE_EXPRESSION, CONCATENATION_EXPRESSION, MULTIPLICATIVE_EXPRESSION, SHIFT_EXPRESSION, RELATIONAL_EXPRESSION, EQUALITY_EXPRESSION, BIT_EXPRESSION, LOGICAL_EXPRESSION, LITERAL_LOGICAL_EXPRESSION, INSTANCEOF_EXPRESSION, COALESCE_EXPRESSION});
    public static final IElementType IF = new PhpElementType("If");
    public static final IElementType STRING = new PhpElementType("String");
    public static final IElementType CLASS_REFERENCE = new PhpElementType("Class reference");
    public static final IElementType CLASS_REFERENCES_GROUP = new PhpElementType("Class reference");
    public static final IElementType CLASS_CONSTANT_REFERENCE = new PhpElementType("Class constant reference");
    public static final IElementType ELSE_IF = new PhpElementType("Elseif");
    public static final IElementType ELSE = new PhpElementType("Else");
    public static final IElementType FOR = new PhpElementType("For");
    public static final IElementType FOREACH = new PhpElementType("Foreach");
    public static final IElementType WHILE = new PhpElementType("While");
    public static final IElementType DO_WHILE = new PhpElementType("Do while");
    public static final IElementType BREAK = new PhpElementType("Break");
    public static final IElementType CONTINUE = new PhpElementType("Continue");
    public static final IElementType ECHO = new PhpElementType("Echo");
    public static final IElementType UNSET = new PhpElementType("Unset");
    public static final IElementType GOTO = new PhpElementType("Goto");
    public static final IElementType GOTO_LABEL = new PhpElementType("Goto label");
    public static final IElementType PARAMETER_DEFAULT_VALUE = new PhpElementType("Parameter default value");
    public static final IElementType RETURN_TYPE = new PhpElementType("Return type");
    public static final IElementType COMMON_SCALAR = new PhpElementType("Common scalar");
    public static final IElementType STATIC_SCALAR = new PhpElementType("Static scalar");
    public static final IElementType EXTENDS_LIST = new PhpElementType("Extends list");
    public static final IElementType IMPLEMENTS_LIST = new PhpElementType("Implements list");
    public static final IElementType MODIFIER_LIST = new PhpElementType("Modifier list");
    public static final IElementType CLASS_FIELDS = new PhpElementType("Class fields");
    public static final IElementType CLASS_CONSTANTS = new PhpElementType("Class constants");
    public static final IElementType CONSTANTS = new PhpElementType("Constants");
    public static final IElementType SWITCH = new PhpElementType("Switch statement");
    public static final IElementType MATCH_EXPRESSION = new PhpElementType("Match expression");
    public static final IElementType MATCH_ARM = new PhpElementType("Match arm");
    public static final IElementType DEFAULT_MATCH_ARM = new PhpElementType("Default match arm");
    public static final IElementType CASE_DEFAULT = new PhpElementType("Default case");
    public static final IElementType CASE = new PhpElementType("Case");
    public static final IElementType RETURN = new PhpElementType("Return");
    public static final IElementType YIELD = new PhpElementType("Yield");
    public static final IElementType DECLARE = new PhpElementType("Declare statement");
    public static final IElementType DECLARE_DIRECTIVE = new PhpElementType("Declare directive");
    public static final IElementType TRY = new PhpElementType("Try statement");
    public static final IElementType CATCH = new PhpElementType("Catch clause");
    public static final IElementType FINALLY = new PhpElementType("Finally clause");
    public static final IElementType THROW = new PhpElementType("Throw statement");
    public static final IElementType THROW_EXPRESSION = new PhpElementType("Throw expression");
    public static final IElementType EXPRESSION = new PhpElementType("Expression");
    public static final IElementType CLOSURE = new PhpElementType("Closure");
    public static final IElementType HEREDOC = new PhpElementType("Heredoc");
    public static final IElementType NUMBER = new PhpElementType("Number");
    public static final IElementType SHELL_COMMAND = new PhpElementType("Shell command");
    public static final IElementType PARAMETER_TYPE = new PhpElementType("Parameter type");
    public static final IElementType FIELD_TYPE = new PhpElementType("Field type");
    public static final IElementType BACKED_ENUM_TYPE = new PhpElementType("Backed Enum type");
    public static final IElementType ATTRIBUTES_LIST = new PhpElementType("Attributes list");
    public static final IElementType CLASS_CONSTANT_TYPE = new PhpElementType("Class constant type");
    public static final IElementType PHP_OUTER_TYPE = new OuterLanguageElementType("PHP outer type in html", (Language)PhpLanguage.INSTANCE);
    public static final TokenSet STATEMENTS = TokenSet.create((IElementType[])new IElementType[]{BREAK, CONTINUE, DECLARE, DO_WHILE, FOREACH, FOR, GLOBAL, ECHO, GOTO, STATIC_STATEMENT, UNSET, STATEMENT, RETURN, IF, TRY, THROW, WHILE, DEFINE, CONST, ELSE, ELSE_IF, SWITCH});
    public static final TokenSet ASSIGNMENTS = TokenSet.create((IElementType[])new IElementType[]{ASSIGNMENT_EXPRESSION, SELF_ASSIGNMENT_EXPRESSION, MULTIASSIGNMENT_EXPRESSION});
    public static final TokenSet SCALARS = TokenSet.create((IElementType[])new IElementType[]{STRING, HEREDOC, NUMBER});
    public static final TokenSet tsEXPRESSIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{SCALARS, TokenSet.create((IElementType[])new IElementType[]{FUNCTION_CALL, CONSTANT_REF, VARIABLE}), TokenSet.create((IElementType[])new IElementType[]{NEW_EXPRESSION}), tsARRAY_EXPRESSIONS, ASSIGNMENTS, TokenSet.create((IElementType[])new IElementType[]{FIELD_REFERENCE, METHOD_REFERENCE, CLASS_CONSTANT_REFERENCE}), UNARY_EXPRESSIONS, BINARY_EXPRESSIONS, TokenSet.create((IElementType[])new IElementType[]{TERNARY_EXPRESSION}), TokenSet.create((IElementType[])new IElementType[]{PARENTHESIZED_EXPRESSION}), TokenSet.create((IElementType[])new IElementType[]{ISSET_EXPRESSION, EMPTY_EXPRESSION, EXIT_EXPRESSION})});
    public static final TokenSet tsCOMMENTS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.LINE_COMMENT, PhpDocStubElementTypes.DOC_COMMENT, PhpTokenTypes.C_STYLE_COMMENT, PhpDocTokenTypes.DOC_IDENTIFIER_FOR_EDITOR, PhpDocTokenTypes.DOC_TAG_NAME_FOR_EDITOR, PhpTokenTypes.DOC_COMMENT_DATA});
    public static final IFileElementType EXPRESSION_CODE_FRAGMENT = new PhpCodeFragmentFileElementType("PHP Expression Code fragment"){

        @Override
        @NotNull
        protected PsiParser createParser(@Nullable Project project) {
            return new PhpExpressionCodeFragmentParser(project);
        }
    };
    public static final IFileElementType TYPE_CODE_FRAGMENT = new PhpCodeFragmentFileElementType("PHP Type Code fragment"){

        @Override
        @NotNull
        protected PsiParser createParser(@Nullable Project project) {
            return new PhpTypeCodeFragmentParser(project);
        }
    };
    public static final IFileElementType CODE_FRAGMENT = new PhpCodeFragmentFileElementType("PHP Code Fragment"){

        @Override
        @NotNull
        protected PsiParser createParser(@Nullable Project project) {
            return new PhpCodeFragmentParser(project);
        }
    };

    public static class GroupStatementElementType
    extends IReparseableElementType {
        public GroupStatementElementType() {
            super("Group statement", (Language)PhpLanguage.INSTANCE);
        }

        public void parse(@NotNull PsiBuilder builder) {
            PhpPsiParser.parseBlockDeep(null, (IElementType)this, builder);
        }

        public boolean isParsable(@Nullable IElementType parentType, @NotNull CharSequence charSequence, @NotNull ITokenSequence tokenSequence, int startLexeme, int lexemeCount) {
            int index = startLexeme;
            int balance = 0;
            while (index - startLexeme < lexemeCount) {
                ProgressManager.checkCanceled();
                IElementType t = tokenSequence.lexType(index);
                if (t == PhpTokenTypes.chLBRACE || t == PhpTokenTypes.DOLLAR_LBRACE) {
                    ++balance;
                } else if (t == PhpTokenTypes.chRBRACE && (--balance == 0 || balance < 0)) break;
                ++index;
            }
            return balance == 0;
        }
    }

    public static abstract class PhpCodeFragmentFileElementType
    extends IFileElementType {
        public PhpCodeFragmentFileElementType(@NotNull String debugName) {
            super(debugName, (Language)PhpLanguage.INSTANCE);
        }

        @NotNull
        protected abstract PsiParser createParser(@Nullable Project var1);

        public void parse(@NotNull PsiBuilder builder) {
            this.createParser(null).parse((IElementType)this, builder);
        }
    }
}

